/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.workorder.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.DictUtil;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictItemDTO;
import com.els.modules.workorder.entity.WorkOrderHead;
import com.els.modules.workorder.entity.WorkOrderRecord;
import com.els.modules.workorder.service.WorkOrderHeadService;
import com.els.modules.workorder.service.WorkOrderRecordService;
import com.els.modules.workorder.vo.CheckResultVO;
import com.els.modules.workorder.vo.ReplyVO;
import com.els.modules.workorder.vo.ScoreResultVO;
import com.els.modules.workorder.vo.WorkOrderHeadVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/other/workOrderHead"})
@Tag(name="\u5de5\u5355\u7ba1\u7406")
public class WorkOrderHeadController
extends BaseController<WorkOrderHead, WorkOrderHeadService> {
    @Autowired
    private WorkOrderHeadService workOrderHeadService;
    @Autowired
    private WorkOrderRecordService workOrderRecordService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"other#workOrderHead:list"})
    public Result<?> queryPageList(WorkOrderHead workOrderHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)workOrderHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.workOrderHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"other#workOrderHead:list"})
    public Result<?> queryTabsCount(WorkOrderHead head, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.select((Object[])new String[]{"order_status", "count(0) as participateQuantity"})).lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"order_status");
        List list = ((WorkOrderHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(WorkOrderHead::getOrderStatus, WorkOrderHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "orderStatus", null, (long)all.intValue()));
        List srmContractStatus = DictUtil.getItemListByCode((String)"workOrderStatus", (String)TenantContext.getTenant());
        for (DictItemDTO status : srmContractStatus) {
            Integer total = countMap.get(status.getItemValue()) == null ? 0 : countMap.get(status.getItemValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getItemText()), "orderStatus", status.getItemValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"other#workOrderHead:add"})
    public Result<?> add(@Valid @RequestBody WorkOrderHeadVO workOrderHeadPage) {
        WorkOrderHead workOrderHead = new WorkOrderHead();
        BeanUtils.copyProperties((Object)((Object)workOrderHeadPage), (Object)((Object)workOrderHead));
        this.workOrderHeadService.saveMain(workOrderHead, workOrderHeadPage.getWorkOrderRecordList());
        return Result.ok((Object)((Object)workOrderHead));
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"other#workOrderHead:edit"})
    public Result<?> edit(@Valid @RequestBody WorkOrderHeadVO workOrderHeadPage) {
        WorkOrderHead workOrderHead = new WorkOrderHead();
        BeanUtils.copyProperties((Object)((Object)workOrderHeadPage), (Object)((Object)workOrderHead));
        this.workOrderHeadService.updateMain(workOrderHead, workOrderHeadPage.getWorkOrderRecordList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"other#workOrderHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.workOrderHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"other#workOrderHead:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        WorkOrderHead workOrderHead = (WorkOrderHead)((Object)this.workOrderHeadService.getById((Serializable)((Object)id)));
        WorkOrderHeadVO workOrderHeadVO = new WorkOrderHeadVO();
        BeanUtils.copyProperties((Object)((Object)workOrderHead), (Object)((Object)workOrderHeadVO));
        List<WorkOrderRecord> workOrderRecordList = this.workOrderRecordService.selectByMainId(id);
        workOrderHeadVO.setWorkOrderRecordList(workOrderRecordList);
        return Result.ok((Object)((Object)workOrderHeadVO));
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u63d0\u4ea4\u5de5\u5355")
    @Operation(summary="\u63d0\u4ea4\u5de5\u5355", description="\u63d0\u4ea4\u5de5\u5355")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"other#workOrderHead:publish"})
    public Result<?> submit(@Valid @RequestBody WorkOrderHead workOrderHead) {
        this.workOrderHeadService.submit(workOrderHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u7b54\u590d\u5de5\u5355")
    @Operation(summary="\u7b54\u590d\u5de5\u5355", description="\u7b54\u590d\u5de5\u5355")
    @PostMapping(value={"/reply"})
    @RequiresPermissions(value={"other#workOrderHead:sendMsg"})
    public Result<?> reply(@RequestBody ReplyVO replyVO) {
        WorkOrderRecord record = this.workOrderHeadService.reply(replyVO);
        return Result.ok((Object)((Object)record));
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5173\u95ed\u5de5\u5355")
    @Operation(summary="\u5173\u95ed\u5de5\u5355", description="\u5173\u95ed\u5de5\u5355")
    @PostMapping(value={"/close"})
    @RequiresPermissions(value={"other#workOrderHead:close"})
    public Result<?> close(@RequestBody ReplyVO replyVO) {
        this.workOrderHeadService.close(replyVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5de5\u5355\u9a8c\u8bc1")
    @Operation(summary="\u5de5\u5355\u9a8c\u8bc1", description="\u5de5\u5355\u9a8c\u8bc1")
    @PostMapping(value={"/check"})
    @RequiresPermissions(value={"other#workOrderHead:check"})
    public Result<?> check(@RequestBody CheckResultVO resultVO) {
        this.workOrderHeadService.check(resultVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5de5\u5355\u50ac\u529e")
    @Operation(summary="\u5de5\u5355\u50ac\u529e", description="\u5de5\u5355\u50ac\u529e")
    @PostMapping(value={"/urgent"})
    @RequiresPermissions(value={"other#workOrderHead:urgent"})
    public Result<?> urgent(@RequestBody ReplyVO replyVO) {
        this.workOrderHeadService.urgent(replyVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u5de5\u5355\u8bc4\u5206")
    @Operation(summary="\u5de5\u5355\u8bc4\u5206", description="\u5de5\u5355\u8bc4\u5206")
    @PostMapping(value={"/score"})
    @RequiresPermissions(value={"other#workOrderHead:score"})
    public Result<?> score(@RequestBody ScoreResultVO resultVO) {
        this.workOrderHeadService.score(resultVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u5355\u7ba1\u7406", value="\u91cd\u53d1\u8bb0\u5f55")
    @Operation(summary="\u91cd\u53d1\u8bb0\u5f55", description="\u91cd\u53d1\u8bb0\u5f55")
    @PostMapping(value={"/retryRecord"})
    @RequiresPermissions(value={"other#workOrderHead:sendMsg"})
    public Result<?> retryRecord(@RequestBody WorkOrderRecord record) {
        this.workOrderHeadService.retryRecord(record);
        return this.commonSuccessResult(3);
    }
}

