/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.minerals.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.minerals.entity.PurchaseMineralsCollect;
import com.els.modules.minerals.entity.PurchaseMineralsDetail;
import com.els.modules.minerals.entity.PurchaseMineralsMetal;
import com.els.modules.minerals.entity.PurchaseMineralsSupplier;
import com.els.modules.minerals.service.PurchaseMineralsCollectService;
import com.els.modules.minerals.service.PurchaseMineralsDetailService;
import com.els.modules.minerals.service.PurchaseMineralsMetalService;
import com.els.modules.minerals.service.PurchaseMineralsSupplierService;
import com.els.modules.minerals.vo.PurchaseMineralsCollectVO;
import com.els.modules.minerals.vo.RejectSmelterIdVo;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/minerals/purchaseMineralsCollect"})
@Api(tags={"\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868"})
public class PurchaseMineralsCollectController
extends BaseController<PurchaseMineralsCollect, PurchaseMineralsCollectService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMineralsCollectController.class);
    @Autowired
    private PurchaseMineralsCollectService purchaseMineralsCollectService;
    @Autowired
    private PurchaseMineralsMetalService purchaseMineralsMetalService;
    @Autowired
    private PurchaseMineralsDetailService purchaseMineralsDetailService;
    @Autowired
    private PurchaseMineralsSupplierService purchaseMineralsSupplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"minerals#PurchaseMineralsCollectList:list"})
    public Result<?> queryPageList(PurchaseMineralsCollect purchaseMineralsCollect, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMineralsCollect), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMineralsCollectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"minerals#purchaseMineralsCollect:add"})
    public Result<?> add(@RequestBody PurchaseMineralsCollectVO purchaseMineralsCollectPage) {
        PurchaseMineralsCollect purchaseMineralsCollect = new PurchaseMineralsCollect();
        BeanUtils.copyProperties((Object)((Object)purchaseMineralsCollectPage), (Object)((Object)purchaseMineralsCollect));
        this.purchaseMineralsCollectService.saveMain(purchaseMineralsCollect, purchaseMineralsCollectPage.getMineralsMetalList(), purchaseMineralsCollectPage.getMineralsDetailList(), purchaseMineralsCollectPage.getMineralsSupplierList(), purchaseMineralsCollectPage.getAttachmentList());
        BeanUtils.copyProperties((Object)((Object)purchaseMineralsCollect), (Object)((Object)purchaseMineralsCollectPage));
        return Result.ok((Object)((Object)purchaseMineralsCollectPage));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"minerals#PurchaseMineralsCollectList:edit"})
    public Result<?> edit(@RequestBody PurchaseMineralsCollectVO purchaseMineralsCollectPage) {
        PurchaseMineralsCollect purchaseMineralsCollect = new PurchaseMineralsCollect();
        BeanUtils.copyProperties((Object)((Object)purchaseMineralsCollectPage), (Object)((Object)purchaseMineralsCollect));
        this.purchaseMineralsCollectService.updateMain(purchaseMineralsCollect, purchaseMineralsCollectPage.getMineralsMetalList(), purchaseMineralsCollectPage.getMineralsDetailList(), purchaseMineralsCollectPage.getMineralsSupplierList(), purchaseMineralsCollectPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"minerals#purchaseMineralsCollect:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseMineralsCollectService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"minerals#purchaseMineralsCollect:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseMineralsCollectService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"minerals#PurchaseMineralsCollectList:view"})
    public Result<?> queryById(@RequestParam(name="id") String id, @RequestParam(name="toElsAccount", required=false) String toElsAccount) {
        PurchaseMineralsCollect purchaseMineralsCollect = (PurchaseMineralsCollect)((Object)this.purchaseMineralsCollectService.getById((Serializable)((Object)id)));
        PurchaseMineralsCollectVO purchaseMineralsCollectVO = new PurchaseMineralsCollectVO();
        BeanUtils.copyProperties((Object)((Object)purchaseMineralsCollect), (Object)((Object)purchaseMineralsCollectVO));
        List<PurchaseMineralsMetal> purchaseMineralsMetalList = this.purchaseMineralsMetalService.selectByMainId(id);
        List<PurchaseMineralsDetail> purchaseMineralsDetailList = this.purchaseMineralsDetailService.selectByMainId(id);
        List<PurchaseMineralsSupplier> purchaseMineralsSupplierList = this.purchaseMineralsSupplierService.selectByMainId(id);
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        if (StrUtil.isNotBlank((CharSequence)toElsAccount)) {
            purchaseMineralsMetalList = purchaseMineralsMetalList.stream().filter(x -> toElsAccount.equals(x.getToElsAccount())).collect(Collectors.toList());
            purchaseMineralsSupplierList = purchaseMineralsSupplierList.stream().filter(x -> toElsAccount.equals(x.getToElsAccount())).collect(Collectors.toList());
            purchaseMineralsDetailList = purchaseMineralsDetailList.stream().filter(x -> toElsAccount.equals(x.getToElsAccount())).collect(Collectors.toList());
            attachmentList = attachmentList.stream().filter(x -> toElsAccount.equals(x.getUploadElsAccount()) || purchaseMineralsCollect.getElsAccount().equals(x.getUploadElsAccount())).collect(Collectors.toList());
        }
        purchaseMineralsCollectVO.setMineralsDetailList(purchaseMineralsDetailList);
        purchaseMineralsCollectVO.setMineralsSupplierList(purchaseMineralsSupplierList);
        purchaseMineralsCollectVO.setMineralsMetalList(purchaseMineralsMetalList);
        purchaseMineralsCollectVO.setAttachmentList(attachmentList);
        return Result.ok((Object)((Object)purchaseMineralsCollectVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u91d1\u5c5e\u660e\u7ec6\u8868", notes="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u91d1\u5c5e\u660e\u7ec6\u8868")
    @GetMapping(value={"/queryPurchaseMineralsMetalByMainId"})
    @RequiresPermissions(value={"minerals#PurchaseMineralsCollectList:view"})
    public Result<?> queryPurchaseMineralsMetalListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseMineralsMetal> purchaseMineralsMetalList = this.purchaseMineralsMetalService.selectByMainId(id);
        return Result.ok(purchaseMineralsMetalList);
    }

    @ApiOperation(value="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u660e\u7ec6\u8868", notes="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u660e\u7ec6\u8868")
    @GetMapping(value={"/queryPurchaseMineralsDetailByMainId"})
    @RequiresPermissions(value={"minerals#PurchaseMineralsCollectList:view"})
    public Result<?> queryPurchaseMineralsDetailListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseMineralsDetail> purchaseMineralsDetailList = this.purchaseMineralsDetailService.selectByMainId(id);
        return Result.ok(purchaseMineralsDetailList);
    }

    @ApiOperation(value="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u77ff\u4ea7\u4f9b\u5e94\u5546\u5217\u8868", notes="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u77ff\u4ea7\u4f9b\u5e94\u5546\u5217\u8868")
    @GetMapping(value={"/queryPurchaseMineralsSupplierByMainId"})
    @RequiresPermissions(value={"minerals#PurchaseMineralsCollectList:view"})
    public Result<?> queryPurchaseMineralsSupplierListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseMineralsSupplier> purchaseMineralsSupplierList = this.purchaseMineralsSupplierService.selectByMainId(id);
        return Result.ok(purchaseMineralsSupplierList);
    }

    @ApiOperation(value="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u9644\u4ef6", notes="\u901a\u8fc7\u77ff\u4ea7\u8d44\u6e90\u6536\u96c6\u5355\u8868id\u67e5\u8be2\u9644\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    @RequiresPermissions(value={"minerals#PurchaseMineralsCollectList:view"})
    public Result<?> queryattachmentListByMainId(@RequestParam(name="id") String id) {
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        return Result.ok((Object)attachmentList);
    }

    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"minerals#purchaseMineralsCollect:publish"})
    public Result<?> publish(@RequestBody PurchaseMineralsCollectVO purchaseMineralsCollectPage) {
        PurchaseMineralsCollect purchaseMineralsCollect = new PurchaseMineralsCollect();
        BeanUtils.copyProperties((Object)((Object)purchaseMineralsCollectPage), (Object)((Object)purchaseMineralsCollect));
        this.purchaseMineralsCollectService.checkBeforePublish(purchaseMineralsCollectPage, purchaseMineralsCollectPage.getMineralsSupplierList(), purchaseMineralsCollectPage.getMineralsMetalList(), purchaseMineralsCollectPage.getAttachmentList());
        this.purchaseMineralsCollectService.publish(purchaseMineralsCollectPage, purchaseMineralsCollectPage.getMineralsSupplierList(), purchaseMineralsCollectPage.getMineralsMetalList(), purchaseMineralsCollectPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u6279\u91cf\u786e\u8ba4", notes="\u6279\u91cf\u786e\u8ba4")
    @GetMapping(value={"/confirmBatch"})
    @RequiresPermissions(value={"minerals#purchaseMineralsDetail:confirm"})
    public Result<?> confirmBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseMineralsCollectService.confirmBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u6279\u91cf\u9a73\u56de", notes="\u6279\u91cf\u9a73\u56de")
    @GetMapping(value={"/rejectBatch"})
    @RequiresPermissions(value={"minerals#purchaseMineralsDetail:reject"})
    public Result<?> rejectBatch(@RequestParam(name="ids") String ids, @RequestParam(name="rejectDesc") String rejectDesc) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseMineralsCollectService.rejectBatch(idList, rejectDesc);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u9a73\u56de\u51b6\u70bc\u5382ID", notes="\u9a73\u56de\u51b6\u70bc\u5382ID")
    @GetMapping(value={"/invalid"})
    @RequiresPermissions(value={"minerals#purchaseMineralsDetail:void"})
    public Result<?> invalid(@RequestParam(name="smelterIdentificationCo") String smelterIdentificationCo, @RequestParam(name="rejectDesc") String rejectDesc) {
        this.purchaseMineralsCollectService.invalid(smelterIdentificationCo, rejectDesc);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u9a73\u56de\u51b6\u70bc\u5382ID", notes="\u9a73\u56de\u51b6\u70bc\u5382ID")
    @PostMapping(value={"/invalids"})
    @RequiresPermissions(value={"minerals#purchaseMineralsDetail:void"})
    public Result<?> invalids(@RequestBody RejectSmelterIdVo rejectSmelterIdVo) {
        List<String> collectItemIds = rejectSmelterIdVo.getCollectItemIds();
        if (CollectionUtils.isEmpty(collectItemIds)) {
            throw new ELSBootException("\u8bf7\u9009\u62e9\u9700\u8981\u907f\u9a73\u56de\u7684\u5355\u636e\uff01");
        }
        if (StrUtil.isBlank((CharSequence)rejectSmelterIdVo.getSmelterIdentificationCo())) {
            throw new ELSBootException("\u8bf7\u586b\u5199\u9a73\u56de\u51b6\u70bc\u5382ID\uff01\uff01");
        }
        if (StrUtil.isBlank((CharSequence)rejectSmelterIdVo.getRejectDesc())) {
            throw new ELSBootException("\u8bf7\u586b\u5199\u9a73\u56de\u539f\u56e0\uff01\uff01");
        }
        this.purchaseMineralsCollectService.invalids(collectItemIds, rejectSmelterIdVo.getSmelterIdentificationCo(), rejectSmelterIdVo.getRejectDesc());
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/toInvalid"})
    @RequiresPermissions(value={"minerals#purchaseMineralsCollect:cancel"})
    public Result<?> toInvalid(@RequestParam(name="ids") String ids, @RequestParam(name="cancelReason") String cancelReason) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseMineralsCollectService.toInvalid(idList, cancelReason);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u4fee\u6539\u9884\u8b66\u622a\u6b62\u65e5\u671f", notes="\u4fee\u6539\u9884\u8b66\u622a\u6b62\u65e5\u671f")
    @GetMapping(value={"/updateEndDate"})
    @RequiresPermissions(value={"minerals#purchaseMineralsCollect:modify"})
    public Result<?> updateEndDate(@RequestParam(name="ids") String ids, @RequestParam(name="endDate") String endDate) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseMineralsCollectService.updateEndDate(idList, endDate);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u6279\u91cf\u9a73\u56de", notes="\u6279\u91cf\u9a73\u56de")
    @GetMapping(value={"/completeOrderRejectBatch"})
    @RequiresPermissions(value={"minerals#purchaseMineralsDetail:reject"})
    public Result<?> completeOrderRejectBatch(@RequestParam(name="collectNumber") String collectNumber, @RequestParam(name="rejectDesc") String rejectDesc) {
        this.purchaseMineralsCollectService.completeOrderRejectBatch(collectNumber, rejectDesc);
        return this.commonSuccessResult(4);
    }
}

