/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rohsreport.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.rohsreport.entity.SaleRohsReportHead;
import com.els.modules.rohsreport.entity.SaleRohsReportItem;
import com.els.modules.rohsreport.service.SaleRohsReportHeadService;
import com.els.modules.rohsreport.service.SaleRohsReportItemService;
import com.els.modules.rohsreport.vo.SaleRohsReportHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rohsreport/saleRohsReportHead"})
@Api(tags={"\u68c0\u6d4b\u62a5\u544a"})
public class SaleRohsReportHeadController
extends BaseController<SaleRohsReportHead, SaleRohsReportHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleRohsReportHeadController.class);
    @Autowired
    private SaleRohsReportHeadService saleRohsReportHeadService;
    @Autowired
    private SaleRohsReportItemService saleRohsReportItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:list"})
    public Result<?> queryPageList(SaleRohsReportHead saleRohsReportHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleRohsReportHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.orderByDesc((Object[])new String[]{"create_time", "jc_date"});
        IPage pageList = this.saleRohsReportHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u68c0\u6d4b\u62a5\u544a", value="\u68c0\u6d4b\u7269\u8d28\u5217\u8868\u914d\u7f6e")
    @ApiOperation(value="\u68c0\u6d4b\u7269\u8d28\u5217\u8868\u914d\u7f6e", notes="\u68c0\u6d4b\u7269\u8d28\u5217\u8868\u914d\u7f6e")
    @GetMapping(value={"/itemConfigList"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:list"})
    public Result<?> itemConfigList(@RequestParam(value="headId", required=false) String headId) {
        List<SaleRohsReportItem> dbs = this.saleRohsReportItemService.selectByMainId(headId);
        Map<String, SaleRohsReportItem> cm = dbs.stream().collect(Collectors.toMap(x -> x.getConfigId(), y -> y));
        List<SaleRohsReportItem> saleRohsReportItems = this.saleRohsReportItemService.selectAllConfig(headId);
        saleRohsReportItems.forEach(item -> {
            if (cm.containsKey(item.getConfigId())) {
                SaleRohsReportItem dbItem = (SaleRohsReportItem)((Object)((Object)cm.get(item.getConfigId())));
                item.setFbk4(dbItem.getFbk4());
                item.setFbk5(dbItem.getFbk5());
            }
        });
        SaleRohsReportHeadVO saleRohsReportHeadVO = new SaleRohsReportHeadVO();
        saleRohsReportHeadVO.setSaleRohsReportItemList(saleRohsReportItems);
        return Result.ok((Object)((Object)saleRohsReportHeadVO));
    }

    @AutoLog(busModule="\u68c0\u6d4b\u62a5\u544a", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"saleRohsReportHead:add"})
    public Result<?> add(@RequestBody SaleRohsReportHeadVO saleRohsReportHeadPage) {
        SaleRohsReportHead saleRohsReportHead = new SaleRohsReportHead();
        BeanUtils.copyProperties((Object)((Object)saleRohsReportHeadPage), (Object)((Object)saleRohsReportHead));
        this.saleRohsReportHeadService.saveMain(saleRohsReportHead, saleRohsReportHeadPage.getSaleRohsReportItemList(), saleRohsReportHeadPage.getSaleRohsReportAttachmentList());
        return Result.ok((Object)((Object)saleRohsReportHead));
    }

    @AutoLog(busModule="\u68c0\u6d4b\u62a5\u544a", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:edit"})
    public Result<?> edit(@RequestBody SaleRohsReportHeadVO saleRohsReportHeadPage) {
        SaleRohsReportHead saleRohsReportHead = new SaleRohsReportHead();
        BeanUtils.copyProperties((Object)((Object)saleRohsReportHeadPage), (Object)((Object)saleRohsReportHead));
        this.saleRohsReportHeadService.updateMain(saleRohsReportHead, saleRohsReportHeadPage.getSaleRohsReportItemList(), saleRohsReportHeadPage.getSaleRohsReportAttachmentList(), saleRohsReportHeadPage.getSaleAttachmentDTOList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u68c0\u6d4b\u62a5\u544a", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:edit"})
    public Result<?> publish(@RequestBody SaleRohsReportHeadVO saleRohsReportHeadPage) {
        SaleRohsReportHead saleRohsReportHead = new SaleRohsReportHead();
        BeanUtils.copyProperties((Object)((Object)saleRohsReportHeadPage), (Object)((Object)saleRohsReportHead));
        this.saleRohsReportHeadService.publish(saleRohsReportHead, saleRohsReportHeadPage.getSaleRohsReportItemList(), saleRohsReportHeadPage.getSaleRohsReportAttachmentList(), saleRohsReportHeadPage.getSaleAttachmentDTOList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u68c0\u6d4b\u62a5\u544a", value="\u5220\u9664")
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:edit"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleRohsReportHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u68c0\u6d4b\u62a5\u544a", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/invalid"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:edit"})
    public Result<?> invalid(@RequestParam(name="id") String id) {
        this.saleRohsReportHeadService.invalid(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u68c0\u6d4b\u62a5\u544a", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:edit"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.saleRohsReportHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"gpmManagement#SaleRohsReportHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleRohsReportHead saleRohsReportHead = (SaleRohsReportHead)((Object)this.saleRohsReportHeadService.getById((Serializable)((Object)id)));
        SaleRohsReportHeadVO saleRohsReportHeadVO = new SaleRohsReportHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleRohsReportHead), (Object)((Object)saleRohsReportHeadVO));
        List<SaleRohsReportItem> saleRohsReportItemList = this.saleRohsReportItemService.selectByMainId(id);
        saleRohsReportHeadVO.setSaleRohsReportItemList(saleRohsReportItemList);
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        List<SaleAttachmentDTO> collect = saleAttachmentDTOList.stream().filter(e -> Objects.equals(e.getId(), saleRohsReportHead.getJcFileId())).collect(Collectors.toList());
        List<SaleAttachmentDTO> collect2 = saleAttachmentDTOList.stream().filter(e -> !Objects.equals(e.getId(), saleRohsReportHead.getJcFileId())).collect(Collectors.toList());
        saleRohsReportHeadVO.setSaleRohsReportAttachmentList(collect);
        saleRohsReportHeadVO.setSaleAttachmentDTOList(collect2);
        return Result.ok((Object)((Object)saleRohsReportHeadVO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u901a\u8fc7\u68c0\u6d4b\u62a5\u544a\u7f16\u7801\u67e5\u8be2-\u91c7\u8d2d\u7aef", notes="\u901a\u8fc7id\u67e5\u8be2-\u91c7\u8d2d\u7aef")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:view"})
    public Result<?> queryItemPageList(SaleRohsReportHead saleRohsReportHead) {
        String tenant = TenantContext.getTenant();
        TenantContext.setTenant((String)saleRohsReportHead.getElsAccount());
        try {
            SaleRohsReportHead head = (SaleRohsReportHead)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.saleRohsReportHeadService.lambdaQuery().eq(SaleRohsReportHead::getJcNumber, (Object)saleRohsReportHead.getJcNumber())).ne(SaleRohsReportHead::getJcState, (Object)"9")).one());
            if (head != null) {
                List<SaleRohsReportItem> list = this.saleRohsReportItemService.selectByMainId(head.getId());
                Page page = new Page();
                page.setRecords(list);
                page.setTotal((long)list.size());
                Result result = Result.ok((Object)page);
                return result;
            }
            Result result = Result.ok(null);
            return result;
        }
        finally {
            TenantContext.clear();
            if (CharSequenceUtil.isNotEmpty((CharSequence)tenant)) {
                TenantContext.setTenant((String)tenant);
            }
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u68c0\u6d4b\u62a5\u544a\u7f16\u7801\u67e5\u8be2-\u91c7\u8d2d\u7aef", notes="\u901a\u8fc7id\u67e5\u8be2-\u91c7\u8d2d\u7aef")
    @GetMapping(value={"/findDictItemsCustom"})
    @RequiresPermissions(value={"gpmManagement#purchaseRohsCollect:view"})
    public Result<?> findDictItemsCustom(@RequestParam(value="busAccount") String busAccount, @RequestParam(value="dictCode") String exempt) {
        List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(exempt, busAccount);
        Page iPage = new Page();
        iPage.setRecords(dictDTOS);
        iPage.setTotal((long)dictDTOS.size());
        return Result.ok((Object)iPage);
    }
}

