/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.report.entity.PurchasePerformanceDetailReport;
import com.els.modules.report.enumerate.AppealStatusEnum;
import com.els.modules.report.excel.PurchasePerformanceDetailReportExportServiceImpl;
import com.els.modules.report.service.PurchasePerformanceDetailReportService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="\u7ee9\u6548\u660e\u7ec6\u62a5\u8868")
@RestController
@RequestMapping(value={"/performanceReport/purchasePerformanceDetailReport"})
public class PurchasePerformanceDetailReportController
extends BaseController<PurchasePerformanceDetailReport, PurchasePerformanceDetailReportService> {
    @Autowired
    private PurchasePerformanceDetailReportService purchasePerformanceDetailReportService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"performanceReport#purchasePerformanceDetailReport:list"})
    @PermissionDataView(businessType="performanceReportDeliveryRate")
    public Result<?> queryPageList(PurchasePerformanceDetailReport purchasePerformanceDetailReport, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceDetailReport), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePerformanceDetailReportService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u660e\u7ec6\u62a5\u8868-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"performanceReport#purchasePerformanceDetailReport:add"})
    @PermissionDataOpt(businessType="performanceReportDeliveryRate", beanClass=PurchasePerformanceDetailReportService.class)
    public Result<?> add(@RequestBody PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        this.purchasePerformanceDetailReportService.savePurchasePerformanceDetailReport(purchasePerformanceDetailReport);
        return Result.ok((Object)((Object)purchasePerformanceDetailReport));
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u660e\u7ec6\u62a5\u8868-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"performanceReport#purchasePerformanceDetailReport:edit"})
    @PermissionDataOpt(businessType="performanceReportDeliveryRate", beanClass=PurchasePerformanceDetailReportService.class)
    public Result<?> edit(@RequestBody PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        this.purchasePerformanceDetailReportService.updatePurchasePerformanceDetailReport(purchasePerformanceDetailReport);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u660e\u7ec6\u62a5\u8868-\u540c\u610f")
    @Operation(summary="\u540c\u610f", description="\u540c\u610f")
    @PostMapping(value={"/agreeAppeal"})
    @RequiresPermissions(value={"performanceReportDeliveryRate#performanceDetailReport:agreeAppeal"})
    public Result<?> agree(@RequestBody List<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList) {
        Assert.notEmpty(purchasePerformanceDetailReportList, (String)I18nUtil.translate((String)"i18n_alert_iFjPzBjRHcxOLVW_fa0ba570", (String)"\u9009\u62e9\u7684\u8981\u6279\u590d\u7684\u660e\u7ec6\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
        for (PurchasePerformanceDetailReport purchasePerformanceDetailReport : purchasePerformanceDetailReportList) {
            Assert.isTrue((boolean)AppealStatusEnum.APPEALING.getValue().equals(purchasePerformanceDetailReport.getAppealStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjUWzEGUWUWsWjRHcnORcrtkW_ee83b9c9", (String)"\u53ea\u6709\u7533\u8bc9\u72b6\u6001\u5904\u4e8e[\u7533\u8bc9\u4e2d]\u7684\u660e\u7ec6\u884c\u624d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!"));
        }
        this.purchasePerformanceDetailReportService.agreeAppeal(purchasePerformanceDetailReportList);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u7ee9\u6548\u660e\u7ec6\u62a5\u8868-\u62d2\u7edd")
    @Operation(summary="\u62d2\u7edd", description="\u62d2\u7edd")
    @PostMapping(value={"/rejectAppeal"})
    @RequiresPermissions(value={"performanceReportDeliveryRate#performanceDetailReport:rejectAppeal"})
    public Result<?> rejectAppeal(@RequestBody List<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList) {
        Assert.notEmpty(purchasePerformanceDetailReportList, (String)I18nUtil.translate((String)"i18n_alert_iFjPzBjRHcxOLVW_fa0ba570", (String)"\u9009\u62e9\u7684\u8981\u6279\u590d\u7684\u660e\u7ec6\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
        for (PurchasePerformanceDetailReport purchasePerformanceDetailReport : purchasePerformanceDetailReportList) {
            Assert.isTrue((boolean)AppealStatusEnum.APPEALING.getValue().equals(purchasePerformanceDetailReport.getAppealStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjUWzEGUWUWsWjRHcnORcrtkW_ee83b9c9", (String)"\u53ea\u6709\u7533\u8bc9\u72b6\u6001\u5904\u4e8e[\u7533\u8bc9\u4e2d]\u7684\u660e\u7ec6\u884c\u624d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c!"));
        }
        this.purchasePerformanceDetailReportService.rejectAppeal(purchasePerformanceDetailReportList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7ee9\u6548\u660e\u7ec6\u62a5\u8868-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"performanceReport#purchasePerformanceDetailReport:delete"})
    @PermissionDataOpt(businessType="performanceReportDeliveryRate", beanClass=PurchasePerformanceDetailReportService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchasePerformanceDetailReportService.delPurchasePerformanceDetailReport(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ee9\u6548\u660e\u7ec6\u62a5\u8868-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"performanceReport#purchasePerformanceDetailReport:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchasePerformanceDetailReportService.delBatchPurchasePerformanceDetailReport(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"performanceReport#purchasePerformanceDetailReport:query"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchasePerformanceDetailReport purchasePerformanceDetailReport = (PurchasePerformanceDetailReport)((Object)this.purchasePerformanceDetailReportService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)purchasePerformanceDetailReport));
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="performanceReportDeliveryRate")
    @RequiresPermissions(value={"performanceReport#purchasePerformanceDetailReport:list"})
    public Result<?> queryTabsCount(PurchasePerformanceDetailReport purchasePerformanceDetailReport, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"appeal_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"appeal_status");
        List list = ((PurchasePerformanceDetailReportService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchasePerformanceDetailReport::getAppealStatus, PurchasePerformanceDetailReport::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "appealStatus", null, (long)all.intValue()));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmRectificationAppealStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "appealStatus", status.getValue(), (long)total.intValue()));
        }
        QueryWrapper queryWrapper2 = QueryGenerator.initQueryWrapper((Object)((Object)purchasePerformanceDetailReport), (Map)req.getParameterMap());
        queryWrapper2.select((Object[])new String[]{"performance_deduce", "count(0) as participateQuantity1"});
        queryWrapper2.groupBy((Object)"performance_deduce");
        List list1 = ((PurchasePerformanceDetailReportService)this.service).list((Wrapper)queryWrapper2);
        Map<String, Integer> countMap1 = list1.stream().collect(Collectors.toMap(PurchasePerformanceDetailReport::getPerformanceDeduce, PurchasePerformanceDetailReport::getParticipateQuantity1));
        Integer all1 = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/exportXls"})
    @PermissionDataView(businessType="performanceReportDeliveryRate")
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchasePerformanceDetailReportExportServiceImpl.class);
    }
}

