/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckProject;
import com.els.modules.sample.enumerate.PurchaseSampleCheckProjectEnum;
import com.els.modules.sample.service.PurchaseSampleCheckProjectService;
import com.els.modules.sample.vo.PurchaseSampleCheckProjectVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f")
@RestController
@RequestMapping(value={"/sample/purchaseSampleCheckProject"})
public class PurchaseSampleCheckProjectController
extends BaseController<PurchaseSampleCheckProject, PurchaseSampleCheckProjectService> {
    @Autowired
    private PurchaseSampleCheckProjectService purchaseSampleCheckProjectService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="sampleCheckProject")
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:list"})
    public Result<?> queryPageList(PurchaseSampleCheckProject purchaseSampleCheckProject, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckProject), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleCheckProjectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)", description="\u5206\u9875\u5217\u8868\u67e5\u8be2(\u542f\u52a8)")
    @GetMapping(value={"/enableList"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:list"})
    public Result<?> queryPageEnableList(PurchaseSampleCheckProject purchaseSampleCheckProject, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSampleCheckProject), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"project_status", (Object)PurchaseSampleCheckProjectEnum.ENABLED.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSampleCheckProjectService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:add"})
    @PermissionDataOpt(businessType="sampleCheckProject", beanClass=PurchaseSampleCheckProjectService.class)
    public Result<?> add(@RequestBody PurchaseSampleCheckProject purchaseSampleCheckProject) {
        this.verifySampleNumber(purchaseSampleCheckProject);
        this.purchaseSampleCheckProjectService.savePurchaseSampleCheckProject(purchaseSampleCheckProject);
        return Result.ok((Object)((Object)purchaseSampleCheckProject));
    }

    private void verifySampleNumber(PurchaseSampleCheckProject purchaseSampleCheckProject) {
        if (Objects.nonNull(purchaseSampleCheckProject.getSamplingNum()) && Objects.nonNull(purchaseSampleCheckProject.getSamplingRate()) || Objects.isNull(purchaseSampleCheckProject.getSamplingNum()) && Objects.isNull(purchaseSampleCheckProject.getSamplingRate())) {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"i18n_alert_CIVVWnVVlvlTSMAsRIxiTOSM_3265e8fc", (String)"\u56fa\u5b9a\u62bd\u6837\u6570\u548c\u62bd\u6837\u6bd4\u4f8b\u5fc5\u987b\u586b\u5199\u5176\u4e2d\u4e4b\u4e00\uff0c\u4e0d\u5141\u8bb8\u90fd\u586b\u5199"));
        }
        if (Objects.isNull(purchaseSampleCheckProject.getSamplingRate()) && purchaseSampleCheckProject.getSamplingNum().compareTo(BigDecimal.ZERO) <= 0) {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"i18n_alert_CIVNWlTfUWW_1b208a94", (String)"\u56fa\u5b9a\u6837\u54c1\u6570\u5fc5\u987b\u5927\u4e8e0\uff01"));
        }
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:edit"})
    @PermissionDataOpt(businessType="sampleCheckProject", beanClass=PurchaseSampleCheckProjectService.class)
    public Result<?> edit(@RequestBody PurchaseSampleCheckProject purchaseSampleCheckProject) {
        this.verifySampleNumber(purchaseSampleCheckProject);
        this.purchaseSampleCheckProjectService.updatePurchaseSampleCheckProject(purchaseSampleCheckProject);
        String id = purchaseSampleCheckProject.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u72b6\u6001\u542f\u7528")
    @Operation(summary="\u72b6\u6001\u542f\u7528", description="\u72b6\u6001\u542f\u7528")
    @PostMapping(value={"/changeEnable"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:changeEnable"})
    public Result<?> changeEnable(@RequestBody PurchaseSampleCheckProjectVO purchaseSampleCheckProjectVO) {
        purchaseSampleCheckProjectVO.setProjectStatus(PurchaseSampleCheckProjectEnum.ENABLED.getValue());
        PurchaseSampleCheckProject purchaseSampleCheckProject = new PurchaseSampleCheckProject();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckProjectVO), (Object)((Object)purchaseSampleCheckProject));
        this.purchaseSampleCheckProjectService.updateById((Object)purchaseSampleCheckProject);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u72b6\u6001\u7981\u7528")
    @Operation(summary="\u72b6\u6001\u7981\u7528", description="\u72b6\u6001\u7981\u7528")
    @PostMapping(value={"/changeDisable"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:changeDisable"})
    public Result<?> changeDisable(@RequestBody PurchaseSampleCheckProjectVO purchaseSampleCheckProjectVO) {
        purchaseSampleCheckProjectVO.setProjectStatus(PurchaseSampleCheckProjectEnum.DISABLED.getValue());
        PurchaseSampleCheckProject purchaseSampleCheckProject = new PurchaseSampleCheckProject();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleCheckProjectVO), (Object)((Object)purchaseSampleCheckProject));
        this.purchaseSampleCheckProjectService.updateById((Object)purchaseSampleCheckProject);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseSampleCheckProjectService.delPurchaseSampleCheckProject(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6837\u54c1\u68c0\u6d4b\u9879\u76ee\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseSampleCheckProjectService.delBatchPurchaseSampleCheckProject(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseSampleCheckProject purchaseSampleCheckProject = (PurchaseSampleCheckProject)((Object)this.purchaseSampleCheckProjectService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)purchaseSampleCheckProject));
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="sampleCheckProject")
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:list"})
    public Result<?> queryTabsCount(PurchaseSampleCheckProject purchaseSampleCheckProject, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"project_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"project_status");
        List list = ((PurchaseSampleCheckProjectService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseSampleCheckProject::getProjectStatus, PurchaseSampleCheckProject::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "projectStatus", null, (long)all.intValue()));
        List sampleCheckProjectStatus = this.invokeBaseRpcService.queryDictItemsByCode("sampleCheckProjectStatus", TenantContext.getTenant());
        for (DictDTO status : sampleCheckProjectStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "projectStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @Operation(summary="\u590d\u5236", description="\u590d\u5236")
    @PostMapping(value={"/copy/{id}"})
    @RequiresPermissions(value={"trialProduction#purchaseSampleCheckProject:copy"})
    public Result<?> copy(@PathVariable String id) {
        this.purchaseSampleCheckProjectService.copy(id);
        return Result.ok();
    }
}

