/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.spcn.entity.PurchaseSpcn;
import com.els.modules.spcn.entity.SpcnOrderDetail;
import com.els.modules.spcn.service.PurchaseSpcnService;
import com.els.modules.spcn.service.SpcnOrderDetailService;
import com.els.modules.spcn.vo.PurchaseSpcnVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="SPCN")
@RestController
@RequestMapping(value={"/spcn/purchaseSpcn"})
@BusinessModule(module="spcn")
public class PurchaseSpcnController
extends BaseController<PurchaseSpcn, PurchaseSpcnService> {
    @Autowired
    private PurchaseSpcnService purchaseSpcnService;
    @Autowired
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Autowired
    private SpcnOrderDetailService spcnOrderDetailService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:list"})
    @PermissionDataView(businessType="spcn")
    public Result<?> queryPageList(PurchaseSpcn purchaseSpcn, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSpcn), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSpcnService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2dSPCN-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:add"})
    @PermissionDataOpt(businessType="spcn", beanClass=PurchaseSpcnService.class)
    public Result<?> add(@RequestBody PurchaseSpcn purchaseSpcn) {
        this.purchaseSpcnService.savePurchaseSpcn(purchaseSpcn);
        return Result.ok((Object)((Object)purchaseSpcn));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2dSPCN-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:edit"})
    @PermissionDataOpt(businessType="spcn", beanClass=PurchaseSpcnService.class)
    public Result<?> edit(@RequestBody PurchaseSpcn purchaseSpcn) {
        this.purchaseSpcnService.updatePurchaseSpcn(purchaseSpcn);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2dSPCN-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:delete"})
    @PermissionDataOpt(businessType="spcn", beanClass=PurchaseSpcnService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseSpcnService.delPurchaseSpcn(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2dSPCN-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseSpcnService.delBatchPurchaseSpcn(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseSpcn purchaseSpcn = (PurchaseSpcn)((Object)this.purchaseSpcnService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseSpcnVO spcnVO = new PurchaseSpcnVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSpcn), (Object)((Object)spcnVO));
        List<SpcnOrderDetail> orderDetailList = this.spcnOrderDetailService.queryByMainId(id);
        spcnVO.setOrderDetailList(orderDetailList);
        List<PurchaseAttachmentDTO> attachments = this.ecnInvokeBaseRpcService.purcahseSelectByMainId(id);
        spcnVO.setAttachments(attachments);
        return Result.ok((Object)((Object)spcnVO));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2dSPCN-\u786e\u8ba4")
    @Operation(summary="\u786e\u8ba4", description="\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:confirm"})
    @PermissionDataOpt(businessType="spcn", beanClass=PurchaseSpcnService.class)
    public Result<?> confirm(@RequestBody PurchaseSpcnVO spcnVO) {
        PurchaseSpcn spcn = new PurchaseSpcn();
        BeanUtils.copyProperties((Object)((Object)spcnVO), (Object)((Object)spcn));
        this.purchaseSpcnService.confirmOperation(spcn, spcnVO.getAttachments());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2dSPCN-\u62d2\u7edd")
    @Operation(summary="\u62d2\u7edd", description="\u62d2\u7edd")
    @PostMapping(value={"/refused"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:refused"})
    @PermissionDataOpt(businessType="spcn", beanClass=PurchaseSpcnService.class)
    public Result<?> refused(@RequestBody PurchaseSpcnVO spcnVO) {
        PurchaseSpcn spcn = new PurchaseSpcn();
        BeanUtils.copyProperties((Object)((Object)spcnVO), (Object)((Object)spcn));
        this.purchaseSpcnService.confirmOperation(spcn, spcnVO.getAttachments());
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u83b7\u53d6ERP\u6570\u636e", description="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseSpcnService.getDataByErp();
        return Result.ok();
    }

    @Operation(summary="SRM\u63a8\u9001\u5230ERP", description="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"spcn#purchaseSpcnHead:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseSpcnService.pushDataToErp(ids);
        return Result.ok();
    }
}

