/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.modules.extend.api.dto.AccountModel;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.SubaccountOrgService;
import com.els.modules.system.service.SyncAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SyncAccountServiceImpl
implements SyncAccountService {
    private static final Logger log = LoggerFactory.getLogger(SyncAccountServiceImpl.class);
    private final ElsSubAccountService elsSubAccountService;
    private final RoleMapper roleMapper;
    private final UserRoleService userRoleService;
    private final PermissionDataService permissionDataService;
    private final ImGroupInvokeRpcService baseImGroupService;
    private final PersonalSettingService personalSettingService;
    private final SubaccountOrgService subaccountOrgService;
    @Value(value="${els.config.purchaseAccount}")
    private String purchaseAccount;
    private static final String PURCHASE_ORG = "purchaseOrg";
    private static final String DEPT = "dept";
    private static final String COMPANY = "company";

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void sync(JSONObject jsonObject) {
        JSONArray headList = jsonObject.getJSONArray("headList");
        List elsSubAccountList = headList.toJavaList(AccountModel.class);
        List ids = elsSubAccountList.stream().map(AccountModel::getId).collect(Collectors.toList());
        List existElsSubAccounts = this.elsSubAccountService.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)existElsSubAccounts)) {
            this.addElsSubAccountList(elsSubAccountList);
        } else {
            this.updateElsSubAccountList(elsSubAccountList, existElsSubAccounts);
        }
    }

    private void addRole(List<AccountModel> accountModels) {
        ArrayList roleCodes = new ArrayList();
        accountModels.forEach(account -> {
            String roleCode = account.getRoleCode();
            if (StringUtils.isNotBlank((CharSequence)roleCode)) {
                String[] split = roleCode.split(",");
                roleCodes.addAll(Arrays.asList(split));
            }
        });
        List elsRole = this.roleMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(Role::getRoleCode, roleCodes));
        Map roleMap = elsRole.stream().collect(Collectors.toMap(Role::getRoleCode, Function.identity()));
        List userRoleList = accountModels.stream().filter(accountModel -> StringUtils.isNotBlank((CharSequence)accountModel.getRoleCode())).map(accountModel -> {
            String roleCode = accountModel.getRoleCode();
            String[] split = roleCode.split(",");
            return Arrays.stream(split).map(code -> {
                Role role = (Role)roleMap.get(code);
                if (role == null) {
                    return null;
                }
                return new UserRole(accountModel.getId(), role.getId());
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        this.userRoleService.saveBatch(userRoleList);
    }

    private void addDefaultPermissionData(List<ElsSubAccount> subAccounts) {
        ArrayList<PermissionData> permissionDataList = new ArrayList<PermissionData>();
        for (ElsSubAccount subAccount : subAccounts) {
            PermissionData permissionDataOne = new PermissionData();
            permissionDataOne.setElsAccount(subAccount.getElsAccount());
            permissionDataOne.setSubAccount(subAccount.getSubAccount());
            permissionDataOne.setUserId(subAccount.getId());
            permissionDataOne.setBusinessType("all");
            permissionDataOne.setPermissionField("createBy");
            permissionDataOne.setPermissionValue(subAccount.getSubAccount());
            permissionDataOne.setDeleted(CommonConstant.DEL_FLAG_0);
            permissionDataOne.setOperation("1");
            permissionDataList.add(permissionDataOne);
        }
        if (!CollectionUtils.isEmpty(permissionDataList)) {
            this.permissionDataService.saveBatch(permissionDataList, 2000);
        }
    }

    private void addElsSubAccountList(List<AccountModel> accountModels) {
        List<ElsSubAccount> elsSubAccountList = this.newElsSubAccounts(accountModels);
        this.elsSubAccountService.saveBatch(elsSubAccountList);
        this.addRole(accountModels);
        this.addSbuAccountOrg(accountModels);
        List userIdList = accountModels.stream().map(AccountModel::getId).collect(Collectors.toList());
        try {
            this.baseImGroupService.initGroupBatch(userIdList);
        }
        catch (Exception e) {
            log.error(":::\u6dfb\u52a0\u597d\u53cb\u5206\u7ec4\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        this.addDefaultPermissionData(elsSubAccountList);
        this.insertPersonalSetting(elsSubAccountList);
    }

    private void addSbuAccountOrg(List<AccountModel> accountModels) {
        List subaccountOrgList = accountModels.stream().map(accountModel -> {
            String company = accountModel.getCompany();
            String department = accountModel.getDepartment();
            String orgCode = accountModel.getOrgCode();
            String id = accountModel.getId();
            String realname = accountModel.getRealname();
            String[] orgCodeArray = orgCode.split(",");
            String[] companyArray = company.split(",");
            String[] departmentArray = department.split(",");
            List<SubaccountOrg> purchaseOrg = this.getCollect(orgCodeArray, id, realname, PURCHASE_ORG);
            List<SubaccountOrg> companyOrg = this.getCollect(companyArray, id, realname, COMPANY);
            List<SubaccountOrg> deptOrg = this.getCollect(departmentArray, id, realname, DEPT);
            purchaseOrg.addAll(companyOrg);
            purchaseOrg.addAll(deptOrg);
            return purchaseOrg;
        }).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
        this.subaccountOrgService.saveBatch(subaccountOrgList, 2000);
    }

    @NotNull
    private List<SubaccountOrg> getCollect(String[] orgCodeArray, String id, String realname, String orgCategoryCode) {
        return Arrays.stream(orgCodeArray).filter(StringUtils::isNotBlank).map(code -> {
            SubaccountOrg subaccountOrg = new SubaccountOrg();
            subaccountOrg.setUserId(id);
            subaccountOrg.setOrgCategoryCode(orgCategoryCode);
            subaccountOrg.setOrgCode((String)code);
            subaccountOrg.setUserName(realname);
            return subaccountOrg;
        }).collect(Collectors.toList());
    }

    private List<ElsSubAccount> newElsSubAccounts(List<AccountModel> accountModels) {
        return accountModels.stream().map(accountModel -> {
            ElsSubAccount elsSubAccount = new ElsSubAccount();
            elsSubAccount.setElsAccount(this.purchaseAccount);
            elsSubAccount.setSubAccount(accountModel.getSubAccount());
            elsSubAccount.setWorkNo(accountModel.getWorkNo());
            elsSubAccount.setRealname(accountModel.getRealname());
            elsSubAccount.setEmail(accountModel.getEmail());
            elsSubAccount.setPhone(accountModel.getPhone());
            elsSubAccount.setId(accountModel.getId());
            elsSubAccount.setTelephone(accountModel.getPhone());
            elsSubAccount.setStatus(Integer.valueOf(accountModel.getStatus()));
            elsSubAccount.setDeleted(CommonConstant.DEL_FLAG_0);
            String salt = ConvertUtils.randomGen((int)8);
            elsSubAccount.setSalt(salt);
            String passwordEncode = PasswordUtil.encrypt((String)(this.purchaseAccount + "_" + accountModel.getSubAccount()), (String)accountModel.getPassword(), (String)salt);
            elsSubAccount.setPassword(passwordEncode);
            elsSubAccount.setSourceSystem("IAM");
            return elsSubAccount;
        }).collect(Collectors.toList());
    }

    private void insertPersonalSetting(List<ElsSubAccount> users) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList personalSettings = new ArrayList();
        users.forEach(user -> {
            for (String str : list) {
                PersonalSetting personalSetting = new PersonalSetting();
                personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
                personalSetting.setElsAccount(user.getElsAccount());
                personalSetting.setSubAccount(user.getSubAccount());
                personalSetting.setCreateBy(user.getCreateBy());
                personalSetting.setCreateTime(new Date());
                personalSetting.setUpdateBy(user.getUpdateBy());
                personalSetting.setUpdateTime(new Date());
                personalSetting.setReceiveType(str);
                personalSetting.setIsReceive(0);
                personalSettings.add(personalSetting);
            }
        });
        this.personalSettingService.saveBatch(personalSettings);
    }

    private void updateElsSubAccountList(List<AccountModel> subAccountList, List<ElsSubAccount> existElsSubAccounts) {
        this.updateAccount(subAccountList, existElsSubAccounts);
        Set existUserIds = existElsSubAccounts.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        List<AccountModel> inExistAccountList = subAccountList.stream().filter(ret -> !existUserIds.contains(ret.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(inExistAccountList)) {
            this.addElsSubAccountList(inExistAccountList);
        }
    }

    private void updateAccount(List<AccountModel> subAccountList, List<ElsSubAccount> existElsSubAccounts) {
        Map accountModelMap = subAccountList.stream().collect(Collectors.toMap(AccountModel::getId, Function.identity(), (value1, value2) -> value2));
        ArrayList updateElsSubAccounts = new ArrayList();
        ArrayList<AccountModel> existAccountModels = new ArrayList<AccountModel>();
        existElsSubAccounts.forEach(elsSubAccount -> {
            AccountModel accountModel = (AccountModel)accountModelMap.get(elsSubAccount.getId());
            if (accountModel != null) {
                elsSubAccount.setRealname(accountModel.getRealname());
                elsSubAccount.setEmail(accountModel.getEmail());
                elsSubAccount.setPhone(accountModel.getPhone());
                elsSubAccount.setWorkNo(accountModel.getWorkNo());
                elsSubAccount.setId(accountModel.getId());
                elsSubAccount.setTelephone(accountModel.getPhone());
                elsSubAccount.setUpdateTime(new Date());
                elsSubAccount.setStatus(Integer.valueOf(accountModel.getStatus()));
                String passwordEncode = PasswordUtil.encrypt((String)(this.purchaseAccount + "_" + elsSubAccount.getSubAccount()), (String)accountModel.getPassword(), (String)elsSubAccount.getSalt());
                elsSubAccount.setPassword(passwordEncode);
                updateElsSubAccounts.add(elsSubAccount);
                existAccountModels.add(accountModel);
            }
        });
        existAccountModels.forEach(accountModel -> {
            this.subaccountOrgService.deleteByMainId(accountModel.getId());
            this.userRoleService.remove((Wrapper)Wrappers.lambdaQuery().eq(UserRole::getUserId, (Object)accountModel.getId()));
        });
        this.addSbuAccountOrg(existAccountModels);
        this.addRole(existAccountModels);
        this.elsSubAccountService.updateBatchById(updateElsSubAccounts);
    }

    public SyncAccountServiceImpl(ElsSubAccountService elsSubAccountService, RoleMapper roleMapper, UserRoleService userRoleService, PermissionDataService permissionDataService, ImGroupInvokeRpcService baseImGroupService, PersonalSettingService personalSettingService, SubaccountOrgService subaccountOrgService) {
        this.elsSubAccountService = elsSubAccountService;
        this.roleMapper = roleMapper;
        this.userRoleService = userRoleService;
        this.permissionDataService = permissionDataService;
        this.baseImGroupService = baseImGroupService;
        this.personalSettingService = personalSettingService;
        this.subaccountOrgService = subaccountOrgService;
    }
}

