/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.api.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.vo.LoginUser;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d26\u53f7\u6a21\u5757\u670d\u52a1"})
@RestController
@RequestMapping(value={"/accountApi"})
public class AccountApiController {
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private PermissionDataService permissionDataService;
    @Resource
    private ThirdAccountService thirdAccountService;
    @Resource
    private PersonalSettingService personalSettingService;

    @GetMapping(value={"/noToken/getThirdAccount"})
    Result<?> getThirdAccount(@RequestParam(name="accountId") String accountId, @RequestParam(name="thirdType") String thirdType) {
        List list = this.thirdAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)accountId)).eq((Object)"third_type", (Object)thirdType));
        return Result.ok((Object)list);
    }

    @GetMapping(value={"/noToken/getPersonalSetting"})
    Result<?> getPersonalSetting(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(PersonalSetting::getElsAccount, (Object)elsAccount);
        query.eq(PersonalSetting::getSubAccount, (Object)subAccount);
        query.eq(PersonalSetting::getIsReceive, (Object)"0");
        List personalSettings = this.personalSettingService.list((Wrapper)query);
        return Result.ok((Object)personalSettings);
    }

    @GetMapping(value={"/noToken/getAccount"})
    Result<?> getAccount(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        return Result.ok((Object)((Object)elsSubAccount));
    }

    @GetMapping(value={"/noToken/getLoginUser"})
    Result<?> getLoginUser(@RequestParam(name="account") String account) {
        LoginUser loginUser = this.sysBaseAPI.getUserByAccount(account);
        return Result.ok((Object)loginUser);
    }

    @GetMapping(value={"/noToken/getUserRolesSet"})
    Result<?> getUserRolesSet(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount) {
        Set<String> roleSet = this.elsSubAccountService.getUserRolesSet(elsAccount, subAccount);
        return Result.ok(roleSet);
    }

    @GetMapping(value={"/noToken/getUserPermissionsSet"})
    Result<?> getUserPermissionsSet(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount) {
        Set<String> permissionSet = this.elsSubAccountService.getUserPermissionsSet(elsAccount, subAccount);
        return Result.ok(permissionSet);
    }

    @GetMapping(value={"/noToken/getAllOptPermission"})
    Result<?> getAllOptPermission() {
        Set<String> permissionSet = this.permissionService.getAllOptPermission();
        return Result.ok(permissionSet);
    }

    @GetMapping(value={"/getPermissionDataList"})
    Result<?> getPermissionDataList(@RequestParam(name="elsAccount") String elsAccount, @RequestParam(name="subAccount") String subAccount, @RequestParam(name="businessType") String businessType) {
        List<PermissionData> dataList = this.permissionDataService.getPermissionDataList(elsAccount, subAccount, businessType);
        return Result.ok(dataList);
    }

    @PostMapping(value={"/role/insert"})
    Result<?> roleInsert(@RequestBody Role role) {
        this.roleService.save(role);
        return Result.ok();
    }
}

