/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.vo.LoginUser;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.account.api.service.AccountDubboService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;

@DubboService
public class AccountDubboServiceImpl
implements AccountDubboService {
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;
    @Resource
    private PermissionService permissionService;
    @Resource
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private PermissionDataService permissionDataService;
    @Resource
    private ThirdAccountService thirdAccountService;
    @Resource
    private PersonalSettingService personalSettingService;

    public List<ThirdAccountDTO> getThirdAccount(String accountId, String thirdType) {
        List list = this.thirdAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)accountId)).eq((Object)"third_type", (Object)thirdType));
        ArrayList<ThirdAccountDTO> resultList = new ArrayList<ThirdAccountDTO>();
        for (ThirdAccount account : list) {
            ThirdAccountDTO accountDTO = new ThirdAccountDTO();
            BeanUtils.copyProperties((Object)((Object)account), (Object)accountDTO);
            resultList.add(accountDTO);
        }
        return resultList;
    }

    public List<PersonalSettingDTO> getPersonalSetting(String elsAccount, String subAccount) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(PersonalSetting::getElsAccount, (Object)elsAccount);
        query.eq(PersonalSetting::getSubAccount, (Object)subAccount);
        query.eq(PersonalSetting::getIsReceive, (Object)"0");
        List personalSettings = this.personalSettingService.list((Wrapper)query);
        ArrayList<PersonalSettingDTO> resultList = new ArrayList<PersonalSettingDTO>();
        for (PersonalSetting setting : personalSettings) {
            PersonalSettingDTO settingDTO = new PersonalSettingDTO();
            BeanUtils.copyProperties((Object)setting, (Object)settingDTO);
            resultList.add(settingDTO);
        }
        return resultList;
    }

    public ElsSubAccountDTO getAccount(String elsAccount, String subAccount) {
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        ElsSubAccountDTO accountDTO = new ElsSubAccountDTO();
        BeanUtils.copyProperties((Object)((Object)elsSubAccount), (Object)accountDTO);
        return accountDTO;
    }

    public LoginUserDTO getLoginUser(String account) {
        LoginUser loginUser = this.sysBaseAPI.getUserByAccount(account);
        LoginUserDTO loginUserDTO = new LoginUserDTO();
        BeanUtils.copyProperties((Object)loginUser, (Object)loginUserDTO);
        return loginUserDTO;
    }

    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        Set<String> roleSet = this.elsSubAccountService.getUserRolesSet(elsAccount, subAccount);
        return roleSet;
    }

    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        Set<String> permissionSet = this.elsSubAccountService.getUserPermissionsSet(elsAccount, subAccount);
        return permissionSet;
    }

    public Set<String> getAllOptPermission() {
        Set<String> permissionSet = this.permissionService.getAllOptPermission();
        return permissionSet;
    }

    public List<PermissionDataDTO> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List<PermissionData> dataList = this.permissionDataService.getPermissionDataList(elsAccount, subAccount, businessType);
        ArrayList<PermissionDataDTO> resultList = new ArrayList<PermissionDataDTO>();
        for (PermissionData data : dataList) {
            PermissionDataDTO dataDTO = new PermissionDataDTO();
            BeanUtils.copyProperties((Object)((Object)data), (Object)dataDTO);
            resultList.add(dataDTO);
        }
        return resultList;
    }
}

