/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.RestUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.JustAuthConfig;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.util.QRCodeUtil;
import com.els.modules.wechat.enums.QRCodeConstant;
import com.els.modules.wechat.vo.TicketVO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/personalSetting"})
public class PersonalSettingController
extends BaseController<PersonalSetting, PersonalSettingService> {
    private static final Logger log = LoggerFactory.getLogger(PersonalSettingController.class);
    @Autowired
    private PersonalSettingService personalSettingService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u4fdd\u5b58\u63a5\u53d7\u8bbe\u7f6e", logType=2, operateType=3)
    @PostMapping(value={"/saveSetting"})
    public Result<?> saveSetting(@RequestBody PersonalSetting personalSetting) {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->saveSetting: personalSetting: " + personalSetting + ", elsAccount: " + elsAccount + ", subAccount: " + subAccount);
        this.personalSettingService.saveNewSetting(elsAccount, subAccount, personalSetting);
        return Result.ok();
    }

    @GetMapping(value={"/querySetting"})
    public Result<?> querySetting() {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->querySetting: elsAccount: " + elsAccount + ",subAccount: " + subAccount);
        List<PersonalSetting> personalSetting = this.personalSettingService.querySettingBySubAccount(elsAccount, subAccount);
        return Result.ok(personalSetting);
    }

    @GetMapping(value={"/queryBindList"})
    public Result<?> queryBindList() {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->queryBindList: elsAccount: " + elsAccount + ",subAccount: " + subAccount);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        query.eq(ThirdAccount::getUserId, (Object)this.getCurrentUser().getId());
        List list = this.thirdAccountService.list((Wrapper)query);
        return Result.ok((Object)list);
    }

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u751f\u6210\u5fae\u4fe1\u4e8c\u7ef4\u7801", logType=2, operateType=3)
    @GetMapping(value={"/generateWechatQRCode"})
    public Result<?> generateWechatQRCode() {
        String code = "";
        Map type = ((JustAuthConfig)SpringContextUtils.getBean(JustAuthConfig.class)).getType();
        String appID = (String)type.get("WECHAT_MP.client-id");
        String loginUri = (String)type.get("WECHAT_MP.login-uri");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(loginUri).append("?").append("appid=").append(appID).append("&").append("redirect_uri=").append("https://api.weixin.qq.com/cgi-bin/qrcode/create").append("/").append(this.getTenantId()).append("/").append(this.getCurrentUser().getSubAccount()).append("&").append("response_type=").append("code").append("&").append("scope=").append("snsapi_userinfo").append("&").append("state=").append("STATE#wechat_redirec");
            code = QRCodeUtil.createQRCode(sb.toString());
            log.info("PersonalSettingController->generateWechatQRCode: code: " + code);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("PersonalSettingController->generateWechatQRCode error: ", (Object)e.getMessage());
        }
        return Result.ok((String)code);
    }

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u89e3\u9664\u5fae\u4fe1\u7ed1\u5b9a", logType=2, operateType=4)
    @GetMapping(value={"/wechatUnBind"})
    public Result<?> wechatUnBind() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(BaseEntity::getElsAccount, (Object)this.getTenantId());
        query.eq(ThirdAccount::getUserId, (Object)this.getCurrentUser().getId());
        this.thirdAccountService.remove((Wrapper)query);
        return Result.ok();
    }

    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u751f\u6210\u5fae\u4fe1\u4e8c\u7ef4\u7801", logType=2, operateType=1)
    @GetMapping(value={"/generateWechatMPQRCode"})
    public Result<Object> generateWechatMPQRCode() {
        String code = "";
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTenantId()).append("-").append(this.getCurrentUser().getId());
        JSONObject ticketJson = this.createTempTicket(ThirdTokenUtil.getWechatMpToken(), sb.toString(), 0);
        if (ticketJson.containsKey((Object)"errcode")) {
            return Result.error((String)ticketJson.getString("errmsg"));
        }
        String ticketStr = ticketJson.getString("ticket");
        StringBuffer buffer = new StringBuffer();
        buffer.append("https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=").append(ticketStr);
        TicketVO resultVO = new TicketVO();
        resultVO.setTicketUri(buffer.toString());
        resultVO.setExpireSeconds(ticketJson.getInteger("expire_seconds"));
        return Result.ok((Object)resultVO);
    }

    public JSONObject createTempTicket(String accessToken, String sceneStr, int expireSeconds) {
        JSONObject params = new JSONObject();
        params.put("access_token", (Object)accessToken);
        JSONObject data = new JSONObject();
        data.put("action_name", (Object)QRCodeConstant.QR_STR_SCENE.getCode());
        if (expireSeconds != 0) {
            data.put("expire_seconds", (Object)expireSeconds);
        }
        JSONObject scene = new JSONObject();
        scene.put("scene_str", (Object)sceneStr);
        JSONObject actionInfo = new JSONObject();
        actionInfo.put("scene", (Object)scene);
        data.put("action_info", (Object)actionInfo);
        log.info("WechatUtil->createTempTicket send post [url:{} , params:{}, data:{}]", new Object[]{"https://api.weixin.qq.com/cgi-bin/qrcode/create", params, data});
        JSONObject object = RestUtil.post((String)"https://api.weixin.qq.com/cgi-bin/qrcode/create", (JSONObject)params, (JSONObject)data);
        log.info("WechatUtil->createTempTicket result {}", (Object)object);
        return object;
    }
}

