/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.els.common.util.ConvertUtils;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.PermissionData;
import java.util.List;

public class PermissionDataUtil {
    private static ThreadLocal<List<PermissionData>> currentPermissionData = new ThreadLocal();

    public static void setData(List<PermissionData> list) {
        currentPermissionData.set(list);
    }

    public static List<PermissionData> getData() {
        return currentPermissionData.get();
    }

    public static void clear() {
        currentPermissionData.remove();
    }

    public static Permission intelligentProcessData(Permission permission) {
        if (permission == null) {
            return null;
        }
        if (ConvertUtils.isNotEmpty((Object)permission.getComponent())) {
            String component = permission.getComponent();
            if (component.startsWith("/")) {
                component = component.substring(1);
            }
            if (component.startsWith("views/")) {
                component = component.replaceFirst("views/", "");
            }
            if (component.startsWith("src/views/")) {
                component = component.replaceFirst("src/views/", "");
            }
            if (component.endsWith(".vue")) {
                component = component.replace(".vue", "");
            }
            permission.setComponent(component);
        }
        if (ConvertUtils.isNotEmpty((Object)permission.getUrl())) {
            String url = permission.getUrl();
            if (url.endsWith(".vue")) {
                url = url.replace(".vue", "");
            }
            if (!(url.startsWith("http") || url.startsWith("/") || url.trim().startsWith("{{"))) {
                url = "/" + url;
            }
            permission.setUrl(url);
        }
        if (permission.getMenuType() == 0 && ConvertUtils.isEmpty((Object)permission.getComponent())) {
            permission.setComponent("layouts/RouteView");
        }
        return permission;
    }

    public static void addIndexPage(List<Permission> metaList) {
        boolean hasIndexMenu = false;
        for (Permission sysPermission : metaList) {
            if (!"\u9996\u9875".equals(sysPermission.getName())) continue;
            hasIndexMenu = true;
            break;
        }
        if (!hasIndexMenu) {
            metaList.add(0, new Permission(true));
        }
    }
}

