/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryinfo.entity.GoodsCategory;
import com.els.modules.industryinfo.mapper.GoodsCategoryMapper;
import com.els.modules.industryinfo.service.GoodsCategoryService;
import com.els.modules.industryinfo.vo.GoodsCategoryVo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsCategoryServiceImpl
extends BaseServiceImpl<GoodsCategoryMapper, GoodsCategory>
implements GoodsCategoryService {
    private static final Logger log = Logger.getLogger(GoodsCategoryServiceImpl.class);
    @Autowired
    private GoodsCategoryMapper categoryMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "good:category:cache";
    private static final String COLON = ":";

    @Override
    public List<GoodsCategoryVo> queryCategoryList() {
        StringBuilder redisKey;
        List collect;
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        if ((collect = (List)this.redisUtil.get((redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(COLON).append(language)).toString())) == null) {
            log.info((Object)"\u65e0\u7f13\u5b58goodsCategories\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"", (Object)0);
            queryWrapper.eq((Object)"", (Object)0);
            List<GoodsCategoryVo> goodsCategories = this.categoryMapper.selectList((QueryWrapper<GoodsCategoryVo>)queryWrapper);
            collect = goodsCategories.stream().filter(item -> item.getParentId().equals("0")).map(item -> item.setChildren(this.getChild(item.getCategoryId(), goodsCategories))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                this.redisUtil.set(redisKey.toString(), collect, 7200L);
            }
        }
        return collect;
    }

    public List<GoodsCategoryVo> getChild(String categoryId, List<GoodsCategoryVo> allMenu) {
        List<GoodsCategoryVo> collect = allMenu.stream().filter(item -> item.getParentId().equals(categoryId)).map(item -> item.setChildren(this.getChild(item.getCategoryId(), allMenu))).collect(Collectors.toList());
        return collect.size() > 0 ? collect : null;
    }

    @Override
    @Transactional
    public void insertBatch(List<List<GoodsCategory>> goodsCategorys) {
        this.delete();
        goodsCategorys.stream().filter(a -> a.size() > 0).forEach(((GoodsCategoryMapper)this.baseMapper)::insertBatch);
    }

    @Override
    public void delete() {
        ((GoodsCategoryMapper)this.baseMapper).delete();
    }

    @Override
    public void cleanCache() {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(COLON).append(language);
        this.redisUtil.del(new String[]{redisKey.toString()});
    }
}

