/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.industryinfo.dto.TopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.StoreTopmanItem;
import com.els.modules.industryinfo.entity.StoreTopmanRecord;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.mapper.StoreTopmanRecordMapper;
import com.els.modules.industryinfo.mapper.TopManInformationHeadMapper;
import com.els.modules.industryinfo.service.StoreTopmanItemService;
import com.els.modules.industryinfo.service.StoreTopmanRecordService;
import com.els.modules.industryinfo.vo.TabCountVO;
import com.els.modules.industryinfo.vo.TopmanItemVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreTopmanRecordServiceImpl
extends BaseServiceImpl<StoreTopmanRecordMapper, StoreTopmanRecord>
implements StoreTopmanRecordService {
    @Autowired
    private StoreTopmanRecordMapper storeTopmanRecordMapper;
    @Autowired
    private StoreTopmanItemService storeTopmanItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private TopManInformationHeadMapper topManInformationHeadMapper;

    @Override
    public List<StoreTopmanRecord> selectByMainId(String mainId) {
        return this.storeTopmanRecordMapper.selectByMainId(mainId);
    }

    @Override
    public IPage<StoreTopmanRecord> queryTopmanPage(Page<StoreTopmanRecord> page, QueryWrapper<StoreTopmanRecord> queryWrapper, TopmanItemQueryDTO queryDTO) {
        this.criteriaQuery(queryWrapper, queryDTO);
        Page recordPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(recordPage.getRecords(), queryDTO);
        return recordPage;
    }

    @Override
    public IPage<TopmanItemVO> queryTopmanPageNew(Page<TopManInformationHead> page, QueryWrapper<TopManInformationHead> queryWrapper, TopmanItemQueryDTO queryDTO) {
        IPage<TopmanItemVO> itemPage;
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        String contentType = queryDTO.getTopmanContentType();
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            if (contentType.contains(",")) {
                contentType = contentType.replace(",", "|");
            } else if (contentType.contains("\u5168\u90e8")) {
                contentType = "";
            }
            queryDTO.setTopmanContentType(contentType);
        }
        if (!CollectionUtils.isEmpty((Collection)(itemPage = this.topManInformationHeadMapper.topManInformationHeadPageByShopId(page, queryWrapper, queryDTO)).getRecords())) {
            for (TopmanItemVO vo : itemPage.getRecords()) {
                if (vo.getPrice() == null || vo.getPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                vo.setSalesNum(vo.getSalesAmountMax().divide(vo.getPrice(), 0, 4));
            }
        }
        return itemPage;
    }

    private List<StoreTopmanRecord> replenish(List<StoreTopmanRecord> records, TopmanItemQueryDTO queryDTO) {
        if (!CollectionUtils.isEmpty(records)) {
            for (StoreTopmanRecord record : records) {
                StoreTopmanItem item = this.storeTopmanItemService.queryTopmanItem(record.getId(), queryDTO.getTopmanTimeSelect());
                if (item == null) continue;
                record.setGoodsNum(item.getGoodsNum());
                record.setVideosNum(item.getVideosNum());
                record.setLivesNum(item.getLivesNum());
                record.setSalesNum(item.getSalesNum());
                record.setSalesAmountMin(item.getSalesAmountMin());
                record.setSalesAmountMax(item.getSalesAmountMax());
                record.setQueryDay(item.getQueryDay());
            }
        }
        return records;
    }

    private QueryWrapper<StoreTopmanRecord> criteriaQuery(QueryWrapper<StoreTopmanRecord> queryWrapper, TopmanItemQueryDTO queryDTO) {
        List<StoreTopmanItem> records;
        Boolean phoneNumber;
        String goodsWom;
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        if (timeSelect.length() < 10) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)selectDay, (Object)today);
        } else if (timeSelect.contains("\u81f3")) {
            String[] strings = timeSelect.split("\u81f3");
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)strings[0], (Object)strings[1]);
        }
        String fansNum = queryDTO.getTopmanFansNum();
        if (StringUtils.isNotBlank((CharSequence)fansNum)) {
            String[] strings;
            if (fansNum.contains("-")) {
                strings = fansNum.split("-");
                queryWrapper.lambda().gt(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains("<")) {
                strings = fansNum.split("<");
                queryWrapper.lambda().lt(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains(">")) {
                strings = fansNum.split(">");
                queryWrapper.lambda().gt(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsWom = queryDTO.getTopmanGoodsWom()))) {
            String[] strings;
            if (goodsWom.contains("-")) {
                strings = goodsWom.split("-");
                queryWrapper.lambda().between(StoreTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (goodsWom.contains("<")) {
                strings = goodsWom.split("<");
                queryWrapper.lambda().lt(StoreTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(StoreTopmanRecord::getGoodsWom, (Object)new BigDecimal(goodsWom));
            }
        }
        if ((phoneNumber = queryDTO.getTopmanPhoneNumber()) != null && phoneNumber.booleanValue()) {
            queryWrapper.lambda().isNotNull(StoreTopmanRecord::getPhoneNumber);
        }
        if (CollectionUtil.isNotEmpty(records = this.storeTopmanItemService.queryList(queryDTO))) {
            List recordIds = records.stream().map(StoreTopmanItem::getRecordId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, recordIds);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        return queryWrapper;
    }

    @Override
    public List<CountVO> contentTypeCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        List<TabCountVO> list = this.topManInformationHeadMapper.tabCountByShopId(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "talentClassification", null, Integer.valueOf(list.size())));
        if (CollectionUtil.isEmpty(list)) {
            return result;
        }
        LinkedHashSet<String> finalTypes = new LinkedHashSet<String>();
        for (TabCountVO vo : list) {
            if (!StringUtils.isNotBlank((CharSequence)vo.getType())) continue;
            if (vo.getType().contains("-")) {
                String[] split = vo.getType().split("-");
                finalTypes.addAll(Arrays.asList(split));
                continue;
            }
            finalTypes.add(vo.getType());
        }
        if (CollectionUtil.isNotEmpty(finalTypes)) {
            for (String finalType : finalTypes) {
                long count = list.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getType()) && h.getType().contains(finalType)).count();
                result.add(new CountVO(I18nUtil.translate((String)"", (String)finalType), "talentClassification", finalType, Integer.valueOf((int)count)));
            }
        }
        return result;
    }

    @Override
    public List<CountVO> goodsWomCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        List<TabCountVO> list = this.topManInformationHeadMapper.tabCountByShopId(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "topmanGoodsWom", null, Integer.valueOf(list.size())));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("topmanGoodsWom", TenantContext.getTenant());
        for (DictDTO dto : dictDTOList) {
            long total = 0L;
            if (dto.getValue().contains("-")) {
                String[] strings = dto.getValue().split("-");
                total = list.stream().filter(h -> h.getGoodsWom() != null && h.getGoodsWom().compareTo(new BigDecimal(strings[0])) >= 0 && h.getGoodsWom().compareTo(new BigDecimal(strings[1])) <= 0).count();
            }
            result.add(new CountVO(I18nUtil.translate((String)dto.getTextI18nKey(), (String)dto.getText()), "topmanGoodsWom", dto.getValue(), Integer.valueOf((int)total)));
        }
        return result;
    }
}

