/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.utils.spider.spiderApi;

import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.industryinfo.utils.spider.entity.StorePhoneEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManDetailBaseEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManDetailSaleGoodsEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSaleGoodsTagEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSpiderGoodsListEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSpiderShopListEntity;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderResponse;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class SpiderApiUtil {
    @Autowired
    private RedisUtil redisUtil;
    private final RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory(){
        {
            this.setReadTimeout(5000);
            this.setConnectTimeout(5000);
        }
    });
    public static final ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor(){
        {
            this.setCorePoolSize(3);
            this.setMaxPoolSize(5);
            this.setKeepAliveSeconds(60);
            this.setThreadNamePrefix("spider-api-");
            this.initialize();
        }
    };
    @Value(value="${spiderApi.url}")
    private String apiUrl;
    @Value(value="${spiderApi.port}")
    private String apiPort;
    @Value(value="${spiderApi.method.base}")
    private String detailBaseUrl;
    @Value(value="${spiderApi.method.saleGoods}")
    private String detailSaleGoodsUrl;
    @Value(value="${spiderApi.method.saleGoodsTag}")
    private String saleGoodsTagUrl;
    @Value(value="${spiderApi.method.saleGoodsProduct}")
    private String saleGoodsProductUrl;
    @Value(value="${spiderApi.method.saleGoodsShop}")
    private String saleGoodsShopUrl;
    @Value(value="${spiderApi.method.storePhone}")
    private String storePhoneUrl;

    public TopManDetailBaseEntity getTopManBaseDetail(final String topManId, final String days) {
        String key = "TopManBaseDetailFromApi_" + topManId + "_" + days;
        TopManDetailBaseEntity topManDetailBaseEntity = (TopManDetailBaseEntity)this.redisUtil.get(key);
        if (topManDetailBaseEntity == null) {
            String paramString = this.getParamString((Map<String, Object>)new HashMap<String, Object>(2){
                {
                    super(x0);
                    this.put("uid", topManId);
                    this.put("days", days);
                }
            });
            String url = this.apiUrl + ":" + this.apiPort + this.detailBaseUrl + paramString;
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, TopManDetailBaseEntity.Response.class, new Object[0]);
            TopManDetailBaseEntity.Response body = (TopManDetailBaseEntity.Response)forEntity.getBody();
            this.checkRequest(forEntity);
            topManDetailBaseEntity = (TopManDetailBaseEntity)body.getData();
            this.redisUtil.set(key, (Object)topManDetailBaseEntity, 14400L);
        }
        return topManDetailBaseEntity;
    }

    public TopManDetailSaleGoodsEntity getTopManSaleGoodsDetail(final String topManId, final String days) {
        String key = "TopManSaleGoodsDetailFromApi_" + topManId + "_" + days;
        TopManDetailSaleGoodsEntity saleGoodsEntity = (TopManDetailSaleGoodsEntity)this.redisUtil.get(key);
        if (saleGoodsEntity == null) {
            String paramString = this.getParamString((Map<String, Object>)new HashMap<String, Object>(2){
                {
                    super(x0);
                    this.put("uid", topManId);
                    this.put("days", days);
                }
            });
            String url = this.apiUrl + ":" + this.apiPort + this.detailSaleGoodsUrl + paramString;
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, TopManDetailSaleGoodsEntity.Response.class, new Object[0]);
            TopManDetailSaleGoodsEntity.Response body = (TopManDetailSaleGoodsEntity.Response)forEntity.getBody();
            this.checkRequest(forEntity);
            saleGoodsEntity = (TopManDetailSaleGoodsEntity)body.getData();
            this.redisUtil.set(key, (Object)saleGoodsEntity, 14400L);
        }
        return saleGoodsEntity;
    }

    public TopManSaleGoodsTagEntity getTopManSaleGoodsTag(final String topManId, final String days) {
        String key = "TopManSaleGoodsTagFromApi_" + topManId + "_" + days;
        TopManSaleGoodsTagEntity tagEntity = (TopManSaleGoodsTagEntity)this.redisUtil.get(key);
        if (tagEntity == null) {
            String paramString = this.getParamString((Map<String, Object>)new HashMap<String, Object>(2){
                {
                    super(x0);
                    this.put("uid", topManId);
                    this.put("days", days);
                }
            });
            String url = this.apiUrl + ":" + this.apiPort + this.saleGoodsTagUrl + paramString;
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, TopManSaleGoodsTagEntity.Response.class, new Object[0]);
            TopManSaleGoodsTagEntity.Response body = (TopManSaleGoodsTagEntity.Response)forEntity.getBody();
            this.checkRequest(forEntity);
            tagEntity = (TopManSaleGoodsTagEntity)body.getData();
            this.redisUtil.set(key, (Object)tagEntity, 14400L);
        }
        return tagEntity;
    }

    public TopManSpiderGoodsListEntity getTopManSaleGoodsGoodsList(final String topManId, final String days, final int ddPage, final String brand, final String category) {
        String key = "TopManGoodsListFromApi_" + topManId + "_" + days + "_" + ddPage + "_" + brand + "_" + category;
        TopManSpiderGoodsListEntity tagEntity = (TopManSpiderGoodsListEntity)this.redisUtil.get(key);
        if (tagEntity == null) {
            String paramString = this.getParamString((Map<String, Object>)new HashMap<String, Object>(5){
                {
                    super(x0);
                    this.put("uid", topManId);
                    this.put("days", days);
                    this.put("cate_id", category);
                    this.put("brand_id", brand);
                    this.put("page", ddPage);
                }
            });
            String url = this.apiUrl + ":" + this.apiPort + this.saleGoodsProductUrl + paramString;
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, TopManSpiderGoodsListEntity.Response.class, new Object[0]);
            TopManSpiderGoodsListEntity.Response body = (TopManSpiderGoodsListEntity.Response)forEntity.getBody();
            this.checkRequest(forEntity);
            tagEntity = (TopManSpiderGoodsListEntity)body.getData();
            this.redisUtil.set(key, (Object)tagEntity, 600L);
        }
        return tagEntity;
    }

    public TopManSpiderShopListEntity getTopManSaleGoodsShopList(final String topManId, final String days, final int ddPage, final String category) {
        String key = "TopManShopListFromApi_" + topManId + "_" + days + "_" + ddPage + "_" + category;
        TopManSpiderShopListEntity tagEntity = (TopManSpiderShopListEntity)this.redisUtil.get(key);
        if (tagEntity == null) {
            String paramString = this.getParamString((Map<String, Object>)new HashMap<String, Object>(4){
                {
                    super(x0);
                    this.put("uid", topManId);
                    this.put("days", days);
                    this.put("cate_id", category);
                    this.put("page", ddPage);
                }
            });
            String url = this.apiUrl + ":" + this.apiPort + this.saleGoodsShopUrl + paramString;
            ResponseEntity forEntity = this.restTemplate.getForEntity(url, TopManSpiderShopListEntity.Response.class, new Object[0]);
            this.checkRequest(forEntity);
            TopManSpiderShopListEntity.Response body = (TopManSpiderShopListEntity.Response)forEntity.getBody();
            tagEntity = (TopManSpiderShopListEntity)body.getData();
            this.redisUtil.set(key, (Object)tagEntity, 600L);
        }
        return tagEntity;
    }

    public StorePhoneEntity getStorePhone(final String shopId) {
        String paramString = this.getParamString((Map<String, Object>)new HashMap<String, Object>(1){
            {
                super(x0);
                this.put("shop_id", shopId);
            }
        });
        String url = this.apiUrl + ":" + this.apiPort + this.storePhoneUrl + paramString;
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, StorePhoneEntity.Response.class, new Object[0]);
        this.checkRequest(forEntity);
        StorePhoneEntity.Response body = (StorePhoneEntity.Response)forEntity.getBody();
        return (StorePhoneEntity)body.getData();
    }

    private void checkRequest(ResponseEntity<? extends SpiderResponse<?>> forEntity) {
        if (!HttpStatus.OK.equals((Object)forEntity.getStatusCode())) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8bf7\u6c42\u5931\u8d25"));
        }
        if (forEntity.getBody() == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u6682\u65e0\u6570\u636e"));
        }
        if (200 != ((SpiderResponse)forEntity.getBody()).getStatus()) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)((SpiderResponse)forEntity.getBody()).getMsg()));
        }
    }

    private String getParamString(Map<String, Object> param) {
        StringBuilder sb = new StringBuilder("?");
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || "".equals(key) || value == null) continue;
            sb.append(key).append("=").append(value).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean checkBaseDetail(String topManId, String days) {
        String key = "TopManBaseDetailFromApi_" + topManId + "_" + days;
        return this.redisUtil.get(key) != null;
    }

    public boolean checkSaleGoodsDetail(String topManId, String days) {
        String key = "TopManSaleGoodsDetailFromApi_" + topManId + "_" + days;
        return this.redisUtil.get(key) != null;
    }

    static enum ApiType {
        base("TopManBaseDetailFromApi", TopManDetailBaseEntity.Response.class),
        saleGoods("TopManSaleGoodsDetailFromApi", TopManDetailSaleGoodsEntity.Response.class),
        saleGoodsTag("TopManSaleGoodsTagFromApi", TopManSaleGoodsTagEntity.Response.class),
        saleGoodsProduct("TopManGoodsListFromApi", TopManSpiderGoodsListEntity.Response.class),
        saleGoodsShop("TopManShopListFromApi", TopManSpiderShopListEntity.Response.class);

        private final String keyName;
        private final Class<? extends SpiderResponse<?>> resultClass;

        private ApiType(String keyName, Class<? extends SpiderResponse<?>> resultClass) {
            this.keyName = keyName;
            this.resultClass = resultClass;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public Class<? extends SpiderResponse<?>> getResultClass() {
            return this.resultClass;
        }
    }
}

