/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.dto.GoodsItemQueryDTO;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.dto.TopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsItem;
import com.els.modules.industryinfo.entity.GoodsLiveItem;
import com.els.modules.industryinfo.entity.GoodsVideoItem;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.entity.TopManLiveItemList;
import com.els.modules.industryinfo.entity.TopManVideoItemList;
import com.els.modules.industryinfo.excel.GoodsHeadExportServiceImpl;
import com.els.modules.industryinfo.excel.GoodsHeadStatisticsExportServiceImpl;
import com.els.modules.industryinfo.excel.GoodsTopmanItemExportServiceImpl;
import com.els.modules.industryinfo.job.GoodsStatJob;
import com.els.modules.industryinfo.query.GoodsHeadQueryParam;
import com.els.modules.industryinfo.query.TopmanRecordQueryParam;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.GoodsLiveItemService;
import com.els.modules.industryinfo.service.GoodsLiveRecordService;
import com.els.modules.industryinfo.service.GoodsTopmanRecordService;
import com.els.modules.industryinfo.service.GoodsVideoItemService;
import com.els.modules.industryinfo.service.GoodsVideoRecordService;
import com.els.modules.industryinfo.vo.GoodsHeadStatisticsVO;
import com.els.modules.industryinfo.vo.GoodsHeadVO;
import com.els.modules.industryinfo.vo.GoodsLiveRecordVO;
import com.els.modules.industryinfo.vo.GoodsVideoRecordVO;
import com.els.modules.industryinfo.vo.TopmanItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/industryinfo/goodsHead"})
@Api(tags={"\u5546\u54c1\u4fe1\u606f\u5934"})
public class GoodsHeadController
extends BaseController<GoodsHead, GoodsHeadService> {
    private static final Logger log = LoggerFactory.getLogger(GoodsHeadController.class);
    @Autowired
    private GoodsHeadService goodsHeadService;
    @Autowired
    private GoodsTopmanRecordService goodsTopmanRecordService;
    @Autowired
    private GoodsVideoItemService goodsVideoItemService;
    @Autowired
    private GoodsVideoRecordService goodsVideoRecordService;
    @Autowired
    private GoodsLiveItemService goodsLiveItemService;
    @Autowired
    private GoodsLiveRecordService goodsLiveRecordService;
    @Autowired
    private GoodsStatJob goodsStatJob;

    @ApiOperation(value="\u6d4b\u8bd5", notes="\u6d4b\u8bd5")
    @GetMapping(value={"/test"})
    public Result<?> test(String parameter) {
        this.goodsStatJob.execute(parameter);
        return Result.ok();
    }

    @ApiOperation(value="\u5546\u54c1\u5217\u8868", notes="\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(GoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<GoodsHead> queryWrapper = GoodsHeadQueryParam.getQueryParam(new GoodsHead(), req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        page.setCountId("queryCount");
        this.goodsHeadService.categoryListConvert(queryDTO);
        IPage<GoodsHead> pageList = this.goodsHeadService.queryPage((Page<GoodsHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6211\u7684\u6536\u85cf\u5217\u8868", notes="\u6211\u7684\u6536\u85cf\u5217\u8868")
    @GetMapping(value={"/favoriteList"})
    public Result<?> queryPageFavoriteList(GoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<GoodsHead> queryWrapper = GoodsHeadQueryParam.getQueryParam(new GoodsHead(), req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsHead> pageList = this.goodsHeadService.queryFavoritePage((Page<GoodsHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u5546\u54c1\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody GoodsHeadVO headVO) {
        GoodsHead goodsHead = new GoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        goodsHead.setBusAccount(this.getTenantId());
        this.goodsHeadService.saveMain(goodsHead, headVO);
        return Result.ok((Object)((Object)goodsHead));
    }

    @AutoLog(busModule="\u5546\u54c1\u4fe1\u606f\u5934", value="\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    @GetMapping(value={"/favorite"})
    public Result<?> favorite(@RequestParam(name="id") String id) {
        this.goodsHeadService.favorite(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5546\u54c1\u4fe1\u606f\u5934", value="\u53d6\u6d88\u6536\u85cf")
    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf", notes="\u53d6\u6d88\u6536\u85cf")
    @GetMapping(value={"/cancelFavorite"})
    public Result<?> cancelFavorite(@RequestParam(name="id") String id) {
        this.goodsHeadService.cancelFavorite(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5546\u54c1\u8be6\u60c5", notes="\u5546\u54c1\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        GoodsHeadVO head = this.goodsHeadService.queryById(id);
        return Result.ok((Object)((Object)head));
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u7edf\u8ba1", notes="\u57fa\u7840\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/goodsStat"})
    public Result<?> goodsStat(GoodsTopmanItemQueryDTO queryDTO) {
        GoodsHeadStatisticsVO vo = this.goodsHeadService.goodsStatNew(queryDTO);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u5217\u8868", notes="\u57fa\u7840\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/goodsListNew"})
    public Result<?> goodsListNew(GoodsItem item, GoodsTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsHeadStatisticsVO> pageList = this.goodsHeadService.queryGoodsItemPage((Page<GoodsItem>)page, (QueryWrapper<GoodsItem>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(TopManInformationHead head, TopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Assert.hasText((String)queryDTO.getGoodsId(), (String)I18nUtil.translate((String)"i18n_alert_empty_notGoodsId", (String)"\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a"));
        QueryWrapper<TopManInformationHead> queryWrapper = TopmanRecordQueryParam.getQueryParam(head, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<TopmanItemVO> pageList = this.goodsTopmanRecordService.queryTopmanPageNew((Page<TopManInformationHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.goodsTopmanRecordService.contentTypeCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u4fe1\u606f\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.goodsTopmanRecordService.goodsWomCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u89c6\u9891\u5206\u6790\u7edf\u8ba1", notes="\u89c6\u9891\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/videoStat"})
    public Result<?> videoStat(GoodsItemQueryDTO queryDTO) {
        List<GoodsVideoItem> itemList = this.goodsVideoItemService.videoList(queryDTO.getGoodsId(), queryDTO);
        return Result.ok(itemList);
    }

    @ApiOperation(value="\u89c6\u9891\u5206\u6790\u5217\u8868", notes="\u89c6\u9891\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/videoListNew"})
    public Result<?> videoListNew(TopManVideoItemList videoList, GoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)videoList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsVideoRecordVO> pageList = this.goodsVideoRecordService.queryVideoPageNew((Page<TopManVideoItemList>)page, (QueryWrapper<TopManVideoItemList>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u76f4\u64ad\u5206\u6790\u7edf\u8ba1", notes="\u76f4\u64ad\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/liveStat"})
    public Result<?> liveStat(GoodsItemQueryDTO queryDTO) {
        List<GoodsLiveItem> itemList = this.goodsLiveItemService.videoList(queryDTO.getGoodsId(), queryDTO);
        return Result.ok(itemList);
    }

    @ApiOperation(value="\u76f4\u64ad\u5206\u6790\u5217\u8868", notes="\u76f4\u64ad\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/liveListNew"})
    public Result<?> liveListNew(TopManLiveItemList liveList, GoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)liveList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<GoodsLiveRecordVO> pageList = this.goodsLiveRecordService.queryLivePageNew((Page<TopManLiveItemList>)page, (QueryWrapper<TopManLiveItemList>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u5217\u8868-\u5bfc\u51fa", notes="\u5546\u54c1\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, GoodsHeadExportServiceImpl.class);
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u5217\u8868-\u5bfc\u51fa", notes="\u57fa\u7840\u5206\u6790\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/statisticsExportXls"})
    public ModelAndView statisticsExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, GoodsHeadStatisticsExportServiceImpl.class);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5bfc\u51fa", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/topmanExportXls"})
    public ModelAndView topmanExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, GoodsTopmanItemExportServiceImpl.class);
    }
}

