/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.enumerate.StatisticsDateType;
import com.els.modules.industryinfo.dto.TopManDetailBodyDo;
import com.els.modules.industryinfo.entity.TopManDetailHeadEntity;
import com.els.modules.industryinfo.entity.TopManGoodsListEntity;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.entity.TopManResultDetailBody;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyBase;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyFans;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyLive;
import com.els.modules.industryinfo.entity.TopManResultDetailBodySaleGoods;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyVideo;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.entity.TopManShopListEntity;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.mapper.TopManInformationMapper;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.utils.spider.entity.TopManDetailBaseEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManDetailSaleGoodsEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSaleGoodsTagEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSpiderGoodsListEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSpiderShopListEntity;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.vo.TopManInformationVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopManInformationServiceImpl
extends BaseServiceImpl<TopManInformationMapper, TopManParamEntity>
implements TopManInformationService {
    HashMap<TopManQueryType, ListMethod> typeMethod = null;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    private final BigDecimal divide = new BigDecimal("100.00");

    @Override
    public IPage<? extends TopManResultEntity> queryTopManList(SimplePostRequestParam<TopManInformationVO> topManDto, TopManQueryType topManQueryType) {
        if (this.typeMethod == null) {
            this.typeMethod = new HashMap<TopManQueryType, ListMethod>(){
                {
                    this.put(TopManQueryType.all, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageAll);
                    this.put(TopManQueryType.myCollection, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageCollection);
                    this.put(TopManQueryType.liveTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageLiveTopMan);
                    this.put(TopManQueryType.videoTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageVideoTopMan);
                }
            };
        }
        QueryWrapper<TopManParamEntity> queryWrapper = this.getQueryWrapper(topManDto);
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        page.setCountId("pageSelectCount");
        ((TopManInformationVO)topManDto.getFilterInfo()).getCountTables().add(topManQueryType.getCountTable());
        topManQueryType.getInitMethod().initQueryWrapper(queryWrapper, null);
        return Optional.ofNullable(this.typeMethod.get((Object)topManQueryType)).orElseThrow(() -> new TopManException(I18nUtil.translate((String)"", (String)"\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef"))).apply((IPage<TopManResultEntity>)page, (Wrapper<TopManParamEntity>)queryWrapper, SysUtil.getLoginUser(), (TopManInformationVO)topManDto.getFilterInfo(), StatisticsDateType.M1);
    }

    @Override
    public TopManDetailHeadEntity queryDetailHead(String id) {
        return ((TopManInformationMapper)this.baseMapper).queryDetailHead(id, SysUtil.getLoginUser(), StatisticsDateType.M1);
    }

    @Override
    public TopManDetailHeadEntity queryDetailHeadBase(String id, String clearCache) {
        String key = "TopManDetailHead" + id;
        TopManDetailHeadEntity topManDetailHeadEntity = null;
        if (!"1".equals(clearCache)) {
            topManDetailHeadEntity = (TopManDetailHeadEntity)((Object)this.redisUtil.get(key));
        }
        if (topManDetailHeadEntity == null) {
            topManDetailHeadEntity = this.getNewTopManDetailHeadEntity(id);
        } else {
            boolean check = this.spiderApiUtil.checkBaseDetail(topManDetailHeadEntity.getTopManBaseData().getTopManId(), StatisticsDateType.M1.getDicCode());
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> this.getNewTopManDetailHeadEntity(id));
            }
        }
        TopManDetailHeadEntity.TopManBaseData topManBaseData = topManDetailHeadEntity.getTopManBaseData();
        int i = ((TopManInformationMapper)this.baseMapper).checkAddAndCollect(topManBaseData.getPlatform(), topManBaseData.getTopManId(), SysUtil.getLoginUser());
        topManBaseData.setIsAdded(i == 2 || i == 3 ? "1" : "0");
        topManBaseData.setIsCollection(i == 1 || i == 3 ? "1" : "0");
        return topManDetailHeadEntity;
    }

    private TopManDetailHeadEntity getNewTopManDetailHeadEntity(String id) {
        TopManDetailBaseEntity.VideoData videoData;
        TopManDetailBaseEntity.LiveData liveData;
        TopManDetailHeadEntity topManDetailHeadEntity = ((TopManInformationMapper)this.baseMapper).queryDetailHeadBase(id, SysUtil.getLoginUser());
        if (topManDetailHeadEntity == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        TopManDetailBaseEntity data = this.spiderApiUtil.getTopManBaseDetail(topManDetailHeadEntity.getTopManBaseData().getTopManId(), StatisticsDateType.M1.getDicCode());
        topManDetailHeadEntity.setStatisticsDate(data.getDate());
        TopManDetailBaseEntity.CoreData coreData = data.getCoreData();
        if (coreData != null) {
            TopManDetailHeadEntity.TopManCoreData topManCoreData = new TopManDetailHeadEntity.TopManCoreData();
            topManDetailHeadEntity.setTopManCoreData(topManCoreData);
            topManCoreData.setCommerceDays(coreData.getTotalWorkDay());
            topManCoreData.setPopularizeGoodsQuantity(coreData.getPromotionSum());
            topManCoreData.setCooperationShop(coreData.getCooperateShopNum());
            topManCoreData.setGoodsTotalSalesLow(coreData.getSaleLow());
            topManCoreData.setGoodsTotalSalesHigh(coreData.getSaleHigh());
        }
        if ((liveData = data.getLiveData()) != null) {
            TopManDetailHeadEntity.TopManLiveData topManLiveData = new TopManDetailHeadEntity.TopManLiveData();
            topManDetailHeadEntity.setTopManLiveData(topManLiveData);
            topManLiveData.setLiveProportionOfSales(liveData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            topManLiveData.setLiveGpmHigh(liveData.getGpmHigh());
            topManLiveData.setLiveGpmLow(liveData.getGpmLow());
            topManLiveData.setGoodsLiveQuantity(liveData.getCount());
            topManLiveData.setLiveSalesAvgHigh(liveData.getSaleHigh());
            topManLiveData.setLiveSalesAvgLow(liveData.getSaleLow());
            topManLiveData.setGoodsLiveViewers(liveData.getWatchingNum());
        }
        if ((videoData = data.getVideoData()) != null) {
            TopManDetailHeadEntity.TopManVideoData topManVideoData = new TopManDetailHeadEntity.TopManVideoData();
            topManDetailHeadEntity.setTopManVideoData(topManVideoData);
            topManVideoData.setGoodsVideoQuantity(videoData.getCount());
            topManVideoData.setVideoGpmHigh(videoData.getGpmHigh());
            topManVideoData.setVideoGpmLow(videoData.getGpmLow());
            topManVideoData.setVideoProportionOfSales(videoData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            topManVideoData.setVideoSalesAvgHigh(videoData.getSaleHigh());
            topManVideoData.setVideoSalesAvgLow(videoData.getSaleLow());
            topManVideoData.setGoodsPlayQuantity(videoData.getWatchingNum());
        }
        this.redisUtil.set("TopManDetailHead" + id, (Object)topManDetailHeadEntity, 18000L);
        this.cacheTopManResultDetailBodyBase(id, StatisticsDateType.M1, data);
        return topManDetailHeadEntity;
    }

    private Map<String, TopManResultDetailBodyBase> cacheTopManResultDetailBodyBase(String id, StatisticsDateType dateType, TopManDetailBaseEntity data) {
        TopManDetailBaseEntity.SaleAnalysis saleAnalysis;
        if (data != null && (saleAnalysis = data.getSaleAnalysis()) != null) {
            HashMap<String, TopManResultDetailBodyBase> cacheBean = new HashMap<String, TopManResultDetailBodyBase>();
            TopManResultDetailBodyBase videoDetailBodyBase = new TopManResultDetailBodyBase();
            TopManDetailBaseEntity.SaleAnalysisMember video = saleAnalysis.getVideo();
            this.transferSaleAnalysis(video, videoDetailBodyBase);
            cacheBean.put("2", videoDetailBodyBase);
            TopManResultDetailBodyBase liveDetailBodyBase = new TopManResultDetailBodyBase();
            TopManDetailBaseEntity.SaleAnalysisMember live = saleAnalysis.getLive();
            this.transferSaleAnalysis(live, liveDetailBodyBase);
            cacheBean.put("1", liveDetailBodyBase);
            this.redisUtil.set("TopManBodyBaseAnalysis_" + id + "_" + dateType.getDicCode(), cacheBean, 18000L);
            return cacheBean;
        }
        return null;
    }

    private void transferSaleAnalysis(TopManDetailBaseEntity.SaleAnalysisMember source, TopManResultDetailBodyBase target) {
        List<TopManDetailBaseEntity.SaleAnalysisMember.Category> category;
        if (source == null || target == null) {
            return;
        }
        List<TopManDetailBaseEntity.SaleAnalysisMember.Brand> brand = source.getBrand();
        if (brand != null && brand.size() > 0) {
            ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity> brandList = new ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity>(Math.min(3, brand.size()));
            target.setBrandAnalysisData(brandList);
            for (int i = 0; i < Math.min(3, brand.size()); ++i) {
                TopManDetailBaseEntity.SaleAnalysisMember.Brand a = brand.get(i);
                TopManResultDetailBodyBase.popularizeAnalysisEntity brandEntity = new TopManResultDetailBodyBase.popularizeAnalysisEntity();
                brandList.add(brandEntity);
                brandEntity.setBrand(a.getBrand());
                brandEntity.setPriceAvg(a.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                brandEntity.setSaleAmountLow(a.getAverageGMVLow());
                brandEntity.setSaleAmountHigh(a.getAverageGMVHigh());
            }
        }
        if ((category = source.getCategory()) != null && category.size() > 0) {
            ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity> categoryList = new ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity>(Math.min(3, category.size()));
            target.setCategoryAnalysisData(categoryList);
            for (int i = 0; i < Math.min(3, category.size()); ++i) {
                TopManDetailBaseEntity.SaleAnalysisMember.Category a = category.get(i);
                TopManResultDetailBodyBase.popularizeAnalysisEntity categoryEntity = new TopManResultDetailBodyBase.popularizeAnalysisEntity();
                categoryList.add(categoryEntity);
                categoryEntity.setCategory(a.getCategory());
                categoryEntity.setPriceAvg(a.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                categoryEntity.setSaleAmountLow(a.getAverageGMVLow());
                categoryEntity.setSaleAmountHigh(a.getAverageGMVHigh());
                categoryEntity.setCommissionRateLow(a.getSuggestRatioMin());
                categoryEntity.setCommissionRateHigh(a.getSuggestRatioMax());
            }
        }
    }

    @Override
    public TopManResultDetailBody queryDetailBody(TopManDetailBodyDo param) {
        return BodyType.getTypeWhitName(param.getBodyType()).function.queryDetailBody(param);
    }

    @Override
    public IPage<TopManGoodsListEntity> queryGoodsList(SimplePostRequestParam<TopManDetailBodyDo> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        return ((TopManInformationMapper)this.baseMapper).queryGoodsList((IPage<TopManGoodsListEntity>)page, (TopManDetailBodyDo)param.getFilterInfo());
    }

    @Override
    public IPage<TopManGoodsListEntity> queryGoodsListNew(SimplePostRequestParam<TopManDetailBodyDo> param) {
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        TopManDetailBodyDo filterInfo = (TopManDetailBodyDo)param.getFilterInfo();
        List<String> brand = filterInfo.getBrand();
        String brandParam = brand != null && brand.size() > 0 ? brand.get(0) : "";
        List<String> category = filterInfo.getCategory();
        String statisticsDateType = filterInfo.getStatisticsDateType();
        String topManId = filterInfo.getTopManId();
        String categoryParam = category != null && category.size() > 0 ? category.get(0) : "";
        int tP = pageNo * pageSize;
        int ddPage = (int)Math.ceil((double)tP / 15.0);
        int mcnPage = tP % 15;
        mcnPage = mcnPage == 0 ? 15 : mcnPage;
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        TopManSpiderGoodsListEntity goodsListEntity = this.spiderApiUtil.getTopManSaleGoodsGoodsList(topManId, statisticsDateType, ddPage, brandParam, categoryParam);
        if (goodsListEntity != null) {
            result.setTotal(goodsListEntity.getTotal());
            List<TopManSpiderGoodsListEntity.Goods> productInfo = goodsListEntity.getProductInfo();
            if (productInfo != null && productInfo.size() > mcnPage - 5) {
                ArrayList<TopManGoodsListEntity> resultEntity = new ArrayList<TopManGoodsListEntity>(5);
                result.setRecords(resultEntity);
                for (TopManSpiderGoodsListEntity.Goods a : productInfo.subList(mcnPage - 5, Math.min(mcnPage, productInfo.size()))) {
                    TopManGoodsListEntity topManGoodsListEntity = new TopManGoodsListEntity();
                    resultEntity.add(topManGoodsListEntity);
                    topManGoodsListEntity.setGoodsId(a.getGoodsInfo().getPid());
                    topManGoodsListEntity.setGoodsPicture(a.getGoodsInfo().getImg());
                    topManGoodsListEntity.setGoodsPrice(a.getGoodsInfo().getCurPrice());
                    topManGoodsListEntity.setGoodsTitle(a.getGoodsInfo().getTitle());
                    topManGoodsListEntity.setGoodsSaleAmountHigh(a.getGoodsSaleHigh());
                    topManGoodsListEntity.setGoodsSaleAmountLow(a.getGoodsSaleLow());
                    topManGoodsListEntity.setLiveQuantity(a.getRelatedLiveTimes());
                    topManGoodsListEntity.setVideoQuantity(a.getRelatedVideoNum());
                }
            }
            if (tP % 15 == 10 && (long)tP <= goodsListEntity.getTotal()) {
                SpiderApiUtil.taskExecutor.execute(() -> this.spiderApiUtil.getTopManSaleGoodsGoodsList(topManId, statisticsDateType, ddPage + 1, brandParam, categoryParam));
            }
        }
        return result;
    }

    @Override
    public IPage<TopManShopListEntity> queryShopList(SimplePostRequestParam<TopManDetailBodyDo> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        return ((TopManInformationMapper)this.baseMapper).queryShopList((IPage<TopManShopListEntity>)page, (TopManDetailBodyDo)param.getFilterInfo());
    }

    @Override
    public IPage<TopManShopListEntity> queryShopListNew(SimplePostRequestParam<TopManDetailBodyDo> param) {
        TopManDetailBodyDo filterInfo = (TopManDetailBodyDo)param.getFilterInfo();
        List<String> category = filterInfo.getCategory();
        String categoryParam = category != null && category.size() > 0 ? category.get(0) : "";
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        String statisticsDateType = filterInfo.getStatisticsDateType();
        String topManId = filterInfo.getTopManId();
        int tP = pageNo * pageSize;
        int ddPage = (int)Math.ceil((double)tP / 15.0);
        int mcnPage = tP % 15;
        mcnPage = mcnPage == 0 ? 15 : mcnPage;
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        TopManSpiderShopListEntity shopListEntity = this.spiderApiUtil.getTopManSaleGoodsShopList(topManId, statisticsDateType, ddPage, categoryParam);
        if (shopListEntity != null) {
            result.setTotal(shopListEntity.getTotal());
            List<TopManSpiderShopListEntity.Shop> shopInfo = shopListEntity.getShopInfo();
            if (shopInfo != null && shopInfo.size() > mcnPage - 5) {
                ArrayList<TopManShopListEntity> record = new ArrayList<TopManShopListEntity>(5);
                result.setRecords(record);
                for (TopManSpiderShopListEntity.Shop a : shopInfo.subList(mcnPage - 5, Math.min(mcnPage, shopInfo.size()))) {
                    TopManShopListEntity shop = new TopManShopListEntity();
                    record.add(shop);
                    shop.setLiveQuantity(a.getRelatedTimes());
                    shop.setShopId(a.getBasicInfo().getShopId());
                    shop.setPopularizeGoodsQuantity(a.getBasicInfo().getSalesCnt());
                    shop.setShopLogo(a.getBasicInfo().getShopAvatar());
                    shop.setVideoQuantity(a.getRelatedVideoNum());
                    shop.setGmvHigh(a.getPromotionGmvHigh());
                    shop.setGmvLow(a.getPromotionGmvLow());
                    shop.setShopTitle(a.getBasicInfo().getName());
                }
            }
            if (mcnPage == 10 && (long)tP <= shopListEntity.getTotal()) {
                SpiderApiUtil.taskExecutor.execute(() -> this.spiderApiUtil.getTopManSaleGoodsShopList(topManId, statisticsDateType, ddPage + 1, categoryParam));
            }
        }
        return result;
    }

    private TopManResultDetailBody queryDetailBodyBase(final TopManDetailBodyDo param) {
        return new TopManResultDetailBodyBase(){
            {
                this.setCategoryAnalysisData(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryCateGoryAnalysisData(param));
                this.setBrandAnalysisData(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryBrandAnalysisData(param));
            }
        };
    }

    private TopManResultDetailBody queryDetailBodyBaseNew(TopManDetailBodyDo param) {
        String popularizeType = param.getPopularizeType();
        String id = param.getId();
        String topManId = param.getTopManId();
        String dateType = param.getStatisticsDateType();
        StatisticsDateType typeWhitDicCode = StatisticsDateType.getTypeWhitDicCode((String)dateType, null);
        if (typeWhitDicCode == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"));
        }
        String key = "TopManBodyBaseAnalysis_" + id + "_" + dateType;
        Map<String, TopManResultDetailBodyBase> cBean = null;
        if (!"1".equals(param.getClearCache())) {
            cBean = (Map<String, TopManResultDetailBodyBase>)this.redisUtil.get(key);
        }
        if (cBean == null) {
            TopManDetailBaseEntity topManDetail = this.spiderApiUtil.getTopManBaseDetail(topManId, dateType);
            cBean = this.cacheTopManResultDetailBodyBase(id, typeWhitDicCode, topManDetail);
        } else {
            boolean check = this.spiderApiUtil.checkBaseDetail(topManId, StatisticsDateType.M1.getDicCode());
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    TopManDetailBaseEntity topManDetail = this.spiderApiUtil.getTopManBaseDetail(topManId, dateType);
                    this.cacheTopManResultDetailBodyBase(id, typeWhitDicCode, topManDetail);
                });
            }
        }
        return cBean != null ? (TopManResultDetailBody)cBean.get(popularizeType) : new TopManResultDetailBodyBase();
    }

    private TopManResultDetailBody queryDetailBodySaleGoods(TopManDetailBodyDo param) {
        final TopManResultDetailBodySaleGoods result = ((TopManInformationMapper)this.baseMapper).queryDetailBodySaleGoods(param);
        if (result == null) {
            return new TopManResultDetailBodySaleGoods();
        }
        result.setSaleGoodsCount((List<TopManResultDetailBodySaleGoods.DataCountItemEntity>)new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(2){
            {
                super(x0);
                this.add(new TopManResultDetailBodySaleGoods.DataCountItemEntity("category", "\u4e3b\u63a8\u7c7b\u76ee"){
                    {
                        this.setChildren(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountGoodsCategory(result.getId()));
                    }
                });
                this.add(new TopManResultDetailBodySaleGoods.DataCountItemEntity("brand", "\u5408\u4f5c\u54c1\u724c"){
                    {
                        this.setChildren(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountGoodsBrand(result.getId()));
                    }
                });
            }
        });
        result.setCooperationShopCount((List<TopManResultDetailBodySaleGoods.DataCountItemEntity>)new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(1){
            {
                super(x0);
                this.add(new TopManResultDetailBodySaleGoods.DataCountItemEntity("category", "\u4e3b\u8425\u7c7b\u76ee"){
                    {
                        this.setChildren(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountShopCategory(result.getId()));
                    }
                });
            }
        });
        return result;
    }

    private TopManResultDetailBody queryDetailBodySaleGoodsNew(TopManDetailBodyDo param) {
        String id = param.getId();
        String topManId = param.getTopManId();
        String dateType = param.getStatisticsDateType();
        StatisticsDateType typeWhitDicCode = StatisticsDateType.getTypeWhitDicCode((String)dateType, null);
        if (typeWhitDicCode == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"));
        }
        String key = "TopManBodySaleGoods_" + id + "_" + dateType;
        TopManResultDetailBodySaleGoods saleGoods = null;
        if (!"1".equals(param.getClearCache())) {
            saleGoods = (TopManResultDetailBodySaleGoods)((Object)this.redisUtil.get(key));
        }
        if (saleGoods == null) {
            saleGoods = new TopManResultDetailBodySaleGoods();
            TopManDetailSaleGoodsEntity topManSaleGoodsDetail = this.spiderApiUtil.getTopManSaleGoodsDetail(topManId, dateType);
            this.transferSaleGoods(topManSaleGoodsDetail, saleGoods);
            TopManSaleGoodsTagEntity topManSaleGoodsTag = this.spiderApiUtil.getTopManSaleGoodsTag(topManId, dateType);
            this.transferSaleGoodsTag(topManSaleGoodsTag, saleGoods);
            this.redisUtil.set(key, (Object)saleGoods, 18000L);
        } else {
            boolean check = this.spiderApiUtil.checkSaleGoodsDetail(topManId, StatisticsDateType.M1.getDicCode());
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    TopManDetailSaleGoodsEntity topManSaleGoodsDetail = this.spiderApiUtil.getTopManSaleGoodsDetail(topManId, dateType);
                    TopManResultDetailBodySaleGoods newSaleGoods = new TopManResultDetailBodySaleGoods();
                    this.transferSaleGoods(topManSaleGoodsDetail, newSaleGoods);
                    this.redisUtil.set(key, (Object)newSaleGoods, 18000L);
                });
            }
        }
        return saleGoods;
    }

    private void transferSaleGoods(TopManDetailSaleGoodsEntity source, TopManResultDetailBodySaleGoods target) {
        if (source != null && target != null) {
            TopManDetailSaleGoodsEntity.VideoData videoData;
            TopManDetailSaleGoodsEntity.LiveData liveData;
            target.setStatisticsDate(source.getStartTime() + "\u81f3" + source.getEndTime());
            TopManDetailSaleGoodsEntity.CoreData coreData = source.getCoreData();
            if (coreData != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsCoreData saleGoodsCoreData = new TopManResultDetailBodySaleGoods.SaleGoodsCoreData();
                target.setSaleGoodsCoreData(saleGoodsCoreData);
                saleGoodsCoreData.setPopularizeGoodsQuantity(coreData.getPromotionSum());
                saleGoodsCoreData.setPriceAvg(coreData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsCoreData.setCooperationShopQuantity(coreData.getCooperateShopNum());
                saleGoodsCoreData.setSaleTotalAmountHigh(coreData.getSaleHigh());
                saleGoodsCoreData.setSaleTotalAmountLow(coreData.getSaleLow());
            }
            if ((liveData = source.getLiveData()) != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsLiveData saleGoodsLiveData = new TopManResultDetailBodySaleGoods.SaleGoodsLiveData();
                target.setSaleGoodsLiveData(saleGoodsLiveData);
                saleGoodsLiveData.setLiveGpmHigh(liveData.getGpmHigh());
                saleGoodsLiveData.setLiveGpmLow(liveData.getGpmLow());
                saleGoodsLiveData.setLiveCooperationShop(liveData.getCooperateShopNum());
                saleGoodsLiveData.setLivePopularizeGoods(liveData.getPromotionSum());
                saleGoodsLiveData.setLivePriceAvg(liveData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsLiveData.setLiveSaleAvgHigh(liveData.getSaleHigh());
                saleGoodsLiveData.setLiveSaleAvgLow(liveData.getSaleLow());
                saleGoodsLiveData.setLiveSaleRate(liveData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            }
            if ((videoData = source.getVideoData()) != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsVideoData saleGoodsVideoData = new TopManResultDetailBodySaleGoods.SaleGoodsVideoData();
                target.setSaleGoodsVideoData(saleGoodsVideoData);
                saleGoodsVideoData.setVideoGpmHigh(videoData.getGpmHigh());
                saleGoodsVideoData.setVideoGpmLow(videoData.getGpmLow());
                saleGoodsVideoData.setVideoCooperationShop(videoData.getCooperateShopNum());
                saleGoodsVideoData.setVideoPopularizeGoods(videoData.getPromotionSum());
                saleGoodsVideoData.setVideoPriceAvg(videoData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsVideoData.setVideoSaleAvgHigh(videoData.getSaleHigh());
                saleGoodsVideoData.setVideoSaleAvgLow(videoData.getSaleLow());
                saleGoodsVideoData.setVideoSaleRate(videoData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            }
        }
    }

    private void transferSaleGoodsTag(TopManSaleGoodsTagEntity source, TopManResultDetailBodySaleGoods target) {
        TopManSaleGoodsTagEntity.TagType cooperateShopTag;
        if (source == null || target == null) {
            return;
        }
        TopManSaleGoodsTagEntity.TagType sellProductTag = source.getSellProductTag();
        if (sellProductTag != null) {
            ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> sellProductList = new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(2);
            target.setSaleGoodsCount(sellProductList);
            this.transferTagDic(sellProductTag, sellProductList);
        }
        if ((cooperateShopTag = source.getCooperateShopTag()) != null) {
            ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> cooperateShopList = new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(1);
            target.setCooperationShopCount(cooperateShopList);
            this.transferTagDic(cooperateShopTag, cooperateShopList);
        }
    }

    private void transferTagDic(TopManSaleGoodsTagEntity.TagType tagType, ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> list) {
        List<TopManSaleGoodsTagEntity.Brand> brand;
        List<TopManSaleGoodsTagEntity.Category> indusCat = tagType.getIndusCat();
        if (indusCat != null && indusCat.size() > 0) {
            TopManResultDetailBodySaleGoods.DataCountItemEntity cateItem = new TopManResultDetailBodySaleGoods.DataCountItemEntity("category", "\u4e3b\u63a8\u7c7b\u76ee");
            list.add(cateItem);
            ArrayList<TopManResultDetailBodySaleGoods.DataCountDic> itemDic = new ArrayList<TopManResultDetailBodySaleGoods.DataCountDic>(indusCat.size());
            cateItem.setChildren(itemDic);
            for (TopManSaleGoodsTagEntity.Category a : indusCat) {
                TopManResultDetailBodySaleGoods.DataCountDic dataCountDic = new TopManResultDetailBodySaleGoods.DataCountDic();
                itemDic.add(dataCountDic);
                dataCountDic.setKey(String.valueOf(a.getCateId()));
                dataCountDic.setTitle(a.getCateName() + "(" + a.getVol() + ")");
            }
        }
        if ((brand = tagType.getBrand()) != null && brand.size() > 0) {
            TopManResultDetailBodySaleGoods.DataCountItemEntity brandItems = new TopManResultDetailBodySaleGoods.DataCountItemEntity("brand", "\u5408\u4f5c\u54c1\u724c");
            list.add(brandItems);
            ArrayList<TopManResultDetailBodySaleGoods.DataCountDic> brandItemDic = new ArrayList<TopManResultDetailBodySaleGoods.DataCountDic>(brand.size());
            brandItems.setChildren(brandItemDic);
            for (TopManSaleGoodsTagEntity.Brand a : brand) {
                TopManResultDetailBodySaleGoods.DataCountDic dataCountDic = new TopManResultDetailBodySaleGoods.DataCountDic();
                brandItemDic.add(dataCountDic);
                dataCountDic.setKey(String.valueOf(a.getBrandId()));
                dataCountDic.setTitle(a.getBrandName() + "(" + a.getVol() + ")");
            }
        }
    }

    private TopManResultDetailBody queryDetailBodyLive(TopManDetailBodyDo param) {
        return new TopManResultDetailBodyLive(){};
    }

    private TopManResultDetailBody queryDetailBodyVideo(TopManDetailBodyDo param) {
        return new TopManResultDetailBodyVideo(){};
    }

    private TopManResultDetailBody queryDetailBodyFans(TopManDetailBodyDo param) {
        return new TopManResultDetailBodyFans(){};
    }

    @PostConstruct
    private void registerMapper() {
        BodyType.base.function = this::queryDetailBodyBaseNew;
        BodyType.saleGoods.function = this::queryDetailBodySaleGoodsNew;
        BodyType.live.function = this::queryDetailBodyLive;
        BodyType.video.function = this::queryDetailBodyVideo;
        BodyType.fans.function = this::queryDetailBodyFans;
    }

    private QueryWrapper<TopManParamEntity> getQueryWrapper(SimplePostRequestParam<TopManInformationVO> topManDto) {
        String[] columns;
        String column;
        TopManInformationVO filterInfo = (TopManInformationVO)topManDto.getFilterInfo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntityClass(TopManParamEntity.class);
        filterInfo.initQueryWrapper((QueryWrapper<TopManParamEntity>)queryWrapper);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            ((QueryWrapper)queryWrapper.like((Object)"aa.topman_name", (Object)keyWord)).or(a -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)a.eq((Object)"aa.topman_id", (Object)keyWord);
            });
        }
        if ((column = topManDto.getColumn()) != null && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("column", columns);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                }
            }, (Object)((Object)new TopManParamEntity()));
        }
        return queryWrapper;
    }

    private static enum BodyType {
        base,
        saleGoods,
        live,
        video,
        fans;

        private BodyTypeMethodFunction function;

        public static BodyType getTypeWhitName(String name) {
            for (BodyType value : BodyType.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            throw new TopManException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u8fbe\u4eba\u8be6\u60c5\u7684\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef\uff1abase\u3001saleGoods\u3001live\u3001video\u3001fans"));
        }

        @FunctionalInterface
        static interface BodyTypeMethodFunction {
            public TopManResultDetailBody queryDetailBody(TopManDetailBodyDo var1);
        }
    }

    @FunctionalInterface
    private static interface ListMethod {
        public IPage<? extends TopManResultEntity> apply(IPage<TopManResultEntity> var1, Wrapper<TopManParamEntity> var2, LoginUser var3, TopManInformationVO var4, StatisticsDateType var5);
    }
}

