/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.BigDecimalUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryinfo.dto.RewardRuleDTO;
import com.els.modules.industryinfo.entity.CommRewardRuleHead;
import com.els.modules.industryinfo.entity.PerRewardHead;
import com.els.modules.industryinfo.entity.PerRewardItem;
import com.els.modules.industryinfo.entity.PromotionalDataHead;
import com.els.modules.industryinfo.enumerate.PromoteTypeEnum;
import com.els.modules.industryinfo.mapper.PerRewardHeadMapper;
import com.els.modules.industryinfo.service.CommRewardRuleHeadService;
import com.els.modules.industryinfo.service.PerRewardHeadService;
import com.els.modules.industryinfo.service.PerRewardItemService;
import com.els.modules.industryinfo.service.PromotionalDataHeadService;
import com.els.modules.industryinfo.service.PromotionalDataItemService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PerRewardHeadServiceImpl
extends BaseServiceImpl<PerRewardHeadMapper, PerRewardHead>
implements PerRewardHeadService {
    @Autowired
    private CommRewardRuleHeadService commRewardRuleHeadService;
    @Autowired
    private PromotionalDataHeadService promotionalDataHeadService;
    @Autowired
    private PromotionalDataItemService promotionalDataItemService;
    @Autowired
    private PerRewardItemService perRewardItemService;

    @Override
    public void add(PerRewardHead perRewardHead) {
        ((PerRewardHeadMapper)this.baseMapper).insert((Object)perRewardHead);
    }

    @Override
    public void edit(PerRewardHead perRewardHead) {
        int count = ((PerRewardHeadMapper)this.baseMapper).updateById((Object)perRewardHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PerRewardHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PerRewardHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void statistics(String startTime, String endTime) {
        String elsAccount = TenantContext.getTenant();
        List<CommRewardRuleHead> commRewardRuleHeads = this.commRewardRuleHeadService.getRuleByElsAccount(elsAccount);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(commRewardRuleHeads), (String)"\u6ca1\u6709\u5df2\u53d1\u5e03\u7684\u63d0\u6210\u89c4\u5219");
        Map<String, String> ruleMap = commRewardRuleHeads.stream().collect(Collectors.toMap(x -> x.getPromotionType(), y -> y.getRewardRatioJson()));
        List<PromotionalDataHead> data = this.promotionalDataHeadService.findByTimes(startTime, endTime);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(data), (String)"\u6ca1\u6709\u53ef\u7edf\u8ba1\u7684\u63d0\u6210\u6570\u636e");
        ArrayList dbHeads = Lists.newArrayList();
        ArrayList items = Lists.newArrayList();
        for (PromotionalDataHead row : data) {
            PerRewardHead perRewardHead = new PerRewardHead();
            BeanUtil.copyProperties((Object)((Object)row), (Object)((Object)perRewardHead), (String[])new String[0]);
            this.handleRemoveParams(perRewardHead);
            String headId = IdWorker.getIdStr();
            perRewardHead.setId(headId);
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalVol = BigDecimal.ZERO;
            BigDecimal totalSales = BigDecimal.ZERO;
            String commRate = ruleMap.get(PromoteTypeEnum.COMMISSION.getCode());
            if (StrUtil.isNotBlank((CharSequence)commRate)) {
                BigDecimal rewardAmount = this.getRewardVal(row.getCommissionSalesVol(), commRate);
                totalAmount = totalAmount.add(rewardAmount);
                items.add(this.getPerRewardItem(headId, PromoteTypeEnum.COMMISSION.getCode(), commRate, row.getCommissionSales(), row.getCommissionSalesVol(), rewardAmount));
            }
            totalVol = totalVol.add(row.getCommissionSalesVol());
            totalSales = totalSales.add(row.getCommissionSales());
            String starMapRate = ruleMap.get(PromoteTypeEnum.STAR_MAP.getCode());
            if (StrUtil.isNotBlank((CharSequence)starMapRate)) {
                BigDecimal rewardAmount = this.getRewardVal(row.getStarMapSalesVol(), starMapRate);
                totalAmount = totalAmount.add(rewardAmount);
                items.add(this.getPerRewardItem(headId, PromoteTypeEnum.STAR_MAP.getCode(), starMapRate, row.getStarMapSales(), row.getStarMapSalesVol(), rewardAmount));
            }
            totalVol = totalVol.add(row.getStarMapSalesVol());
            totalSales = totalSales.add(row.getStarMapSales());
            String orgRate = ruleMap.get(PromoteTypeEnum.MECHANISM.getCode());
            if (StrUtil.isNotBlank((CharSequence)orgRate)) {
                BigDecimal rewardAmount = this.getRewardVal(row.getOrgSalesVol(), orgRate);
                totalAmount = totalAmount.add(rewardAmount);
                items.add(this.getPerRewardItem(headId, PromoteTypeEnum.MECHANISM.getCode(), orgRate, row.getOrgSales(), row.getOrgSalesVol(), rewardAmount));
            }
            totalVol = totalVol.add(row.getOrgSalesVol());
            totalSales = totalSales.add(row.getOrgSales());
            String proRate = ruleMap.get(PromoteTypeEnum.PRO_ALLIANCE.getCode());
            if (StrUtil.isNotBlank((CharSequence)proRate)) {
                BigDecimal rewardAmount = this.getRewardVal(row.getProAllianceSalesVol(), proRate);
                totalAmount = totalAmount.add(rewardAmount);
                items.add(this.getPerRewardItem(headId, PromoteTypeEnum.PRO_ALLIANCE.getCode(), proRate, row.getProAllianceSales(), row.getProAllianceSalesVol(), rewardAmount));
            }
            totalVol = totalVol.add(row.getProAllianceSalesVol());
            totalSales = totalSales.add(row.getProAllianceSales());
            perRewardHead.setTotalSales(totalSales);
            perRewardHead.setTotalVol(totalVol);
            perRewardHead.setTotalAmount(totalAmount);
            dbHeads.add(perRewardHead);
        }
        if (CollUtil.isNotEmpty((Collection)dbHeads)) {
            this.saveBatch(dbHeads);
            this.perRewardItemService.saveBatch(items);
        }
    }

    private PerRewardItem getPerRewardItem(String headId, String promotionType, String rate, BigDecimal sale, BigDecimal val, BigDecimal amount) {
        PerRewardItem item = new PerRewardItem();
        item.setHeadId(headId);
        item.setPromotionType(promotionType);
        item.setRewardRate(rate);
        item.setSales(sale);
        item.setVol(val);
        item.setRewardAmount(amount);
        return item;
    }

    private void handleRemoveParams(PerRewardHead perRewardHead) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_account", (Object)perRewardHead.getSubAccount());
        queryWrapper.eq((Object)"employee_no", (Object)perRewardHead.getEmployeeNo());
        queryWrapper.eq((Object)"count_year", (Object)perRewardHead.getCountYear());
        queryWrapper.eq((Object)"count_month", (Object)perRewardHead.getCountMonth());
        queryWrapper.select(new String[]{"id"});
        List dbs = this.list((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)dbs)) {
            return;
        }
        List headIds = dbs.stream().map(x -> x.getId()).collect(Collectors.toList());
        this.removeByIds(headIds);
        this.perRewardItemService.remove((Wrapper)Wrappers.lambdaQuery().in(PerRewardItem::getHeadId, headIds));
    }

    private BigDecimal getRewardVal(BigDecimal calVar, String rewardJson) {
        BigDecimal rewardAmount = BigDecimal.ZERO;
        List rewardRuleDTOS = JSONArray.parseArray((String)rewardJson, RewardRuleDTO.class);
        int count = 0;
        for (RewardRuleDTO rule : rewardRuleDTOS) {
            BigDecimal var;
            BigDecimal rewardRatio = PerRewardHeadServiceImpl.trunBigDecimal(rule.getRewardRatio());
            if (rewardRatio == null) continue;
            rewardRatio = rewardRatio.divide(BigDecimal.valueOf(100L));
            BigDecimal start = new BigDecimal(rule.getLadderQuantity());
            if (rewardRatio == null) continue;
            if (count == 0 && BigDecimalUtils.lessEqual((BigDecimal)calVar, (BigDecimal)start)) {
                return BigDecimal.ZERO;
            }
            BigDecimal end = null;
            String endStr = rule.getSaleStart().replaceAll(" ", "");
            if (endStr.indexOf("x<=") == -1) {
                if (BigDecimalUtils.greaterEqual((BigDecimal)calVar, (BigDecimal)start)) {
                    var = calVar.subtract(start).multiply(rewardRatio);
                    rewardAmount = rewardAmount.add(var);
                }
                return rewardAmount;
            }
            end = new BigDecimal(endStr.substring(endStr.indexOf("x<=")).replaceAll("x<=", ""));
            ++count;
            if (BigDecimalUtils.greaterEqual((BigDecimal)calVar, (BigDecimal)end)) {
                var = end.subtract(start).multiply(rewardRatio);
                rewardAmount = rewardAmount.add(var);
                continue;
            }
            var = calVar.subtract(start).multiply(rewardRatio);
            rewardAmount = rewardAmount.add(var);
            return rewardAmount;
        }
        return rewardAmount;
    }

    public static BigDecimal trunBigDecimal(String str) {
        try {
            return new BigDecimal(str);
        }
        catch (Exception e) {
            return null;
        }
    }
}

