/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryinfo.entity.CommRewardRuleHead;
import com.els.modules.industryinfo.entity.ProCommissionHead;
import com.els.modules.industryinfo.entity.ProCommissionItem;
import com.els.modules.industryinfo.entity.PromotionalDataHead;
import com.els.modules.industryinfo.entity.PromotionalDataItem;
import com.els.modules.industryinfo.enumerate.PromoteTypeEnum;
import com.els.modules.industryinfo.mapper.ProCommissionHeadMapper;
import com.els.modules.industryinfo.service.CommRewardRuleHeadService;
import com.els.modules.industryinfo.service.ProCommissionHeadService;
import com.els.modules.industryinfo.service.ProCommissionItemService;
import com.els.modules.industryinfo.service.PromotionalDataHeadService;
import com.els.modules.industryinfo.service.PromotionalDataItemService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ProCommissionHeadServiceImpl
extends BaseServiceImpl<ProCommissionHeadMapper, ProCommissionHead>
implements ProCommissionHeadService {
    @Autowired
    private CommRewardRuleHeadService commRewardRuleHeadService;
    @Autowired
    private PromotionalDataHeadService promotionalDataHeadService;
    @Autowired
    private PromotionalDataItemService promotionalDataItemService;
    @Autowired
    private ProCommissionItemService proCommissionItemService;

    @Override
    public void add(ProCommissionHead proCommissionHead) {
        ((ProCommissionHeadMapper)this.baseMapper).insert((Object)proCommissionHead);
    }

    @Override
    public void edit(ProCommissionHead proCommissionHead) {
        int count = ((ProCommissionHeadMapper)this.baseMapper).updateById((Object)proCommissionHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ProCommissionHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ProCommissionHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void statistics(String startTime, String endTime) {
        String elsAccount = TenantContext.getTenant();
        List<CommRewardRuleHead> commRewardRuleHeads = this.commRewardRuleHeadService.getRuleByElsAccount(elsAccount);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(commRewardRuleHeads), (String)"\u6ca1\u6709\u5df2\u53d1\u5e03\u7684\u63d0\u6210\u89c4\u5219");
        Map<String, BigDecimal> ruleMap = commRewardRuleHeads.stream().collect(Collectors.toMap(x -> x.getPromotionType(), y -> y.getCommRatio().divide(BigDecimal.valueOf(100L))));
        List<PromotionalDataHead> data = this.promotionalDataHeadService.findByTimes(startTime, endTime);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(data), (String)"\u6ca1\u6709\u53ef\u7edf\u8ba1\u7684\u63d0\u6210\u6570\u636e");
        ArrayList dbHeads = Lists.newArrayList();
        for (PromotionalDataHead row : data) {
            ProCommissionHead proCommissionHead = new ProCommissionHead();
            BeanUtil.copyProperties((Object)((Object)row), (Object)((Object)proCommissionHead), (String[])new String[0]);
            this.handleRemoveParams(proCommissionHead);
            proCommissionHead.setId(null);
            BigDecimal commRate = ruleMap.get(PromoteTypeEnum.COMMISSION.getCode());
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalVol = BigDecimal.ZERO;
            BigDecimal totalSales = BigDecimal.ZERO;
            totalSales = totalSales.add(proCommissionHead.getCommissionSales());
            totalVol = totalVol.add(proCommissionHead.getCommissionSalesVol());
            if (ObjectUtil.isNotEmpty((Object)commRate)) {
                proCommissionHead.setCommissionRate(commRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setCommissionAmount(proCommissionHead.getCommissionSalesVol().multiply(commRate));
                totalAmount = totalAmount.add(proCommissionHead.getCommissionAmount());
            }
            totalSales = totalSales.add(proCommissionHead.getStarMapSales());
            totalVol = totalVol.add(proCommissionHead.getStarMapSalesVol());
            BigDecimal starMapRate = ruleMap.get(PromoteTypeEnum.STAR_MAP.getCode());
            if (ObjectUtil.isNotEmpty((Object)starMapRate)) {
                proCommissionHead.setStarMapRate(starMapRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setStarMapAmount(proCommissionHead.getStarMapSalesVol().multiply(starMapRate));
                totalAmount = totalAmount.add(proCommissionHead.getStarMapAmount());
            }
            totalSales = totalSales.add(proCommissionHead.getOrgSales());
            totalVol = totalVol.add(proCommissionHead.getOrgSalesVol());
            BigDecimal mechanismRate = ruleMap.get(PromoteTypeEnum.MECHANISM.getCode());
            if (ObjectUtil.isNotEmpty((Object)mechanismRate)) {
                proCommissionHead.setOrgRate(mechanismRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setOrgAmount(proCommissionHead.getOrgSalesVol().multiply(mechanismRate));
                totalAmount = totalAmount.add(proCommissionHead.getOrgAmount());
            }
            totalSales = totalSales.add(proCommissionHead.getProAllianceSales());
            totalVol = totalVol.add(proCommissionHead.getProAllianceSalesVol());
            BigDecimal proAllianceRate = ruleMap.get(PromoteTypeEnum.PRO_ALLIANCE.getCode());
            if (ObjectUtil.isNotEmpty((Object)proAllianceRate)) {
                proCommissionHead.setProAllianceRate(proAllianceRate.multiply(BigDecimal.valueOf(100L)));
                proCommissionHead.setProAllianceAmount(proCommissionHead.getProAllianceSalesVol().multiply(proAllianceRate));
                totalAmount = totalAmount.add(proCommissionHead.getProAllianceAmount());
            }
            proCommissionHead.setTotalSales(totalSales);
            proCommissionHead.setTotalAmount(totalAmount);
            proCommissionHead.setTotalVol(totalVol);
            proCommissionHead.setId(IdWorker.getIdStr());
            dbHeads.add(proCommissionHead);
            this.handleItemData(row, ruleMap, proCommissionHead.getId());
        }
        if (CollUtil.isNotEmpty((Collection)dbHeads)) {
            this.saveBatch(dbHeads);
        }
    }

    private void handleItemData(PromotionalDataHead headDb, Map<String, BigDecimal> ruleMap, String headId) {
        ArrayList adds = Lists.newArrayList();
        List<PromotionalDataItem> itemDatas = this.promotionalDataItemService.listByHeadId(headDb.getId());
        if (CollUtil.isEmpty(itemDatas)) {
            return;
        }
        for (PromotionalDataItem itemData : itemDatas) {
            ProCommissionItem proCommissionItem = new ProCommissionItem();
            BeanUtil.copyProperties((Object)((Object)itemData), (Object)((Object)proCommissionItem), (String[])new String[0]);
            proCommissionItem.setId(null);
            proCommissionItem.setHeadId(headId);
            PromoteTypeEnum promoteType = PromoteTypeEnum.getPromoteTypeEnumByCode(proCommissionItem.getPromotionType());
            BigDecimal rate = ruleMap.get(promoteType.getCode());
            if (ObjectUtil.isNotNull((Object)rate)) {
                proCommissionItem.setOrderRate(rate.multiply(BigDecimal.valueOf(100L)));
                proCommissionItem.setOrderAmount(proCommissionItem.getOrderVal().multiply(rate));
            }
            adds.add(proCommissionItem);
        }
        this.proCommissionItemService.saveBatch(adds);
    }

    private void handleRemoveParams(ProCommissionHead proCommissionHead) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sub_account", (Object)proCommissionHead.getSubAccount());
        queryWrapper.eq((Object)"employee_no", (Object)proCommissionHead.getEmployeeNo());
        queryWrapper.eq((Object)"count_year", (Object)proCommissionHead.getCountYear());
        queryWrapper.eq((Object)"count_month", (Object)proCommissionHead.getCountMonth());
        queryWrapper.select(new String[]{"id"});
        List dbs = this.list((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)dbs)) {
            return;
        }
        List headIds = dbs.stream().map(x -> x.getId()).collect(Collectors.toList());
        this.removeByIds(headIds);
        this.proCommissionItemService.remove((Wrapper)Wrappers.lambdaQuery().in(ProCommissionItem::getHeadId, headIds));
    }
}

