/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.industryinfo.entity.TopManAnalysisDataItem;
import com.els.modules.industryinfo.entity.TopManBrandAnalysisItem;
import com.els.modules.industryinfo.entity.TopManCategoryAnalysisItem;
import com.els.modules.industryinfo.entity.TopManGoodsItemList;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.entity.TopManLiveItemList;
import com.els.modules.industryinfo.entity.TopManLiveItemMain;
import com.els.modules.industryinfo.entity.TopManShopItemList;
import com.els.modules.industryinfo.entity.TopManVideoItemList;
import com.els.modules.industryinfo.entity.TopManVideoItemMain;
import com.els.modules.industryinfo.job.utils.DataFormatUtils;
import com.els.modules.industryinfo.service.TopManAnalysisDataItemService;
import com.els.modules.industryinfo.service.TopManBrandAnalysisItemService;
import com.els.modules.industryinfo.service.TopManCategoryAnalysisItemService;
import com.els.modules.industryinfo.service.TopManGoodsItemListService;
import com.els.modules.industryinfo.service.TopManInformationHeadService;
import com.els.modules.industryinfo.service.TopManLiveItemListService;
import com.els.modules.industryinfo.service.TopManLiveItemMainService;
import com.els.modules.industryinfo.service.TopManShopItemListService;
import com.els.modules.industryinfo.service.TopManVideoItemListService;
import com.els.modules.industryinfo.service.TopManVideoItemMainService;
import com.mongodb.client.MongoCursor;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TopManJob.class);
    @Resource
    private TopManInformationHeadService topManInformationHeadService;
    @Resource
    private TopManBrandAnalysisItemService topManBrandAnalysisItemService;
    @Resource
    private TopManCategoryAnalysisItemService topManCategoryAnalysisItemService;
    @Resource
    private TopManLiveItemMainService topManLiveItemMainService;
    @Resource
    private TopManLiveItemListService topManLiveItemListService;
    @Resource
    private TopManVideoItemMainService topManVideoItemMainService;
    @Resource
    private TopManVideoItemListService topManVideoItemListService;
    @Resource
    private TopManAnalysisDataItemService topManAnalysisDataItemService;
    @Resource
    private TopManGoodsItemListService topManGoodsItemListService;
    @Resource
    private TopManShopItemListService topManShopItemListService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TOPMAN_DATA_NAME = "tb_topman_data";
    private final String TOPMAN_COLLECTION_NAME = "tb_doudian_daren_uid";
    private final String TOPMAN_CORE_DATA_NAME = "tb_doudian_daren_overview";
    private final String TOPMAN_PROFILE_NAME = "tb_doudian_daren_profile";
    private final String TOPMAN_LIVE_DATA_NAME = "tb_doudian_daren_LiveDetail";
    private final String TOPMAN_VIDEO_DATA_NAME = "tb_doudian_daren_VideoDetail";
    private final String TOPMAN_SALASANALYSE_DATA_NAME = "tb_doudian_daren_salesAnalyse";
    private final int BATCH_SIZE = 500;

    public void execute(String parameter) {
        log.info("------------start TopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_daren_uid").find().noCursorTimeout(true).batchSize(500).cursor();){
            ArrayList<TopManInformationHead> entityList = new ArrayList<TopManInformationHead>();
            log.info("------------start TopManJob cursor -----------1");
            while (cursor.hasNext()) {
                ++i;
                Document doc = (Document)cursor.next();
                try {
                    String id = doc.getString((Object)"_id");
                    Document inquerDoc = new Document();
                    inquerDoc.append("_id", (Object)id);
                    Document topmapData = (Document)this.mongoTemplate.getCollection("tb_topman_data").find((Bson)inquerDoc).first();
                    Document profileData = (Document)this.mongoTemplate.getCollection("tb_doudian_daren_profile").find((Bson)inquerDoc).first();
                    entityList.add(this.genTopMan(doc, profileData, topmapData));
                    this.genCoreData(doc, id);
                }
                catch (Exception e) {
                    log.error("doc error ", (Object)doc);
                    log.error("genTopMan error ", (Throwable)e);
                }
                if (i % 1000 != 0) continue;
                log.info("------------start TopManJob cursor -----------" + i);
                try {
                    this.topManInformationHeadService.saveOrUpdateBatch(entityList);
                }
                catch (Exception e) {
                    log.error("saveOrUpdateBatch error", (Throwable)e);
                }
                entityList = new ArrayList();
            }
            log.info("------------start TopManJob cursor -----------" + i);
            this.topManInformationHeadService.saveOrUpdateBatch(entityList);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private TopManVideoItemMain genVideoData(Document coreData, String headId) throws ParseException {
        Document inquerDoc = new Document();
        inquerDoc.append("_id", (Object)coreData.getString((Object)"_id"));
        Document videoData = (Document)this.mongoTemplate.getCollection("tb_doudian_daren_VideoDetail").find((Bson)inquerDoc).first();
        if (videoData == null || videoData.isEmpty()) {
            return null;
        }
        return this.getTopManVideo(videoData, headId, coreData);
    }

    private TopManVideoItemMain getTopManVideo(Document doc, String id, Document coreData) throws ParseException {
        TopManVideoItemMain itemMain = new TopManVideoItemMain();
        Document videoDoc = (Document)coreData.get((Object)"video_data", Document.class);
        itemMain.setId(doc.getString((Object)"_id"));
        itemMain.setHeadId(id);
        itemMain.setElsAccount("100000");
        itemMain.setStatisticsType(doc.getString((Object)"days"));
        itemMain.setStatisticsDate(coreData.getString((Object)"date"));
        itemMain.setGoodsVideoQuantity(DataFormatUtils.numberToBigDecimal(videoDoc.get((Object)"count")));
        itemMain.setGoodsPlayQuantity(DataFormatUtils.numberToBigDecimal(videoDoc.get((Object)"watching_num")));
        itemMain.setSalesAvgLow(DataFormatUtils.numberToBigDecimal(videoDoc.get((Object)"sale_low")));
        itemMain.setSalesAvgHigh(DataFormatUtils.numberToBigDecimal(videoDoc.get((Object)"sale_high")));
        itemMain.setGpmLow(DataFormatUtils.numberToBigDecimal(videoDoc.get((Object)"GPM_low")));
        itemMain.setGpmHigh(DataFormatUtils.numberToBigDecimal(videoDoc.get((Object)"GPM_high")));
        itemMain.setProportionOfSales(DataFormatUtils.numberToBigDecimal(videoDoc.get((Object)"percentage")));
        itemMain.setVideoQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"video_num")));
        itemMain.setPlayQuantity(DataFormatUtils.stringToBigDecimal(doc.getString((Object)"play_times")));
        itemMain.setPlayFullRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"finish_rate")));
        itemMain.setLikesQuantity(DataFormatUtils.stringToBigDecimal(doc.getString((Object)"like_num")));
        itemMain.setCommentsQuantity(DataFormatUtils.stringToBigDecimal(doc.getString((Object)"comment_num")));
        itemMain.setForwardQuantity(DataFormatUtils.stringToBigDecimal(doc.getString((Object)"reshare_num")));
        this.genVideoRecode((List)doc.get((Object)"VideoDetail_List", List.class), id, doc.getString((Object)"_id"));
        return itemMain;
    }

    @Async
    public void genVideoRecode(List<Document> videos, String headId, String mainId) throws ParseException {
        ArrayList<TopManVideoItemList> entityList = new ArrayList<TopManVideoItemList>();
        for (Document video : videos) {
            TopManVideoItemList item = new TopManVideoItemList();
            item.setMainId(mainId);
            item.setHeadId(headId);
            item.setElsAccount("100000");
            item.setVideoId(video.getString((Object)"videoId"));
            item.setVideoInfo(video.getString((Object)"content_url"));
            item.setPublishTime(DataFormatUtils.stringToDate(video.getString((Object)"date_create")));
            item.setPlayQuantity(DataFormatUtils.stringToBigDecimal(video.getString((Object)"play_times")));
            item.setInteractionRate(DataFormatUtils.numberToBigDecimal(video.get((Object)"interact_rate")));
            item.setSalesAmountLow(DataFormatUtils.numberToBigDecimal(video.get((Object)"sale_low")));
            item.setSalesAmountHigh(DataFormatUtils.numberToBigDecimal(video.get((Object)"sale_high")));
            item.setGpmLow(DataFormatUtils.numberToBigDecimal(video.get((Object)"GPM_low")));
            item.setGpmHigh(DataFormatUtils.numberToBigDecimal(video.get((Object)"GPM_high")));
            item.setGoodsQuantity(DataFormatUtils.stringToBigDecimal(video.getString((Object)"promotion_sum")));
            entityList.add(item);
        }
        if (entityList.size() > 0) {
            this.topManVideoItemListService.saveBatch(entityList);
        }
    }

    private TopManLiveItemMain genLiveData(Document coreData, String headId) throws ParseException {
        Document inquerDoc = new Document();
        inquerDoc.append("_id", (Object)coreData.getString((Object)"_id"));
        Document liveData = (Document)this.mongoTemplate.getCollection("tb_doudian_daren_LiveDetail").find((Bson)inquerDoc).first();
        if (liveData == null || liveData.isEmpty()) {
            return null;
        }
        return this.getLiveMain(liveData, headId, coreData);
    }

    private TopManLiveItemMain getLiveMain(Document doc, String id, Document coreData) throws ParseException {
        Document liveData = (Document)coreData.get((Object)"live_data", Document.class);
        TopManLiveItemMain itemMain = new TopManLiveItemMain();
        itemMain.setId(doc.getString((Object)"_id"));
        itemMain.setHeadId(id);
        itemMain.setElsAccount("100000");
        itemMain.setStatisticsType(doc.getString((Object)"days"));
        itemMain.setStatisticsDate(doc.getString((Object)"date"));
        itemMain.setInteractionRate(DataFormatUtils.numberToBigDecimal(doc.get((Object)"interact_rate")));
        itemMain.setLiveQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"live_count")));
        itemMain.setLiveDays(DataFormatUtils.numberToBigDecimal(doc.get((Object)"work_day_count")));
        itemMain.setLiveDurationAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"live_duration")));
        itemMain.setLiveViewers(DataFormatUtils.numberToBigDecimal(doc.get((Object)"watching_num")));
        itemMain.setOnlinePopulationAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"online_avg")));
        itemMain.setOnlinePopulationMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"online_peak")));
        itemMain.setWatchDurationAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"watching_duration_avg")));
        itemMain.setGoodsLiveQuantity(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"count")));
        itemMain.setGoodsLiveViewers(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"watching_num")));
        itemMain.setGoodsSalesAvgLow(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"sale_low")));
        itemMain.setGoodsSalesAvgHigh(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"sale_high")));
        itemMain.setGoodsGpmLow(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"GPM_low")));
        itemMain.setGoodsGpmHigh(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"GPM_high")));
        itemMain.setProportionOfSales(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"percentage")));
        this.genLiveRecode((List)doc.get((Object)"LiveDetail_List", List.class), id, doc.getString((Object)"_id"));
        return itemMain;
    }

    @Async
    private void genLiveRecode(List<Document> lives, String headId, String mainId) throws ParseException {
        ArrayList<TopManLiveItemList> entityList = new ArrayList<TopManLiveItemList>();
        for (Document recode : lives) {
            TopManLiveItemList item = new TopManLiveItemList();
            item.setMainId(mainId);
            item.setHeadId(headId);
            item.setElsAccount("100000");
            item.setLiveId(recode.getString((Object)"roomId"));
            item.setWatchQuantity(DataFormatUtils.stringToBigDecimal(recode.getString((Object)"viewer")));
            item.setGoodsQuantity(DataFormatUtils.stringToBigDecimal(recode.getString((Object)"promotion_sum")));
            item.setWatchDurationAvg(DataFormatUtils.stringToBigDecimal(recode.getString((Object)"average_watching_time")));
            List dateSection = recode.getList((Object)"date_section", String.class);
            item.setLiveTime(DataFormatUtils.stringToDate((String)dateSection.get(0)));
            item.setLiveDuration(DataFormatUtils.stringToBigDecimal((String)dateSection.get(1)));
            item.setGpmLow(DataFormatUtils.numberToBigDecimal(recode.get((Object)"GPM_low")));
            item.setGpmHigh(DataFormatUtils.numberToBigDecimal(recode.get((Object)"GPM_high")));
            item.setSalesAmountLow(DataFormatUtils.numberToBigDecimal(recode.get((Object)"live_sale_low")));
            item.setSalesAmountHigh(DataFormatUtils.numberToBigDecimal(recode.get((Object)"live_sale_high")));
            entityList.add(item);
        }
        this.topManLiveItemListService.saveBatch(entityList);
    }

    @Async
    private void genSalesAnalyse(BigDecimal commerceDays, String id) {
        Document inquerDoc = new Document();
        inquerDoc.append("invite_id", (Object)id);
        this.topManGoodsItemListService.deleteByMainId(id);
        this.topManShopItemListService.deleteByMainId(id);
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_daren_salesAnalyse").find((Bson)inquerDoc).noCursorTimeout(true).cursor();){
            ArrayList<TopManAnalysisDataItem> entityList = new ArrayList<TopManAnalysisDataItem>();
            ArrayList<TopManShopItemList> shopList = new ArrayList<TopManShopItemList>();
            ArrayList<TopManGoodsItemList> goodsList = new ArrayList<TopManGoodsItemList>();
            while (cursor.hasNext()) {
                Document salesData = (Document)cursor.next();
                String days = salesData.getString((Object)"days");
                TopManAnalysisDataItem analysisData = this.getAnalysisData(salesData, id);
                analysisData.setCommerceDays(commerceDays);
                shopList.addAll(this.getShopList((Document)salesData.get((Object)"cooperateShop", Document.class), id, analysisData.getId()));
                goodsList.addAll(this.getGoodsList((Document)salesData.get((Object)"sellProduct", Document.class), id, analysisData.getId()));
                entityList.add(analysisData);
            }
            this.topManAnalysisDataItemService.saveOrUpdateBatch(entityList);
            this.topManGoodsItemListService.saveBatch(goodsList);
            this.topManShopItemListService.saveBatch(shopList);
        }
        catch (Exception e) {
            log.error("genSalesAnalyse error", (Throwable)e);
        }
    }

    private List<TopManGoodsItemList> getGoodsList(Document goods, String headId, String mainId) {
        ArrayList<TopManGoodsItemList> list = new ArrayList<TopManGoodsItemList>();
        List cateListDoc = (List)goods.get((Object)"indus_cat_list", List.class);
        Map<String, String> brands = this.getBrands((List)goods.get((Object)"brand_list", List.class));
        for (Document cateShop : cateListDoc) {
            String cateName = cateShop.getString((Object)"cate_name");
            BigDecimal vol = DataFormatUtils.numberToBigDecimal(cateShop.get((Object)"vol"));
            List dataList = (List)cateShop.get((Object)"data_list", List.class);
            for (Document doc : dataList) {
                TopManGoodsItemList item = new TopManGoodsItemList();
                item.setElsAccount("100000");
                item.setHeadId(headId);
                item.setMainId(mainId);
                Document basice = (Document)doc.get((Object)"good_info", Document.class);
                item.setGoodsId(basice.getString((Object)"pidStr"));
                item.setGoodsTitle(basice.getString((Object)"title"));
                item.setBrand(brands.get(item.getGoodsId()));
                item.setGoodsPicture(basice.getString((Object)"img"));
                item.setGoodsCategory(cateName);
                item.setPrice(DataFormatUtils.numberToBigDecimal(basice.get((Object)"cur_price")));
                item.setSalesRangeHigh(DataFormatUtils.numberToBigDecimal(doc.get((Object)"goods_sale_high")));
                item.setSalesRangeLow(DataFormatUtils.numberToBigDecimal(doc.get((Object)"goods_sale_low")));
                item.setLiveQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"related_live_times")));
                item.setVideoQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"related_video_num")));
                list.add(item);
            }
        }
        return list;
    }

    private Map<String, String> getBrands(List<Document> brandList) {
        HashMap<String, String> brands = new HashMap<String, String>();
        for (Document brand : brandList) {
            String brandName = brand.getString((Object)"cate_name");
            List dataList = (List)brand.get((Object)"data_list", List.class);
            for (Document data : dataList) {
                Document basic = (Document)data.get((Object)"good_info", Document.class);
                String id = basic.getString((Object)"pidStr");
                if (id == null) continue;
                brands.put(id, brandName);
            }
        }
        return brands;
    }

    private List<TopManShopItemList> getShopList(Document shop, String headId, String mainId) {
        ArrayList<TopManShopItemList> list = new ArrayList<TopManShopItemList>();
        List cateListDoc = (List)shop.get((Object)"indus_cat_list", List.class);
        for (Document cateShop : cateListDoc) {
            String cateName = cateShop.getString((Object)"cate_name");
            BigDecimal vol = DataFormatUtils.numberToBigDecimal(cateShop.get((Object)"vol"));
            List dataList = (List)cateShop.get((Object)"data_list", List.class);
            for (Document doc : dataList) {
                TopManShopItemList item = new TopManShopItemList();
                item.setElsAccount("100000");
                item.setHeadId(headId);
                item.setMainId(mainId);
                Document basice = (Document)doc.get((Object)"basic_info", Document.class);
                item.setShopId(basice.getString((Object)"shop_id"));
                item.setShopTitle(basice.getString((Object)"name"));
                item.setShopLogo(basice.getString((Object)"shop_avatar"));
                item.setGoodsCategory(cateName);
                item.setPopularizeGoodsQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"promotion_sum")));
                item.setPopularizeGmvLow(DataFormatUtils.numberToBigDecimal(doc.get((Object)"promotion_GMV_low")));
                item.setPopularizeGmvHigh(DataFormatUtils.numberToBigDecimal(doc.get((Object)"promotion_GMV_high")));
                item.setLiveQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"related_times")));
                item.setVideoQuantity(DataFormatUtils.numberToBigDecimal(doc.get((Object)"related_video_num")));
                list.add(item);
            }
        }
        return list;
    }

    private TopManAnalysisDataItem getAnalysisData(Document doc, String headId) {
        TopManAnalysisDataItem data = new TopManAnalysisDataItem();
        data.setId(doc.getString((Object)"_id"));
        data.setHeadId(headId);
        data.setElsAccount("100000");
        Document keyData = (Document)doc.get((Object)"key_data", Document.class);
        Document liveData = (Document)doc.get((Object)"live_data", Document.class);
        Document videoData = (Document)doc.get((Object)"video_data", Document.class);
        data.setPopularizeGoodsQuantity(DataFormatUtils.numberToBigDecimal(keyData.get((Object)"promotion_sum")));
        data.setCooperationShopQuantity(DataFormatUtils.numberToBigDecimal(keyData.get((Object)"cooperate_shop_num")));
        data.setPriceAvg(DataFormatUtils.numberToBigDecimal(keyData.get((Object)"average_price")));
        data.setSaleTotalAmountLow(DataFormatUtils.numberToBigDecimal(keyData.get((Object)"sale_low")));
        data.setSaleTotalAmountHigh(DataFormatUtils.numberToBigDecimal(keyData.get((Object)"sale_high")));
        data.setStatisticsType(doc.getString((Object)"days"));
        data.setLiveCooperationShop(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"cooperate_shop_num")));
        data.setLivePopularizeGoods(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"promotion_sum")));
        data.setLivePriceAvg(DataFormatUtils.numberToBigDecimal(liveData.get((Object)"average_price")));
        data.setVideoCooperationShop(DataFormatUtils.numberToBigDecimal(videoData.get((Object)"cooperate_shop_num")));
        data.setVideoPopularizeGoods(DataFormatUtils.numberToBigDecimal(videoData.get((Object)"promotion_sum")));
        data.setVideoPriceAvg(DataFormatUtils.numberToBigDecimal(videoData.get((Object)"average_price")));
        return data;
    }

    @Async
    private void genCoreData(Document doc, String id) {
        Document inquerDoc = new Document();
        inquerDoc.append("invite_id", (Object)id);
        BigDecimal commerceDays = new BigDecimal(0);
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_daren_overview").find((Bson)inquerDoc).noCursorTimeout(true).cursor();){
            ArrayList<TopManBrandAnalysisItem> breadList = new ArrayList<TopManBrandAnalysisItem>();
            ArrayList<TopManCategoryAnalysisItem> categoryList = new ArrayList<TopManCategoryAnalysisItem>();
            ArrayList<TopManLiveItemMain> liveMain = new ArrayList<TopManLiveItemMain>();
            ArrayList<TopManVideoItemMain> videoMainList = new ArrayList<TopManVideoItemMain>();
            this.topManBrandAnalysisItemService.deleteByMainId(id);
            this.topManCategoryAnalysisItemService.deleteByMainId(id);
            this.topManLiveItemMainService.deleteByMainId(id);
            this.topManLiveItemListService.deleteByMainId(id);
            this.topManVideoItemMainService.deleteByMainId(id);
            this.topManVideoItemListService.deleteByMainId(id);
            log.info("------------start genCoreData cursor -----------1");
            while (cursor.hasNext()) {
                TopManVideoItemMain videoMain;
                Document coreData = (Document)cursor.next();
                Document keyData = (Document)coreData.get((Object)"key_data", Document.class);
                commerceDays = DataFormatUtils.numberToBigDecimal(keyData.get((Object)"total_work_day"));
                Document saleAnalysis = (Document)coreData.get((Object)"sale_analysis", Document.class);
                String days = coreData.getString((Object)"days");
                breadList.addAll(this.genBrandItem(saleAnalysis, id, days));
                categoryList.addAll(this.genTopManCategoryAnalysisItem(saleAnalysis, id, days));
                TopManLiveItemMain main = this.genLiveData(coreData, id);
                if (main != null) {
                    liveMain.add(main);
                }
                if ((videoMain = this.genVideoData(coreData, id)) == null) continue;
                videoMainList.add(videoMain);
            }
            this.topManBrandAnalysisItemService.saveBatch(breadList);
            this.topManCategoryAnalysisItemService.saveBatch(categoryList);
            this.topManLiveItemMainService.saveBatch(liveMain);
            this.topManVideoItemMainService.saveBatch(videoMainList);
        }
        catch (Exception e) {
            log.error("genCoreData error", (Throwable)e);
        }
        this.genSalesAnalyse(commerceDays, id);
    }

    private List<TopManBrandAnalysisItem> genBrandItem(Document saleAnalysis, String headId, String days) {
        ArrayList<TopManBrandAnalysisItem> entityList = new ArrayList<TopManBrandAnalysisItem>();
        List liveBrand = (List)((Document)saleAnalysis.get((Object)"live", Document.class)).get((Object)"brand", List.class);
        for (Document doc : liveBrand) {
            entityList.add(this.getBrand(doc, "1", headId, days));
        }
        List videoBrand = (List)((Document)saleAnalysis.get((Object)"video", Document.class)).get((Object)"brand", List.class);
        for (Document doc : videoBrand) {
            entityList.add(this.getBrand(doc, "2", headId, days));
        }
        return entityList;
    }

    private TopManBrandAnalysisItem getBrand(Document doc, String popularizeType, String headId, String days) {
        TopManBrandAnalysisItem brand = new TopManBrandAnalysisItem();
        brand.setHeadId(headId);
        brand.setElsAccount("100000");
        brand.setPopularizeType(popularizeType);
        brand.setBrand(doc.getString((Object)"brand"));
        brand.setStatisticsType(days);
        brand.setPriceAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_price")));
        brand.setSaleAmountMin(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_low")));
        brand.setSaleAmountMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_high")));
        return brand;
    }

    private List<TopManCategoryAnalysisItem> genTopManCategoryAnalysisItem(Document saleAnalysis, String headId, String days) {
        ArrayList<TopManCategoryAnalysisItem> entityList = new ArrayList<TopManCategoryAnalysisItem>();
        List liveCategory = (List)((Document)saleAnalysis.get((Object)"live", Document.class)).get((Object)"catogory", List.class);
        for (Document doc : liveCategory) {
            entityList.add(this.getCategoryAnalysis(doc, "1", headId, days));
        }
        List videoCategory = (List)((Document)saleAnalysis.get((Object)"video", Document.class)).get((Object)"catogory", List.class);
        for (Document doc : videoCategory) {
            entityList.add(this.getCategoryAnalysis(doc, "2", headId, days));
        }
        return entityList;
    }

    private TopManCategoryAnalysisItem getCategoryAnalysis(Document doc, String popularizeType, String headId, String days) {
        TopManCategoryAnalysisItem category = new TopManCategoryAnalysisItem();
        category.setHeadId(headId);
        category.setElsAccount("100000");
        category.setPopularizeType(popularizeType);
        category.setCategory(doc.getString((Object)"category"));
        category.setPriceAvg(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_price")));
        category.setStatisticsType(days);
        category.setSaleAmountMin(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_low")));
        category.setSaleAmountMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"average_GMV_high")));
        category.setCommissionRateMin(DataFormatUtils.numberToBigDecimal(doc.get((Object)"suggest_ratio_min")));
        category.setCommissionRateMax(DataFormatUtils.numberToBigDecimal(doc.get((Object)"suggest_ratio_max")));
        return category;
    }

    private TopManInformationHead genTopMan(Document doc, Document profileData, Document topmapData) {
        Document base = (Document)doc.get((Object)"author_base");
        Document contact = (Document)doc.get((Object)"author_contact");
        TopManInformationHead bean = new TopManInformationHead();
        bean.setId(doc.getString((Object)"_id"));
        bean.setElsAccount("100000");
        bean.setPlatform("1");
        bean.setTopmanName(base.getString((Object)"nickname"));
        bean.setTopmanId(base.getString((Object)"uid"));
        bean.setTopmanAvatar(base.getString((Object)"avatar_big"));
        bean.setFansNum(DataFormatUtils.numberToBigDecimal(base.get((Object)"fans_num")));
        bean.setTopmanSex(DataFormatUtils.numberToString(base.getInteger((Object)"gender")));
        bean.setRegion(base.getString((Object)"city"));
        bean.setTopmanLevel(DataFormatUtils.numberToString(base.get((Object)"author_level")));
        bean.setMobile(contact.getString((Object)"phone"));
        bean.setWechat(contact.getString((Object)"wechat"));
        this.genData(topmapData, bean);
        if (profileData != null && !profileData.isEmpty()) {
            bean.setTiktokNo(profileData.getString((Object)"account_douyin"));
            bean.setRemark(profileData.getString((Object)"introduction"));
            bean.setGoodsWom(DataFormatUtils.stringToBigDecimal(profileData.getString((Object)"score")));
            bean.setCreditScore(DataFormatUtils.numberToBigDecimal(profileData.get((Object)"credit_score")));
            bean.setCooperationMode(DataFormatUtils.numberToString(profileData.get((Object)"sell_requirement")));
            List content = (List)profileData.get((Object)"works_type", List.class);
            String contentType = "";
            int cnt = 0;
            for (String str : content) {
                contentType = cnt == 0 ? str : contentType + "-" + str;
                ++cnt;
            }
            bean.setContentType(contentType);
        }
        return bean;
    }

    private void genData(Document topmanData, TopManInformationHead bean) {
        if (topmanData != null && !topmanData.isEmpty()) {
            bean.setXingtuTopman("1");
            bean.setQuoteOfLive(DataFormatUtils.stringToBigDecimal(topmanData.getString((Object)"price_60")));
        }
    }
}

