/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.entity.GoodsHead;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodsHeadQueryParam {
    private static final Logger log = LoggerFactory.getLogger(GoodsHeadQueryParam.class);

    public static QueryWrapper<GoodsHead> getQueryParam(GoodsHead head, Map<String, String[]> parameterMap, GoodsHeadQueryDTO queryDTO) {
        Boolean goodsVideo;
        Boolean goodsLive;
        String goodsBrowsesNum;
        String salesNum;
        String topman;
        String goodsRate;
        String goodsPrice;
        String shopId;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), parameterMap);
        String platform = queryDTO.getPlatform();
        if (StringUtils.isNotBlank((CharSequence)platform)) {
            queryWrapper.eq((Object)"gh.platform", (Object)platform);
        }
        if (StringUtils.isNotBlank((CharSequence)(shopId = queryDTO.getShopId()))) {
            queryWrapper.eq((Object)"gh.shop_id", (Object)shopId);
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsPrice = queryDTO.getGoodsPrice()))) {
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.gt((Object)"gh.price", (Object)new BigDecimal(prices[0]));
                queryWrapper.le((Object)"gh.price", (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                queryWrapper.lt((Object)"gh.price", (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                queryWrapper.gt((Object)"gh.price", (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsRate = queryDTO.getGoodsCommissionRate()))) {
            String[] strings;
            if (goodsRate.contains("-")) {
                strings = goodsRate.split("-");
                String split = strings[0].contains("%") ? strings[0].split("%")[0] : strings[0];
                String split1 = strings[1].split("%")[0];
                queryWrapper.gt((Object)"gh.commission_rate", (Object)split);
                queryWrapper.le((Object)"gh.commission_rate", (Object)split1);
            }
            if (goodsRate.contains(">=")) {
                strings = goodsRate.split(">=");
                String split1 = strings[1].split("%")[0];
                queryWrapper.ge((Object)"gh.commission_rate", (Object)split1);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(topman = queryDTO.getGoodsTopmanNum()))) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.gt((Object)"gdi.topman_num", (Object)new BigDecimal(strings[0]));
                queryWrapper.le((Object)"gdi.topman_num", (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                queryWrapper.gt((Object)"gdi.topman_num", (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.eq((Object)"gdi.topman_num", (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
            String[] strings;
            if (salesNum.contains("-")) {
                strings = salesNum.split("-");
                queryWrapper.between((Object)"gdi.sales_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (salesNum.contains(">=")) {
                strings = salesNum.split(">=");
                queryWrapper.ge((Object)"gdi.sales_num", (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
            String[] strings;
            if (goodsBrowsesNum.contains("-")) {
                strings = goodsBrowsesNum.split("-");
                queryWrapper.between((Object)"gdi.browses_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (goodsBrowsesNum.contains(">=")) {
                strings = goodsBrowsesNum.split(">=");
                queryWrapper.ge((Object)"gdi.browses_num", (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.gt((Object)"gdi.lives_num", (Object)BigDecimal.ZERO);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.gt((Object)"gdi.videos_num", (Object)BigDecimal.ZERO);
        }
        return queryWrapper;
    }
}

