/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.enumerate.StatisticsDateType;
import com.els.modules.industryinfo.dto.TopManDetailBodyDo;
import com.els.modules.industryinfo.entity.TopManDetailHeadEntity;
import com.els.modules.industryinfo.entity.TopManGoodsListEntity;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.entity.TopManResultDetailBody;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyBase;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyFans;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyLive;
import com.els.modules.industryinfo.entity.TopManResultDetailBodySaleGoods;
import com.els.modules.industryinfo.entity.TopManResultDetailBodyVideo;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.entity.TopManShopListEntity;
import com.els.modules.industryinfo.enumerate.TopManCategoryEnum;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.mapper.TopManInformationMapper;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.utils.spider.entity.TopManDetailBaseEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManDetailSaleGoodsEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSaleGoodsTagEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSpiderGoodsListEntity;
import com.els.modules.industryinfo.utils.spider.entity.TopManSpiderShopListEntity;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.vo.KsTopManCategory;
import com.els.modules.industryinfo.vo.TopManInformationVO;
import com.mongodb.client.MongoCursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class TopManInformationServiceImpl
extends BaseServiceImpl<TopManInformationMapper, TopManParamEntity>
implements TopManInformationService {
    private static final Logger log = LoggerFactory.getLogger(TopManInformationServiceImpl.class);
    HashMap<TopManQueryType, ListMethod> typeMethod = null;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String MCN_COLLECTION_NAME = "tb_kuaishou_category";
    private final BigDecimal divide = new BigDecimal("100.00");
    private static final String CATALOGUE = "talent:category:cache";
    private static final String COLON = ":";

    @Override
    public IPage<? extends TopManResultEntity> queryTopManList(SimplePostRequestParam<TopManInformationVO> topManDto, TopManQueryType topManQueryType) {
        if (this.typeMethod == null) {
            this.typeMethod = new HashMap<TopManQueryType, ListMethod>(){
                {
                    this.put(TopManQueryType.all, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageAll);
                    this.put(TopManQueryType.myCollection, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageCollection);
                    this.put(TopManQueryType.liveTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageLiveTopMan);
                    this.put(TopManQueryType.videoTopMan, ((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper)::selectPageVideoTopMan);
                }
            };
        }
        QueryWrapper<TopManParamEntity> queryWrapper = this.getQueryWrapper(topManDto);
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        page.setCountId("pageSelectCount");
        ((TopManInformationVO)topManDto.getFilterInfo()).getCountTables().add(topManQueryType.getCountTable());
        topManQueryType.getInitMethod().initQueryWrapper(queryWrapper, null);
        return Optional.ofNullable(this.typeMethod.get((Object)topManQueryType)).orElseThrow(() -> new TopManException(I18nUtil.translate((String)"", (String)"\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef"))).apply((IPage<TopManResultEntity>)page, (Wrapper<TopManParamEntity>)queryWrapper, SysUtil.getLoginUser(), (TopManInformationVO)topManDto.getFilterInfo(), StatisticsDateType.M1);
    }

    @Override
    public TopManDetailHeadEntity queryDetailHead(String id) {
        return ((TopManInformationMapper)this.baseMapper).queryDetailHead(id, SysUtil.getLoginUser(), StatisticsDateType.M1);
    }

    @Override
    public TopManDetailHeadEntity queryDetailHeadBase(String id, String clearCache) {
        String key = "TopManDetailHead" + id;
        TopManDetailHeadEntity topManDetailHeadEntity = null;
        if (!"1".equals(clearCache)) {
            topManDetailHeadEntity = (TopManDetailHeadEntity)((Object)this.redisUtil.get(key));
        }
        if (topManDetailHeadEntity == null) {
            topManDetailHeadEntity = this.getNewTopManDetailHeadEntity(id);
        } else {
            HashMap<String, Object> paramBean = new HashMap<String, Object>(2);
            paramBean.put("uid", topManDetailHeadEntity.getTopManBaseData().getTopManId());
            paramBean.put("days", StatisticsDateType.M1.getDicCode());
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.DOU_YIN_BASE, paramBean);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> this.getNewTopManDetailHeadEntity(id));
            }
        }
        TopManDetailHeadEntity.TopManBaseData topManBaseData = topManDetailHeadEntity.getTopManBaseData();
        int i = ((TopManInformationMapper)this.baseMapper).checkAddAndCollect(topManBaseData.getPlatform(), topManBaseData.getTopManId(), SysUtil.getLoginUser());
        topManBaseData.setIsAdded(i == 2 || i == 3 ? "1" : "0");
        topManBaseData.setIsCollection(i == 1 || i == 3 ? "1" : "0");
        return topManDetailHeadEntity;
    }

    private TopManDetailHeadEntity getNewTopManDetailHeadEntity(String id) {
        TopManDetailBaseEntity.VideoData videoData;
        TopManDetailBaseEntity.LiveData liveData;
        final TopManDetailHeadEntity topManDetailHeadEntity = ((TopManInformationMapper)this.baseMapper).queryDetailHeadBase(id, SysUtil.getLoginUser());
        if (topManDetailHeadEntity == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(2){
            {
                super(x0);
                this.put("uid", topManDetailHeadEntity.getTopManBaseData().getTopManId());
                this.put("days", StatisticsDateType.M1.getDicCode());
            }
        };
        TopManDetailBaseEntity data = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE, (Map<String, Object>)paramBean, TopManDetailBaseEntity.class);
        topManDetailHeadEntity.setStatisticsDate(data.getDate());
        TopManDetailBaseEntity.CoreData coreData = data.getCoreData();
        if (coreData != null) {
            TopManDetailHeadEntity.TopManCoreData topManCoreData = new TopManDetailHeadEntity.TopManCoreData();
            topManDetailHeadEntity.setTopManCoreData(topManCoreData);
            topManCoreData.setCommerceDays(coreData.getTotalWorkDay());
            topManCoreData.setPopularizeGoodsQuantity(coreData.getPromotionSum());
            topManCoreData.setCooperationShop(coreData.getCooperateShopNum());
            topManCoreData.setGoodsTotalSalesLow(coreData.getSaleLow());
            topManCoreData.setGoodsTotalSalesHigh(coreData.getSaleHigh());
        }
        if ((liveData = data.getLiveData()) != null) {
            TopManDetailHeadEntity.TopManLiveData topManLiveData = new TopManDetailHeadEntity.TopManLiveData();
            topManDetailHeadEntity.setTopManLiveData(topManLiveData);
            topManLiveData.setLiveProportionOfSales(liveData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            topManLiveData.setLiveGpmHigh(liveData.getGpmHigh());
            topManLiveData.setLiveGpmLow(liveData.getGpmLow());
            topManLiveData.setGoodsLiveQuantity(liveData.getCount());
            topManLiveData.setLiveSalesAvgHigh(liveData.getSaleHigh());
            topManLiveData.setLiveSalesAvgLow(liveData.getSaleLow());
            topManLiveData.setGoodsLiveViewers(liveData.getWatchingNum());
        }
        if ((videoData = data.getVideoData()) != null) {
            TopManDetailHeadEntity.TopManVideoData topManVideoData = new TopManDetailHeadEntity.TopManVideoData();
            topManDetailHeadEntity.setTopManVideoData(topManVideoData);
            topManVideoData.setGoodsVideoQuantity(videoData.getCount());
            topManVideoData.setVideoGpmHigh(videoData.getGpmHigh());
            topManVideoData.setVideoGpmLow(videoData.getGpmLow());
            topManVideoData.setVideoProportionOfSales(videoData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            topManVideoData.setVideoSalesAvgHigh(videoData.getSaleHigh());
            topManVideoData.setVideoSalesAvgLow(videoData.getSaleLow());
            topManVideoData.setGoodsPlayQuantity(videoData.getWatchingNum());
        }
        this.redisUtil.set("TopManDetailHead" + id, (Object)topManDetailHeadEntity, 18000L);
        this.cacheTopManResultDetailBodyBase(id, StatisticsDateType.M1, data);
        return topManDetailHeadEntity;
    }

    private Map<String, TopManResultDetailBodyBase> cacheTopManResultDetailBodyBase(String id, StatisticsDateType dateType, TopManDetailBaseEntity data) {
        TopManDetailBaseEntity.SaleAnalysis saleAnalysis;
        if (data != null && (saleAnalysis = data.getSaleAnalysis()) != null) {
            HashMap<String, TopManResultDetailBodyBase> cacheBean = new HashMap<String, TopManResultDetailBodyBase>();
            TopManResultDetailBodyBase videoDetailBodyBase = new TopManResultDetailBodyBase();
            TopManDetailBaseEntity.SaleAnalysisMember video = saleAnalysis.getVideo();
            this.transferSaleAnalysis(video, videoDetailBodyBase);
            cacheBean.put("2", videoDetailBodyBase);
            TopManResultDetailBodyBase liveDetailBodyBase = new TopManResultDetailBodyBase();
            TopManDetailBaseEntity.SaleAnalysisMember live = saleAnalysis.getLive();
            this.transferSaleAnalysis(live, liveDetailBodyBase);
            cacheBean.put("1", liveDetailBodyBase);
            this.redisUtil.set("TopManBodyBaseAnalysis_" + id + "_" + dateType.getDicCode(), cacheBean, 18000L);
            return cacheBean;
        }
        return null;
    }

    private void transferSaleAnalysis(TopManDetailBaseEntity.SaleAnalysisMember source, TopManResultDetailBodyBase target) {
        List<TopManDetailBaseEntity.SaleAnalysisMember.Category> category;
        if (source == null || target == null) {
            return;
        }
        List<TopManDetailBaseEntity.SaleAnalysisMember.Brand> brand = source.getBrand();
        if (brand != null && brand.size() > 0) {
            ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity> brandList = new ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity>(Math.min(3, brand.size()));
            target.setBrandAnalysisData(brandList);
            for (int i = 0; i < Math.min(3, brand.size()); ++i) {
                TopManDetailBaseEntity.SaleAnalysisMember.Brand a = brand.get(i);
                TopManResultDetailBodyBase.popularizeAnalysisEntity brandEntity = new TopManResultDetailBodyBase.popularizeAnalysisEntity();
                brandList.add(brandEntity);
                brandEntity.setBrand(a.getBrand());
                brandEntity.setPriceAvg(a.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                brandEntity.setSaleAmountLow(a.getAverageGMVLow());
                brandEntity.setSaleAmountHigh(a.getAverageGMVHigh());
            }
        }
        if ((category = source.getCategory()) != null && category.size() > 0) {
            ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity> categoryList = new ArrayList<TopManResultDetailBodyBase.popularizeAnalysisEntity>(Math.min(3, category.size()));
            target.setCategoryAnalysisData(categoryList);
            for (int i = 0; i < Math.min(3, category.size()); ++i) {
                TopManDetailBaseEntity.SaleAnalysisMember.Category a = category.get(i);
                TopManResultDetailBodyBase.popularizeAnalysisEntity categoryEntity = new TopManResultDetailBodyBase.popularizeAnalysisEntity();
                categoryList.add(categoryEntity);
                categoryEntity.setCategory(a.getCategory());
                categoryEntity.setPriceAvg(a.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                categoryEntity.setSaleAmountLow(a.getAverageGMVLow());
                categoryEntity.setSaleAmountHigh(a.getAverageGMVHigh());
                categoryEntity.setCommissionRateLow(a.getSuggestRatioMin());
                categoryEntity.setCommissionRateHigh(a.getSuggestRatioMax());
            }
        }
    }

    @Override
    public TopManResultDetailBody queryDetailBody(TopManDetailBodyDo param) {
        return BodyType.getTypeWhitName(param.getBodyType()).function.queryDetailBody(param);
    }

    @Override
    public IPage<TopManGoodsListEntity> queryGoodsList(SimplePostRequestParam<TopManDetailBodyDo> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        return ((TopManInformationMapper)this.baseMapper).queryGoodsList((IPage<TopManGoodsListEntity>)page, (TopManDetailBodyDo)param.getFilterInfo());
    }

    @Override
    public IPage<TopManGoodsListEntity> queryGoodsListNew(SimplePostRequestParam<TopManDetailBodyDo> param) {
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        TopManDetailBodyDo filterInfo = (TopManDetailBodyDo)param.getFilterInfo();
        List<String> brand = filterInfo.getBrand();
        final String brandParam = brand != null && brand.size() > 0 ? brand.get(0) : "";
        List<String> category = filterInfo.getCategory();
        final String statisticsDateType = filterInfo.getStatisticsDateType();
        final String topManId = filterInfo.getTopManId();
        final String categoryParam = category != null && category.size() > 0 ? category.get(0) : "";
        int tP = pageNo * pageSize;
        final int ddPage = (int)Math.ceil((double)tP / 15.0);
        int mcnPage = tP % 15;
        mcnPage = mcnPage == 0 ? 15 : mcnPage;
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        HashMap<String, Object> paramBean = new HashMap<String, Object>(5){
            {
                super(x0);
                this.put("uid", topManId);
                this.put("days", statisticsDateType);
                this.put("cate_id", categoryParam);
                this.put("brand_id", brandParam);
                this.put("page", ddPage);
            }
        };
        TopManSpiderGoodsListEntity goodsListEntity = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_PRODUCT, (Map<String, Object>)paramBean, TopManSpiderGoodsListEntity.class);
        if (goodsListEntity != null) {
            result.setTotal(goodsListEntity.getTotal());
            List<TopManSpiderGoodsListEntity.Goods> productInfo = goodsListEntity.getProductInfo();
            if (productInfo != null && productInfo.size() > mcnPage - 5) {
                ArrayList<TopManGoodsListEntity> resultEntity = new ArrayList<TopManGoodsListEntity>(5);
                result.setRecords(resultEntity);
                for (TopManSpiderGoodsListEntity.Goods a : productInfo.subList(mcnPage - 5, Math.min(mcnPage, productInfo.size()))) {
                    TopManGoodsListEntity topManGoodsListEntity = new TopManGoodsListEntity();
                    resultEntity.add(topManGoodsListEntity);
                    topManGoodsListEntity.setGoodsId(a.getGoodsInfo().getPid());
                    topManGoodsListEntity.setGoodsPicture(a.getGoodsInfo().getImg());
                    topManGoodsListEntity.setGoodsPrice(a.getGoodsInfo().getCurPrice());
                    topManGoodsListEntity.setGoodsTitle(a.getGoodsInfo().getTitle());
                    topManGoodsListEntity.setGoodsSaleAmountHigh(a.getGoodsSaleHigh());
                    topManGoodsListEntity.setGoodsSaleAmountLow(a.getGoodsSaleLow());
                    topManGoodsListEntity.setLiveQuantity(a.getRelatedLiveTimes());
                    topManGoodsListEntity.setVideoQuantity(a.getRelatedVideoNum());
                }
            }
            if (tP % 15 == 10 && (long)tP <= goodsListEntity.getTotal()) {
                paramBean.put("page", ddPage + 1);
                SpiderApiUtil.taskExecutor.execute(() -> this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_PRODUCT, paramBean, TopManSpiderGoodsListEntity.class));
            }
        }
        return result;
    }

    @Override
    public IPage<TopManShopListEntity> queryShopList(SimplePostRequestParam<TopManDetailBodyDo> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        return ((TopManInformationMapper)this.baseMapper).queryShopList((IPage<TopManShopListEntity>)page, (TopManDetailBodyDo)param.getFilterInfo());
    }

    @Override
    public IPage<TopManShopListEntity> queryShopListNew(SimplePostRequestParam<TopManDetailBodyDo> param) {
        TopManDetailBodyDo filterInfo = (TopManDetailBodyDo)param.getFilterInfo();
        List<String> category = filterInfo.getCategory();
        final String categoryParam = category != null && category.size() > 0 ? category.get(0) : "";
        Integer pageNo = param.getPageNo();
        Integer pageSize = param.getPageSize();
        final String statisticsDateType = filterInfo.getStatisticsDateType();
        final String topManId = filterInfo.getTopManId();
        int tP = pageNo * pageSize;
        final int ddPage = (int)Math.ceil((double)tP / 15.0);
        int mcnPage = tP % 15;
        mcnPage = mcnPage == 0 ? 15 : mcnPage;
        Page result = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        HashMap<String, Object> paramBean = new HashMap<String, Object>(4){
            {
                super(x0);
                this.put("uid", topManId);
                this.put("days", statisticsDateType);
                this.put("cate_id", categoryParam);
                this.put("page", ddPage);
            }
        };
        TopManSpiderShopListEntity shopListEntity = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_SHOP, (Map<String, Object>)paramBean, TopManSpiderShopListEntity.class);
        if (shopListEntity != null) {
            result.setTotal(shopListEntity.getTotal());
            List<TopManSpiderShopListEntity.Shop> shopInfo = shopListEntity.getShopInfo();
            if (shopInfo != null && shopInfo.size() > mcnPage - 5) {
                ArrayList<TopManShopListEntity> record = new ArrayList<TopManShopListEntity>(5);
                result.setRecords(record);
                for (TopManSpiderShopListEntity.Shop a : shopInfo.subList(mcnPage - 5, Math.min(mcnPage, shopInfo.size()))) {
                    TopManShopListEntity shop = new TopManShopListEntity();
                    record.add(shop);
                    shop.setLiveQuantity(a.getRelatedTimes());
                    shop.setShopId(a.getBasicInfo().getShopId());
                    shop.setPopularizeGoodsQuantity(a.getBasicInfo().getSalesCnt());
                    shop.setShopLogo(a.getBasicInfo().getShopAvatar());
                    shop.setVideoQuantity(a.getRelatedVideoNum());
                    shop.setGmvHigh(a.getPromotionGmvHigh());
                    shop.setGmvLow(a.getPromotionGmvLow());
                    shop.setShopTitle(a.getBasicInfo().getName());
                }
            }
            if (mcnPage == 10 && (long)tP <= shopListEntity.getTotal()) {
                paramBean.put("page", ddPage + 1);
                SpiderApiUtil.taskExecutor.execute(() -> this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_SHOP, paramBean, TopManSpiderShopListEntity.class));
            }
        }
        return result;
    }

    @Override
    public List<KsTopManCategory> getCategoryData(String type) {
        StringBuilder redisKey;
        List<KsTopManCategory> stringListMap;
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        if ((stringListMap = (List<KsTopManCategory>)this.redisUtil.get((redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(type).append(COLON).append(language)).toString())) == null) {
            log.info("getCategoryData:\u8d70\u4e86\u65e0\u7f13\u5b58");
            LinkedHashMap<String, KsTopManCategory> resultData = new LinkedHashMap<String, KsTopManCategory>();
            Document document = new Document();
            MongoCursor attractCursor = this.mongoTemplate.getCollection("tb_kuaishou_category").find((Bson)document).noCursorTimeout(true).cursor();
            Document attract = null;
            boolean isTalentCategory = false;
            KsTopManCategory talentInfoCategory = new KsTopManCategory();
            ArrayList<KsTopManCategory.ContentCategory> talentList = new ArrayList<KsTopManCategory.ContentCategory>();
            boolean isFanCategory = false;
            KsTopManCategory fanInfoCategory = new KsTopManCategory();
            ArrayList<KsTopManCategory.ContentCategory> fanList = new ArrayList<KsTopManCategory.ContentCategory>();
            boolean isContentCategory = false;
            KsTopManCategory contentPerformanceCategory = new KsTopManCategory();
            ArrayList<KsTopManCategory.ContentCategory> contentList = new ArrayList<KsTopManCategory.ContentCategory>();
            while (attractCursor.hasNext()) {
                try {
                    ArrayList<KsTopManCategory.SubTags> commonList;
                    Object directory_json;
                    ArrayList<KsTopManCategory.SubTags> categoryList;
                    List directory_json2;
                    ArrayList<KsTopManCategory.SubTags> commonList2;
                    KsTopManCategory.ContentCategory topManInfo;
                    attract = (Document)attractCursor.next();
                    String name = attract.getString((Object)"name");
                    String secName = attract.getString((Object)"sec_name");
                    String str = attract.toJson();
                    Map t = (Map)JSONObject.parseObject((String)str, Map.class);
                    KsTopManCategory ksTopManCategory = new KsTopManCategory();
                    if (TopManCategoryEnum.CONTENT_CATEGORY.getDesc().equals(name)) {
                        this.getContentData(t, resultData, "contentType", ksTopManCategory, 1);
                    }
                    if (TopManCategoryEnum.INDUSTRY.getDesc().equals(name)) {
                        this.getContentData(t, resultData, "Industry", ksTopManCategory, 2);
                    }
                    if (TopManCategoryEnum.CONTENT_FORM.getDesc().equals(name)) {
                        this.getContentData(t, resultData, "contentForm", ksTopManCategory, 3);
                    }
                    if (TopManCategoryEnum.RECOMMEND.getDesc().equals(name)) {
                        ksTopManCategory.setFieldName("starRecommendation");
                        ksTopManCategory.setTitle(name);
                        ksTopManCategory.setSort(4);
                        ArrayList<KsTopManCategory.ContentCategory> categoryList2 = new ArrayList<KsTopManCategory.ContentCategory>();
                        List directory_json3 = (List)t.get("directory_json");
                        directory_json3.forEach(a -> {
                            if (this.checkoutStarRecommendation(a.get("tagName").toString())) {
                                KsTopManCategory.ContentCategory contentCategory = new KsTopManCategory.ContentCategory();
                                contentCategory.setStarTagId(String.valueOf(a.get("tagId")));
                                contentCategory.setStarTagName(String.valueOf(a.get("tagName")));
                                contentCategory.setComponent("RCheckbox");
                                categoryList2.add(contentCategory);
                            }
                        });
                        ksTopManCategory.setChildren(categoryList2);
                        resultData.put("starRecommendation", ksTopManCategory);
                    }
                    if (TopManCategoryEnum.CONTENT_PERFORMANCE.getDesc().equals(name)) {
                        topManInfo = new KsTopManCategory.ContentCategory();
                        topManInfo.setComponent("RCustomSelect");
                        topManInfo.setStarTagId(attract.getString((Object)"_id"));
                        topManInfo.setStarTagName(attract.getString((Object)"sec_name"));
                        if (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(secName) || TopManCategoryEnum.EXPECTED_PLAYBACK_VOLUME.getDesc().equals(secName) || TopManCategoryEnum.NUMBER_OF_PEOPLE.getDesc().equals(secName) || TopManCategoryEnum.ESTIMATED_ONLINE_POPULATION.getDesc().equals(secName)) {
                            commonList2 = new ArrayList<KsTopManCategory.SubTags>();
                            directory_json2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                            this.getParamData(commonList2, directory_json2, "");
                            topManInfo.setSubTags(commonList2);
                        } else {
                            ArrayList<KsTopManCategory.SubTags> subTagsList = new ArrayList<KsTopManCategory.SubTags>();
                            directory_json2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                            directory_json2.forEach(a -> {
                                KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                                if (TopManCategoryEnum.CPE.getDesc().equals(secName)) {
                                    subTags.setStarTagName(a.getMax().stripTrailingZeros().toPlainString());
                                    subTags.setStarTagValue(a.getMax());
                                } else {
                                    subTags.setStarTagName(a.getMin().stripTrailingZeros().toPlainString());
                                    subTags.setStarTagValue(a.getMin());
                                }
                                subTagsList.add(subTags);
                            });
                            topManInfo.setSubTags(subTagsList);
                        }
                        this.contentPerformanceGroup(contentList, topManInfo, type);
                        if (!isContentCategory) {
                            contentPerformanceCategory.setFieldName("contentPerformance");
                            contentPerformanceCategory.setTitle(name);
                            contentPerformanceCategory.setSort(8);
                            isContentCategory = true;
                        }
                    }
                    if (TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName)) {
                        ksTopManCategory.setFieldName("talentIndex");
                        ksTopManCategory.setTitle(TopManCategoryEnum.TANLENT_INDEX.getDesc());
                        ksTopManCategory.setSort(6);
                        topManInfo = new KsTopManCategory.ContentCategory();
                        topManInfo.setStarTagId(attract.getString((Object)"_id"));
                        categoryList = new ArrayList<KsTopManCategory.SubTags>();
                        ArrayList<KsTopManCategory.SubTags> subTagsList = new ArrayList<KsTopManCategory.SubTags>();
                        directory_json = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                        directory_json.stream().sorted((a, b) -> this.getDefault(a.getMin()).compareTo(this.getDefault(b.getMin()))).forEach(a -> {
                            KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                            subTags.setStarTagName(a.getMin().stripTrailingZeros().toPlainString() + "\u4ee5\u4e0a");
                            subTags.setStarTagValue(a.getMin());
                            subTagsList.add(subTags);
                        });
                        topManInfo.setComponent("RCustomSelect");
                        topManInfo.setStarTagName(TopManCategoryEnum.COMPOSTIE_INDEX.getDesc());
                        topManInfo.setSubTags(subTagsList);
                        categoryList.add((KsTopManCategory.SubTags)((Object)topManInfo));
                        KsTopManCategory.ContentCategory powderTopManInfo = new KsTopManCategory.ContentCategory();
                        BeanUtils.copyProperties((Object)topManInfo, (Object)powderTopManInfo);
                        powderTopManInfo.setStarTagName(TopManCategoryEnum.FLOUR_INDEX.getDesc());
                        categoryList.add((KsTopManCategory.SubTags)((Object)powderTopManInfo));
                        KsTopManCategory.ContentCategory creationTopManInfo = new KsTopManCategory.ContentCategory();
                        BeanUtils.copyProperties((Object)topManInfo, (Object)creationTopManInfo);
                        creationTopManInfo.setStarTagName(TopManCategoryEnum.CREATION_INDEX.getDesc());
                        categoryList.add((KsTopManCategory.SubTags)((Object)creationTopManInfo));
                        KsTopManCategory.ContentCategory costTopManInfo = new KsTopManCategory.ContentCategory();
                        BeanUtils.copyProperties((Object)topManInfo, (Object)costTopManInfo);
                        costTopManInfo.setStarTagName(TopManCategoryEnum.COST_PERFORMANCE.getDesc());
                        categoryList.add((KsTopManCategory.SubTags)((Object)costTopManInfo));
                        KsTopManCategory.ContentCategory activityManInfo = new KsTopManCategory.ContentCategory();
                        BeanUtils.copyProperties((Object)topManInfo, (Object)activityManInfo);
                        activityManInfo.setStarTagName(TopManCategoryEnum.BUSINESS_ACTIVITY.getDesc());
                        categoryList.add((KsTopManCategory.SubTags)((Object)activityManInfo));
                        KsTopManCategory.ContentCategory cooperationManInfo = new KsTopManCategory.ContentCategory();
                        BeanUtils.copyProperties((Object)topManInfo, (Object)cooperationManInfo);
                        cooperationManInfo.setStarTagName(TopManCategoryEnum.COOPERATION_INDEX.getDesc());
                        categoryList.add((KsTopManCategory.SubTags)((Object)cooperationManInfo));
                        ksTopManCategory.setChildren(categoryList);
                        resultData.put("talentIndex", ksTopManCategory);
                    }
                    if (TopManCategoryEnum.TALENT_INFORMATION.getDesc().equals(name) && !TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName)) {
                        topManInfo = new KsTopManCategory.ContentCategory();
                        topManInfo.setStarTagId(attract.getString((Object)"_id"));
                        topManInfo.setStarTagName(attract.getString((Object)"sec_name"));
                        topManInfo.setComponent("RCascader");
                        if (TopManCategoryEnum.TALENT_REGION.getDesc().equals(secName)) {
                            categoryList = new ArrayList();
                            directory_json2 = (List)t.get("directory_json");
                            for (Map param : directory_json2) {
                                KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                                subTags.setStarTagId(String.valueOf(param.get("provinceCode")));
                                subTags.setStarTagName((String)param.get("provinceName"));
                                subTags.setStarTagValue((String)param.get("provinceName"));
                                List citys = (List)param.get("citys");
                                ArrayList<KsTopManCategory.SubTags> subTagsList = new ArrayList<KsTopManCategory.SubTags>();
                                for (Map citysMap : citys) {
                                    KsTopManCategory.SubTags subTagsCitys = new KsTopManCategory.SubTags();
                                    subTagsCitys.setStarTagId(String.valueOf(citysMap.get("cityCode")));
                                    subTagsCitys.setStarTagName((String)citysMap.get("cityName"));
                                    subTagsCitys.setStarTagValue((String)citysMap.get("cityName"));
                                    subTagsList.add(subTagsCitys);
                                }
                                subTags.setSubTags(subTagsList);
                                categoryList.add(subTags);
                            }
                            topManInfo.setSubTags(categoryList);
                        }
                        if (TopManCategoryEnum.TALENT_QUOTATION.getDesc().equals(secName) || TopManCategoryEnum.NUMBER_OF_FANS.getDesc().equals(secName)) {
                            commonList2 = new ArrayList();
                            directory_json2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                            this.getParamData(commonList2, directory_json2, "");
                            topManInfo.setComponent("RCustomSelect");
                            topManInfo.setSubTags(commonList2);
                        }
                        if (TopManCategoryEnum.GENDER_OF_TALENT.getDesc().equals(secName)) {
                            commonList2 = new ArrayList();
                            directory_json2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Sex.class);
                            directory_json2.forEach(a -> {
                                KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                                subTags.setStarTagName(a.getLabel());
                                subTags.setStarTagValue(a.getValue());
                                commonList2.add(subTags);
                            });
                            topManInfo.setComponent("RSelect");
                            topManInfo.setSubTags(commonList2);
                        }
                        talentList.add(topManInfo);
                        if (!isTalentCategory) {
                            talentInfoCategory.setFieldName("talentInfo");
                            talentInfoCategory.setTitle(name);
                            talentInfoCategory.setSort(5);
                            isTalentCategory = true;
                        }
                    }
                    if (!TopManCategoryEnum.FAN_PORTRAIT.getDesc().equals(name)) continue;
                    topManInfo = new KsTopManCategory.ContentCategory();
                    topManInfo.setStarTagId(attract.getString((Object)"_id"));
                    String value = attract.getString((Object)"sec_name").equals(TopManCategoryEnum.FAN_REGION.getDesc()) ? "\u7c89\u4e1d\u57ce\u5e02\u7ebf" : attract.getString((Object)"sec_name");
                    topManInfo.setStarTagName(value);
                    if (TopManCategoryEnum.FAN_REGION.getDesc().equals(secName) || TopManCategoryEnum.FAN_DEVICE.getDesc().equals(secName)) {
                        directory_json2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Sex.class);
                        commonList = new ArrayList<KsTopManCategory.SubTags>(directory_json2.size());
                        directory_json2.forEach(a -> {
                            KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                            subTags.setStarTagName(a.getLabel());
                            subTags.setStarTagValue(a.getValue());
                            commonList.add(subTags);
                        });
                        topManInfo.setComponent("RSelect");
                        topManInfo.setSubTags(commonList);
                    }
                    if (TopManCategoryEnum.FAN_GENDER.getDesc().equals(secName)) {
                        directory_json2 = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Sex.class);
                        commonList = new ArrayList(directory_json2.size());
                        directory_json2.forEach(a -> {
                            KsTopManCategory.SubTags subTags = new KsTopManCategory.SubTags();
                            subTags.setStarTagName(a.getLabel() + "\u5c45\u591a");
                            subTags.setStarTagValue(a.getValue());
                            commonList.add(subTags);
                        });
                        topManInfo.setComponent("RSelect");
                        topManInfo.setSubTags(commonList);
                    }
                    if (TopManCategoryEnum.FAN_AGE.getDesc().equals(secName)) {
                        ArrayList<KsTopManCategory.SubTags> commonList3 = new ArrayList<KsTopManCategory.SubTags>();
                        directory_json = JSON.parseArray((String)t.get("directory_json").toString(), KsTopManCategory.Fans.class);
                        this.getParamData(commonList3, (List<KsTopManCategory.Fans>)directory_json, "\u5c81");
                        topManInfo.setComponent("RSelect");
                        topManInfo.setSubTags(commonList3);
                    }
                    fanList.add(topManInfo);
                    if (isFanCategory) continue;
                    fanInfoCategory.setFieldName("fanInfo");
                    fanInfoCategory.setTitle("\u7c89\u4e1d\u4fe1\u606f");
                    fanInfoCategory.setSort(5);
                    isFanCategory = true;
                }
                catch (Exception e) {
                    log.error("attractCursor error", (Throwable)e);
                    if (attract == null) continue;
                    log.error("error is Data" + attract.toJson());
                }
            }
            contentPerformanceCategory.setChildren(contentList);
            resultData.put("contentPerformance", contentPerformanceCategory);
            talentInfoCategory.setChildren(talentList);
            resultData.put("talentInfo", talentInfoCategory);
            fanInfoCategory.setChildren(fanList);
            resultData.put("fanInfo", fanInfoCategory);
            stringListMap = this.groupMap(type, resultData);
            if (!stringListMap.isEmpty()) {
                this.redisUtil.set(redisKey.toString(), stringListMap, 7200L);
            }
        }
        return stringListMap;
    }

    public void contentPerformanceGroup(List<KsTopManCategory.ContentCategory> contentList, KsTopManCategory.ContentCategory topManInfo, String type) {
        if ("1".equals(type) && (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.CPE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.EXPECTED_PLAYBACK_VOLUME.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.INTERACTION_RATE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.COMPLETION_RATE.getDesc().equals(topManInfo.getStarTagName()))) {
            contentList.add(topManInfo);
        }
        if ("4".equals(type) && (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.CPE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.NUMBER_OF_PEOPLE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.ESTIMATED_ONLINE_POPULATION.getDesc().equals(topManInfo.getStarTagName()))) {
            contentList.add(topManInfo);
        }
    }

    public boolean checkoutStarRecommendation(String str) {
        boolean isFalse = true;
        if (StringUtils.isNotEmpty((CharSequence)str) && ("\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347".equals(str) || "\u652f\u6301\u5bf9\u516c".equals(str) || "\u6709\u5546\u5355\u7ecf\u9a8c".equals(str) || "\u5386\u53f2\u5408\u4f5c\u8fc7".equals(str))) {
            isFalse = false;
            return isFalse;
        }
        return isFalse;
    }

    @Override
    public void cleanCache() {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKeyVideo = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("1").append(COLON).append(language);
        StringBuilder redisKeyLive = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("4").append(COLON).append(language);
        StringBuilder redisKeyCollect = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("0").append(COLON).append(language);
        String[] arr = new String[]{redisKeyVideo.toString(), redisKeyLive.toString(), redisKeyCollect.toString()};
        this.redisUtil.del(arr);
    }

    private List<KsTopManCategory> groupMap(String type, Map<String, KsTopManCategory> resultData) {
        LinkedList<KsTopManCategory> linkedHashData = new LinkedList<KsTopManCategory>();
        if (resultData != null && resultData.size() > 0) {
            linkedHashData.add(resultData.get("contentType"));
            linkedHashData.add(resultData.get("Industry"));
            switch (type) {
                case "1": {
                    linkedHashData.add(resultData.get("contentForm"));
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("talentIndex"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    linkedHashData.add(resultData.get("contentPerformance"));
                    break;
                }
                case "4": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("talentIndex"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    linkedHashData.add(resultData.get("contentPerformance"));
                    break;
                }
                case "0": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    break;
                }
                default: {
                    new ELSBootException("type\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        return linkedHashData;
    }

    private void getContentData(Map t, Map<String, KsTopManCategory> resultData, String type, KsTopManCategory ksTopManCategory, int sort) {
        ksTopManCategory.setTitle(String.valueOf(t.get("name")));
        ksTopManCategory.setSort(sort);
        ksTopManCategory.setFieldName(type);
        LinkedList<KsTopManCategory.ContentCategory> categoryList = new LinkedList<KsTopManCategory.ContentCategory>();
        List map = (List)t.get("directory_json");
        if (map != null && map.size() > 0) {
            for (Map param : map) {
                KsTopManCategory.ContentCategory aa = new KsTopManCategory.ContentCategory();
                aa.setStarTagName((String)param.get("starTagName"));
                aa.setStarTagId((String)param.get("starTagId"));
                aa.setComponent("RButton");
                categoryList.add(aa);
            }
            ksTopManCategory.setChildren(categoryList);
            resultData.put(type, ksTopManCategory);
        }
    }

    private void getParamData(List<KsTopManCategory.SubTags> commonList, List<KsTopManCategory.Fans> map, String postStr) {
        map.stream().sorted((a, b) -> this.getDefault(a.getMin()).compareTo(this.getDefault(b.getMin()))).forEach(a -> {
            KsTopManCategory.SubTags common = new KsTopManCategory.SubTags();
            if (a.getMax() == null) {
                common.setStarTagName(TopManInformationServiceImpl.getTenThousandOfANumber(a.getMin()) + postStr + "\u4ee5\u4e0a");
                common.setStarTagValue(a.getMin().setScale(2, RoundingMode.HALF_UP).toPlainString() + "-");
            }
            if (a.getMin() == null) {
                common.setStarTagName(TopManInformationServiceImpl.getTenThousandOfANumber(a.getMax()) + postStr + "\u4ee5\u4e0b");
                common.setStarTagValue("-" + a.getMax().setScale(2, RoundingMode.HALF_UP).toPlainString());
            }
            if (a.getMin() != null && a.getMax() != null) {
                common.setStarTagName(TopManInformationServiceImpl.getTenThousandOfANumber(a.getMin()) + postStr + "-" + TopManInformationServiceImpl.getTenThousandOfANumber(a.getMax()) + postStr);
                common.setStarTagValue(a.getMin().setScale(2, RoundingMode.HALF_UP).toPlainString() + "-" + a.getMax().setScale(2, RoundingMode.HALF_UP).toPlainString());
            }
            commonList.add(common);
        });
    }

    private BigDecimal getDefault(BigDecimal bigDecimal) {
        BigDecimal defaultNum = new BigDecimal(0);
        return bigDecimal == null ? defaultNum : bigDecimal;
    }

    public static String getTenThousandOfANumber(BigDecimal num) {
        BigDecimal d10000 = new BigDecimal(10000);
        if (num.compareTo(d10000) < 0) {
            return num.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
        }
        String numStr = num.divide(d10000, 2, RoundingMode.HALF_UP).toPlainString();
        String[] ss = numStr.split("\\.");
        if ("00".equals(ss[1])) {
            return ss[0] + "w";
        }
        if ('0' == ss[1].charAt(1)) {
            return ss[0] + "." + ss[1].charAt(0) + "w";
        }
        return numStr + "w";
    }

    private TopManResultDetailBody queryDetailBodyBase(final TopManDetailBodyDo param) {
        return new TopManResultDetailBodyBase(){
            {
                this.setCategoryAnalysisData(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryCateGoryAnalysisData(param));
                this.setBrandAnalysisData(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryBrandAnalysisData(param));
            }
        };
    }

    private TopManResultDetailBody queryDetailBodyBaseNew(TopManDetailBodyDo param) {
        String popularizeType = param.getPopularizeType();
        final String topManId = param.getTopManId();
        String id = param.getId();
        final String dateType = param.getStatisticsDateType();
        StatisticsDateType typeWhitDicCode = StatisticsDateType.getTypeWhitDicCode((String)dateType, null);
        if (typeWhitDicCode == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"));
        }
        String key = "TopManBodyBaseAnalysis_" + id + "_" + dateType;
        Map<String, TopManResultDetailBodyBase> cBean = null;
        if (!"1".equals(param.getClearCache())) {
            cBean = (Map<String, TopManResultDetailBodyBase>)this.redisUtil.get(key);
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(2){
            {
                super(x0);
                this.put("uid", topManId);
                this.put("days", dateType);
            }
        };
        if (cBean == null) {
            TopManDetailBaseEntity topManDetail = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE, (Map<String, Object>)paramBean, TopManDetailBaseEntity.class);
            cBean = this.cacheTopManResultDetailBodyBase(id, typeWhitDicCode, topManDetail);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.DOU_YIN_BASE, (Map<String, Object>)paramBean);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.queryDetailBodyBaseNew(param);
                });
            }
        }
        return cBean != null ? (TopManResultDetailBody)((Object)cBean.get(popularizeType)) : new TopManResultDetailBodyBase();
    }

    private TopManResultDetailBody queryDetailBodySaleGoods(TopManDetailBodyDo param) {
        final TopManResultDetailBodySaleGoods result = ((TopManInformationMapper)this.baseMapper).queryDetailBodySaleGoods(param);
        if (result == null) {
            return new TopManResultDetailBodySaleGoods();
        }
        result.setSaleGoodsCount((List<TopManResultDetailBodySaleGoods.DataCountItemEntity>)new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(2){
            {
                super(x0);
                this.add(new TopManResultDetailBodySaleGoods.DataCountItemEntity("category", "\u4e3b\u63a8\u7c7b\u76ee"){
                    {
                        this.setChildren(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountGoodsCategory(result.getId()));
                    }
                });
                this.add(new TopManResultDetailBodySaleGoods.DataCountItemEntity("brand", "\u5408\u4f5c\u54c1\u724c"){
                    {
                        this.setChildren(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountGoodsBrand(result.getId()));
                    }
                });
            }
        });
        result.setCooperationShopCount((List<TopManResultDetailBodySaleGoods.DataCountItemEntity>)new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(1){
            {
                super(x0);
                this.add(new TopManResultDetailBodySaleGoods.DataCountItemEntity("category", "\u4e3b\u8425\u7c7b\u76ee"){
                    {
                        this.setChildren(((TopManInformationMapper)TopManInformationServiceImpl.this.baseMapper).queryDetailCountShopCategory(result.getId()));
                    }
                });
            }
        });
        return result;
    }

    private TopManResultDetailBody queryDetailBodySaleGoodsNew(TopManDetailBodyDo param) {
        String id = param.getId();
        final String topManId = param.getTopManId();
        final String dateType = param.getStatisticsDateType();
        StatisticsDateType typeWhitDicCode = StatisticsDateType.getTypeWhitDicCode((String)dateType, null);
        if (typeWhitDicCode == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef"));
        }
        String key = "TopManBodySaleGoods_" + id + "_" + dateType;
        TopManResultDetailBodySaleGoods saleGoods = null;
        if (!"1".equals(param.getClearCache())) {
            saleGoods = (TopManResultDetailBodySaleGoods)((Object)this.redisUtil.get(key));
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(2){
            {
                super(x0);
                this.put("uid", topManId);
                this.put("days", dateType);
            }
        };
        if (saleGoods == null) {
            saleGoods = new TopManResultDetailBodySaleGoods();
            TopManDetailSaleGoodsEntity topManSaleGoodsDetail = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS, (Map<String, Object>)paramBean, TopManDetailSaleGoodsEntity.class);
            this.transferSaleGoods(topManSaleGoodsDetail, saleGoods);
            TopManSaleGoodsTagEntity topManSaleGoodsTag = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_SALE_GOODS_TAG, (Map<String, Object>)paramBean, TopManSaleGoodsTagEntity.class);
            this.transferSaleGoodsTag(topManSaleGoodsTag, saleGoods);
            this.redisUtil.set(key, (Object)saleGoods, 18000L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.DOU_YIN_SALE_GOODS, (Map<String, Object>)paramBean);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.queryDetailBodySaleGoodsNew(param);
                });
            }
        }
        return saleGoods;
    }

    private void transferSaleGoods(TopManDetailSaleGoodsEntity source, TopManResultDetailBodySaleGoods target) {
        if (source != null && target != null) {
            TopManDetailSaleGoodsEntity.VideoData videoData;
            TopManDetailSaleGoodsEntity.LiveData liveData;
            target.setStatisticsDate(source.getStartTime() + "\u81f3" + source.getEndTime());
            TopManDetailSaleGoodsEntity.CoreData coreData = source.getCoreData();
            if (coreData != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsCoreData saleGoodsCoreData = new TopManResultDetailBodySaleGoods.SaleGoodsCoreData();
                target.setSaleGoodsCoreData(saleGoodsCoreData);
                saleGoodsCoreData.setPopularizeGoodsQuantity(coreData.getPromotionSum());
                saleGoodsCoreData.setPriceAvg(coreData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsCoreData.setCooperationShopQuantity(coreData.getCooperateShopNum());
                saleGoodsCoreData.setSaleTotalAmountHigh(coreData.getSaleHigh());
                saleGoodsCoreData.setSaleTotalAmountLow(coreData.getSaleLow());
            }
            if ((liveData = source.getLiveData()) != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsLiveData saleGoodsLiveData = new TopManResultDetailBodySaleGoods.SaleGoodsLiveData();
                target.setSaleGoodsLiveData(saleGoodsLiveData);
                saleGoodsLiveData.setLiveGpmHigh(liveData.getGpmHigh());
                saleGoodsLiveData.setLiveGpmLow(liveData.getGpmLow());
                saleGoodsLiveData.setLiveCooperationShop(liveData.getCooperateShopNum());
                saleGoodsLiveData.setLivePopularizeGoods(liveData.getPromotionSum());
                saleGoodsLiveData.setLivePriceAvg(liveData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsLiveData.setLiveSaleAvgHigh(liveData.getSaleHigh());
                saleGoodsLiveData.setLiveSaleAvgLow(liveData.getSaleLow());
                saleGoodsLiveData.setLiveSaleRate(liveData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            }
            if ((videoData = source.getVideoData()) != null) {
                TopManResultDetailBodySaleGoods.SaleGoodsVideoData saleGoodsVideoData = new TopManResultDetailBodySaleGoods.SaleGoodsVideoData();
                target.setSaleGoodsVideoData(saleGoodsVideoData);
                saleGoodsVideoData.setVideoGpmHigh(videoData.getGpmHigh());
                saleGoodsVideoData.setVideoGpmLow(videoData.getGpmLow());
                saleGoodsVideoData.setVideoCooperationShop(videoData.getCooperateShopNum());
                saleGoodsVideoData.setVideoPopularizeGoods(videoData.getPromotionSum());
                saleGoodsVideoData.setVideoPriceAvg(videoData.getAveragePrice().divide(this.divide, 2, RoundingMode.HALF_UP));
                saleGoodsVideoData.setVideoSaleAvgHigh(videoData.getSaleHigh());
                saleGoodsVideoData.setVideoSaleAvgLow(videoData.getSaleLow());
                saleGoodsVideoData.setVideoSaleRate(videoData.getPercentage().divide(this.divide, 2, RoundingMode.HALF_UP));
            }
        }
    }

    private void transferSaleGoodsTag(TopManSaleGoodsTagEntity source, TopManResultDetailBodySaleGoods target) {
        TopManSaleGoodsTagEntity.TagType cooperateShopTag;
        if (source == null || target == null) {
            return;
        }
        TopManSaleGoodsTagEntity.TagType sellProductTag = source.getSellProductTag();
        if (sellProductTag != null) {
            ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> sellProductList = new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(2);
            target.setSaleGoodsCount(sellProductList);
            this.transferTagDic(sellProductTag, sellProductList);
        }
        if ((cooperateShopTag = source.getCooperateShopTag()) != null) {
            ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> cooperateShopList = new ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity>(1);
            target.setCooperationShopCount(cooperateShopList);
            this.transferTagDic(cooperateShopTag, cooperateShopList);
        }
    }

    private void transferTagDic(TopManSaleGoodsTagEntity.TagType tagType, ArrayList<TopManResultDetailBodySaleGoods.DataCountItemEntity> list) {
        List<TopManSaleGoodsTagEntity.Brand> brand;
        List<TopManSaleGoodsTagEntity.Category> indusCat = tagType.getIndusCat();
        if (indusCat != null && indusCat.size() > 0) {
            TopManResultDetailBodySaleGoods.DataCountItemEntity cateItem = new TopManResultDetailBodySaleGoods.DataCountItemEntity("category", "\u4e3b\u63a8\u7c7b\u76ee");
            list.add(cateItem);
            ArrayList<TopManResultDetailBodySaleGoods.DataCountDic> itemDic = new ArrayList<TopManResultDetailBodySaleGoods.DataCountDic>(indusCat.size());
            cateItem.setChildren(itemDic);
            for (TopManSaleGoodsTagEntity.Category a : indusCat) {
                TopManResultDetailBodySaleGoods.DataCountDic dataCountDic = new TopManResultDetailBodySaleGoods.DataCountDic();
                itemDic.add(dataCountDic);
                dataCountDic.setKey(String.valueOf(a.getCateId()));
                dataCountDic.setTitle(a.getCateName() + "(" + a.getVol() + ")");
            }
        }
        if ((brand = tagType.getBrand()) != null && brand.size() > 0) {
            TopManResultDetailBodySaleGoods.DataCountItemEntity brandItems = new TopManResultDetailBodySaleGoods.DataCountItemEntity("brand", "\u5408\u4f5c\u54c1\u724c");
            list.add(brandItems);
            ArrayList<TopManResultDetailBodySaleGoods.DataCountDic> brandItemDic = new ArrayList<TopManResultDetailBodySaleGoods.DataCountDic>(brand.size());
            brandItems.setChildren(brandItemDic);
            for (TopManSaleGoodsTagEntity.Brand a : brand) {
                TopManResultDetailBodySaleGoods.DataCountDic dataCountDic = new TopManResultDetailBodySaleGoods.DataCountDic();
                brandItemDic.add(dataCountDic);
                dataCountDic.setKey(String.valueOf(a.getBrandId()));
                dataCountDic.setTitle(a.getBrandName() + "(" + a.getVol() + ")");
            }
        }
    }

    private TopManResultDetailBody queryDetailBodyLive(TopManDetailBodyDo param) {
        return new TopManResultDetailBodyLive(){};
    }

    private TopManResultDetailBody queryDetailBodyVideo(TopManDetailBodyDo param) {
        return new TopManResultDetailBodyVideo(){};
    }

    private TopManResultDetailBody queryDetailBodyFans(TopManDetailBodyDo param) {
        return new TopManResultDetailBodyFans(){};
    }

    @PostConstruct
    private void registerMapper() {
        BodyType.base.function = this::queryDetailBodyBaseNew;
        BodyType.saleGoods.function = this::queryDetailBodySaleGoodsNew;
        BodyType.live.function = this::queryDetailBodyLive;
        BodyType.video.function = this::queryDetailBodyVideo;
        BodyType.fans.function = this::queryDetailBodyFans;
    }

    private QueryWrapper<TopManParamEntity> getQueryWrapper(SimplePostRequestParam<TopManInformationVO> topManDto) {
        String[] columns;
        String column;
        TopManInformationVO filterInfo = (TopManInformationVO)topManDto.getFilterInfo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntityClass(TopManParamEntity.class);
        filterInfo.initQueryWrapper((QueryWrapper<TopManParamEntity>)queryWrapper);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            ((QueryWrapper)queryWrapper.like((Object)"aa.topman_name", (Object)keyWord)).or(a -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)a.eq((Object)"aa.topman_id", (Object)keyWord);
            });
        }
        if ((column = topManDto.getColumn()) != null && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)queryWrapper, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("column", columns);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                }
            }, (Object)((Object)new TopManParamEntity()));
        }
        return queryWrapper;
    }

    public static void main(String[] args) {
        LinkedHashMap map = new LinkedHashMap();
        if (map.isEmpty()) {
            System.out.println("aaaa");
        }
    }

    private static enum BodyType {
        base,
        saleGoods,
        live,
        video,
        fans;

        private BodyTypeMethodFunction function;

        public static BodyType getTypeWhitName(String name) {
            for (BodyType value : BodyType.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            throw new TopManException(I18nUtil.translate((String)"", (String)"\u83b7\u53d6\u8fbe\u4eba\u8be6\u60c5\u7684\u4e3b\u4f53\u7c7b\u578b\u9519\u8bef\uff1abase\u3001saleGoods\u3001live\u3001video\u3001fans"));
        }

        @FunctionalInterface
        static interface BodyTypeMethodFunction {
            public TopManResultDetailBody queryDetailBody(TopManDetailBodyDo var1);
        }
    }

    @FunctionalInterface
    private static interface ListMethod {
        public IPage<? extends TopManResultEntity> apply(IPage<TopManResultEntity> var1, Wrapper<TopManParamEntity> var2, LoginUser var3, TopManInformationVO var4, StatisticsDateType var5);
    }
}

