/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.annotation.ApiCallCount;
import com.els.common.api.vo.Result;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.topman.dto.VideoNumTopManDetailDTO;
import com.els.modules.topman.service.VideoNumTopmanService;
import com.els.modules.topman.vo.VideoNumRequestParamVO;
import com.els.modules.topman.vo.VideoNumTopManListVo;
import com.els.modules.topman.vo.VideoNumTopManTopCasesVo;
import com.els.modules.topman.vo.VideoNumTopManTopDetailsVO;
import com.els.modules.topman.vo.VideoNumTopManTopSimilarVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/video/topMan"})
@Api(tags={"\u89c6\u9891\u53f7\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class VideoNumTopmanController {
    @Autowired
    private VideoNumTopmanService videoNumTopManService;

    @ApiOperation(value="\u7b5b\u9009\u9879", notes="\u7b5b\u9009\u9879")
    @GetMapping(value={"/options"})
    public Result<?> getOptions(@RequestParam(name="type", required=false, defaultValue="0") String type, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        List<TopManOptionsEntity> list = this.videoNumTopManService.getOptions(type, clearCache);
        return Result.ok(list);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    @ApiCallCount(apiCode="industry_top_main_list_data")
    public Result<?> listAll(@RequestBody SimplePostRequestParam<VideoNumRequestParamVO> topManDto) throws Exception {
        IPage<VideoNumTopManListVo> pageList = this.videoNumTopManService.queryTopManList(topManDto);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u89c6\u9891\u8fbe\u4eba\u5934\u90e8\u8be6\u60c5", notes="\u89c6\u9891\u8fbe\u4eba\u5934\u90e8\u8be6\u60c5")
    @PostMapping(value={"/top/details"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> bStationTopManDetails(@RequestBody VideoNumTopManDetailDTO dto) {
        VideoNumTopManTopDetailsVO entity = this.videoNumTopManService.bStationTopManDetails(dto.getAppid());
        return Result.ok((Object)entity);
    }

    @ApiOperation(value="\u5408\u4f5c\u6848\u4f8b", notes="\u5408\u4f5c\u6848\u4f8b")
    @PostMapping(value={"/top/details/cases"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> bStationTopManDetailsNew(@RequestBody VideoNumTopManDetailDTO dto) {
        VideoNumTopManTopCasesVo entity = this.videoNumTopManService.topManDetailsCases(dto);
        return Result.ok((Object)entity);
    }

    @ApiOperation(value="\u83b7\u53d6\u535a\u4e3b\u611f\u5174\u8da3\u7684\u521b\u4f5c\u8005", notes="\u83b7\u53d6\u535a\u4e3b\u611f\u5174\u8da3\u7684\u521b\u4f5c\u8005")
    @PostMapping(value={"/top/details/similar"})
    public Result<?> bStationTopManDetailsLiveInfo(@RequestBody VideoNumTopManDetailDTO dto) {
        VideoNumTopManTopSimilarVO entity = this.videoNumTopManService.topManDetailsSimilar(dto);
        return Result.ok((Object)entity);
    }

    @GetMapping(value={"/cache/clear"})
    public Result<?> cleanCache(@RequestParam(name="cacheKey", defaultValue="bs") String cacheKey) {
        this.videoNumTopManService.cleanCache(cacheKey);
        return Result.ok((String)"\u6e05\u9664B\u7ad9\u6570\u636e\u7f13\u5b58\u6210\u529f");
    }
}

