/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.func.VoidFunc1;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.common.spider.dto.GoodsApiDTO;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.HttpClientResult;
import com.els.modules.common.spider.spiderApi.HttpClientUtils;
import com.els.modules.common.spider.spiderApi.JsonUtils;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.spider.vo.GoodsApiPage;
import com.els.modules.common.spider.vo.GoodsApiVO;
import com.els.modules.goods.dto.GoodsDTO;
import com.els.modules.goods.entity.GoodsAnalysisSearch;
import com.els.modules.goods.entity.GoodsAnalysisType;
import com.els.modules.goods.entity.GoodsAnalysisTypes;
import com.els.modules.goods.entity.GoodsAweme;
import com.els.modules.goods.entity.GoodsDetail;
import com.els.modules.goods.entity.GoodsItems;
import com.els.modules.goods.entity.GoodsLive;
import com.els.modules.goods.entity.GoodsOverview;
import com.els.modules.goods.entity.GoodsOverviewTrend;
import com.els.modules.goods.entity.GoodsTopManAnalysis;
import com.els.modules.goods.mapper.GoodsMapper;
import com.els.modules.goods.service.GoodsService;
import com.els.modules.goods.vo.GoodsItemsVO;
import com.els.modules.goods.vo.GoodsResultVO;
import com.els.modules.goods.vo.GoodsVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.topman.utils.spider.entity.GoodsListPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GoodsServiceImpl
implements GoodsService {
    @Autowired
    private GoodsMapper goodsMapper;
    @Value(value="${spider-api.topManUrl}")
    private String url;
    @Value(value="${spider-api.method.goods.productsList}")
    private String promotionMethod;
    @Value(value="${spider-api.method.goods.productsItems}")
    private String itemdsMethod;
    @Value(value="${spider-api.method.goods.getGoodsDetails}")
    private String detailMethod;
    @Value(value="${spider-api.method.goods.getGoodsOverviewTrend}")
    private String goodsOverviewTrendMethod;
    @Value(value="${spider-api.method.goods.getGoodsDataOverview}")
    private String goodsDataOverview;
    @Value(value="${spider-api.method.goods.getGoodsAweme}")
    private String getGoodsAwemeMethod;
    @Value(value="${spider-api.method.goods.getGoodsLive}")
    private String getGoodsLiveMethod;
    @Value(value="${spider-api.method.goods.getGoodsTopManItem}")
    private String getGoodsTopManItemMethod;
    @Value(value="${spider-api.method.goods.getGoodsTopManTypes}")
    private String getGoodsTopManTypesMethod;
    @Value(value="${spider-api.method.goods.getGoodsTopMan}")
    private String getGoodsTopManMethod;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<GoodsResultVO> searchItems() throws Exception {
        String method = this.url + this.itemdsMethod;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        HashMap resutlMap = new HashMap();
        String jsonResult = "";
        String resultString = (String)this.redisUtil.get(this.itemdsMethod);
        if (resultString != null && !"".equals(resultString)) {
            jsonResult = resultString;
        } else {
            HttpClientResult result = HttpClientUtils.doGet(method, headers, new HashMap<String, String>());
            if (result != null && 200 == result.getCode()) {
                jsonResult = result.getContent();
                this.redisUtil.set(this.itemdsMethod, (Object)jsonResult, 36000L);
            }
            if (jsonResult == null || "".equals(jsonResult)) {
                return null;
            }
        }
        JsonObject jsonObject = JsonUtils.parseJson(jsonResult);
        List<GoodsResultVO> list = this.json2GoodsResultVO((JsonObject)jsonObject.get("data"));
        return list;
    }

    private List<GoodsItemsVO> json2goodsItem(JsonArray jsonArray) {
        ArrayList<GoodsItemsVO> goodsItemVOS = new ArrayList<GoodsItemsVO>();
        if (jsonArray == null || jsonArray.isEmpty()) {
            return goodsItemVOS;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject json = (JsonObject)jsonArray.get(i);
            GoodsItemsVO item = new GoodsItemsVO();
            HashMap map = new HashMap();
            Set entrySet = json.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String text = "";
                if (!(value instanceof JsonArray)) {
                    text = (value + "").replace("\"", "");
                }
                switch (key) {
                    case "KeyInt": {
                        item.setKeyInt(text);
                        break;
                    }
                    case "Number": {
                        item.setNumber(text);
                        break;
                    }
                    case "Text": {
                        item.setText(text);
                        break;
                    }
                    case "Value": {
                        item.setValue(text);
                        break;
                    }
                    case "Value2": {
                        item.setValue2(text);
                        break;
                    }
                    case "SearchTwoLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "SearchThreeLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "SearchFourLevelItemList": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                        break;
                    }
                    case "Expand": {
                        item.setChildren(this.json2goodsItem((JsonArray)value));
                    }
                }
            }
            if (item.getChildren() == null || item.getChildren().isEmpty()) {
                item.setComponentType("RSelect");
            } else {
                item.setComponentType("RCascader");
            }
            goodsItemVOS.add(item);
        }
        return goodsItemVOS;
    }

    private List<GoodsResultVO> json2GoodsResultVO(JsonObject jsonObject) {
        ArrayList<GoodsResultVO> resultList = new ArrayList<GoodsResultVO>();
        GoodsResultVO cata = new GoodsResultVO();
        cata.setFieldName("categorys");
        cata.setSort(1);
        cata.setTitle("\u5546\u54c1\u5206\u7c7b");
        GoodsResultVO fiter = new GoodsResultVO();
        fiter.setFieldName("filter");
        fiter.setSort(2);
        fiter.setTitle("\u5546\u54c1\u4fe1\u606f");
        ArrayList<GoodsItemsVO> fiterChren = new ArrayList<GoodsItemsVO>();
        boolean sort = true;
        Set entrySet = jsonObject.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            GoodsItemsVO item = new GoodsItemsVO();
            Map.Entry entry = (Map.Entry)iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            JsonArray ja = new JsonArray();
            if (!(value instanceof JsonArray)) break;
            ja = (JsonArray)value;
            switch (key) {
                case "Ages": {
                    item.setText("\u5e74\u9f84");
                    item.setValue("\u5e74\u9f84");
                    item.setKeyInt("ages");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Categorys": {
                    cata.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Commissions": {
                    item.setText("\u4f63\u91d1\u6bd4\u4f8b");
                    item.setValue("\u4f63\u91d1\u6bd4\u4f8b");
                    item.setKeyInt("Commissions");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Coupons": {
                    item.setText("\u4f18\u60e0\u5238");
                    item.setValue("\u4f18\u60e0\u5238");
                    item.setKeyInt("Coupons");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "FirstTimes": {
                    item.setText("\u4e0a\u67b6\u65f6\u95f4");
                    item.setValue("\u4e0a\u67b6\u65f6\u95f4");
                    item.setKeyInt("FirstTimes");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "Genders": {
                    item.setText("\u6027\u522b");
                    item.setValue("\u6027\u522b");
                    item.setKeyInt("Genders");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "MainSalesModel": {
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "PraiseRates": {
                    item.setText("\u597d\u8bc4\u7387");
                    item.setValue("\u597d\u8bc4\u7387");
                    item.setKeyInt("PraiseRates");
                    item.setComponentType("RSelect");
                    item.setChildren(this.json2goodsItem(ja));
                    break;
                }
                case "ProportionGoods": {
                    break;
                }
                case "RecommendTags": {
                    break;
                }
                case "SendFroms": {
                    break;
                }
                case "ServiceTypes": {
                    break;
                }
                case "ShopScores": {
                    break;
                }
                case "Sorts": {
                    break;
                }
                case "SourceList": {
                    break;
                }
            }
            fiterChren.add(item);
        }
        fiter.setChildren(fiterChren);
        if (cata.getChildren() == null || cata.getChildren().isEmpty()) {
            HashMap<String, String> keys = new HashMap<String, String>();
            keys.put("key", this.itemdsMethod);
            this.clearCache(keys);
        }
        resultList.add(cata);
        resultList.add(fiter);
        return resultList;
    }

    @Override
    public IPage<GoodsItems> searchPromotion(Map query) throws Exception {
        Page page = new Page(Long.parseLong(query.get("pageIndex") + ""), Long.parseLong(query.get("pageSize") + ""));
        String method = this.url + this.promotionMethod;
        String jsonResult = this.getPostResult(method, this.promotionMethod, query, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList goodsList = new ArrayList();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonResult);
        GoodsListPage goods = (GoodsListPage)((Object)mapper.convertValue((Object)jsonNode.get("data"), GoodsListPage.class));
        if (goods == null) {
            return page;
        }
        page.setTotal(goods.getTotal().longValue());
        List<GoodsItems> items = goods.getItems();
        this.checkCollect(items);
        page.setRecords(items);
        return page;
    }

    private void checkCollect(List<GoodsItems> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List<String> goodsIds = list.stream().map(GoodsItems::getGid).distinct().collect(Collectors.toList());
        List<GoodsItems> goodsItems = this.goodsMapper.checkCollect(goodsIds, SysUtil.getLoginUser(), 1);
        if (CollectionUtil.isNotEmpty(goodsItems)) {
            Map<String, Integer> map = goodsItems.stream().collect(Collectors.toMap(GoodsItems::getGid, GoodsItems::getIsCollection));
            list.forEach(h -> h.setIsCollection(map.get(h.getGid()) != null ? (Integer)map.get(h.getGid()) : Integer.valueOf(0)));
        }
    }

    @Override
    public IPage<GoodsVO> searchList(SimplePostRequestParam<GoodsDTO> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        GoodsDTO dto = (GoodsDTO)param.getFilterInfo();
        Map<?, ?> map = this.handleBody(param);
        SpiderMethodType methodType = SpiderMethodType.PRODUCTS_LIST;
        GoodsApiPage data = this.spiderApiUtil.postForEntity(methodType, map, GoodsApiPage.class);
        page.setTotal((long)data.getTotal().intValue());
        page.setRecords(this.handleResult(data, dto.getPlatform()));
        return page;
    }

    private Map<?, ?> handleBody(SimplePostRequestParam<GoodsDTO> param) {
        GoodsDTO.ScreenItem screenItem;
        GoodsApiDTO spiderApiDTO = new GoodsApiDTO(param);
        String keyWord = param.getKeyWord();
        if (StringUtils.isNotBlank((CharSequence)keyWord)) {
            spiderApiDTO.setKeyword(keyWord);
        }
        if ((screenItem = ((GoodsDTO)param.getFilterInfo()).getScreenItem()) == null) {
            return (Map)JSON.parseObject((String)JSON.toJSONString((Object)spiderApiDTO), Map.class);
        }
        List<GoodsDTO.ScreenItemField> category = screenItem.getCategory();
        if (CollectionUtil.isNotEmpty(category)) {
            GoodsDTO.ScreenItemField screenItemField = category.get(0);
            spiderApiDTO.setCate0(screenItemField.getStarTagId());
            Object value = screenItemField.getValue();
            if (value != null) {
                List maps = JSON.parseArray((String)((String)value), String.class);
                for (int size = maps.size(); size > 0; --size) {
                    if (size == 1) {
                        spiderApiDTO.setCate1(maps.get(0) != null ? (String)maps.get(0) : "");
                        continue;
                    }
                    if (size == 2) {
                        spiderApiDTO.setCate2(maps.get(1) != null ? (String)maps.get(1) : "");
                        continue;
                    }
                    if (size != 3) continue;
                    spiderApiDTO.setCate3(maps.get(2) != null ? (String)maps.get(2) : "");
                }
            }
        }
        List<GoodsDTO.ScreenItemField> goodsInfo = screenItem.getGoodsInfo();
        this.initScreenItemField(goodsInfo, spiderApiDTO);
        List<GoodsDTO.ScreenItemField> promotional = screenItem.getPromotional();
        this.initScreenItemField(promotional, spiderApiDTO);
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)spiderApiDTO), Map.class);
    }

    private void initScreenItemField(List<GoodsDTO.ScreenItemField> screenItemFields, GoodsApiDTO spiderApiDTO) {
        if (CollectionUtil.isEmpty(screenItemFields)) {
            return;
        }
        block20: for (GoodsDTO.ScreenItemField screenItemField : screenItemFields) {
            Object value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u5546\u54c1\u4ef7\u683c": {
                    this.handleMinMax((String)value, (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setPriceGt), (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setPriceLt));
                    continue block20;
                }
                case "\u4f63\u91d1\u6bd4\u4f8b": {
                    spiderApiDTO.setYjbl((String)value);
                    continue block20;
                }
                case "\u597d\u8bc4\u7387": {
                    spiderApiDTO.setHpl((String)value);
                    continue block20;
                }
                case "\u4f18\u60e0\u5238": {
                    spiderApiDTO.setHasCoupon((String)value);
                    continue block20;
                }
                case "\u4e0a\u67b6\u65f6\u95f4": {
                    spiderApiDTO.setFirstTime((String)value);
                    continue block20;
                }
                case "\u5546\u54c1\u9500\u91cf": {
                    this.handleMinMax((String)value, (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setDySalesCount_30day_gt), (VoidFunc1<Integer>)((VoidFunc1 & Serializable)spiderApiDTO::setDySalesCount_30day_lt));
                    continue block20;
                }
                case "\u6709\u76f4\u64ad\u5e26\u8d27": {
                    spiderApiDTO.setMainSalesModel(2);
                    spiderApiDTO.setMainSalesRatio(0.5);
                    continue block20;
                }
                case "\u6709\u89c6\u9891\u5e26\u8d27": {
                    spiderApiDTO.setMainSalesModel(1);
                    spiderApiDTO.setMainSalesRatio(0.5);
                    continue block20;
                }
            }
            throw new ELSBootException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b");
        }
    }

    private void handleMinMax(String value, VoidFunc1<Integer> minField, VoidFunc1<Integer> maxField) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    minField.call((Object)Integer.valueOf(split[0]));
                }
                if ((max = split[1]) != null && !"".equals(max)) {
                    maxField.call((Object)Integer.valueOf(split[1]));
                }
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)Integer.valueOf(split[0]));
                    break;
                }
                minField.call((Object)Integer.valueOf(split[0]));
                break;
            }
            default: {
                throw new ELSBootException("\u6570\u636e\u914d\u7f6e\u6709\u8bef");
            }
        }
    }

    private List<GoodsVO> handleResult(GoodsApiPage data, Integer platform) {
        List<GoodsApiVO> shopDatas = data.getItems();
        if (CollectionUtil.isEmpty(shopDatas)) {
            return new ArrayList<GoodsVO>(0);
        }
        List<String> goodsIds = shopDatas.stream().map(GoodsApiVO::getGid).distinct().collect(Collectors.toList());
        List<GoodsVO> collects = this.goodsMapper.checkCollectNew(goodsIds, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap(collects.size());
        if (CollectionUtil.isNotEmpty(collects)) {
            map = collects.stream().collect(Collectors.toMap(GoodsVO::getGoodsId, h -> h, (k1, k2) -> k1));
        }
        ArrayList<GoodsVO> list = new ArrayList<GoodsVO>(shopDatas.size());
        for (GoodsApiVO vo : shopDatas) {
            GoodsVO goods = new GoodsVO();
            BeanUtils.copyProperties((Object)vo, (Object)goods);
            goods.setPlatform(1);
            goods.setGoodsId(vo.getGid());
            goods.setTotalSales(vo.getTotalSales30Day());
            goods.setLivesSales(vo.getLiveSales30Day());
            goods.setVideosSales(vo.getAwemeSales30Day());
            goods.setLivesNum(vo.getLive30Day());
            goods.setVideosNum(vo.getAweme30Day());
            goods.setIsCollection(map.get(vo.getGid()) != null ? ((GoodsVO)map.get(vo.getGid())).getIsCollection() : 0);
            list.add(goods);
        }
        return list;
    }

    @Override
    public GoodsDetail searchGoodsDetails(Map goods) throws Exception {
        GoodsDetail detail = new GoodsDetail();
        String method = this.url + this.detailMethod;
        String jsonResult = this.getPostResult(method, this.detailMethod, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return detail;
        }
        detail = this.buildDetail(jsonResult, (String)goods.get("gid"));
        this.checkDetailCollect(detail);
        return detail;
    }

    private void checkDetailCollect(GoodsDetail detail) {
        List<String> ids = Collections.singletonList(detail.getGid());
        List<GoodsItems> checkCollects = this.goodsMapper.checkCollect(ids, SysUtil.getLoginUser(), 1);
        if (CollectionUtil.isNotEmpty(checkCollects)) {
            detail.setIsCollection(checkCollects.get(0).getIsCollection());
        }
    }

    private GoodsDetail buildDetail(String jsonResult, String gid) throws Exception {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        GoodsDetail result = new GoodsDetail();
        if (CollectionUtil.isEmpty((Map)data)) {
            return result;
        }
        result.setGid(data.get("Gid") + "");
        result.setTitle(data.get("Title") + "");
        result.setCateStr(data.get("CateStr") + "");
        result.setCosRatio(data.get("CosRatio") + "");
        result.setShopName(data.get("ShopName") + "");
        result.setShopId(data.get("ShopId") + "");
        result.setPrice(data.get("PriceRange") + "");
        result.setLiveCountDay(data.get("LiveCount_30Day") + "");
        result.setImageUrl(data.get("ImageUrl") + "");
        result.setVisitorCount(data.get("VisitorCount") + "");
        result.setInversionRate(this.getInversionRate(gid) + "%");
        result.setTotalPV(data.get("TotalPV_30Day") + "");
        result.setPromUserAccount30Day(data.get("PromUserAccount_30Day") + "");
        result.setSalesCount30Day(data.get("SalesCount_30Day") + "");
        result.setAwemesDay(data.get("Awemes_30Day") + "");
        return result;
    }

    @Override
    public GoodsOverview getGoodsOverviewTrend(Map goods) throws Exception {
        GoodsOverview overiew = new GoodsOverview();
        String method = this.url + this.goodsOverviewTrendMethod;
        String jsonResult = this.getPostResult(method, this.goodsOverviewTrendMethod, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return overiew;
        }
        overiew = this.buildTrend(jsonResult);
        return overiew;
    }

    private GoodsOverview buildTrend(String jsonResult) {
        GoodsOverview overiew = new GoodsOverview();
        ArrayList<GoodsOverviewTrend> trends = new ArrayList<GoodsOverviewTrend>();
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        if (CollectionUtil.isEmpty((Map)data)) {
            return overiew;
        }
        List list = (List)data.get("List");
        if (list != null && !list.isEmpty()) {
            for (Map obj : list) {
                GoodsOverviewTrend trend = new GoodsOverviewTrend();
                trend.setDateyyyyMMdd(obj.get("DateyyyyMMdd") + "");
                trend.setPvStr(obj.get("PvStr") + "");
                trend.setAwemeCount(obj.get("AwemeCount") + "");
                trend.setBloggerCount(obj.get("BloggerCount") + "");
                trend.setLiveCount(obj.get("LiveCount") + "");
                trend.setTotalSaleCountStr(obj.get("TotalSaleCountStr") + "");
                trend.setTotalSalesStr(obj.get("TotalSalesStr") + "");
                trends.add(trend);
            }
        }
        overiew.setTrends(trends);
        Map totalData = (Map)data.get("TotalData");
        if (CollectionUtil.isEmpty((Map)totalData)) {
            return overiew;
        }
        overiew.setBloggerCount(totalData.get("BloggerCountStr") + "");
        overiew.setPvStr(totalData.get("PvStr") + "");
        overiew.setSalesCountStr(totalData.get("SalesCountStr") + "");
        overiew.setTotalSalesStr(totalData.get("TotalSalesStr") + "");
        overiew.setAwemeCount(totalData.get("AwemeCountStr") + "");
        overiew.setLiveCount(totalData.get("LiveCountStr") + "");
        return overiew;
    }

    private String getPostResult(String url, String method, Map query, Boolean isJson) throws Exception {
        String redisKey = method + JsonUtils.getRedisKey(query);
        String resultString = (String)this.redisUtil.get(redisKey);
        if (resultString != null && !"".equals(resultString)) {
            return resultString;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String jsonResult = "";
        HttpClientResult result = HttpClientUtils.doPost(url, headers, query, true);
        if (result != null && 200 == result.getCode()) {
            jsonResult = result.getContent();
            this.redisUtil.set(redisKey, (Object)jsonResult, 7200L);
        }
        return jsonResult;
    }

    @Override
    public IPage<GoodsAweme> getGoodsAweme(Map goods) throws Exception {
        Page page = new Page(Long.parseLong(goods.get("page") + ""), Long.parseLong(goods.get("pageSize") + ""));
        String method = this.url + this.getGoodsAwemeMethod;
        String jsonResult = this.getPostResult(method, this.getGoodsAwemeMethod, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList<GoodsAweme> awemes = new ArrayList<GoodsAweme>();
        long total = this.buildAweme(jsonResult, awemes);
        page.setTotal(total);
        page.setRecords(awemes);
        return page;
    }

    @Override
    public IPage<GoodsLive> getGoodsLive(Map goods) throws Exception {
        Page page = new Page(Long.parseLong(goods.get("page") + ""), Long.parseLong(goods.get("pageSize") + ""));
        String method = this.url + this.getGoodsLiveMethod;
        String jsonResult = this.getPostResult(method, this.getGoodsTopManTypesMethod, goods, true);
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList<GoodsLive> lives = new ArrayList<GoodsLive>();
        long total = this.buildLives(jsonResult, lives);
        page.setTotal(total);
        page.setRecords(lives);
        return page;
    }

    private long buildLives(String jsonResult, List<GoodsLive> lives) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        long total = 0L;
        if (CollectionUtil.isEmpty((Map)data)) {
            return total;
        }
        total = Long.parseLong(data.get("Total") + "");
        List list = (List)data.get("Items");
        if (list != null && !list.isEmpty()) {
            for (Map obj : list) {
                GoodsLive live = new GoodsLive();
                live.setRoomId(obj.get("AwemeDesc") + "");
                live.setRoomName(obj.get("RoomName") + "");
                live.setDateCode(obj.get("DateCode") + "");
                live.setLiveBeginTime(obj.get("LiveBeginTime") + "");
                live.setLiveEndTime(obj.get("LiveEndTime") + "");
                live.setPrice(obj.get("Price") + "");
                live.setMPlatformFans(obj.get("UserCount") + "");
                live.setSaleCount(obj.get("SaleCount") + "");
                live.setTotalSales(obj.get("TotalSales") + "");
                live.setNickName(obj.get("NickName") + "");
                lives.add(live);
            }
        }
        return total;
    }

    private long buildAweme(String jsonResult, List<GoodsAweme> awemes) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        long total = 0L;
        if (CollectionUtil.isEmpty((Map)data)) {
            return total;
        }
        total = Long.parseLong(data.get("Total") + "");
        List list = (List)data.get("Items");
        if (list != null && !list.isEmpty()) {
            for (Map obj : list) {
                GoodsAweme aweme = new GoodsAweme();
                aweme.setAwemeDesc(obj.get("AwemeDesc") + "");
                aweme.setAwemePubTime(obj.get("AwemePubTime") + "");
                aweme.setAwemeId(obj.get("AwemeId") + "");
                aweme.setAwemeOrderAccount(obj.get("AwemeOrderAccount") + "");
                aweme.setAwemeTotalSales(obj.get("AwemeTotalSales") + "");
                aweme.setBloggerName(obj.get("BloggerName") + "");
                aweme.setBloggerPlatform_Fans(obj.get("BloggerPlatform_Fans") + "");
                aweme.setLikeCount(obj.get("LikeCount") + "");
                aweme.setShareCount(obj.get("ShareCount") + "");
                aweme.setCommentCount(obj.get("CommentCount") + "");
                awemes.add(aweme);
            }
        }
        return total;
    }

    @Override
    public GoodsAnalysisSearch getGoodsTopManItem(Map goods) throws Exception {
        String method = this.url + this.getGoodsTopManItemMethod;
        String jsonResult = this.getPostResult(method, this.getGoodsTopManItemMethod, goods, true);
        JsonObject jsonObject = JsonUtils.parseJson(jsonResult);
        JsonObject data = (JsonObject)jsonObject.get("data");
        GoodsAnalysisSearch search = new GoodsAnalysisSearch();
        if (data == null) {
            return search;
        }
        return this.json2GoodsAnalysisSearchVO(data);
    }

    private GoodsAnalysisSearch json2GoodsAnalysisSearchVO(JsonObject jsonObject) {
        GoodsAnalysisSearch result = new GoodsAnalysisSearch();
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            JsonArray ja = new JsonArray();
            if (!(value instanceof JsonArray)) break;
            ja = (JsonArray)value;
            switch (key) {
                case "Dates": {
                    result.setDates(this.json2goodsItem(ja));
                    break;
                }
                case "FansCounts": {
                    result.setFansCounts(this.json2goodsItem(ja));
                    break;
                }
                case "Tags": {
                    result.setTags(this.json2goodsItem(ja));
                    break;
                }
                case "Sorts": {
                    result.setSorts(this.json2goodsItem(ja));
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public GoodsAnalysisTypes getAnalysisTypes(Map goods) throws Exception {
        String method = this.url + this.getGoodsTopManTypesMethod;
        String jsonResult = this.getPostResult(method, this.getGoodsTopManTypesMethod, goods, true);
        GoodsAnalysisTypes types = new GoodsAnalysisTypes();
        JsonObject jsonObject = JsonUtils.parseJson(jsonResult);
        JsonObject data = (JsonObject)jsonObject.get("data");
        if (data == null) {
            return types;
        }
        types.setBrandDistributes(this.getGoodsAnalysisType((JsonArray)data.get("BrandDistributes")));
        types.setTypeDistributes(this.getGoodsAnalysisType((JsonArray)data.get("TypeDistributes")));
        return types;
    }

    private List<GoodsAnalysisType> getGoodsAnalysisType(JsonArray jsonArray) {
        ArrayList<GoodsAnalysisType> types = new ArrayList<GoodsAnalysisType>();
        if (jsonArray == null || jsonArray.isEmpty()) {
            return types;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject json = (JsonObject)jsonArray.get(i);
            GoodsAnalysisType item = new GoodsAnalysisType();
            HashMap map = new HashMap();
            Set entrySet = json.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String text = "";
                if (!(value instanceof JsonArray)) {
                    text = (value + "").replace("\"", "");
                }
                switch (key) {
                    case "BloggerCount": {
                        item.setBloggerCount(text);
                        break;
                    }
                    case "BrandName": {
                        item.setBrandName(text);
                        break;
                    }
                    case "DouyinBrandId": {
                        item.setDouyinBrandId(text);
                        break;
                    }
                    case "TypeId": {
                        item.setTypeId(text);
                        break;
                    }
                    case "TypeName": {
                        item.setTypeName(text);
                        break;
                    }
                }
            }
            types.add(item);
        }
        return types;
    }

    @Override
    public IPage<GoodsTopManAnalysis> getGoodsTopManAnalysis(Map goods) throws Exception {
        String method = this.url + this.getGoodsTopManMethod;
        String jsonResult = this.getPostResult(method, this.getGoodsTopManMethod, goods, true);
        Page page = new Page(Long.parseLong(goods.get("page") + ""), Long.parseLong(goods.get("pageSize") + ""));
        if (jsonResult == null || "".equals(jsonResult)) {
            return page;
        }
        ArrayList<GoodsTopManAnalysis> goodsTopMans = new ArrayList<GoodsTopManAnalysis>();
        long total = this.buildGoodsTopManAnalysis(jsonResult, goodsTopMans);
        page.setTotal(total);
        page.setRecords(goodsTopMans);
        return page;
    }

    private long buildGoodsTopManAnalysis(String jsonResult, List<GoodsTopManAnalysis> goodsTopMans) {
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        long total = 0L;
        if (CollectionUtil.isEmpty((Map)data)) {
            return total;
        }
        total = Long.parseLong(data.get("Total") + "");
        List list = (List)data.get("Items");
        if (list != null && !list.isEmpty()) {
            for (Map obj : list) {
                GoodsTopManAnalysis topMan = new GoodsTopManAnalysis();
                topMan.setTags(obj.get("Tags") + "");
                topMan.setMPlatform_Fans(obj.get("MPlatform_Fans") + "");
                topMan.setLiveCount(obj.get("LiveCount") + "");
                topMan.setLiveSalesCount(obj.get("LiveSalesCount") + "");
                topMan.setAvatar(obj.get("Avatar") + "");
                topMan.setAvatar(this.shopLogoConverter(topMan.getAvatar()));
                topMan.setAwemeCount(obj.get("AwemeCount") + "");
                topMan.setNickName(obj.get("NickName") + "");
                topMan.setTotalSalesCount(obj.get("TotalSalesCount") + "");
                topMan.setAwemeSalesCount(obj.get("AwemeSalesCount") + "");
                goodsTopMans.add(topMan);
            }
        }
        return total;
    }

    private String shopLogoConverter(String shopLogo) {
        if (shopLogo.contains("dyurl=")) {
            return shopLogo.substring(shopLogo.indexOf("dyurl=") + 6);
        }
        return shopLogo;
    }

    private String getInversionRate(String gid) throws Exception {
        String method = this.url + this.goodsDataOverview;
        HashMap<String, String> goods = new HashMap<String, String>();
        goods.put("gid", gid);
        String jsonResult = this.getPostResult(method, this.goodsDataOverview, goods, true);
        Map<String, Object> detailObject = JsonUtils.jsontoMap(jsonResult);
        Map data = (Map)detailObject.get("data");
        List radars = (List)data.get("PromotionTrendRadars");
        if (radars != null) {
            for (Map radar : radars) {
                String name = (String)radar.get("Name");
                if (!"\u5546\u54c1\u8f6c\u5316\u7387".equals(name)) continue;
                return (String)radar.get("ValueStr");
            }
        }
        return "";
    }

    @Override
    public String clearCache(Map query) {
        String key = (String)query.get("key");
        if (key != null) {
            this.redisUtil.del(new String[]{key});
        }
        return "success";
    }
}

