/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.common.spider.entity.BiliBiliTopManDetailsFanTrendEntity;
import com.els.modules.common.spider.entity.BiliBiliTopManDetailsHeadLiveEntity;
import com.els.modules.common.spider.entity.BiliBiliTopManDetailsHeadVidioEntity;
import com.els.modules.common.spider.entity.VideoNumTopManBasicAnalysisEntity;
import com.els.modules.common.spider.entity.VideoNumTopManDetailsBasicDataEntity;
import com.els.modules.common.spider.properties.SpiderBaseProperties;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.utils.HttpRequestUtils;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.OptionComponentType;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.topman.dto.VideoNumTopManCollectDTO;
import com.els.modules.topman.dto.VideoNumTopManDetailDTO;
import com.els.modules.topman.entity.TopManCollectEntity;
import com.els.modules.topman.entity.TopManSpiderMark;
import com.els.modules.topman.entity.VideoNumTopManEntity;
import com.els.modules.topman.enumerate.MarkYn;
import com.els.modules.topman.enumerate.MongoCollectionType;
import com.els.modules.topman.mapper.VideoNumTopManMapper;
import com.els.modules.topman.service.MongoEntityService;
import com.els.modules.topman.service.TopManCollectService;
import com.els.modules.topman.service.VideoNumTopmanService;
import com.els.modules.topman.vo.BilibiliRequestParamVO;
import com.els.modules.topman.vo.VideoNumRequestParamVO;
import com.els.modules.topman.vo.VideoNumTopManChannelsVO;
import com.els.modules.topman.vo.VideoNumTopManFanAnalysisVO;
import com.els.modules.topman.vo.VideoNumTopManListVo;
import com.els.modules.topman.vo.VideoNumTopManTopCasesVo;
import com.els.modules.topman.vo.VideoNumTopManTopDetailsVO;
import com.els.modules.topman.vo.VideoNumTopManTopSimilarVO;
import com.els.modules.topman.vo.VideoNumTopManVO;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class VideoNumTopmanServiceImpl
extends BaseServiceImpl<VideoNumTopManMapper, VideoNumTopManEntity>
implements VideoNumTopmanService {
    private static final Logger log = LoggerFactory.getLogger(VideoNumTopmanServiceImpl.class);
    private static final String TALENT_DETAILS = "bstation:talent:details:cache";
    private static final String COLON = ":";
    private static final String VIDEONUM = "video";
    @Autowired
    private TopManCollectService topManCollectService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;

    public static void sort(SimplePostRequestParam<VideoNumTopManVO> topManDto, BilibiliRequestParamVO.Content ksSpiderApiIndexListVo, QueryWrapper<VideoNumTopManEntity> queryWrapper) {
        boolean order = false;
        if (StringUtils.isNotEmpty((CharSequence)topManDto.getColumn())) {
            String column = topManDto.getColumn();
            if (StringUtils.isNotEmpty((CharSequence)topManDto.getOrder()) && "asc".equals(topManDto.getOrder())) {
                order = true;
            }
            switch (column) {
                case "fanTotal": {
                    ksSpiderApiIndexListVo.setOrder_by("fans_num");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"fan_total"});
                    break;
                }
                case "avgPlay": {
                    ksSpiderApiIndexListVo.setOrder_by("last5_avg_play");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"avg_play"});
                    break;
                }
                case "interactionRate": {
                    ksSpiderApiIndexListVo.setOrder_by("last5_interaction_rate");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"interaction_rate"});
                    break;
                }
                case "topmanName": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_name"});
                    break;
                }
                case "topmanRegion": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_region"});
                    break;
                }
                case "topmanLevel": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_level"});
                    break;
                }
                case "commercialOrderType": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"commercial_drder_type"});
                    break;
                }
                case "liveLabel": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"livelabel"});
                    break;
                }
                case "liveCategory": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"live_category"});
                    break;
                }
                default: {
                    VideoNumTopManVO filterInfo = (VideoNumTopManVO)topManDto.getFilterInfo();
                    if (!filterInfo.getTaskType().equals("liveTopMan")) break;
                    ksSpiderApiIndexListVo.setOrder_by("fans_num");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                }
            }
            if (column.equals("customVideoPrice") || column.equals("implantVideoPrice") || column.equals("directDynamicPrice") || column.equals("forwardDynamicPrice")) {
                ksSpiderApiIndexListVo.setOrder_by("price");
                ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                switch (column) {
                    case "customVideoPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"interaction_rate"});
                        break;
                    }
                    case "implantVideoPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"implant_video_price"});
                        break;
                    }
                    case "directDynamicPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"direct_dynamic_price"});
                        break;
                    }
                    case "forwardDynamicPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"forwarddynamic_price"});
                    }
                }
            }
        } else {
            queryWrapper.orderBy(true, order, (Object[])new String[]{"collect_update_time"});
        }
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    private static String apiGetList(String taskType, SimplePostRequestParam<VideoNumRequestParamVO> topManDto, QueryWrapper<VideoNumTopManEntity> queryWrapper, StringBuilder cacheKey) throws Exception {
        VideoNumRequestParamVO filterInfoVideoNumTopManVO = (VideoNumRequestParamVO)topManDto.getFilterInfo();
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            filterInfoVideoNumTopManVO.setKeyword(keyWord.trim());
            queryWrapper.lambda().eq(VideoNumTopManEntity::getNickname, (Object)keyWord.trim());
            cacheKey.append(keyWord.trim()).append(COLON);
        }
        filterInfoVideoNumTopManVO.setNo(topManDto.getPageNo());
        filterInfoVideoNumTopManVO.setSize(topManDto.getPageSize());
        String json = JSON.toJSONString((Object)filterInfoVideoNumTopManVO);
        System.out.println("bbbbbbbbbbbbbbb=" + json);
        return json;
    }

    public static Map<String, String> getQueryParam(List<VideoNumTopManVO.ScreenItemField> liveType, StringBuilder cacheKey) {
        StringBuilder sbValue = new StringBuilder();
        StringBuilder sbLabel = new StringBuilder();
        liveType.forEach(a -> {
            Object value = a.getValue();
            String string = JSON.toJSONString((Object)value);
            List maps = JSON.parseArray((String)string, Map.class);
            maps.forEach(b -> {
                sbValue.append(b.get("value")).append(",");
                sbLabel.append(b.get("label")).append("|");
            });
        });
        String strCount = sbValue.delete(sbValue.length() - 1, sbValue.length()).toString();
        String strName = sbLabel.delete(sbLabel.length() - 1, sbLabel.length()).toString();
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("value", strCount);
        param.put("label", strName);
        cacheKey.append(strCount).append(COLON);
        return param;
    }

    public static String getCooperationType(String value) {
        String str = "";
        switch (value) {
            case "1": {
                str = "\u690d\u5165\u89c6\u9891";
                break;
            }
            case "2": {
                str = "\u5b9a\u5236\u89c6\u9891";
                break;
            }
            case "3": {
                str = "\u76f4\u53d1\u52a8\u6001";
                break;
            }
            case "4": {
                str = "\u8f6c\u53d1\u52a8\u6001";
                break;
            }
            default: {
                throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
            }
        }
        return null;
    }

    public static Map<String, String> getTelentInfoParam(Object value, StringBuilder cacheKey) {
        StringBuilder sbValue = new StringBuilder();
        StringBuilder sbLabel = new StringBuilder();
        String string = JSON.toJSONString((Object)value);
        List maps = JSON.parseArray((String)string, Map.class);
        maps.forEach(b -> {
            sbValue.append(b.get("value")).append(",");
            sbLabel.append(b.get("label")).append("|");
        });
        String strCount = sbValue.delete(sbValue.length() - 1, sbValue.length()).toString();
        String strName = sbLabel.delete(sbLabel.length() - 1, sbLabel.length()).toString();
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("value", strCount);
        param.put("label", strName);
        cacheKey.append(strCount).append(COLON);
        return param;
    }

    public static void getRegion(Object str, BilibiliRequestParamVO.Content ksSpiderApiIndexListVo, VideoNumTopManEntity bStationTopManInformation, StringBuilder cacheKey) {
        String string = JSON.toJSONString((Object)str);
        List maps = JSON.parseArray((String)string, Map.class);
        ksSpiderApiIndexListVo.setRegion_id(((Map)maps.get(0)).get("value").toString());
        cacheKey.append(((Map)maps.get(0)).get("value").toString()).append(COLON);
        if (((Map)maps.get(1)).size() > 0) {
            ksSpiderApiIndexListVo.setSecond_region_id(((Map)maps.get(1)).get("value").toString());
            cacheKey.append(((Map)maps.get(0)).get("label").toString() + "|" + ((Map)maps.get(1)).get("value").toString()).append(COLON);
        }
    }

    @Override
    public void collect(VideoNumTopManCollectDTO dto) {
        if (MarkYn.check(dto.getCollect())) {
            this.addMarkToSpider(dto);
        }
        this.collectHandle(dto);
        this.redisUtil.dels("bs:" + TenantContext.getTenant() + COLON + "list");
    }

    private void collectHandle(VideoNumTopManCollectDTO dto) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        VideoNumTopManEntity entity = dto.getEntity();
        if (MarkYn.check(dto.getCollect())) {
            TopManCollectEntity topManCollectEntity = new TopManCollectEntity();
            topManCollectEntity.setTopmanId(entity.getAppid());
            topManCollectEntity.setPlatform("7");
            topManCollectEntity.setElsAccount(elsAccount);
            topManCollectEntity.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectEntity);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectEntity::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectEntity::getPlatform, (Object)"7");
            queryWrapper.lambda().eq(TopManCollectEntity::getTopmanId, (Object)entity.getAppid());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(VideoNumTopManCollectDTO dto) {
        this.saveRedBookSpiderTopMan(dto.getEntity());
        this.redisUtil.dels("bs:" + TenantContext.getTenant() + COLON + "list");
    }

    private void addMarkToMongo(VideoNumTopManCollectDTO dto) {
        VideoNumTopManEntity entity = dto.getEntity();
        String topManId = String.valueOf(entity.getTopmanId());
        MongoCollectionType collectMark = MongoCollectionType.TB_REDBOOK_ELS_TOPMAN;
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("topManId", topManId);
        Map<String, TopManSpiderMark> data = this.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(topManId);
        if (topManSpiderMark == null) {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTopManId(topManId);
            topManSpiderMark.setTaskType(dto.getTaskType());
            topManSpiderMark.setCount(1);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)topManId));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        }
    }

    private <T extends MongoEntityService> Map<String, T> handleMongo(MongoCollectionType collectionType, HashMap<String, String> param, Class<T> beanClass) {
        Document inquireDoc = new Document();
        for (Map.Entry<String, String> p : param.entrySet()) {
            inquireDoc.append(p.getKey(), (Object)p.getValue());
        }
        try (MongoCursor cursor = this.mongoTemplate.getCollection(collectionType.getCollectName()).find((Bson)inquireDoc).noCursorTimeout(true).cursor();){
            HashMap<String, MongoEntityService> map = new HashMap<String, MongoEntityService>(20);
            while (cursor.hasNext()) {
                Document coreData = (Document)cursor.next();
                String subKey = collectionType.getSubKey();
                if (subKey != null) {
                    List keyData = coreData.getList((Object)subKey, Document.class);
                    for (Document keyDatum : keyData) {
                        String s = keyDatum.toJson();
                        MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                        map.put(t.getKeyId(), t);
                    }
                    continue;
                }
                String s = coreData.toJson();
                MongoEntityService t = (MongoEntityService)JSON.parseObject((String)s, beanClass);
                map.put(t.getKeyId(), t);
            }
            HashMap<String, MongoEntityService> hashMap = map;
            return hashMap;
        }
    }

    private void saveRedBookSpiderTopMan(VideoNumTopManEntity information) {
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(VideoNumTopManEntity::getAppid, (Object)information.getAppid());
        VideoNumTopManEntity VideoNumTopManEntity2 = (VideoNumTopManEntity)((Object)((VideoNumTopManMapper)this.baseMapper).selectOne((Wrapper)query));
        if (VideoNumTopManEntity2 == null) {
            information.setPlatform("7");
            information.setDeleted(0);
            information.setId("");
            ((VideoNumTopManMapper)this.baseMapper).insert((Object)information);
        } else {
            information.setPlatform("7");
            information.setId(VideoNumTopManEntity2.getId());
            information.setUpdateBy(TenantContext.getTenant());
            information.setUpdateTime(new Date());
            ((VideoNumTopManMapper)this.baseMapper).updateById((Object)information);
        }
    }

    private void getAge(Document ages) {
    }

    private void setTag(List<Map<String, Object>> directoryJson, List<TopManOptionsEntity> options) {
        TopManOptionsEntity result = new TopManOptionsEntity();
        result.setSort(2);
        result.setTitle("\u884c\u4e1a\u5206\u7c7b");
        result.setFieldName("tags");
        ArrayList<TopManOptionsEntity.Tag> children = new ArrayList<TopManOptionsEntity.Tag>();
        TopManOptionsEntity result1 = new TopManOptionsEntity();
        result1.setSort(3);
        result1.setTitle("\u5185\u5bb9\u7c7b\u578b");
        result1.setFieldName("cons");
        ArrayList<TopManOptionsEntity.Tag> children1 = new ArrayList<TopManOptionsEntity.Tag>();
        for (Map<String, Object> tag : directoryJson) {
            TopManOptionsEntity.Tag childrenTag = new TopManOptionsEntity.Tag();
            childrenTag.setComponentType(OptionComponentType.RButton);
            childrenTag.setStarTagId(tag.get("id") + "");
            childrenTag.setStarTagName(tag.get("name") + "");
            childrenTag.setStarTagValue(tag.get("id") + "");
            String type = tag.get("type") + "";
            if ("3".equals(type)) {
                children.add(childrenTag);
                continue;
            }
            if (!"5".equals(type)) continue;
            children1.add(childrenTag);
        }
        result.setChildren(children);
        result1.setChildren(children1);
        options.add(result);
        options.add(result1);
    }

    private void setLabels(List<Map<String, Object>> directoryJson, List<TopManOptionsEntity> options) {
        TopManOptionsEntity option = new TopManOptionsEntity();
        option.setSort(1);
        option.setFieldName("labels");
        option.setTitle("\u8fbe\u4eba\u5206\u7c7b");
        List parentLab = directoryJson.stream().filter(v -> "0".equals(v.get("parent_lableid") + "")).collect(Collectors.toList());
        ArrayList<TopManOptionsEntity.Tag> children = new ArrayList<TopManOptionsEntity.Tag>();
        for (Map label : parentLab) {
            TopManOptionsEntity.Tag childrenTag = new TopManOptionsEntity.Tag();
            childrenTag.setComponentType(OptionComponentType.RMultipleChoice);
            childrenTag.setStarTagId(label.get("lable_id") + "");
            childrenTag.setStarTagName(label.get("lable_text") + "");
            childrenTag.setStarTagValue(label.get("lable_id") + "");
            List<Object> subLabel = this.labelSub(directoryJson, label.get("lable_id") + "");
            if (subLabel == null || subLabel.size() <= 0) {
                childrenTag.setComponentType(OptionComponentType.RButton);
            }
            childrenTag.setSubTags(subLabel);
            children.add(childrenTag);
        }
        option.setChildren(children);
        options.add(option);
    }

    private List<Object> labelSub(List<Map<String, Object>> directoryJson, String parent) {
        ArrayList<Object> children = new ArrayList<Object>();
        List sort = directoryJson.stream().filter(v -> (v.get("parent_lableid") + "").equals(parent)).collect(Collectors.toList());
        for (Map label : sort) {
            TopManOptionsEntity.Tag childrenTag = new TopManOptionsEntity.Tag();
            childrenTag.setComponentType(OptionComponentType.RButton);
            childrenTag.setStarTagId(label.get("lable_id") + "");
            childrenTag.setStarTagName(label.get("lable_text") + "");
            childrenTag.setStarTagValue(label.get("lable_id") + "");
            children.add(childrenTag);
        }
        return children;
    }

    private List<Object> getCommonLab(List<Map<String, Object>> directoryJson) {
        ArrayList<Object> commSelectLab = new ArrayList<Object>();
        for (Map<String, Object> json : directoryJson) {
            TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
            tag.setStarTagId(json.get("label") + "");
            tag.setStarTagName(json.get("label") + "");
            tag.setStarTagValue(json.get("value") + "");
            commSelectLab.add(tag);
        }
        return commSelectLab;
    }

    private List<Object> getCommonArea(List<Map<String, Object>> directoryJson) {
        ArrayList<Object> commSelectArea = new ArrayList<Object>();
        for (Map<String, Object> json : directoryJson) {
            TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
            tag.setStarTagId(json.get("key") + "");
            tag.setStarTagName(json.get("key") + "");
            tag.setStarTagValue(json.get("title") + "");
            List children = (List)json.get("children");
            if (children != null && children.size() > 0) {
                tag.setSubTags(this.getCommonArea(children));
            }
            commSelectArea.add(tag);
        }
        return commSelectArea;
    }

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        ArrayList<TopManOptionsEntity> result = new ArrayList<TopManOptionsEntity>();
        Document document = new Document();
        String collection = "tb_videonum_category";
        MongoCursor attractCursor = this.mongoTemplate.getCollection(collection).find((Bson)document).noCursorTimeout(true).cursor();
        TopManOptionsEntity topman = new TopManOptionsEntity();
        topman.setChildren(new ArrayList());
        topman.setSort(4);
        topman.setFieldName("topman");
        topman.setTitle("\u8fbe\u4eba\u4fe1\u606f");
        TopManOptionsEntity fnas = new TopManOptionsEntity();
        fnas.setChildren(new ArrayList());
        fnas.setSort(5);
        fnas.setFieldName("fnas");
        fnas.setTitle("\u7c89\u4e1d\u753b\u50cf");
        TopManOptionsEntity play = new TopManOptionsEntity();
        play.setChildren(new ArrayList());
        play.setSort(65);
        play.setFieldName("play");
        play.setTitle("\u4f20\u64ad\u8868\u73b0");
        while (attractCursor.hasNext()) {
            String name;
            Document attract = (Document)attractCursor.next();
            switch (name = attract.getString((Object)"name")) {
                case "tags": {
                    this.setTag((List)attract.get((Object)"directory_json"), result);
                    break;
                }
                case "labels": {
                    this.setLabels((List)attract.get((Object)"directory_json"), result);
                    break;
                }
                case "area_list": {
                    TopManOptionsEntity.Tag fansArea = new TopManOptionsEntity.Tag();
                    fansArea.setStarTagId("3");
                    fansArea.setStarTagValue("fans_area");
                    fansArea.setLevel(Integer.valueOf(1));
                    fansArea.setStarTagName("\u7c89\u4e1d\u5730\u57df");
                    List<Object> areaComlab = this.getCommonArea((List)attract.get((Object)"directory_json"));
                    fansArea.setComponentType(OptionComponentType.RCascader);
                    fansArea.setSubTags(areaComlab);
                    fnas.getChildren().add(fansArea);
                    TopManOptionsEntity.Tag cityArea = new TopManOptionsEntity.Tag();
                    cityArea.setComponentType(OptionComponentType.RCascader);
                    cityArea.setStarTagValue("city_label");
                    cityArea.setLevel(Integer.valueOf(2));
                    cityArea.setStarTagName("\u8fbe\u4eba\u5730\u57df");
                    cityArea.setSubTags(areaComlab);
                    topman.getChildren().add(cityArea);
                    break;
                }
                case "age": {
                    TopManOptionsEntity.Tag ageTag = new TopManOptionsEntity.Tag();
                    ageTag.setComponentType(OptionComponentType.RMultipleChoice);
                    ageTag.setStarTagId("2");
                    ageTag.setStarTagValue("fans_num");
                    ageTag.setLevel(Integer.valueOf(1));
                    ageTag.setStarTagName("\u7c89\u4e1d\u5e74\u9f84");
                    List<Object> ageComlab = this.getCommonLab((List)attract.get((Object)"directory_json"));
                    ageTag.setSubTags(ageComlab);
                    fnas.getChildren().add(ageTag);
                    break;
                }
                case "device": {
                    TopManOptionsEntity.Tag device = new TopManOptionsEntity.Tag();
                    device.setComponentType(OptionComponentType.RSelect);
                    device.setStarTagId("4");
                    device.setStarTagValue("device");
                    device.setLevel(Integer.valueOf(4));
                    device.setStarTagName("\u7c89\u4e1d\u8bbe\u5907");
                    List<Object> deviceComlab = this.getCommonLab((List)attract.get((Object)"directory_json"));
                    device.setSubTags(deviceComlab);
                    fnas.getChildren().add(device);
                    break;
                }
                case "expected_cpm": {
                    TopManOptionsEntity.Tag cpmTag = new TopManOptionsEntity.Tag();
                    cpmTag.setComponentType(OptionComponentType.RSelect);
                    cpmTag.setStarTagId("1");
                    cpmTag.setStarTagValue("expected_cpm");
                    cpmTag.setLevel(Integer.valueOf(1));
                    cpmTag.setStarTagName("\u9884\u671fCPM");
                    List<Object> cpmComlab = this.getCommonLab((List)attract.get((Object)"directory_json"));
                    cpmTag.setSubTags(cpmComlab);
                    play.getChildren().add(cpmTag);
                    break;
                }
                case "fans_num": {
                    TopManOptionsEntity.Tag tag = new TopManOptionsEntity.Tag();
                    tag.setComponentType(OptionComponentType.RMultipleChoice);
                    tag.setStarTagId("1");
                    tag.setStarTagValue("fans_num");
                    tag.setLevel(Integer.valueOf(1));
                    tag.setStarTagName("\u7c89\u4e1d\u6570");
                    List<Object> comlab = this.getCommonLab((List)attract.get((Object)"directory_json"));
                    tag.setSubTags(comlab);
                    topman.getChildren().add(tag);
                    break;
                }
                case "fans_num_growth_rate": {
                    break;
                }
                case "gender": {
                    TopManOptionsEntity.Tag gender = new TopManOptionsEntity.Tag();
                    gender.setComponentType(OptionComponentType.RSelect);
                    gender.setStarTagId("1");
                    gender.setStarTagValue("gender");
                    gender.setLevel(Integer.valueOf(2));
                    gender.setStarTagName("\u7c89\u4e1d\u6027\u522b");
                    List<Object> genderComlab = this.getCommonLab((List)attract.get((Object)"directory_json"));
                    gender.setSubTags(genderComlab);
                    fnas.getChildren().add(gender);
                    break;
                }
                case "interaction_rate": {
                    TopManOptionsEntity.Tag rateTag = new TopManOptionsEntity.Tag();
                    rateTag.setComponentType(OptionComponentType.RSelect);
                    rateTag.setStarTagId("2");
                    rateTag.setStarTagValue("interaction_rate");
                    rateTag.setLevel(Integer.valueOf(2));
                    rateTag.setStarTagName("\u4e92\u52a8\u7387");
                    List<Object> rateComlab = this.getCommonLab((List)attract.get((Object)"directory_json"));
                    rateTag.setSubTags(rateComlab);
                    play.getChildren().add(rateTag);
                    break;
                }
                case "like_count": {
                    break;
                }
                case "play_finish_rate": {
                    break;
                }
                case "read_count": {
                    break;
                }
                case "price": {
                    TopManOptionsEntity.Tag priceTag = new TopManOptionsEntity.Tag();
                    priceTag.setComponentType(OptionComponentType.RMultipleChoice);
                    priceTag.setStarTagId("3");
                    priceTag.setStarTagValue("price");
                    priceTag.setLevel(Integer.valueOf(3));
                    priceTag.setStarTagName("\u6295\u653e\u62a5\u4ef7");
                    List<Object> priceComlab = this.getCommonLab((List)attract.get((Object)"directory_json"));
                    priceTag.setSubTags(priceComlab);
                    topman.getChildren().add(priceTag);
                }
            }
        }
        switch (type) {
            case "videoTopMan": {
                result.add(topman);
                result.add(fnas);
                result.add(play);
                break;
            }
            case "liveTopMan": {
                break;
            }
            case "enterpriseTopMan": {
                result.add(topman);
                result.add(play);
                break;
            }
            case "myTopMan": {
                result.add(topman);
                result.add(play);
                break;
            }
            case "collectTopMan": {
                result.add(topman);
                result.add(play);
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return result;
    }

    @Override
    public IPage<?> queryTopManList(SimplePostRequestParam<VideoNumRequestParamVO> topManDto) throws Exception {
        IPage page;
        VideoNumRequestParamVO filterInfo = (VideoNumRequestParamVO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        QueryWrapper queryWrapper = new QueryWrapper();
        StringBuilder redisKey = new StringBuilder(VIDEONUM).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON);
        String param = VideoNumTopmanServiceImpl.apiGetList(taskType, topManDto, (QueryWrapper<VideoNumTopManEntity>)queryWrapper, redisKey);
        redisKey.append(param);
        redisKey.append(taskType).append(COLON).append(topManDto.getPageNo()).append(COLON).append(topManDto.getPageSize());
        switch (taskType) {
            case "videoTopMan": {
                page = (IPage)this.redisUtil.get(redisKey.toString());
                List<VideoNumTopManListVo> bStationManInformationVOVideo = new ArrayList();
                if (page == null) {
                    page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                    String urlVideo = this.spiderBaseProperties.getTopManUrl() + "/weixin/index_list";
                    JSONObject jsonObjectVideo = HttpRequestUtils.doPostNew(urlVideo, param);
                    if (jsonObjectVideo == null) {
                        return page;
                    }
                    JSONObject dataVideo = jsonObjectVideo.getJSONObject("data");
                    if (dataVideo == null) {
                        return page;
                    }
                    JSONArray dataItem = dataVideo.getJSONArray("item");
                    if (dataItem == null || dataItem.size() == 0) {
                        return page;
                    }
                    bStationManInformationVOVideo = dataItem.toJavaList(VideoNumTopManListVo.class);
                    page.setTotal((long)dataVideo.getInteger("total_num").intValue());
                    page.setRecords(bStationManInformationVOVideo);
                    if (CollectionUtils.isNotEmpty(bStationManInformationVOVideo)) {
                        this.redisUtil.set(redisKey.toString(), (Object)page, 14400L);
                    }
                } else {
                    bStationManInformationVOVideo = page.getRecords();
                }
                if (bStationManInformationVOVideo == null || bStationManInformationVOVideo.size() <= 0) break;
                this.handleResult(bStationManInformationVOVideo);
                break;
            }
            case "enterpriseTopMan": {
                IPage<VideoNumTopManListVo> enterpriseResult = new IPage<VideoNumTopManListVo>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                filterInfo = this.handleFilterInfo(filterInfo);
                enterpriseResult = ((VideoNumTopManMapper)this.baseMapper).selectEnterpriseTopMan(enterpriseResult, (Wrapper<VideoNumTopManEntity>)queryWrapper, SysUtil.getLoginUser(), filterInfo, this.permissionDataRpcService.getCompany("companyResource"), this.subaccountOrgRpcService.getSubaccountOrgCode());
                this.handleTags(enterpriseResult.getRecords());
                return enterpriseResult;
            }
            case "myTopMan": {
                LoginUser loginUser = SysUtil.getLoginUser();
                queryWrapper.eq((Object)"leader", (Object)loginUser.getSubAccount());
                queryWrapper.orderByDesc((Object)"addTime");
                IPage<VideoNumTopManListVo> myResult = new IPage<VideoNumTopManListVo>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                filterInfo = this.handleFilterInfo(filterInfo);
                myResult = ((VideoNumTopManMapper)this.baseMapper).selectEnterpriseTopMan(myResult, (Wrapper<VideoNumTopManEntity>)queryWrapper, SysUtil.getLoginUser(), filterInfo, this.permissionDataRpcService.getCompany("companyResource"), this.subaccountOrgRpcService.getSubaccountOrgCode());
                this.handleTags(myResult.getRecords());
                return myResult;
            }
            case "collectTopMan": {
                IPage<VideoNumTopManListVo> result = new IPage<VideoNumTopManListVo>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                filterInfo = this.handleFilterInfo(filterInfo);
                result = ((VideoNumTopManMapper)this.baseMapper).selectCollectTopMan(result, (Wrapper<VideoNumTopManEntity>)queryWrapper, SysUtil.getLoginUser(), filterInfo, this.subaccountOrgRpcService.getSubaccountOrgCode());
                this.handleTags(result.getRecords());
                return result;
            }
            default: {
                throw new ELSBootException("\u8be5\u8bf7\u6c42\u4e0d\u5408\u6cd5");
            }
        }
        return page;
    }

    private VideoNumRequestParamVO handleFilterInfo(VideoNumRequestParamVO filterInfo) {
        String[] rateArray;
        String rate;
        String[] cpmArray;
        ArrayList<Integer> allTag = new ArrayList<Integer>();
        if (filterInfo.getAbility_tag() != null && filterInfo.getAbility_tag().size() > 0) {
            allTag.addAll(filterInfo.getAbility_tag());
        }
        if (filterInfo.getAccount_tag() != null && filterInfo.getAccount_tag().size() > 0) {
            allTag.addAll(filterInfo.getAccount_tag());
        }
        if (filterInfo.getIndustry_tag() != null && filterInfo.getIndustry_tag().size() > 0) {
            allTag.addAll(filterInfo.getIndustry_tag());
        }
        List<String> prices = filterInfo.getPrice();
        String cpm = filterInfo.getExpected_cpm();
        if (cpm != null && !"".equals(cpm) && (cpmArray = cpm.split("-")).length > 1) {
            String max;
            String min = cpmArray[0];
            VideoNumRequestParamVO.Tag tag = new VideoNumRequestParamVO.Tag();
            if (min != null && !"".equals(min)) {
                tag.setMin(Integer.parseInt(min));
            }
            if ((max = cpmArray[1]) != null && !"".equals(max)) {
                tag.setMax(Integer.parseInt(max));
            }
            filterInfo.setCpmTag(tag);
        }
        if ((rate = filterInfo.getInteraction_rate()) != null && !"".equals(rate) && (rateArray = rate.split("-")).length > 1) {
            String max;
            String min = rateArray[0];
            VideoNumRequestParamVO.Tag tag = new VideoNumRequestParamVO.Tag();
            if (min != null && !"".equals(min)) {
                tag.setMin(Integer.parseInt(min));
            }
            if ((max = rateArray[1]) != null && !"".equals(max)) {
                tag.setMax(Integer.parseInt(max));
            }
            filterInfo.setRateTag(tag);
        }
        if (prices != null && prices.size() > 0) {
            ArrayList<VideoNumRequestParamVO.Tag> pricesTags = new ArrayList<VideoNumRequestParamVO.Tag>();
            for (String price : prices) {
                String max;
                String[] priceArray = price.split("-");
                VideoNumRequestParamVO.Tag tag = new VideoNumRequestParamVO.Tag();
                String min = priceArray[0];
                if (min != null && !"".equals(min)) {
                    tag.setMin(Integer.parseInt(min));
                }
                if ((max = priceArray[1]) != null && !"".equals(max)) {
                    tag.setMax(Integer.parseInt(max));
                }
                pricesTags.add(tag);
            }
            filterInfo.setPriceTag(pricesTags);
        }
        filterInfo.setAllTag(allTag);
        return filterInfo;
    }

    private void handleTags(List<VideoNumTopManListVo> bStationManInformationVOVideo) {
        String collection = "tb_videonum_category";
        Document document = new Document();
        document.append("name", (Object)"tags");
        HashMap<String, String> tagKey = new HashMap<String, String>();
        MongoCursor attractCursor = this.mongoTemplate.getCollection(collection).find((Bson)document).noCursorTimeout(true).cursor();
        while (attractCursor.hasNext()) {
            Document attract = (Document)attractCursor.next();
            List json = (List)attract.get((Object)"directory_json");
            for (Map tag : json) {
                tagKey.put(tag.get("id") + "", tag.get("name") + "");
            }
        }
        Document documentLabels = new Document();
        documentLabels.append("name", (Object)"labels");
        attractCursor = this.mongoTemplate.getCollection(collection).find((Bson)documentLabels).noCursorTimeout(true).cursor();
        HashMap<String, String> labelsKey = new HashMap<String, String>();
        while (attractCursor.hasNext()) {
            Document attract = (Document)attractCursor.next();
            List json = (List)attract.get((Object)"directory_json");
            for (Map tag : json) {
                labelsKey.put(tag.get("lable_id") + "", tag.get("lable_text") + "");
            }
        }
        for (VideoNumTopManListVo vo : bStationManInformationVOVideo) {
            vo.setCategoryLevel1Label((String)labelsKey.get(vo.getCategoryLevel1()));
            vo.setCategoryLevel2Label((String)labelsKey.get(vo.getCategoryLevel2()));
            int cnt = 0;
            String tagLabel = "";
            String[] tags = vo.getQueryTags().split(",");
            if (tags == null || tags.length <= 0) continue;
            for (String tag : tags) {
                String tagName = (String)tagKey.get(tag);
                if (tagName != null && !"".equals(tagName)) {
                    if (cnt > 0) {
                        tagLabel = tagLabel + "," + tagName;
                    } else {
                        tagLabel = tagName;
                        ++cnt;
                    }
                }
                vo.setTagslabel(tagLabel);
            }
        }
    }

    private void handleResult(List<VideoNumTopManListVo> bStationManInformationVOVideo) {
        String collection = "tb_videonum_category";
        Document document = new Document();
        document.append("name", (Object)"tags");
        HashMap<String, String> tagKey = new HashMap<String, String>();
        MongoCursor attractCursor = this.mongoTemplate.getCollection(collection).find((Bson)document).noCursorTimeout(true).cursor();
        while (attractCursor.hasNext()) {
            Document attract = (Document)attractCursor.next();
            List json = (List)attract.get((Object)"directory_json");
            for (Map tag : json) {
                tagKey.put(tag.get("id") + "", tag.get("name") + "");
            }
        }
        Document documentLabels = new Document();
        documentLabels.append("name", (Object)"labels");
        attractCursor = this.mongoTemplate.getCollection(collection).find((Bson)documentLabels).noCursorTimeout(true).cursor();
        HashMap<String, String> labelsKey = new HashMap<String, String>();
        while (attractCursor.hasNext()) {
            Document attract = (Document)attractCursor.next();
            List json = (List)attract.get((Object)"directory_json");
            for (Map tag : json) {
                labelsKey.put(tag.get("lable_id") + "", tag.get("lable_text") + "");
            }
        }
        for (VideoNumTopManListVo vo : bStationManInformationVOVideo) {
            vo.setCategoryLevel1Label((String)labelsKey.get(vo.getCategoryLevel1()));
            vo.setCategoryLevel2Label((String)labelsKey.get(vo.getCategoryLevel2()));
            int cnt = 0;
            String tagLabel = "";
            for (String tag : vo.getTags()) {
                String tagName = (String)tagKey.get(tag);
                if (tagName != null && !"".equals(tagName)) {
                    if (cnt > 0) {
                        tagLabel = tagLabel + "," + tagName;
                    } else {
                        tagLabel = tagName;
                        ++cnt;
                    }
                }
                vo.setTagslabel(tagLabel);
            }
        }
        List<String> bStationId = bStationManInformationVOVideo.stream().map(VideoNumTopManListVo::getAppid).distinct().collect(Collectors.toList());
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        List<VideoNumTopManEntity> addedAndCollects = ((VideoNumTopManMapper)this.baseMapper).checkAddedAndCollect(bStationId, SysUtil.getLoginUser(), "7", company);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(VideoNumTopManEntity::getAppid, h -> h, (k1, k2) -> k1));
        }
        for (VideoNumTopManListVo topManInfo : bStationManInformationVOVideo) {
            if (!map.containsKey(topManInfo.getAppid())) continue;
            VideoNumTopManEntity info = (VideoNumTopManEntity)((Object)map.get(topManInfo.getAppid()));
            topManInfo.setIsCollection(info.getIsCollection() + "");
            topManInfo.setIsAdded(info.getIsAdded() + "");
        }
    }

    @Override
    public VideoNumTopManTopDetailsVO bStationTopManDetails(String appid) {
        StringBuilder redisKey = new StringBuilder(VIDEONUM).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON).append(TALENT_DETAILS).append(COLON).append(appid);
        VideoNumTopManTopDetailsVO bStationTopManInformationDetails = (VideoNumTopManTopDetailsVO)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationDetails == null) {
            log.info("\u65e0\u8fbe\u4eba\u5934\u90e8\u8be6\u60c5\u7f13\u5b58\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("appid", appid);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/weixin/detail/porfile";
            JSONObject jsonObject = HttpRequestUtils.doPostNew(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new VideoNumTopManTopDetailsVO();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            bStationTopManInformationDetails = (VideoNumTopManTopDetailsVO)data.toJavaObject(VideoNumTopManTopDetailsVO.class);
            List<VideoNumTopManTopDetailsVO.UserProfile.Label> ages = bStationTopManInformationDetails.getUser_profile().getAge();
            Collections.sort(ages, new Comparator<VideoNumTopManTopDetailsVO.UserProfile.Label>(){

                @Override
                public int compare(VideoNumTopManTopDetailsVO.UserProfile.Label label1, VideoNumTopManTopDetailsVO.UserProfile.Label label2) {
                    int age2;
                    int age1 = Integer.parseInt(VideoNumTopmanServiceImpl.this.getAge(label1.getLabel()));
                    if (age1 < (age2 = Integer.parseInt(VideoNumTopmanServiceImpl.this.getAge(label2.getLabel())))) {
                        return -1;
                    }
                    if (age1 == age2) {
                        return 0;
                    }
                    return 1;
                }
            });
            bStationTopManInformationDetails.getItem().setTagsLabel(this.getTags(bStationTopManInformationDetails.getItem().getTags()));
            this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationDetails, 14400L);
        }
        List<String> ids = Collections.singletonList(bStationTopManInformationDetails.getItem().getAppid());
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        List<VideoNumTopManEntity> bStationTopManInformationEntities = ((VideoNumTopManMapper)this.baseMapper).checkAddedAndCollect(ids, SysUtil.getLoginUser(), "7", company);
        if (CollectionUtils.isNotEmpty(bStationTopManInformationEntities)) {
            bStationTopManInformationDetails.setIsAdded(bStationTopManInformationEntities.get(0).getIsAdded());
            bStationTopManInformationDetails.setIsCollection(bStationTopManInformationEntities.get(0).getIsCollection());
        }
        return bStationTopManInformationDetails;
    }

    private String getAge(String ageLabe) {
        String ageLabeObj = ageLabe;
        ageLabeObj = ageLabeObj.replace("<", "");
        ageLabeObj = ageLabeObj.replace(">", "");
        return ageLabeObj.substring(0, 2);
    }

    @Override
    public VideoNumTopManTopCasesVo topManDetailsCases(VideoNumTopManDetailDTO dto) {
        VideoNumTopManTopCasesVo result = null;
        String redisKey = "TopManDetailsCases_" + dto.getAppid();
        if (!"1".equals(dto.getClearCache())) {
            result = (VideoNumTopManTopCasesVo)this.redisUtil.get(redisKey);
        }
        HashMap<String, String> apiParam = new HashMap<String, String>(2);
        apiParam.put("appid", dto.getAppid());
        if (result == null) {
            String string = JSON.toJSONString(apiParam);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/weixin/detail/cases";
            JSONObject jsonObject = HttpRequestUtils.doPostNew(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new VideoNumTopManTopCasesVo();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            result = (VideoNumTopManTopCasesVo)data.toJavaObject(VideoNumTopManTopCasesVo.class);
            if (result != null) {
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        }
        return result;
    }

    @Override
    public VideoNumTopManTopSimilarVO topManDetailsSimilar(VideoNumTopManDetailDTO dto) {
        VideoNumTopManTopSimilarVO result = null;
        String redisKey = "topManDetailsSimilar_" + dto.getAppid();
        if (!"1".equals(dto.getClearCache())) {
            result = (VideoNumTopManTopSimilarVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("appid", dto.getAppid());
        apiParam.put("page", dto.getPage());
        if (result == null) {
            String string = JSON.toJSONString(apiParam);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/weixin/detail/similar";
            JSONObject jsonObject = HttpRequestUtils.doPostNew(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new VideoNumTopManTopSimilarVO();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            result = (VideoNumTopManTopSimilarVO)data.toJavaObject(VideoNumTopManTopSimilarVO.class);
            if (result != null) {
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        }
        return result;
    }

    private void topManDetailsLiveConverter(BiliBiliTopManDetailsHeadLiveEntity entity, VideoNumTopManTopDetailsVO result) {
    }

    @Override
    public VideoNumTopManDetailsBasicDataEntity topManBasicData(VideoNumTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_ARCHIVE_HIGHLIGHTS;
        VideoNumTopManDetailsBasicDataEntity result = null;
        String redisKey = "BiliBiliTopManDetailBasicData_" + dto.getVideoId() + "_" + dto.getDayRange();
        if (!"1".equals(dto.getClearCache())) {
            result = (VideoNumTopManDetailsBasicDataEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getVideoId());
        apiParam.put("day_range", dto.getDayRange());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(methodType, apiParam, VideoNumTopManDetailsBasicDataEntity.class);
            if (result != null) {
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.topManBasicData(dto);
            });
        }
        return result;
    }

    @Override
    public IPage<VideoNumTopManBasicAnalysisEntity> bStationTopManFanBasicAnalysisList(String bStationId, String fanCode, int pageNO) {
        StringBuilder redisKey = new StringBuilder(VIDEONUM).append(COLON).append(TenantContext.getTenant()).append(COLON).append("fan").append(COLON).append(bStationId).append(COLON).append(fanCode).append(COLON).append(pageNO);
        IPage page = (IPage)this.redisUtil.get(redisKey.toString());
        if (page == null) {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("upper_mid", bStationId);
            if (StringUtils.isNotEmpty((CharSequence)fanCode)) {
                param.put("fans_range", fanCode);
            }
            param.put("page", pageNO);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/similar/fan/telent/list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new Page();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            List bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(VideoNumTopManBasicAnalysisEntity.class);
            Integer current = jsonObject.getInteger("page");
            Integer total = jsonObject.getInteger("total");
            page = new Page((long)current.intValue(), 9L, (long)total.intValue());
            page.setRecords(bStationTopManInformationBasicAnalysisEntities);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)page, 14400L);
            }
        }
        return page;
    }

    @Override
    public List<VideoNumTopManBasicAnalysisEntity.Screen> bStationTopManFanBasicAnalysisCategory() {
        StringBuilder redisKey = new StringBuilder(VIDEONUM).append(COLON).append(TenantContext.getTenant()).append(COLON).append("category").append(COLON).append("screen");
        List bStationTopManInformationBasicAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationBasicAnalysisEntities == null) {
            HashMap param = new HashMap();
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/similar/fan/telent/category";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<VideoNumTopManBasicAnalysisEntity.Screen>();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(VideoNumTopManBasicAnalysisEntity.Screen.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationBasicAnalysisEntities, 14400L);
            }
        }
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public List<VideoNumTopManBasicAnalysisEntity> bStationTopManContentBasicAnalysisList(String bStationId) {
        StringBuilder redisKey = new StringBuilder(VIDEONUM).append(COLON).append(TenantContext.getTenant()).append(COLON).append("Similarfansoverlap").append(COLON).append(bStationId);
        List bStationTopManInformationBasicAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationBasicAnalysisEntities == null) {
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("upper_mid", bStationId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/bilibili/content/cooperation/api/similar/content/telent/list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<VideoNumTopManBasicAnalysisEntity>();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(VideoNumTopManBasicAnalysisEntity.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationBasicAnalysisEntities, 14400L);
            }
        }
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public VideoNumTopManFanAnalysisVO topManFanAnalysisFanTrend(VideoNumTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_FANS_TREND;
        VideoNumTopManFanAnalysisVO result = null;
        String redisKey = "BiliBiliTopManFanAnalysisFanTrend_" + dto.getVideoId();
        if (!"1".equals(dto.getClearCache())) {
            result = (VideoNumTopManFanAnalysisVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getVideoId());
        apiParam.put("query_type", 1);
        HashMap<String, Object> apiParam2 = new HashMap<String, Object>(2);
        apiParam2.put("upper_mid", dto.getVideoId());
        apiParam2.put("query_type", 2);
        if (result == null) {
            result = new VideoNumTopManFanAnalysisVO();
            BiliBiliTopManDetailsFanTrendEntity entity = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsFanTrendEntity.class);
            BiliBiliTopManDetailsFanTrendEntity entity2 = this.spiderApiUtil.postForEntity(methodType, apiParam2, BiliBiliTopManDetailsFanTrendEntity.class);
            if (entity != null && entity2 != null) {
                this.topManFanAnalysisFanTrendConverter(entity, entity2, result);
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                this.topManFanAnalysisFanTrend(dto);
            });
        }
        return result;
    }

    private void topManFanAnalysisFanTrendConverter(BiliBiliTopManDetailsFanTrendEntity entity, BiliBiliTopManDetailsFanTrendEntity entity2, VideoNumTopManFanAnalysisVO result) {
        List<BiliBiliTopManDetailsFanTrendEntity.DataStatistics> fanIncrementTrends;
        List<BiliBiliTopManDetailsFanTrendEntity.DataStatistics> fanTotalTrends = entity.getDataStatisticsByDayVos();
        if (CollectionUtil.isNotEmpty(fanTotalTrends)) {
            ArrayList<VideoNumTopManFanAnalysisVO.FanTrend> tags = new ArrayList<VideoNumTopManFanAnalysisVO.FanTrend>(fanTotalTrends.size());
            fanTotalTrends.forEach(h -> {
                VideoNumTopManFanAnalysisVO.FanTrend tag = new VideoNumTopManFanAnalysisVO.FanTrend();
                tag.setCount(h.getCount());
                tag.setDate(h.getDate());
                tags.add(tag);
            });
            result.setFanTotalTrends(tags);
        }
        if (CollectionUtil.isNotEmpty(fanIncrementTrends = entity2.getDataStatisticsByDayVos())) {
            ArrayList<VideoNumTopManFanAnalysisVO.FanTrend> tags = new ArrayList<VideoNumTopManFanAnalysisVO.FanTrend>(fanIncrementTrends.size());
            fanIncrementTrends.forEach(h -> {
                VideoNumTopManFanAnalysisVO.FanTrend tag = new VideoNumTopManFanAnalysisVO.FanTrend();
                tag.setCount(h.getCount());
                tag.setDate(h.getDate());
                tags.add(tag);
            });
            result.setFanIncrementTrends(tags);
        }
    }

    @Override
    public VideoNumTopManFanAnalysisVO topManFanAnalysisFanDetails(VideoNumTopManDetailDTO dto) {
        SpiderMethodType methodType = SpiderMethodType.BILI_BILI_PROFILE_DETAILS;
        VideoNumTopManFanAnalysisVO result = null;
        String redisKey = "BiliBiliTopManFanAnalysisFanDetails_" + dto.getVideoId() + "_" + dto.getTopmanId() + "_" + dto.getFansType();
        if (!"1".equals(dto.getClearCache())) {
            result = (VideoNumTopManFanAnalysisVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("upper_mid", dto.getVideoId());
        apiParam.put("mcn_id", dto.getTopmanId());
        if (result == null) {
            result = new VideoNumTopManFanAnalysisVO();
            BiliBiliTopManDetailsHeadVidioEntity entity = this.spiderApiUtil.postForEntity(methodType, apiParam, BiliBiliTopManDetailsHeadVidioEntity.class);
            if (entity != null) {
                this.topManFanAnalysisFanDetailsConverter(entity, result, dto.getFansType());
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        } else if (!this.spiderApiUtil.checkCache(methodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                dto.setClearCache("1");
                dto.setFansType(1);
                this.topManFanAnalysisFanDetails(dto);
            });
        }
        return result;
    }

    private void topManFanAnalysisFanDetailsConverter(BiliBiliTopManDetailsHeadVidioEntity entity, VideoNumTopManFanAnalysisVO result, Integer fansType) {
        List<String> secondCategories;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> tagProfileList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> topRegionList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> deviceList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> ageList;
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> saxList;
        List<String> featureTags = entity.getAttentionUserFeatureTags();
        List<String> distributedTags = entity.getAttentionUserDistributedTags();
        if (CollectionUtil.isNotEmpty(featureTags) || CollectionUtil.isNotEmpty(distributedTags)) {
            ArrayList<String> tags = new ArrayList<String>(featureTags.size() + distributedTags.size());
            tags.addAll(featureTags);
            tags.addAll(distributedTags);
            result.setGenderMost(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list = saxList = fansType == 1 ? entity.getSaxDistributions() : entity.getSaxDistributionsAudience();
        if (CollectionUtil.isNotEmpty(saxList)) {
            ArrayList<VideoNumTopManFanAnalysisVO.GenderDistribution> tags = new ArrayList<VideoNumTopManFanAnalysisVO.GenderDistribution>(saxList.size());
            saxList.forEach(h -> {
                VideoNumTopManFanAnalysisVO.GenderDistribution tag = new VideoNumTopManFanAnalysisVO.GenderDistribution();
                tag.setCount(h.getCount());
                tag.setGender(h.getSectionDesc());
                tags.add(tag);
            });
            result.setGenderDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list2 = ageList = fansType == 1 ? entity.getAgeDistributions() : entity.getAgeDistributionsAudience();
        if (CollectionUtil.isNotEmpty(ageList)) {
            ArrayList<VideoNumTopManFanAnalysisVO.AgeDistribution> tags = new ArrayList<VideoNumTopManFanAnalysisVO.AgeDistribution>(ageList.size());
            ageList.forEach(h -> {
                VideoNumTopManFanAnalysisVO.AgeDistribution tag = new VideoNumTopManFanAnalysisVO.AgeDistribution();
                tag.setCount(h.getCount());
                tag.setAge(h.getSectionDesc());
                tags.add(tag);
            });
            result.setAgeDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list3 = deviceList = fansType == 1 ? entity.getDeviceDistributions() : entity.getDeviceDistributionsAudience();
        if (CollectionUtil.isNotEmpty(deviceList)) {
            ArrayList<VideoNumTopManFanAnalysisVO.EquipmentDistribution> tags = new ArrayList<VideoNumTopManFanAnalysisVO.EquipmentDistribution>(deviceList.size());
            deviceList.forEach(h -> {
                VideoNumTopManFanAnalysisVO.EquipmentDistribution tag = new VideoNumTopManFanAnalysisVO.EquipmentDistribution();
                tag.setCount(h.getCount());
                tag.setMobile(h.getSectionDesc());
                tags.add(tag);
            });
            result.setEquipmentDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list4 = topRegionList = fansType == 1 ? entity.getTopRegionDistributions() : entity.getTopRegionDistributionsAudience();
        if (CollectionUtil.isNotEmpty(topRegionList)) {
            ArrayList<VideoNumTopManFanAnalysisVO.RegionDistribution> tags = new ArrayList<VideoNumTopManFanAnalysisVO.RegionDistribution>(topRegionList.size());
            topRegionList.forEach(h -> {
                VideoNumTopManFanAnalysisVO.RegionDistribution tag = new VideoNumTopManFanAnalysisVO.RegionDistribution();
                tag.setCount(h.getCount());
                tag.setRegion(h.getSectionDesc());
                tags.add(tag);
            });
            result.setRegionDistributions(tags);
        }
        List<BiliBiliTopManDetailsHeadVidioEntity.AgeDistributions> list5 = tagProfileList = fansType == 1 ? entity.getTagProfile() : entity.getTagProfileAudience();
        if (CollectionUtil.isNotEmpty(tagProfileList)) {
            ArrayList<VideoNumTopManFanAnalysisVO.Distributions> tags = new ArrayList<VideoNumTopManFanAnalysisVO.Distributions>(tagProfileList.size());
            tagProfileList.forEach(h -> {
                VideoNumTopManFanAnalysisVO.Distributions tag = new VideoNumTopManFanAnalysisVO.Distributions();
                tag.setCount(h.getCount());
                tag.setSectionDesc(h.getSectionDesc());
                tags.add(tag);
            });
            result.setTagProfile(tags);
        }
        List<String> firstCategories = fansType == 1 ? entity.getFirstCategoriesProfile() : entity.getFirstCategoriesProfileAudience();
        List<String> list6 = secondCategories = fansType == 1 ? entity.getSecondCategoriesProfile() : entity.getSecondCategoriesProfileAudience();
        if (CollectionUtil.isNotEmpty(firstCategories) && CollectionUtil.isNotEmpty(secondCategories)) {
            ArrayList<VideoNumTopManFanAnalysisVO.CategoriesProfile> tags = new ArrayList<VideoNumTopManFanAnalysisVO.CategoriesProfile>(firstCategories.size());
            for (int i = 0; i < firstCategories.size(); ++i) {
                VideoNumTopManFanAnalysisVO.CategoriesProfile tag = new VideoNumTopManFanAnalysisVO.CategoriesProfile();
                tag.setFirstCategories(firstCategories.get(i));
                tag.setSecondCategories(secondCategories.get(i));
                tags.add(tag);
            }
            result.setCategoriesProfile(tags);
        }
    }

    @Override
    public List<TopManOptionsEntity> getEnterpriseOptions(String type, String clearCache) {
        return null;
    }

    @Override
    public String getTags(List<String> tags) {
        String collection = "tb_videonum_category";
        Document document = new Document();
        document.append("name", (Object)"tags");
        String reslut = "";
        MongoCursor attractCursor = this.mongoTemplate.getCollection(collection).find((Bson)document).noCursorTimeout(true).cursor();
        while (attractCursor.hasNext()) {
            Document attract = (Document)attractCursor.next();
            List json = (List)attract.get((Object)"directory_json");
            HashMap<String, String> tagKey = new HashMap<String, String>();
            for (Map tag : json) {
                tagKey.put(tag.get("id") + "", tag.get("name") + "");
            }
            int cnt = 0;
            for (String tag : tags) {
                String tagName = (String)tagKey.get(tag);
                if (tagName == null || "".equals(tagName)) continue;
                if (cnt > 0) {
                    reslut = reslut + "," + tagName;
                    continue;
                }
                reslut = tagName;
                ++cnt;
            }
        }
        return reslut;
    }

    @Override
    public void cleanCache(String cacheKey) {
    }

    @Override
    public VideoNumTopManChannelsVO topManDetailsCasesChannels(VideoNumTopManDetailDTO dto) {
        VideoNumTopManChannelsVO result = null;
        String redisKey = "VideoNumTopManChannelsVO_" + dto.getAppid();
        if (!"1".equals(dto.getClearCache())) {
            result = (VideoNumTopManChannelsVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, String> apiParam = new HashMap<String, String>(2);
        apiParam.put("channels_id", dto.getChannelsId());
        if (result == null) {
            String string = JSON.toJSONString(apiParam);
            String urlDetails = this.spiderBaseProperties.getTopManUrl() + "/weixin/detail/cases/get_finder_video_info";
            JSONObject jsonObject = HttpRequestUtils.doPostNew(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new VideoNumTopManChannelsVO();
            }
            JSONObject data = jsonObject.getJSONObject("data");
            result = (VideoNumTopManChannelsVO)data.toJavaObject(VideoNumTopManChannelsVO.class);
            if (result != null) {
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        }
        return result;
    }
}

