/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.msg;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.Adapter;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.common.spider.entity.KuaiShouIndexListPage;
import com.els.modules.common.spider.entity.KuaiShouTopManInfo;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.properties.TopManMsgProperties;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.topman.dto.KuaiShouTopManDTO;
import com.els.modules.topman.service.KuaiShouTopManService;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.enumerate.MsgTopManSourceEnum;
import com.els.modules.touch.msg.TopManMsgAdapter;
import com.els.modules.touch.service.TopManMsgRecordService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"2"})
public class KuaiShouMsgAdapter
extends TopManMsgAdapter {
    private static final Logger log = LoggerFactory.getLogger(KuaiShouMsgAdapter.class);
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private KuaiShouTopManService informationService;
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;

    @Override
    public List<TopManMsgRecord> getSearchData(String filterInfoJson, TopManMsgTask topManMsgTask, int limitSize) {
        JSONObject jsonObject = JSON.parseObject((String)filterInfoJson);
        KuaiShouTopManDTO requestOptionVO = new KuaiShouTopManDTO();
        JSONObject f = jsonObject.getJSONObject("filterInfo");
        requestOptionVO.setTaskType(f.getString("taskType"));
        requestOptionVO.setPlatformType(f.getString("platformType"));
        JSONObject screen = f.getJSONObject("screenItem");
        KuaiShouTopManDTO.ScreenItem screenItem = new KuaiShouTopManDTO.ScreenItem();
        screen.keySet().forEach(key -> {
            JSONArray jsonArray = screen.getJSONArray(key);
            switch (key) {
                case "contentType": {
                    screenItem.setContentType(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                    break;
                }
                case "industry": {
                    screenItem.setIndustry(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                    break;
                }
                case "contentForm": {
                    screenItem.setContentForm(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                    break;
                }
                case "starRecommendation": {
                    screenItem.setStarRecommendation(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                    break;
                }
                case "talentInfo": {
                    screenItem.setTalentInfo(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                    break;
                }
                case "talentIndex": {
                    screenItem.setTalentIndex(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                    break;
                }
                case "fanInfo": {
                    screenItem.setFanInfo(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                    break;
                }
                case "contentPerformance": {
                    screenItem.setContentPerformance(jsonArray.toJavaList(KuaiShouTopManDTO.ScreenItemField.class));
                }
            }
        });
        String kw = f.getString("keyWord");
        if (CollUtil.isEmpty(screenItem.getContentType()) && CollUtil.isEmpty(screenItem.getIndustry()) && CollUtil.isEmpty(screenItem.getContentForm()) && CollUtil.isEmpty(screenItem.getStarRecommendation()) && CollUtil.isEmpty(screenItem.getTalentInfo()) && CollUtil.isEmpty(screenItem.getTalentIndex()) && CollUtil.isEmpty(screenItem.getFanInfo()) && CollUtil.isEmpty(screenItem.getContentPerformance()) && StrUtil.isBlank((CharSequence)kw)) {
            return Lists.newArrayList();
        }
        requestOptionVO.setScreenItem(screenItem);
        SimplePostRequestParam topManDto = new SimplePostRequestParam();
        topManDto.setFilterInfo((Object)requestOptionVO);
        topManDto.setKeyWord(kw);
        ArrayList records = Lists.newArrayList();
        records.addAll(this.handleListData(filterInfoJson, (SimplePostRequestParam<KuaiShouTopManDTO>)topManDto, topManMsgTask, limitSize));
        return records;
    }

    private List<TopManMsgRecord> handleListData(String filterInfoJson, SimplePostRequestParam<KuaiShouTopManDTO> topManDto, TopManMsgTask task, int limit) {
        ArrayList list = Lists.newArrayList();
        List oldTaskRecord = this.topManMsgRecordService.list((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)task.getElsAccount()));
        List oldTopManIds = oldTaskRecord.stream().map(x -> x.getTopmanId()).distinct().collect(Collectors.toList());
        int total = this.topManMsgProperties.getPageSize();
        int totalData = 0;
        int pageNo = 1;
        boolean endFlag = true;
        boolean first = true;
        long subTotal = 0L;
        while (endFlag) {
            topManDto.setPageNo(Integer.valueOf(pageNo));
            topManDto.setPageSize(Integer.valueOf(total));
            Map<?, ?> map = null;
            try {
                map = this.informationService.apiGetList(topManDto);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SpiderMethodType kuaiShouIndexList = SpiderMethodType.KUAI_SHOU_INDEX_LIST;
            Class<KuaiShouIndexListPage> responseClass = KuaiShouIndexListPage.class;
            KuaiShouIndexListPage apiResult = this.spiderApiUtil.postForEntity(kuaiShouIndexList, map, responseClass);
            if (first) {
                subTotal = apiResult.getTotal();
                first = false;
            }
            if (ObjectUtil.isNotEmpty((Object)apiResult) && CollUtil.isNotEmpty(apiResult.getStarList()) && subTotal > 0L) {
                ++pageNo;
                for (KuaiShouTopManInfo apiData : apiResult.getStarList()) {
                    --subTotal;
                    if (totalData >= limit) {
                        return list;
                    }
                    if (oldTopManIds.contains(apiData.getUserId().toString())) continue;
                    oldTopManIds.add(apiData.getUserId().toString());
                    TopManMsgRecord topManMsgRecord = new TopManMsgRecord();
                    topManMsgRecord.setTaskId(task.getId());
                    topManMsgRecord.setPlatform(task.getPlatform());
                    topManMsgRecord.setDeleted(CommonConstant.STATUS_NO);
                    topManMsgRecord.setElsAccount(task.getElsAccount());
                    topManMsgRecord.setSubAccount(task.getSubAccount());
                    topManMsgRecord.setSubAdd(MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode());
                    topManMsgRecord.setSearchContext(filterInfoJson);
                    topManMsgRecord.setSendStatus("0");
                    topManMsgRecord.setReplyStatus("0");
                    topManMsgRecord.setSendCount(0);
                    topManMsgRecord.setReplyCount(0);
                    topManMsgRecord.setId(IdWorker.getIdStr());
                    topManMsgRecord.setTopmanId(apiData.getUserId().toString());
                    topManMsgRecord.setStarId(apiData.getStarId().toString());
                    topManMsgRecord.setLiveStatus(apiData.getLiveStatus().toString());
                    topManMsgRecord.setTopmanName(apiData.getName());
                    topManMsgRecord.setAvatar(apiData.getHeadUrl());
                    if (ObjectUtil.isNotEmpty((Object)apiData.getFansNum())) {
                        topManMsgRecord.setFansNum(apiData.getFansNum().toString());
                    }
                    list.add(topManMsgRecord);
                    ++totalData;
                }
                continue;
            }
            endFlag = false;
        }
        return list;
    }
}

