/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.service.JobRpcService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.entity.TouchAppAuth;
import com.els.modules.touch.enumerate.MsgTouchTypeEnum;
import com.els.modules.touch.service.TopManMsgTaskService;
import com.els.modules.touch.service.TouchAppAuthService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TopManDmMsgJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TopManDmMsgJob.class);
    @Resource
    private TopManMsgTaskService topManMsgTaskService;
    @Resource
    private TouchAppAuthService touchAppAuthService;

    public void execute(String parameter) {
        log.info("------------start TopManDmMsgJob -----------");
        List auths = this.touchAppAuthService.list((Wrapper)Wrappers.lambdaQuery().eq(TouchAppAuth::getStartupStatus, (Object)"1"));
        if (CollUtil.isEmpty((Collection)auths)) {
            return;
        }
        List elsAccounts = auths.stream().map(x -> x.getToElsAccount()).distinct().collect(Collectors.toList());
        List tasks = this.topManMsgTaskService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).in(BaseEntity::getElsAccount, elsAccounts));
        if (CollUtil.isNotEmpty((Collection)tasks)) {
            tasks.forEach(task -> {
                try {
                    this.topManMsgTaskService.resetRecord((TopManMsgTask)((Object)task));
                }
                catch (Exception e) {
                    log.error("handle TopManDmMsgJob error ,account[{}],platform[{}]", new Object[]{task.getPlatformAccount(), task.getPlatform(), e});
                }
            });
        }
        log.info("------------end TopManDmMsgJob-----------");
    }
}

