/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.AdapterFactory;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.barcode.rpc.service.ElsSubAccountApiRpcService;
import com.els.modules.common.spider.entity.DouYinIDList;
import com.els.modules.common.spider.entity.DouYinTopManDetailBaseContacrEntity;
import com.els.modules.common.spider.entity.DouYinTopManDetailBaseInfoEntity;
import com.els.modules.common.spider.entity.DouYinTopManIndexListPage;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.utils.MsgConvertUtil;
import com.els.modules.topman.utils.DouYinUtil;
import com.els.modules.touch.dto.TopManMsgReplyDto;
import com.els.modules.touch.dto.TopManMsgTurnRq;
import com.els.modules.touch.dto.TopmanMsgRqDto;
import com.els.modules.touch.entity.TopManMsgConfig;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.entity.TopManMsgRecordHis;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.enumerate.DmErrorCodeEnum;
import com.els.modules.touch.enumerate.MsgTopManSourceEnum;
import com.els.modules.touch.enumerate.MsgTouchTypeEnum;
import com.els.modules.touch.enumerate.TouchAppAuthTypeEnum;
import com.els.modules.touch.mapper.TopManMsgRecordMapper;
import com.els.modules.touch.msg.ITopManMessageAdapter;
import com.els.modules.touch.service.TopManMsgConfigService;
import com.els.modules.touch.service.TopManMsgRecordHisService;
import com.els.modules.touch.service.TopManMsgRecordService;
import com.els.modules.touch.service.TopManMsgTaskService;
import com.els.modules.touch.vo.TopMsgRecordVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgRecordServiceImpl
extends BaseServiceImpl<TopManMsgRecordMapper, TopManMsgRecord>
implements TopManMsgRecordService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgRecordServiceImpl.class);
    @Lazy
    @Autowired
    private TopManMsgRecordHisService recordHisService;
    @Autowired
    @Lazy
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    @Lazy
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    @Lazy
    private TopManMsgTaskService topManMsgTaskService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private AdapterFactory adapterFactory;
    @Autowired
    private DouYinUtil douYinUtil;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private ElsSubAccountApiRpcService elsSubAccountApiRpcService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<Pair> add(TopMsgRecordVO topManMsgRecord) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<String> autoMaticValue = topManMsgRecord.getAutoMaticValue();
        ArrayList msg = Lists.newArrayList();
        for (String value : autoMaticValue) {
            Integer max;
            String contact;
            DouYinTopManDetailBaseContacrEntity bodyContacr;
            HashMap<String, String> paramBean;
            topManMsgRecord.setId(null);
            topManMsgRecord.setContact(null);
            String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
            if (StrUtil.isBlank((CharSequence)company)) {
                if (this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTopmanName, (Object)topManMsgRecord.getTopmanName())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgRecord::getTouchType, (Object)value)).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())) > 0) {
                    msg.add(new Pair((Object)false, (Object)("\u8be5\u8fbe\u4eba\u5df2\u5b58\u5728" + MsgTouchTypeEnum.getDescByCode(value) + "\u81ea\u52a8\u5efa\u8054\u5217\u8868\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0")));
                    continue;
                }
            } else if (this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTopmanName, (Object)topManMsgRecord.getTopmanName())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgRecord::getTouchType, (Object)value)).eq(TopManMsgRecord::getCompany, (Object)company)).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())) > 0) {
                msg.add(new Pair((Object)false, (Object)("\u8be5\u8fbe\u4eba\u5df2\u5b58\u5728" + MsgTouchTypeEnum.getDescByCode(value) + "\u81ea\u52a8\u5efa\u8054\u5217\u8868\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0")));
                continue;
            }
            if (this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTopmanName, (Object)topManMsgRecord.getTopmanName())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(StrUtil.isNotBlank((CharSequence)company), TopManMsgRecord::getCompany, (Object)company)).eq(TopManMsgRecord::getTouchType, (Object)value)).eq(TopManMsgRecord::getSendStatus, (Object)CommonConstant.STATUS_NO)) > 0) {
                msg.add(new Pair((Object)false, (Object)("\u6b64\u8fbe\u4eba\u8be5\u8d26\u53f7\u5df2\u6709" + MsgTouchTypeEnum.getDescByCode(value) + "\u6210\u529f\u89e6\u8fbe\u7684\u8bb0\u5f55")));
            }
            if (MsgTouchTypeEnum.SMS.getCode().equals(value)) {
                paramBean = new HashMap<String, String>(3);
                paramBean.put("uid", topManMsgRecord.getTopmanId());
                paramBean.put("contact_mode", "1");
                paramBean.put("check_mode", "2");
                bodyContacr = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_BASE_CONTACR, paramBean, DouYinTopManDetailBaseContacrEntity.class);
                if (ObjectUtil.isNotEmpty((Object)bodyContacr)) {
                    contact = bodyContacr.getContactValue();
                    max = bodyContacr.getTimesLeft();
                    if (ObjectUtil.isNotEmpty((Object)max) && max <= 0) {
                        msg.add(new Pair((Object)false, (Object)"\u5f53\u65e5\u67e5\u770b\u624b\u673a\u53f7\u7801\u6b21\u6570\u5df2\u7528\u5b8c\uff0c\u672a\u6dfb\u52a0\u5230\u77ed\u4fe1\u89e6\u8fbe\u5217\u8868"));
                        continue;
                    }
                    if (StrUtil.isNotBlank((CharSequence)contact)) {
                        topManMsgRecord.setContact(contact);
                    } else {
                        msg.add(new Pair((Object)false, (Object)"\u627e\u4e0d\u5230\u7535\u8bdd\u53f7\u7801\uff0c\u672a\u6dfb\u52a0\u5230\u77ed\u4fe1\u89e6\u8fbe\u5217\u8868"));
                        continue;
                    }
                }
            }
            if (MsgTouchTypeEnum.WE_CHAT.getCode().equals(value)) {
                paramBean = new HashMap(3);
                paramBean.put("uid", topManMsgRecord.getTopmanId());
                paramBean.put("contact_mode", "2");
                paramBean.put("check_mode", "2");
                bodyContacr = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_BASE_CONTACR, paramBean, DouYinTopManDetailBaseContacrEntity.class);
                if (ObjectUtil.isNotEmpty((Object)bodyContacr)) {
                    contact = bodyContacr.getContactValue();
                    max = bodyContacr.getTimesLeft();
                    if (ObjectUtil.isNotEmpty((Object)max)) {
                        Assert.isTrue((max > 0 ? 1 : 0) != 0, (String)"\u5f53\u65e5\u67e5\u770b\u5fae\u4fe1\u53f7\u7801\u6b21\u6570\u5df2\u7528\u5b8c");
                    }
                    if (StrUtil.isNotBlank((CharSequence)contact)) {
                        topManMsgRecord.setContact(contact);
                    } else {
                        Assert.isTrue((boolean)false, (String)"\u6b64\u8fbe\u4eba\u672a\u627e\u5230\u5fae\u4fe1\u53f7\u7801");
                    }
                }
            }
            if (MsgTouchTypeEnum.DM.getCode().equals(value) && "1".equals(topManMsgRecord.getPlatform())) {
                String code = this.douYinUtil.getDouYinId(topManMsgRecord.getTopmanName(), topManMsgRecord.getAvatar(), topManMsgRecord.getTopmanId());
                if (StrUtil.isBlank((CharSequence)code)) {
                    msg.add(new Pair((Object)false, (Object)"\u627e\u4e0d\u5230\u6296\u97f3\u53f7\uff0c\u672a\u6dfb\u52a0\u5230\u79c1\u4fe1\u89e6\u8fbe\u5217\u8868"));
                    continue;
                }
                topManMsgRecord.setTopmanCode(code);
            }
            if (StrUtil.isNotBlank((CharSequence)topManMsgRecord.getTopmanLevel())) {
                topManMsgRecord.setTopmanLevel(topManMsgRecord.getTopmanLevelId());
            }
            if (StrUtil.isNotBlank((CharSequence)topManMsgRecord.getAvatar())) {
                topManMsgRecord.setAvatar(topManMsgRecord.getAvatar().replaceAll("-sign", ""));
            }
            topManMsgRecord.setTopmanSex(topManMsgRecord.getTopmanGenderId());
            topManMsgRecord.setSubAdd(MsgTopManSourceEnum.MANUALLY_ADDED.getCode());
            topManMsgRecord.setSubAccount(loginUser.getSubAccount());
            topManMsgRecord.setSendStatus("0");
            topManMsgRecord.setPush("0");
            topManMsgRecord.setReplyStatus("0");
            topManMsgRecord.setDeleted(CommonConstant.STATUS_NO);
            topManMsgRecord.setTouchType(value);
            topManMsgRecord.setId(null);
            topManMsgRecord.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCode());
            ((TopManMsgRecordMapper)this.baseMapper).insert((Object)topManMsgRecord);
            msg.add(new Pair((Object)true, (Object)(MsgTouchTypeEnum.getDescByCode(value) + "\u5df2\u6210\u529f\u5efa\u8054")));
        }
        return msg;
    }

    @Override
    public void edit(TopManMsgRecord topManMsgRecord) {
        int count = ((TopManMsgRecordMapper)this.baseMapper).updateById((Object)topManMsgRecord);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgRecordMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgRecordMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void handleMsg(TopmanMsgRqDto msg) {
        TopManMsgRecordHis his = (TopManMsgRecordHis)((Object)this.recordHisService.getById((Serializable)((Object)msg.getTaskId())));
        if (ObjectUtil.isEmpty((Object)((Object)his))) {
            return;
        }
        TopManMsgRecord record = (TopManMsgRecord)((Object)this.getById((Serializable)((Object)his.getTaskId())));
        if (ObjectUtil.isEmpty((Object)((Object)record))) {
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)msg.getStatus()) && !msg.getStatus().booleanValue()) {
            record.setSendStatus("3");
            this.updateById((Object)record);
            return;
        }
        if ("200".equals(msg.getCode())) {
            record.setSendStatus("1");
            record.setSendCount(record.getSendCount() + 1);
            if (ObjectUtil.isEmpty((Object)record.getSendTime())) {
                record.setSendTime(new Date());
            }
            record.setLateSendTime(new Date());
            his.setSendMsgId(record.getMsgId());
            his.setSendMsgContent(record.getMsgContent());
            TopManMsgConfig config = (TopManMsgConfig)((Object)this.topManMsgConfigService.getById((Serializable)((Object)record.getMsgId())));
            his.setMsgType(config.getMsgType());
            his.setTaskId(record.getId());
            his.setSortNum(config.getSortNum());
            his.setReplyStatus("0");
            his.setSendTime(DateUtil.formatDateTime((Date)new Date()));
            his.setCreateBy(record.getCreateBy());
            his.setCreateTime(new Date());
            his.setUpdateBy(record.getCreateBy());
            his.setUpdateTime(new Date());
            his.setElsAccount(record.getElsAccount());
            this.recordHisService.updateById((Object)his);
        } else {
            record.setSendStatus("0");
        }
        this.updateById((Object)record);
    }

    @Override
    public void turn(TopManMsgTurnRq rq) {
        List records = this.listByIds(rq.getTaskIds());
        List topmanName = records.stream().map(x -> x.getTopmanName()).collect(Collectors.toList());
        List olds = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(TopManMsgRecord::getTopmanName, topmanName)).eq(TopManMsgRecord::getSubAccount, (Object)rq.getSubAccount()));
        if (CollUtil.isNotEmpty((Collection)olds)) {
            String tips = olds.stream().map(x -> x.getTopmanName()).collect(Collectors.joining(","));
            Assert.isTrue((boolean)false, (String)("\u8fbe\u4eba:[" + tips + "],\u5df2\u5b58\u5728\u6b64\u5b50\u8d26\u53f7\u7684\u81ea\u52a8\u5efa\u8054\u5217\u8868\uff0c\u8bf7\u52ff\u8f6c\u529e"));
        }
        records.forEach(x -> {
            x.setSubAccount(rq.getSubAccount());
            x.setTurn("1");
            x.setSendStatus("0");
        });
        this.updateBatchById(records);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void handleReplyMsg(TopManMsgReplyDto msg) {
        if (StrUtil.isBlank((CharSequence)msg.getPlatform())) {
            return;
        }
        TopManMsgTask task = (TopManMsgTask)((Object)this.topManMsgTaskService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)msg.getPlatform())).eq(TopManMsgTask::getPlatformAccount, (Object)msg.getUserName()), false));
        if (ObjectUtil.isEmpty((Object)((Object)task))) {
            log.error("\u5904\u7406\u8fbe\u4eba\u6d88\u606f\u8d26\u53f7[{}]\u5e73\u53f0[{}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1", (Object)task.getPlatformAccount(), (Object)task.getPlatform());
            return;
        }
        List<TopManMsgReplyDto.Msg> msgs = msg.getMsgList();
        if (CollUtil.isEmpty(msgs)) {
            log.error("\u5904\u7406\u8fbe\u4eba\u6d88\u606f\u8d26\u53f7[{}]\u5e73\u53f0[{}]\u5bf9\u5e94\u7684\u6d88\u606f\u4e3a\u7a7a", (Object)task.getPlatformAccount(), (Object)task.getPlatform());
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)msg.getTaskId())) {
            TopManMsgRecordHis his = (TopManMsgRecordHis)((Object)this.recordHisService.getById((Serializable)((Object)msg.getTaskId())));
            if (ObjectUtil.isEmpty((Object)((Object)his))) {
                return;
            }
            TopManMsgRecord record = (TopManMsgRecord)((Object)this.getById((Serializable)((Object)his.getTaskId())));
            if (ObjectUtil.isEmpty((Object)((Object)record))) {
                return;
            }
            ArrayList replys = Lists.newArrayList();
            boolean flag = false;
            for (TopManMsgReplyDto.Msg msg1 : msgs) {
                if (flag && msg1.getChatUserType().equals("1")) {
                    replys.add(msg1);
                }
                if (!msg1.getMsg().equals(his.getSendMsgContent()) || !msg1.getChatUserType().equals("2")) continue;
                flag = true;
            }
            if (CollUtil.isNotEmpty((Collection)replys)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                TopManMsgReplyDto.Msg r = replys.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getTime())).findFirst().orElse(null);
                String replyTime = Optional.ofNullable(r.getTime()).orElse(sdf.format(new Date()));
                String replyContent = replys.stream().map(x -> x.getMsg()).collect(Collectors.joining(","));
                his.setReplyContent(replyContent);
                his.setReplyTime(replyTime);
                his.setReplyStatus("1");
                record.setReplyCount(record.getReplyCount() + 1);
                record.setReplyTime(replyTime);
                record.setReplyContent(replyContent);
                record.setReplyStatus("1");
                this.recordHisService.updateById((Object)his);
                this.updateById((Object)record);
            }
        } else {
            ElsSubAccountDTO elsSubAccountDTO;
            Map<String, List<TopManMsgReplyDto.Msg>> msgTypes = msg.getMsgList().stream().collect(Collectors.groupingBy(x -> x.getChatUserType()));
            if (ObjectUtil.isEmpty(msgTypes) || CollUtil.isEmpty((Collection)msgTypes.get("1"))) {
                return;
            }
            if (StrUtil.isBlank((CharSequence)msg.getNew_man_id())) {
                log.info("\u5904\u7406\u4e0d\u662f\u81ea\u52a8\u89e6\u8fbe\u8fbe\u4eba\u65f6,topmanName:{}\uff0cpy\u672a\u4f20uid", (Object)msg.getTopmanName());
                return;
            }
            TopManMsgRecord topManMsgRecord = this.getRecordByUid(msg.getNew_man_id(), msg.getAvatar_url(), msg.getTopmanName(), task);
            if (ObjectUtil.isEmpty((Object)((Object)topManMsgRecord))) {
                return;
            }
            TopManMsgRecord dbRecord = (TopManMsgRecord)((Object)this.topManMsgRecordService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)task.getId())).eq(TopManMsgRecord::getUid, (Object)msg.getNew_man_id()), false));
            String taskId = null;
            log.info("\u62c9\u53d6\u56de\u590d\u5bf9\u5e94\u7684taskId\u7684\u5b50\u8d26\u53f7:task:{},{}", (Object)JSON.toJSONString((Object)((Object)task)), (Object)task.getSubAccount());
            if (ObjectUtil.isEmpty((Object)((Object)dbRecord))) {
                topManMsgRecord.setUid(msg.getNew_man_id());
                topManMsgRecord.setTaskId(task.getId());
                topManMsgRecord.setPush("0");
                topManMsgRecord.setId(IdWorker.getIdStr());
                topManMsgRecord.setSubAdd(CollUtil.isNotEmpty((Collection)msgTypes.get("2")) ? MsgTopManSourceEnum.PRO_CONTACTS.getCode() : MsgTopManSourceEnum.INITIATIVE_RETRIEVAL.getCode());
                TenantContext.setTenant((String)task.getElsAccount());
                elsSubAccountDTO = this.elsSubAccountApiRpcService.getUserBySubAccount(task.getSubAccount());
                log.info("\u62c9\u53d6\u56de\u590d\u5bf9\u5e94\u7684elsSubAccountDTO:{}", (Object)JSON.toJSONString((Object)elsSubAccountDTO));
                if (ObjectUtil.isNotEmpty((Object)elsSubAccountDTO)) {
                    topManMsgRecord.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCodeByUserId(elsSubAccountDTO.getId()));
                    log.info("\u62c9\u53d6\u56de\u590d\u5bf9\u5e94\u7684taskId\u7684\u516c\u53f8:{}", (Object)topManMsgRecord.getCompany());
                }
                this.topManMsgRecordService.save((Object)topManMsgRecord);
                taskId = topManMsgRecord.getId();
            } else {
                TenantContext.setTenant((String)task.getElsAccount());
                elsSubAccountDTO = this.elsSubAccountApiRpcService.getUserBySubAccount(task.getSubAccount());
                log.info("\u62c9\u53d6\u56de\u590d\u66f4\u65b0\u5bf9\u5e94\u7684elsSubAccountDTO:{}", (Object)JSON.toJSONString((Object)elsSubAccountDTO));
                if (ObjectUtil.isNotEmpty((Object)elsSubAccountDTO)) {
                    dbRecord.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCodeByUserId(elsSubAccountDTO.getId()));
                    log.info("\u62c9\u53d6\u56de\u590d\u66f4\u65b0\u5bf9\u5e94\u7684company:{}", (Object)dbRecord.getCompany());
                    this.topManMsgRecordService.updateById((Object)dbRecord);
                }
                taskId = dbRecord.getId();
            }
            ArrayList dbHis = Lists.newArrayList();
            if (CollUtil.isNotEmpty((Collection)msgTypes.get("2"))) {
                for (int i = 0; i < msgs.size(); ++i) {
                    if (!"2".equals(msgs.get(i).getChatUserType()) || i != msgs.size() - 1 && "2".equals(msgs.get(i + 1).getChatUserType()) || !this.checkHisRepeat(msgs.get(i).getMsg(), msgs.get(i).getTime(), null, null, taskId)) continue;
                    TopManMsgRecordHis topManMsgRecordHis = new TopManMsgRecordHis();
                    topManMsgRecordHis.setSendMsgContent(msgs.get(i).getMsg());
                    topManMsgRecordHis.setElsAccount(task.getElsAccount());
                    topManMsgRecordHis.setSubAccount(task.getSubAccount());
                    topManMsgRecordHis.setPlatform(task.getPlatform());
                    topManMsgRecordHis.setTaskId(taskId);
                    topManMsgRecordHis.setSendTime(msgs.get(i).getTime());
                    boolean flag = false;
                    StrBuilder strBuilder = new StrBuilder();
                    for (int j = i + 1; !(j >= msgs.size() || flag && "2".equals(msgs.get(j).getChatUserType())); ++j) {
                        if (strBuilder.length() > 0) {
                            strBuilder.append((CharSequence)";");
                        }
                        if (!"1".equals(msgs.get(j).getChatUserType())) continue;
                        topManMsgRecordHis.setReplyTime(msgs.get(j).getTime());
                        strBuilder.append((CharSequence)msgs.get(j).getMsg());
                        flag = true;
                    }
                    topManMsgRecordHis.setReplyContent(strBuilder.toString());
                    dbHis.add(topManMsgRecordHis);
                }
            } else {
                for (TopManMsgReplyDto.Msg msg1 : msg.getMsgList()) {
                    if (!this.checkHisRepeat(null, null, msg1.getMsg(), msg1.getTime(), taskId)) continue;
                    TopManMsgRecordHis his = new TopManMsgRecordHis();
                    his.setReplyContent(msg1.getMsg());
                    his.setTaskId(taskId);
                    his.setElsAccount(task.getElsAccount());
                    his.setSubAccount(task.getSubAccount());
                    his.setPlatform(task.getPlatform());
                    his.setReplyTime(msg1.getTime());
                    dbHis.add(his);
                }
            }
            if (CollUtil.isNotEmpty((Collection)dbHis)) {
                this.recordHisService.saveBatch(dbHis);
            }
        }
    }

    @Override
    public String checkIsAdded(TopManMsgRecord x) {
        return ((TopManMsgRecordMapper)this.baseMapper).checkIsAdded(x);
    }

    @Override
    public void addReply(TopManMsgRecord topManMsgRecord) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgRecord.getReplyContent()), (String)"\u56de\u590d\u80fd\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgRecord.getReplyTime()), (String)"\u56de\u590d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        topManMsgRecord.setReplyStatus("1");
        this.updateById((Object)topManMsgRecord);
        List his = this.recordHisService.list((Wrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)topManMsgRecord.getId()));
        if (CollUtil.isEmpty((Collection)his)) {
            return;
        }
        for (TopManMsgRecordHis hi : his) {
            hi.setReplyContent(topManMsgRecord.getReplyContent());
            hi.setReplyTime(topManMsgRecord.getReplyTime());
            hi.setReplyStatus("1");
        }
        this.recordHisService.updateBatchById(his);
    }

    @Override
    public List<TopManMsgRecord> getDmRecords(String toElsAccount, TouchAppAuthTypeEnum touchAppAuthTypeEnum) {
        List topManMsgTasks;
        Map<String, String> maps;
        ArrayList records = Lists.newArrayList();
        int limit = 5;
        List topManMsgConfig = this.topManMsgConfigService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)toElsAccount)).eq(TopManMsgConfig::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).eq(TopManMsgConfig::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform())).eq(BaseEntity::getDeleted, (Object)"0"));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)topManMsgConfig), (String)"\u8bf7\u5148\u5230pc\u7aef\u914d\u7f6e\u3010\u81ea\u52a8\u6d88\u606f\u3011");
        List subs = topManMsgConfig.stream().map(x -> x.getSubAccount()).distinct().collect(Collectors.toList());
        records.addAll(this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)toElsAccount)).eq(TopManMsgRecord::getPush, (Object)"0")).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())).eq(TopManMsgRecord::getSendStatus, (Object)"0")).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).eq(TopManMsgRecord::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform())).in(TopManMsgRecord::getSubAccount, subs)).last("limit " + limit)));
        if ((limit -= records.size()) > 0) {
            records.addAll(this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)toElsAccount)).in(TopManMsgRecord::getFailureCode, DmErrorCodeEnum.getNeedReCode())).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).eq(TopManMsgRecord::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform())).in(TopManMsgRecord::getSubAccount, subs)).eq(TopManMsgRecord::getSendStatus, (Object)"2")).last("and failure_time is not null and TIMESTAMPDIFF(MINUTE,failure_time,NOW())>=1440 limit " + limit)));
        }
        if (ObjectUtil.isNotEmpty(maps = (topManMsgTasks = this.topManMsgTaskService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)toElsAccount)).eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).eq(BaseEntity::getDeleted, (Object)"0")).eq(TopManMsgTask::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform())).in(TopManMsgTask::getSubAccount, subs))).stream().collect(Collectors.toMap(x -> x.getElsAccount() + x.getSubAccount(), y -> y.getId()))) && CollUtil.isNotEmpty((Collection)records)) {
            for (TopManMsgRecord record : records) {
                if (!StrUtil.isBlank((CharSequence)record.getTaskId())) continue;
                record.setTaskId(maps.get(record.getElsAccount() + record.getSubAccount()));
            }
            return records;
        }
        if (limit > 0) {
            Assert.isTrue((records.size() > 0 || CollUtil.isNotEmpty((Collection)topManMsgTasks) ? 1 : 0) != 0, (String)"\u8bf7\u5148\u5230pc\u7aef\u8bbe\u7f6e\u68c0\u7d22\u6761\u4ef6\u6216\u5efa\u8054\u8fbe\u4eba");
            if (CollUtil.isNotEmpty((Collection)topManMsgTasks)) {
                List taskIds = topManMsgTasks.stream().map(x -> x.getId()).collect(Collectors.toList());
                List dbRs = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSendStatus, (Object)"0")).eq(TopManMsgRecord::getPush, (Object)"0")).eq(TopManMsgRecord::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform())).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode())).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).in(TopManMsgRecord::getTaskId, taskIds)).orderByAsc(TopManMsgRecord::getSubAdd)).last("limit " + limit));
                limit -= dbRs.size();
                records.addAll(dbRs);
                if (CollUtil.isNotEmpty((Collection)records)) {
                    return records;
                }
                if (limit > 0) {
                    for (TopManMsgTask topManMsgTask : topManMsgTasks) {
                        String filterInfoJson = topManMsgTask.getFilterInfoJson();
                        ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
                        if (limit <= 0 || !StrUtil.isNotBlank((CharSequence)filterInfoJson)) continue;
                        try {
                            List<TopManMsgRecord> searchList = adapter.getSearchData(filterInfoJson, topManMsgTask, limit);
                            for (TopManMsgRecord x2 : searchList) {
                                String code;
                                if ("1".equals(touchAppAuthTypeEnum.getPlatform()) && StrUtil.isNotBlank((CharSequence)(code = this.douYinUtil.getDouYinId(x2.getTopmanName(), x2.getAvatar(), x2.getTopmanId())))) {
                                    x2.setTopmanCode(code);
                                    x2.setSubAccount(topManMsgTask.getSubAccount());
                                    x2.setTaskId(topManMsgTask.getId());
                                }
                                x2.setTouchType(MsgTouchTypeEnum.DM.getCode());
                                records.add(x2);
                                if ((limit -= records.size()) > 0) continue;
                                return records;
                            }
                        }
                        catch (Exception e) {
                            log.error("\u89e6\u8fbe\u65f6\u68c0\u7d22\u5f02\u5e38:", (Throwable)e);
                        }
                    }
                }
            }
        }
        return records;
    }

    private boolean checkHisRepeat(String sendMsg, String sengTime, String replyMsg, String replyTime, String recordId) {
        return this.recordHisService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)recordId)).eq(StrUtil.isNotBlank((CharSequence)sendMsg), TopManMsgRecordHis::getSendMsgContent, (Object)sendMsg)).eq(StrUtil.isNotBlank((CharSequence)sengTime), TopManMsgRecordHis::getSendTime, (Object)sengTime)).eq(StrUtil.isNotBlank((CharSequence)replyMsg), TopManMsgRecordHis::getReplyContent, (Object)replyMsg)).eq(StrUtil.isNotBlank((CharSequence)replyTime), TopManMsgRecordHis::getReplyTime, (Object)replyTime)) == 0;
    }

    public TopManMsgRecord getRecordByUid(String uid, String avatar, String topManName, TopManMsgTask topManMsgTask) {
        String accountDouYin;
        TopManMsgRecord record;
        block12: {
            record = null;
            DouYinTopManDetailBaseInfoEntity baseInfo = null;
            accountDouYin = null;
            try {
                baseInfo = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_BASE_INFO, Collections.singletonMap("uid", uid), DouYinTopManDetailBaseInfoEntity.class);
                accountDouYin = baseInfo.getAccountDouyin();
            }
            catch (Exception e) {
                log.error("name:{}uid:{}\u83b7\u53d6\u6296\u97f3id\u5f02\u5e38{}", new Object[]{topManName, uid, e.getMessage()});
                if ("\u6682\u672a\u5165\u9a7b\u8fbe\u4eba\u5e7f\u573a\uff0c\u65e0\u6cd5\u67e5\u770b\u8fbe\u4eba\u4fe1\u606f".equals(e.getMessage())) {
                    return null;
                }
                log.error("getRecordByUid error", (Throwable)e);
            }
            if (ObjectUtil.isEmpty((Object)baseInfo) || StrUtil.isEmpty((CharSequence)accountDouYin)) {
                try {
                    if (StrUtil.isEmpty((CharSequence)avatar)) {
                        log.error("topManName:{}uid:{}\u5934\u50cf\u53c2\u6570\u4e3a\u7a7a", (Object)topManName, (Object)uid);
                        return null;
                    }
                    DouYinIDList response = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_GET_DOU_YIN_ID, Collections.singletonMap("topman_name", topManName), DouYinIDList.class);
                    if (!ObjectUtil.isNotEmpty((Object)response)) break block12;
                    List<DouYinIDList.DyIDResult> dyIDResults = response.getResult();
                    for (DouYinIDList.DyIDResult dyIDResult : dyIDResults) {
                        String uri = dyIDResult.getUser_info().getAvatar_thumb().getUri();
                        String[] uris = uri.split("/");
                        String endUri = uris[uris.length - 1];
                        if (!avatar.contains(endUri)) continue;
                        accountDouYin = dyIDResult.getUser_info().getUnique_id();
                        break;
                    }
                }
                catch (Exception e) {
                    log.error("DOU_YIN_GET_DOU_YIN_ID error", (Throwable)e);
                }
            }
        }
        if (StrUtil.isNotBlank((CharSequence)accountDouYin)) {
            HashMap apiParam = Maps.newHashMap();
            apiParam.put("type", "1");
            apiParam.put("page", "1");
            apiParam.put("refresh", "true");
            apiParam.put("req_source", "0");
            apiParam.put("options", Maps.newHashMap());
            apiParam.put("search_id", "");
            apiParam.put("search_source", "");
            apiParam.put("query", accountDouYin);
            apiParam.put("act_id", "");
            DouYinTopManIndexListPage apiResult = null;
            try {
                apiResult = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_INDEX_LIST, apiParam, DouYinTopManIndexListPage.class);
            }
            catch (Exception e) {
                log.error("DOU_YIN_INDEX_LIST error", (Throwable)e);
            }
            if (ObjectUtil.isNotEmpty((Object)apiResult) && CollUtil.isNotEmpty(apiResult.getList())) {
                record = MsgConvertUtil.convertDyList(topManMsgTask, null, apiResult.getList().get(0));
            }
            System.out.println("accountDouYin:" + apiResult);
        }
        return record;
    }
}

