/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.common.spider.spiderApi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static boolean isjson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return false;
        }
        try {
            new JsonParser().parse(json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String mapToJson(Map<String, Object> map) {
        Gson gson = new Gson();
        return gson.toJson(map, Map.class);
    }

    public static Map<String, Object> jsontoMap(String json) {
        Gson gson = new Gson();
        return JsonUtils.toMap(JsonUtils.parseJson(json));
    }

    public static JsonObject parseJson(String json) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObj = parser.parse(json).getAsJsonObject();
        return jsonObj;
    }

    public static Map<String, Object> toMap(JsonObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set entrySet = json.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JsonArray) {
                map.put(key, JsonUtils.toList((JsonArray)value));
                continue;
            }
            if (value instanceof JsonObject) {
                map.put(key, JsonUtils.toMap((JsonObject)value));
                continue;
            }
            String putValue = value + "";
            String text = putValue.replace("\"", "");
            map.put(key, text);
        }
        return map;
    }

    public static List<Object> toList(JsonArray json) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < json.size(); ++i) {
            JsonElement value = json.get(i);
            if (value instanceof JsonArray) {
                list.add(JsonUtils.toList((JsonArray)value));
                continue;
            }
            if (value instanceof JsonObject) {
                list.add(JsonUtils.toMap((JsonObject)value));
                continue;
            }
            list.add(value);
        }
        return list;
    }

    public static String getRedisKey(Map query) {
        LinkedHashMap linkedMap = new LinkedHashMap();
        linkedMap.putAll(query);
        Set keySet = linkedMap.keySet();
        String defi = "";
        for (Object key : keySet) {
            Object value = linkedMap.get(key);
            defi = defi + key;
            defi = defi + value;
        }
        if ("".equals(defi)) {
            return "";
        }
        return JsonUtils.SHA1(defi);
    }

    private static String SHA1(String decript) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(decript.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

