/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.goods.entity.GoodsCategory;
import com.els.modules.goods.service.GoodsCategoryService;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class GoodsCategoryJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(GoodsCategoryJob.class);
    private final String GOODS_CATEGORY = "tb_doudian_category";
    private final int BATCH_SIZE = 5000;
    @Autowired
    private GoodsCategoryService goodsCategoryService;
    @Resource
    private MongoTemplate mongoTemplate;

    public void execute(String parameter) {
        log.info("------------start GoodsCategoryJob-----------");
        boolean i = false;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_category").find().noCursorTimeout(true).batchSize(5000).cursor();){
            ArrayList<List<GoodsCategory>> allList = new ArrayList<List<GoodsCategory>>(10);
            ArrayList<GoodsCategory> entityList = new ArrayList<GoodsCategory>(1000);
            allList.add(entityList);
            GoodsCategory frontCategory = new GoodsCategory();
            frontCategory.setId("1");
            frontCategory.setCategoryId("1");
            frontCategory.setTitle("\u5546\u54c1\u5206\u7c7b:");
            frontCategory.setLevel("0");
            frontCategory.setParentId("0");
            frontCategory.setStatus("0");
            frontCategory.setElsAccount("100000");
            frontCategory.setCreateBy("admin");
            frontCategory.setCreateTime(new Date());
            frontCategory.setUpdateTime(new Date());
            frontCategory.setUpdateBy("admin");
            frontCategory.setDeleted(0);
            frontCategory.setSortOrder(0);
            entityList.add(frontCategory);
            log.info("------------start GoodsCategoryJob111111 -----------1");
            int nIndex = 0;
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                try {
                    List nList = (List)allList.get(nIndex);
                    GoodsCategory category = this.genOrganization(doc);
                    nList.add(category);
                    if (nList.size() != 1000) continue;
                    ++nIndex;
                    allList.add(new ArrayList(1000));
                }
                catch (Exception e) {
                    log.error("GoodsCategoryJob error ", (Throwable)e);
                }
            }
            this.goodsCategoryService.insertBatch(allList);
        }
        catch (Exception e) {
            log.error("GoodsCategoryJob error", (Throwable)e);
        }
    }

    private GoodsCategory genOrganization(Document doc) {
        GoodsCategory category = new GoodsCategory();
        category.setId(doc.getString((Object)"_id"));
        category.setCategoryId(doc.getString((Object)"category_id"));
        category.setTitle(doc.getString((Object)"category_name"));
        category.setLevel(doc.getString((Object)"level"));
        category.setParentId(doc.getString((Object)"parent_id").equals("0") ? "1" : doc.getString((Object)"parent_id"));
        category.setDescription(doc.getString((Object)"level").equals("1") ? "cascader" : null);
        category.setStatus("0");
        category.setElsAccount("100000");
        category.setCreateBy("admin");
        category.setCreateTime(new Date());
        category.setUpdateTime(new Date());
        category.setUpdateBy("admin");
        category.setDeleted(0);
        category.setSortOrder(0);
        return category;
    }
}

