/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.BigDecimalUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.topman.entity.PromotionalDataHead;
import com.els.modules.topman.entity.PromotionalDataItem;
import com.els.modules.topman.service.PromotionalDataHeadService;
import com.els.modules.topman.service.PromotionalDataItemService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="promotionalDataItemImportExcelHandler")
public class PromotionalDataItemImportExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PromotionalDataHeadService promotionalDataHeadService;
    @Autowired
    private PromotionalDataItemService promotionalDataItemService;

    @SrmTransaction(rollbackFor={Exception.class})
    public List<Map<String, Object>> importExcel(ExcelImportDTO var1) {
        List dataList = var1.getDataList();
        int totalCount = 0 == var1.getTotalCount() ? dataList.size() : var1.getTotalCount();
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a"));
        ArrayList adds = Lists.newArrayList();
        HashSet oldIds = Sets.newHashSet((Object[])new String[0]);
        String elsAccount = TenantContext.getTenant();
        int index = 1;
        StringBuffer stringBuffer = new StringBuffer();
        HashMap headCheck = Maps.newHashMap();
        HashMap headMaps = Maps.newHashMap();
        HashSet orderSets = Sets.newHashSet((Object[])new String[0]);
        for (Map data : dataList) {
            PromotionalDataItem entity = (PromotionalDataItem)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PromotionalDataItem.class));
            PromotionalDataHead head = this.promotionalDataHeadService.selectOneByOnlyParam(entity.getSubAccount(), entity.getCountYear(), entity.getCountMonth(), elsAccount);
            entity.setImportFlag(true);
            if (head == null) {
                this.getIndexTips(index, stringBuffer);
                stringBuffer.append("\u672a\u627e\u5230\u8be5\u5458\u5de5\u5728[" + entity.getCountYear() + "\u5e74" + entity.getCountMonth() + "\u6708]\u7684\u7edf\u8ba1\u6570\u636e;");
                ++index;
                continue;
            }
            Calendar date = Calendar.getInstance();
            date.setTime(entity.getOrderTime());
            Integer orderYear = date.get(1);
            Integer orderMonth = date.get(2) + 1;
            if (!orderYear.equals(head.getCountYear()) || !orderMonth.equals(head.getCountMonth())) {
                this.getIndexTips(index, stringBuffer);
                stringBuffer.append("\u8ba2\u5355\u65e5\u671f\u4e0d\u5728\u5934\u6570\u636e\u7684\u7edf\u8ba1\u5e74\u6708\u5185;");
            }
            if (orderSets.contains(entity.getOrderNo())) {
                this.getIndexTips(index, stringBuffer);
                stringBuffer.append("\u8ba2\u5355\u53f7\u91cd\u590d;");
            }
            orderSets.add(entity.getOrderNo());
            ++index;
            if (!headCheck.containsKey(head.getId())) {
                BigDecimal c = Optional.ofNullable(head.getCommissionSalesVol()).orElse(BigDecimal.ZERO);
                BigDecimal p = Optional.ofNullable(head.getProAllianceSalesVol()).orElse(BigDecimal.ZERO);
                BigDecimal o = Optional.ofNullable(head.getOrgSalesVol()).orElse(BigDecimal.ZERO);
                BigDecimal s = Optional.ofNullable(head.getStarMapSalesVol()).orElse(BigDecimal.ZERO);
                headCheck.put(head.getId(), c.add(p).add(o).add(s));
                headMaps.put(head.getId(), head);
            }
            String orderNo = entity.getOrderNo();
            PromotionalDataItem db = (PromotionalDataItem)((Object)this.promotionalDataItemService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PromotionalDataItem::getHeadId, (Object)head.getId())).eq(PromotionalDataItem::getOrderNo, (Object)orderNo)));
            if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
                oldIds.add(db.getId());
            }
            entity.setHeadId(head.getId());
            if (StrUtil.isBlank((CharSequence)entity.getDeptNo())) {
                entity.setDeptNo(head.getDeptNo());
            }
            if (StrUtil.isBlank((CharSequence)entity.getDeptName())) {
                entity.setDeptName(head.getDeptName());
            }
            adds.add(entity);
        }
        HashMap countMap = Maps.newHashMap();
        if (headCheck.size() > 0) {
            List<PromotionalDataItem> dbItems = this.promotionalDataItemService.listByHeadIds(headCheck.keySet());
            dbItems.addAll(adds);
            Map<String, List<PromotionalDataItem>> maps = dbItems.stream().collect(Collectors.groupingBy(PromotionalDataItem::getHeadId));
            maps.forEach((k, v) -> {
                HashSet orderNos = Sets.newHashSet((Object[])new String[0]);
                v.stream().sorted(Comparator.comparing(PromotionalDataItem::isImportFlag).reversed());
                v.forEach(x -> {
                    if (!orderNos.contains(x.getOrderNo())) {
                        if (countMap.get(k) == null) {
                            countMap.put(k, BigDecimal.ZERO);
                        }
                        countMap.put(k, ((BigDecimal)countMap.get(k)).add(x.getOrderVal()));
                    }
                    orderNos.add(x.getOrderNo());
                });
            });
            headCheck.forEach((k, v) -> {
                if (BigDecimalUtils.lessThan((BigDecimal)v, (BigDecimal)Optional.of(countMap.get(k)).orElse(BigDecimal.ZERO))) {
                    PromotionalDataHead headData = (PromotionalDataHead)((Object)((Object)headMaps.get(k)));
                    stringBuffer.append("\u5458\u5de5\u5b50\u8d26\u53f7[" + headData.getSubAccount() + "]");
                    stringBuffer.append("\u7edf\u8ba1\u5e74" + headData.getCountYear() + "\u7edf\u8ba1\u6708" + headData.getCountMonth());
                    stringBuffer.append("\u8ba2\u5355\u989d\u5927\u4e8e\u5934\u6570\u636e\u7684\u91d1\u989d;");
                }
            });
        }
        if (StrUtil.isNotBlank((CharSequence)stringBuffer.toString())) {
            Assert.isTrue((boolean)false, (String)stringBuffer.toString());
        }
        if (CollUtil.isNotEmpty((Collection)adds)) {
            if (CollUtil.isNotEmpty((Collection)oldIds)) {
                this.promotionalDataItemService.removeByIds(oldIds);
            }
            this.promotionalDataItemService.saveBatch(adds);
        }
        this.errorHandle(true, var1, TenantContext.getTenant(), totalCount);
        return dataList;
    }

    private void getIndexTips(int index, StringBuffer stringBuffer) {
        String indexStr = "\u7b2c[" + index + "]\u6761\u6570\u636e\u9519\u8bef:";
        if (!stringBuffer.toString().contains(indexStr)) {
            stringBuffer.append("\u7b2c[");
            stringBuffer.append(index);
            stringBuffer.append("]\u6761\u6570\u636e\u9519\u8bef:");
        }
    }
}

