/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.service.JobRpcService;
import com.els.modules.common.utils.RedissonUtil;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.enumerate.MsgTouchTypeEnum;
import com.els.modules.touch.service.TopManMsgTaskService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TopManMsgSmsJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgSmsJob.class);
    @Resource
    private TopManMsgTaskService topManMsgTaskService;
    @Resource
    private RedissonUtil redissonUtil;

    public void execute(String parameter) {
        log.info("------------start TopManMsgSmsJob -----------");
        List tasks = this.topManMsgTaskService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getStatus, (Object)"1")).eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.SMS.getCode()));
        if (CollUtil.isNotEmpty((Collection)tasks)) {
            log.info("sms\u81ea\u52a8\u89e6\u8fbe\u5f00\u59cb\u6267\u884c:{}", (Object)JSON.toJSONString((Object)tasks));
            tasks.forEach(task -> {
                long time = 120L;
                RLock lock = this.redissonUtil.lock("topman_sms_touch_lock:" + task.getMsgId(), (Long)time);
                try {
                    if (ObjectUtil.isNotEmpty((Object)lock)) {
                        this.topManMsgTaskService.smsStartUp((TopManMsgTask)((Object)task));
                        lock.unlock();
                    }
                }
                catch (Exception e) {
                    log.error("handle TopManMsgSmsJob error ,account[{}],platform[{}]", new Object[]{task.getPlatformAccount(), task.getPlatform(), e});
                    lock.unlock();
                }
            });
        }
        log.info("------------end TopManMsgJob-----------");
    }
}

