/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.industryInfo.api.optiondic.McnInstitutionalOptionSource;
import com.els.modules.industryInfo.api.weboption.OptionComponentType;
import com.els.modules.organ.entity.McnInstitutionalHeadEntity;
import com.els.modules.organ.entity.McnInstitutionalOptionEntity;
import com.els.modules.organ.entity.McnInstitutionalTopmanEntity;
import com.els.modules.organ.mapper.McnInstitutionalHeadMapper;
import com.els.modules.organ.mapper.McnInstitutionalTopmanMapper;
import com.els.modules.organ.service.McnInstitutionalHeadService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McnInstitutionalHeadServiceImpl
extends ServiceImpl<McnInstitutionalHeadMapper, McnInstitutionalHeadEntity>
implements McnInstitutionalHeadService {
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private McnInstitutionalTopmanMapper topManMapper;

    @Override
    public void saveMcnInstitutional(McnInstitutionalHeadEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)entity.getUserId());
        McnInstitutionalHeadEntity query = (McnInstitutionalHeadEntity)((McnInstitutionalHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
        if (query != null) {
            entity.setId(query.getId());
            QueryWrapper topmanWrapper = new QueryWrapper();
            topmanWrapper.eq((Object)"head_id", (Object)query.getId());
            this.topManMapper.delete((Wrapper)topmanWrapper);
            ((McnInstitutionalHeadMapper)this.baseMapper).updateById(entity);
        } else {
            ((McnInstitutionalHeadMapper)this.baseMapper).insert(entity);
        }
        List topMans = JSON.parseArray((String)entity.getTopmans(), McnInstitutionalTopmanEntity.class);
        if (topMans != null) {
            for (McnInstitutionalTopmanEntity topman : topMans) {
                topman.setHeadId(entity.getId());
                this.topManMapper.insert(topman);
            }
        }
    }

    @Override
    public IPage<McnInstitutionalHeadEntity> pageMcnList(Page<McnInstitutionalHeadEntity> page, McnInstitutionalHeadEntity dto) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String keyWord = dto.getKeyWord();
        String topmanNums = dto.getAuthorTags();
        if (topmanNums != null) {
            String[] numbsTag = topmanNums.split("-");
            if (numbsTag.length > 0) {
                dto.setAuthorNumMin(new BigDecimal(numbsTag[0]));
            }
            if (numbsTag.length > 1) {
                dto.setAuthorNumMax(new BigDecimal(numbsTag[1]));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getKeyWord())) {
            queryWrapper.like((Object)"name", (Object)keyWord);
        }
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        IPage<McnInstitutionalHeadEntity> result = ((McnInstitutionalHeadMapper)this.baseMapper).pageMcnList((IPage<McnInstitutionalHeadEntity>)page, dto, (Wrapper<McnInstitutionalHeadEntity>)queryWrapper, TenantContext.getTenant(), company);
        for (McnInstitutionalHeadEntity inst : result.getRecords()) {
            HashMap<String, String> topmanMap = new HashMap<String, String>();
            topmanMap.put("head_id", inst.getId());
            List topmans = this.topManMapper.selectByMap(topmanMap);
            inst.setTopMansInfo(topmans);
        }
        return result;
    }

    @Override
    public List<McnInstitutionalOptionEntity> getOptions(String type, String clearCache) {
        ArrayList<McnInstitutionalOptionEntity> result = new ArrayList<McnInstitutionalOptionEntity>();
        McnInstitutionalOptionEntity cata = new McnInstitutionalOptionEntity();
        cata.setSort(1);
        cata.setFieldName("\u673a\u6784\u5206\u7c7b");
        cata.setFieldName("authorTags");
        cata.setTitle("\u673a\u6784\u5206\u7c7b");
        ArrayList<McnInstitutionalOptionEntity.Tag> children = new ArrayList<McnInstitutionalOptionEntity.Tag>();
        for (String key : McnInstitutionalOptionSource.category.keySet()) {
            McnInstitutionalOptionEntity.Tag childrenTag = new McnInstitutionalOptionEntity.Tag();
            childrenTag.setComponentType(OptionComponentType.RButton);
            childrenTag.setStarTagId(key);
            childrenTag.setStarTagName((String)McnInstitutionalOptionSource.category.get(key));
            childrenTag.setStarTagValue(key);
            children.add(childrenTag);
        }
        cata.setChildren(children);
        result.add(cata);
        McnInstitutionalOptionEntity topnums = new McnInstitutionalOptionEntity();
        topnums.setSort(2);
        topnums.setFieldName("\u8fbe\u4eba\u89c4\u6a21");
        topnums.setFieldName("authorNum");
        topnums.setTitle("\u8fbe\u4eba\u89c4\u6a21");
        ArrayList<McnInstitutionalOptionEntity.Tag> topNum = new ArrayList<McnInstitutionalOptionEntity.Tag>();
        for (String key : McnInstitutionalOptionSource.topmanNums.keySet()) {
            McnInstitutionalOptionEntity.Tag childrenTag = new McnInstitutionalOptionEntity.Tag();
            childrenTag.setComponentType(OptionComponentType.RButton);
            childrenTag.setStarTagId(key);
            childrenTag.setStarTagName((String)McnInstitutionalOptionSource.topmanNums.get(key));
            childrenTag.setStarTagValue(key);
            topNum.add(childrenTag);
        }
        topnums.setChildren(topNum);
        result.add(topnums);
        return result;
    }
}

