/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.msg;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.Adapter;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.barcode.rpc.service.ElsSubAccountApiRpcService;
import com.els.modules.common.spider.entity.DouYinTopManIndexListPage;
import com.els.modules.common.spider.entity.DouYinTopManInfoEntity;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.properties.TopManMsgProperties;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.utils.MsgConvertUtil;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import com.els.modules.topman.service.DouYinTopManService;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.msg.TopManMsgAdapter;
import com.els.modules.touch.service.TopManMsgRecordService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"1"})
public class DouYinMsgAdapter
extends TopManMsgAdapter {
    private static final Logger log = LoggerFactory.getLogger(DouYinMsgAdapter.class);
    @Autowired
    private DouYinTopManService topManInformationService;
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private ElsSubAccountApiRpcService elsSubAccountApiRpcService;

    @Override
    public List<TopManMsgRecord> getSearchData(String filterInfoJson, TopManMsgTask topManMsgTask, int limitSize) {
        SimplePostRequestParam topManDto = new SimplePostRequestParam();
        RequestOptionVO requestOptionVO = new RequestOptionVO();
        JSONObject jsonObject = JSON.parseObject((String)filterInfoJson);
        JSONObject f = jsonObject.getJSONObject("filterInfo");
        requestOptionVO.setTaskType(f.getString("taskType"));
        requestOptionVO.setPlatformType(f.getString("platformType"));
        JSONObject screen = f.getJSONObject("screenItem");
        HashMap screenItem = Maps.newHashMap();
        AtomicBoolean emptyFlag = new AtomicBoolean(true);
        screen.keySet().forEach(key -> {
            JSONArray jsonArray = screen.getJSONArray(key);
            List screenItems = jsonArray.toJavaList(RequestOptionVO.ScreenItem.class);
            if (CollUtil.isNotEmpty((Collection)screenItems)) {
                emptyFlag.set(false);
            }
            screenItem.put(key, screenItems);
        });
        requestOptionVO.setScreenItem((Map)screenItem);
        topManDto.setFilterInfo((Object)requestOptionVO);
        topManDto.setKeyWord(f.getString("keyWord"));
        if (StrUtil.isBlank((CharSequence)f.getString("keyWord")) && emptyFlag.get()) {
            return Lists.newArrayList();
        }
        ArrayList searchList = this.handleDouYinListData(filterInfoJson, (SimplePostRequestParam<RequestOptionVO>)topManDto, topManMsgTask, limitSize);
        return CollUtil.isNotEmpty(searchList) ? searchList : Lists.newArrayList();
    }

    private List<TopManMsgRecord> handleDouYinListData(String filterInfoJson, SimplePostRequestParam<RequestOptionVO> topManDto, TopManMsgTask task, int limit) {
        ArrayList list = Lists.newArrayList();
        List oldTaskRecord = this.topManMsgRecordService.list((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)task.getElsAccount()));
        List oldTopManNames = oldTaskRecord.stream().map(x -> x.getTopmanName()).distinct().collect(Collectors.toList());
        int total = this.topManMsgProperties.getPageSize();
        int totalData = 0;
        int pageNo = 1;
        boolean endFlag = true;
        while (endFlag) {
            topManDto.setPageNo(Integer.valueOf(pageNo));
            topManDto.setPageSize(Integer.valueOf(total));
            Map<String, Object> apiParam = this.topManInformationService.getApiParam(topManDto);
            DouYinTopManIndexListPage apiResult = this.spiderApiUtil.postForEntity(SpiderMethodType.DOU_YIN_INDEX_LIST, apiParam, DouYinTopManIndexListPage.class);
            if (ObjectUtil.isNotEmpty((Object)apiResult) && ObjectUtil.isNotEmpty((Object)apiResult.getTotal()) && (long)list.size() == apiResult.getTotal()) {
                return list;
            }
            if (ObjectUtil.isNotEmpty((Object)apiResult) && CollUtil.isNotEmpty(apiResult.getList())) {
                ++pageNo;
                for (DouYinTopManInfoEntity apiData : apiResult.getList()) {
                    if (ObjectUtil.isEmpty((Object)apiData.getAuthorBase()) || ObjectUtil.isEmpty((Object)apiData.getAuthorBase().getNickname()) || oldTopManNames.contains(apiData.getAuthorBase().getNickname())) continue;
                    if (totalData >= limit) {
                        return list;
                    }
                    oldTopManNames.add(apiData.getAuthorBase().getNickname());
                    TopManMsgRecord record = MsgConvertUtil.convertDyList(task, filterInfoJson, apiData);
                    record.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCode());
                    if (StrUtil.isBlank((CharSequence)record.getCompany())) {
                        TenantContext.setTenant((String)task.getElsAccount());
                        ElsSubAccountDTO elsSubAccountDTO = this.elsSubAccountApiRpcService.getUserBySubAccount(task.getSubAccount());
                        if (ObjectUtil.isNotEmpty((Object)elsSubAccountDTO)) {
                            record.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCodeByUserId(elsSubAccountDTO.getId()));
                        }
                        TenantContext.clear();
                    }
                    list.add(record);
                    ++totalData;
                }
                continue;
            }
            return list;
        }
        return list;
    }
}

