/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.touch.dto.DmAuthRq;
import com.els.modules.touch.entity.DmAuthConfig;
import com.els.modules.touch.entity.TouchAppAuth;
import com.els.modules.touch.mapper.DmAuthConfigMapper;
import com.els.modules.touch.service.DmAuthConfigService;
import com.els.modules.touch.service.TouchAppAuthService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DmAuthConfigServiceImpl
extends BaseServiceImpl<DmAuthConfigMapper, DmAuthConfig>
implements DmAuthConfigService {
    @Autowired
    @Lazy
    private TouchAppAuthService touchAppAuthService;

    @Override
    public void add(DmAuthConfig dmAuthConfig) {
        ((DmAuthConfigMapper)this.baseMapper).insert((Object)dmAuthConfig);
    }

    @Override
    public void edit(DmAuthConfig dmAuthConfig) {
        int count = ((DmAuthConfigMapper)this.baseMapper).updateById((Object)dmAuthConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((DmAuthConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((DmAuthConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<Map> getCompany() {
        return ((DmAuthConfigMapper)this.baseMapper).getCompany(TenantContext.getTenant());
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveConfig(DmAuthRq dmAuthRq) {
        ArrayList dbs = Lists.newArrayList();
        dmAuthRq.getDmAuthConfigs().forEach(row -> {
            TouchAppAuth auth = (TouchAppAuth)((Object)((Object)this.touchAppAuthService.getOne((Wrapper)Wrappers.lambdaQuery().eq(TouchAppAuth::getAuthNo, (Object)row.getAuthCode()))));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)auth)), (String)(row.getAuthCode() + "\u6388\u6743\u7801\u672a\u627e\u5230"));
            DmAuthConfig config = new DmAuthConfig();
            if (CollUtil.isNotEmpty(row.getSubCompany())) {
                config.setSubCompany(row.getSubCompany().stream().collect(Collectors.joining(",")));
            }
            if (CollUtil.isNotEmpty(row.getSubAccount())) {
                config.setSubAccount(row.getSubAccount().stream().collect(Collectors.joining(",")));
            }
            config.setAuthCode(row.getAuthCode());
            config.setElsAccount(TenantContext.getTenant());
            config.setId(null);
            dbs.add(config);
        });
        this.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant()));
        this.saveBatch(dbs);
    }

    @Override
    public DmAuthConfig getByElsAccount(String toElsAccount) {
        return (DmAuthConfig)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)toElsAccount), false));
    }
}

