/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.system.service.DictService;
import com.els.modules.touch.entity.SmsTemplate;
import com.els.modules.touch.entity.TopManMsgConfigItem;
import com.els.modules.touch.mapper.SmsTemplateMapper;
import com.els.modules.touch.service.SmsTemplateService;
import com.els.modules.touch.service.TopManMsgConfigItemService;
import com.els.modules.touch.util.StringAssembler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SmsTemplateServiceImpl
extends BaseServiceImpl<SmsTemplateMapper, SmsTemplate>
implements SmsTemplateService {
    @Autowired
    private DictService dictService;
    @Autowired
    private TopManMsgConfigItemService topManMsgConfigItemService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void add(SmsTemplate smsTemplate) {
        ((SmsTemplateMapper)this.baseMapper).insert((Object)smsTemplate);
        List dicts = this.dictService.queryDictItemsByCode("smsTemplateFieldName", "100000", "1");
        Map<String, String> dictMap = dicts.stream().collect(Collectors.toMap(x -> x.getValue(), y -> y.getText()));
        List<String> params = StringAssembler.getParams(smsTemplate.getSmsTemplate());
        ArrayList items = Lists.newArrayList();
        int i = 0;
        for (String v : params) {
            TopManMsgConfigItem item = new TopManMsgConfigItem();
            item.setSort(i++);
            item.setHeadId(smsTemplate.getId());
            item.setCanSet(Boolean.TRUE);
            item.setField(v);
            item.setFieldName(Optional.ofNullable(dictMap.get(v)).orElse(v));
            items.add(item);
        }
        this.topManMsgConfigItemService.saveBatch(items);
    }

    @Override
    public void edit(SmsTemplate smsTemplate) {
        int count = ((SmsTemplateMapper)this.baseMapper).updateById((Object)smsTemplate);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SmsTemplateMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SmsTemplateMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void switchAuthStatus(String id) {
        SmsTemplate template = (SmsTemplate)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtil.isNotEmpty((Object)((Object)template))) {
            template.setTemplateStatus("0".equals(template.getTemplateStatus()) ? "1" : "0");
            this.updateById((Object)template);
        }
    }
}

