/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.controller;

import com.els.common.annotation.ApiCallCount;
import com.els.common.api.vo.Result;
import com.els.modules.goods.dto.GoodsDTO;
import com.els.modules.goods.service.GoodsService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/industryinfo/goods"})
@Api(tags={"\u5546\u54c1"})
public class GoodsController {
    private static final Logger log = LoggerFactory.getLogger(GoodsController.class);
    @Autowired
    private GoodsService goodsService;

    @GetMapping(value={"/searchItems"})
    public Result<?> searchItems() throws Exception {
        return Result.ok(this.goodsService.searchItems());
    }

    @GetMapping(value={"/clearCache"})
    public Result<?> clearCache(@RequestParam Map query) throws Exception {
        return Result.ok((String)this.goodsService.clearCache(query));
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4fe1\u606f", notes="\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/searchGoosList"})
    public Result<?> searchGoosList(@RequestBody Map query) throws Exception {
        return Result.ok(this.goodsService.searchPromotion(query));
    }

    @ApiOperation(value="\u5546\u54c1\u5217\u8868-\u8fd130\u5929", notes="\u5546\u54c1\u5217\u8868-\u8fd130\u5929")
    @PostMapping(value={"/list"})
    @ApiCallCount(apiCode="industry_goods_list_data")
    public Result<?> searchList(@RequestBody SimplePostRequestParam<GoodsDTO> param) {
        return Result.ok(this.goodsService.searchList(param));
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u8be6\u7ec6\u4fe1\u606f", notes="\u67e5\u8be2\u5546\u54c1\u8be6\u7ec6\u4fe1\u606f")
    @PostMapping(value={"/searchGoodsInfo"})
    @ApiCallCount(apiCode="industry_goods_detail_data")
    public Result<?> searchGoodsInfo(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)((Object)this.goodsService.searchGoodsDetails(goods)));
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u76f4\u64ad\u4fe1\u606f", notes="\u67e5\u8be2\u5546\u54c1\u76f4\u64ad\u4fe1\u606f")
    @PostMapping(value={"/searchGoodsLive"})
    public Result<?> searchGoodsLive(@RequestBody Map goods) throws Exception {
        return Result.ok(this.goodsService.getGoodsLive(goods));
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u89c6\u9891", notes="\u67e5\u8be2\u5546\u54c1\u89c6\u9891")
    @PostMapping(value={"/searchGoodsAweme"})
    public Result<?> searchGoodsAweme(@RequestBody Map goods) throws Exception {
        return Result.ok(this.goodsService.getGoodsAweme(goods));
    }

    @ApiOperation(value="\u67e5\u8be2\u7b5b\u9009\u6807\u7b7e\u4e0e\u6392\u5e8f\u6761\u4ef6", notes="\u67e5\u8be2\u7b5b\u9009\u6807\u7b7e\u4e0e\u6392\u5e8f\u6761\u4ef6")
    @PostMapping(value={"/searchGoodsTopManItem"})
    public Result<?> searchGoodsTopManItem(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)this.goodsService.getGoodsTopManItem(goods));
    }

    @ApiOperation(value="\u67e5\u8be2\u7c7b\u578b\u4e0e\u54c1\u724c\u7c7b", notes="\u67e5\u8be2\u7c7b\u578b\u4e0e\u54c1\u724c\u7c7b")
    @PostMapping(value={"/searchAnalysisTypes"})
    public Result<?> searchAnalysisTypes(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)this.goodsService.getAnalysisTypes(goods));
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u8fbe\u4eba\u5206\u6790", notes="\u67e5\u8be2\u5546\u54c1\u8fbe\u4eba\u5206\u6790")
    @PostMapping(value={"/searchGoodsTopManAnalysis"})
    public Result<?> searchGoodsTopManAnalysis(@RequestBody Map goods) throws Exception {
        return Result.ok(this.goodsService.getGoodsTopManAnalysis(goods));
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u6bcf\u65e5\u8d8b\u52bf", notes="\u67e5\u8be2\u5546\u54c1\u6bcf\u65e5\u8d8b\u52bf")
    @PostMapping(value={"/searchGoodsTrend"})
    public Result<?> searchGoodsTrend(@RequestBody Map goods) throws Exception {
        return Result.ok((Object)this.goodsService.getGoodsOverviewTrend(goods));
    }
}

