/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.common.utils;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.modules.common.spider.entity.DouYinTopManInfoEntity;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.enumerate.MsgTopManSourceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MsgConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(MsgConvertUtil.class);

    public static TopManMsgRecord convertDyList(TopManMsgTask task, String filterInfoJson, DouYinTopManInfoEntity apiData) {
        TopManMsgRecord topManMsgRecord = new TopManMsgRecord();
        topManMsgRecord.setTaskId(task.getId());
        topManMsgRecord.setPlatform(task.getPlatform());
        topManMsgRecord.setDeleted(CommonConstant.STATUS_NO);
        topManMsgRecord.setSubAdd(MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode());
        topManMsgRecord.setElsAccount(task.getElsAccount());
        topManMsgRecord.setSubAccount(task.getSubAccount());
        topManMsgRecord.setSearchContext(filterInfoJson);
        DouYinTopManInfoEntity.AuthorBase authorBase = apiData.getAuthorBase();
        topManMsgRecord.setTopmanLevel(authorBase.getAuthorLevel().toString());
        topManMsgRecord.setTopmanSex(authorBase.getGender().toString());
        topManMsgRecord.setSendStatus("0");
        topManMsgRecord.setReplyStatus("0");
        topManMsgRecord.setSendCount(0);
        topManMsgRecord.setReplyCount(0);
        topManMsgRecord.setTopmanRegion(authorBase.getCity());
        topManMsgRecord.setId(IdWorker.getIdStr());
        topManMsgRecord.setTopmanId(authorBase.getUid());
        topManMsgRecord.setTopmanName(authorBase.getNickname());
        DouYinTopManInfoEntity.AuthorSale authorSale = apiData.getAuthorSale();
        topManMsgRecord.setSaleD30High(authorSale.getSaleD30High());
        topManMsgRecord.setSaleD30Low(authorSale.getSaleD30Low());
        DouYinTopManInfoEntity.AuthorLive authorLive = apiData.getAuthorLive();
        topManMsgRecord.setLiveGpmHigh(authorLive.getGpmHigh());
        topManMsgRecord.setLiveGpmLow(authorLive.getGpmLow());
        topManMsgRecord.setLiveSaleHigh(authorLive.getSaleHigh());
        topManMsgRecord.setLiveSaleLow(authorLive.getSaleLow());
        DouYinTopManInfoEntity.AuthorVideo authorVideo = apiData.getAuthorVideo();
        topManMsgRecord.setVideoGpmHigh(authorVideo.getGpmHigh());
        topManMsgRecord.setVideoGpmLow(authorVideo.getGpmLow());
        topManMsgRecord.setVideoSaleHigh(authorVideo.getVideoSaleHigh());
        topManMsgRecord.setVideoSaleLow(authorVideo.getVideoSaleLow());
        topManMsgRecord.setPlayMedian(authorVideo.getPlayMedian());
        topManMsgRecord.setAvatar(authorBase.getAvatar().replaceAll("-sign", ""));
        if (ObjectUtil.isNotEmpty((Object)authorBase.getFansNum())) {
            topManMsgRecord.setFansNum(authorBase.getFansNum().toString());
        }
        if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorVideo()) && ObjectUtil.isNotEmpty((Object)apiData.getAuthorVideo().getPlayMedian())) {
            topManMsgRecord.setVideoPlayAvg(apiData.getAuthorVideo().getPlayMedian().toString());
        }
        if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive())) {
            if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getWatchingNumber())) {
                topManMsgRecord.setWatchingNumber(apiData.getAuthorLive().getWatchingNumber().toString());
            }
            if (ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getSaleLow()) && ObjectUtil.isNotEmpty((Object)apiData.getAuthorLive().getSaleHigh())) {
                topManMsgRecord.setLiveSaleAvg(apiData.getAuthorLive().getSaleLow().toString() + " - " + apiData.getAuthorLive().getSaleHigh());
            }
        }
        return topManMsgRecord;
    }
}

