/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.topman.entity.PerRewardHead;
import com.els.modules.topman.entity.PerRewardItem;
import com.els.modules.topman.service.CommRewardRuleHeadService;
import com.els.modules.topman.service.PerRewardHeadService;
import com.els.modules.topman.service.PerRewardItemService;
import com.els.modules.topman.vo.PerRewardVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ee9\u6548\u5956\u52b1\u5934"})
@RestController
@RequestMapping(value={"/perRewardHead"})
public class PerRewardHeadController
extends BaseController<PerRewardHead, PerRewardHeadService> {
    @Autowired
    private PerRewardHeadService perRewardHeadService;
    @Autowired
    private PerRewardItemService itemService;
    @Autowired
    private CommRewardRuleHeadService commRewardRuleHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="performanCecommission")
    public Result<?> queryPageList(PerRewardHead perRewardHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)perRewardHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        if (StrUtil.isNotBlank((CharSequence)perRewardHead.getCountYearQuery())) {
            queryWrapper.eq((Object)"count_year", (Object)perRewardHead.getCountYearQuery());
        }
        if (StrUtil.isNotBlank((CharSequence)perRewardHead.getCountMonthQuery())) {
            queryWrapper.eq((Object)"count_month", (Object)perRewardHead.getCountMonthQuery());
        }
        IPage pageList = this.perRewardHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u7ee9\u6548\u5956\u52b1\u5934-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PerRewardHead perRewardHead) {
        this.perRewardHeadService.add(perRewardHead);
        return Result.ok((Object)((Object)perRewardHead));
    }

    @AutoLog(value="\u7ee9\u6548\u5956\u52b1\u5934-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PerRewardHead perRewardHead) {
        this.perRewardHeadService.edit(perRewardHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7ee9\u6548\u5956\u52b1\u5934-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.perRewardHeadService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ee9\u6548\u5956\u52b1\u5934-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.perRewardHeadService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PerRewardHead perRewardHead = (PerRewardHead)((Object)this.perRewardHeadService.getById((Serializable)((Object)id)));
        PerRewardVo vo = new PerRewardVo();
        BeanUtil.copyProperties((Object)((Object)perRewardHead), (Object)((Object)vo), (String[])new String[0]);
        List<PerRewardItem> items = this.itemService.listByHeadId(id);
        items.forEach(row -> {
            if (StrUtil.isNotBlank((CharSequence)row.getRewardRate())) {
                row.setRewardRate(this.commRewardRuleHeadService.handleRewardShow(row.getRewardRate()));
            }
        });
        vo.setItems(items);
        return Result.ok((Object)((Object)vo));
    }

    @GetMapping(value={"/statistics"})
    public Result<?> statistics(@RequestParam(name="startTime") String startTime, @RequestParam(name="endTime") String endTime) {
        this.perRewardHeadService.statistics(startTime, endTime);
        return Result.ok();
    }
}

