/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.annotation.McnLog;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.common.utils.RedissonUtil;
import com.els.modules.touch.dto.TouchAppRq;
import com.els.modules.touch.entity.TouchAppAuth;
import com.els.modules.touch.enumerate.TouchAppAuthTypeEnum;
import com.els.modules.touch.service.TouchAppAuthService;
import com.els.modules.touch.util.EncryptAesUtil;
import com.els.modules.touch.vo.TouchAppAuthVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79df\u6237\u89e6\u8fbe\u6388\u6743\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/msg/touchAppAuth"})
public class TouchAppAuthController
extends BaseController<TouchAppAuth, TouchAppAuthService> {
    @Autowired
    private TouchAppAuthService touchAppAuthService;
    @Autowired
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(TouchAppAuth touchAppAuth, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)touchAppAuth), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.touchAppAuthService.page((IPage)page, (Wrapper)queryWrapper);
        Page pageVo = new Page();
        BeanUtil.copyProperties((Object)pageList, (Object)pageVo, (String[])new String[0]);
        if (ObjectUtil.isNotEmpty((Object)pageList) && CollUtil.isNotEmpty((Collection)pageList.getRecords())) {
            ArrayList vos = Lists.newArrayList();
            pageList.getRecords().forEach(x -> {
                ArrayList desc = Lists.newArrayList();
                for (String s : x.getAuthType().split(",")) {
                    desc.add(TouchAppAuthTypeEnum.getDescByCode(s));
                }
                TouchAppAuthVo vo = new TouchAppAuthVo();
                BeanUtil.copyProperties((Object)x, (Object)((Object)vo), (String[])new String[0]);
                vo.setAuthTypeArr(desc.stream().collect(Collectors.joining(",")));
                vos.add(vo);
            });
            pageVo.setRecords((List)vos);
        }
        return Result.ok((Object)pageVo);
    }

    @GetMapping(value={"/getAuthCode"})
    public Result<?> queryPageList(@RequestParam(value="toElsAccount") String toElsAccount) {
        String code = ((TouchAppAuthService)this.service).getAuthCode(toElsAccount);
        return Result.ok((String)code);
    }

    @AutoLog(value="\u79df\u6237\u89e6\u8fbe\u6388\u6743\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TouchAppAuth touchAppAuth) {
        this.touchAppAuthService.add(touchAppAuth);
        return Result.ok((Object)((Object)touchAppAuth));
    }

    @AutoLog(value="\u79df\u6237\u89e6\u8fbe\u6388\u6743\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u542f\u52a8/\u505c\u7528", notes="\u6dfb\u52a0")
    @GetMapping(value={"/switchAuthStatus"})
    public Result<?> switchAuthStatus(@RequestParam(value="id") String id) {
        this.touchAppAuthService.switchAuthStatus(id);
        return Result.ok();
    }

    @AutoLog(value="\u79df\u6237\u89e6\u8fbe\u6388\u6743\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TouchAppAuth touchAppAuth) {
        this.touchAppAuthService.edit(touchAppAuth);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u79df\u6237\u89e6\u8fbe\u6388\u6743\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.touchAppAuthService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u79df\u6237\u89e6\u8fbe\u6388\u6743\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.touchAppAuthService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TouchAppAuth touchAppAuth = (TouchAppAuth)((Object)this.touchAppAuthService.getById((Serializable)((Object)id)));
        ArrayList desc = Lists.newArrayList();
        for (String s : touchAppAuth.getAuthType().split(",")) {
            desc.add(TouchAppAuthTypeEnum.getDescByCode(s));
        }
        TouchAppAuthVo vo = new TouchAppAuthVo();
        BeanUtil.copyProperties((Object)((Object)touchAppAuth), (Object)((Object)vo), (String[])new String[0]);
        vo.setAuthTypeArr(desc.stream().collect(Collectors.joining(",")));
        return Result.ok((Object)((Object)vo));
    }

    @PostMapping(value={"/app/queryByAuthCode"})
    @McnLog(apiName="\u6388\u6743\u7801-\u67e5\u8be2")
    public Result<?> queryByAuthCode(@RequestBody TouchAppRq.TouchAppRqBase touchAppRqBase, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, touchAppRqBase.getAuthCode());
        TouchAppAuth touchAppAuth = this.touchAppAuthService.getByAuthCode(touchAppRqBase.getAuthCode());
        ArrayList desc = Lists.newArrayList();
        for (String s : touchAppAuth.getAuthType().split(",")) {
            desc.add(TouchAppAuthTypeEnum.getDescByCode(s));
        }
        TouchAppAuthVo vo = new TouchAppAuthVo();
        BeanUtil.copyProperties((Object)((Object)touchAppAuth), (Object)((Object)vo), (String[])new String[0]);
        vo.setAuthTypeArr(desc.stream().collect(Collectors.joining(",")));
        return Result.ok((Object)((Object)vo));
    }

    @PostMapping(value={"/app/binding"})
    @McnLog(apiName="\u79c1\u4fe1\u89e6\u8fbe-\u7ed1\u5b9a")
    public Result<?> binding(@RequestBody TouchAppRq.TouchAppRqBind rq, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getTerminalMachine()), (String)"\u7ec8\u7aef\u673a\u5668\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.touchAppAuthService.binding(rq);
        return Result.ok();
    }

    @PostMapping(value={"/app/un_binding"})
    @McnLog(apiName="\u79c1\u4fe1\u89e6\u8fbe-\u89e3\u7ed1")
    public Result<?> unBinding(@RequestBody TouchAppRq.TouchAppRqBind rq, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.touchAppAuthService.unBinding(rq);
        return Result.ok();
    }

    @GetMapping(value={"/un_binding"})
    public Result<?> pageUnBinding(@RequestParam(name="id") String id) {
        this.touchAppAuthService.pageUnBinding(id);
        return Result.ok();
    }

    @PostMapping(value={"/app/startUp"})
    @McnLog(apiName="\u79c1\u4fe1\u89e6\u8fbe-\u542f\u52a8")
    public Result<?> startUp(@RequestBody TouchAppRq.TouchAppRqBind rq, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.touchAppAuthService.startUp(rq);
    }

    @PostMapping(value={"/app/stop"})
    @McnLog(apiName="\u79c1\u4fe1\u89e6\u8fbe-\u505c\u6b62")
    public Result<?> stop(@RequestBody TouchAppRq.TouchAppRqBind rq, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.touchAppAuthService.stop(rq);
        return Result.ok();
    }

    @PostMapping(value={"/app/getMsg"})
    @McnLog(apiName="\u79c1\u4fe1\u89e6\u8fbe-\u83b7\u53d6\u8fbe\u4eba\u6d88\u606f")
    public Result<?> getMsg(@RequestBody TouchAppRq.TouchAppRqBind rq, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        long time = 180L;
        RLock lock = this.redissonUtil.lock("dm_msg_lock_" + rq.getAuthCode() + rq.getAuthType(), (Long)time);
        List<Object> list = Lists.newArrayList();
        try {
            if (ObjectUtil.isNotEmpty((Object)lock)) {
                list = this.touchAppAuthService.getMsg(rq);
                lock.unlock();
            }
        }
        catch (Exception e) {
            lock.unlock();
            return Result.error((String)e.getMessage());
        }
        return Result.ok((Object)list);
    }

    @PostMapping(value={"/app/notice"})
    @McnLog(apiName="\u79c1\u4fe1\u89e6\u8fbe-\u6d88\u606f\u901a\u77e5")
    public Result<?> notice(@RequestBody TouchAppRq.TouchAppRqNotify rq, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.touchAppAuthService.notice(rq);
        return Result.ok();
    }

    @PostMapping(value={"/app/reply"})
    @McnLog(apiName="\u79c1\u4fe1\u89e6\u8fbe-\u56de\u590d\u901a\u77e5")
    public Result<?> reply(@RequestBody TouchAppRq.TouchAppRqNotify rq, @RequestHeader(value="authCode") String authCode) {
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.touchAppAuthService.handleReply(rq, rq.getAuthCode());
        return Result.ok();
    }
}

