/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.touch.dto.PdAppRp;
import com.els.modules.touch.dto.PdAppRq;
import com.els.modules.touch.entity.PdCustomerHead;
import com.els.modules.touch.entity.PdCustomerItem;
import com.els.modules.touch.entity.PdMsgConfig;
import com.els.modules.touch.entity.TouchAppAuth;
import com.els.modules.touch.enumerate.ClueStageEnum;
import com.els.modules.touch.enumerate.TouchAppAuthTypeEnum;
import com.els.modules.touch.mapper.PdCustomerHeadMapper;
import com.els.modules.touch.service.PdCustomerHeadService;
import com.els.modules.touch.service.PdCustomerItemService;
import com.els.modules.touch.service.PdMsgConfigService;
import com.els.modules.touch.service.TouchAppAuthService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PdCustomerHeadServiceImpl
extends BaseServiceImpl<PdCustomerHeadMapper, PdCustomerHead>
implements PdCustomerHeadService {
    private static final Logger log = LoggerFactory.getLogger(PdCustomerHeadServiceImpl.class);
    @Autowired
    private TouchAppAuthService touchAppAuthService;
    @Autowired
    private PdCustomerItemService pdCustomerItemService;
    @Autowired
    private PdMsgConfigService pdMsgConfigService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;

    @Override
    public void add(PdCustomerHead pdCustomerHead) {
        ((PdCustomerHeadMapper)this.baseMapper).insert((Object)pdCustomerHead);
    }

    @Override
    public void edit(PdCustomerHead pdCustomerHead) {
        int count = ((PdCustomerHeadMapper)this.baseMapper).updateById((Object)pdCustomerHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PdCustomerHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PdCustomerHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<PdAppRp.MsgRp> receive(PdAppRq.Receive rq) {
        ArrayList result = Lists.newArrayList();
        TouchAppAuth appAuth = this.touchAppAuthService.getByAuthCode(rq.getAuthCode());
        String elsAccount = appAuth.getToElsAccount();
        Assert.isTrue((boolean)ObjectUtil.equals((Object)"1", (Object)appAuth.getStartupStatus()), (String)"\u6388\u6743\u7801\u672a\u542f\u52a8");
        List<PdAppRq.Customer> customers = rq.getCustomers();
        Assert.isTrue((boolean)CollUtil.isNotEmpty(customers), (String)"\u76d1\u63a7\u5ba2\u6237\u4e3a\u7a7a");
        List<String> customerIds = customers.stream().map(x -> x.getCustomerId()).distinct().collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isNotEmpty(customerIds), (String)"\u76d1\u63a7\u5ba2\u6237\u4e3a\u7a7a");
        TouchAppAuthTypeEnum authTypeEnum = TouchAppAuthTypeEnum.getByCode(rq.getAuthType());
        List msgConfigs = this.pdMsgConfigService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PdMsgConfig::getPlatform, (Object)authTypeEnum.getPlatform())).eq(PdMsgConfig::getAuthCode, (Object)appAuth.getAuthNo()));
        Map<String, PdMsgConfig> msgConfigMap = msgConfigs.stream().collect(Collectors.toMap(x -> x.getId(), y -> y));
        Map<Integer, PdMsgConfig> sortMsgConfigMap = msgConfigs.stream().collect(Collectors.toMap(x -> x.getSortNum(), y -> y));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)msgConfigs), (String)"\u8bf7\u5148\u5230pc\u7aef\u8bbe\u7f6e\u83b7\u5ba2\u914d\u7f6e");
        List heads = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PdCustomerHead::getPlatform, (Object)authTypeEnum.getPlatform())).in(PdCustomerHead::getCustomerId, customerIds));
        Map<Object, Object> customerMap = Maps.newHashMap();
        if (CollUtil.isNotEmpty((Collection)heads)) {
            customerMap = heads.stream().collect(Collectors.toMap(x -> x.getCustomerId(), y -> y));
        }
        for (PdAppRq.Customer customer : customers) {
            String oldMsgId = null;
            PdCustomerHead oldDb = (PdCustomerHead)((Object)customerMap.get(customer.getCustomerId()));
            PdCustomerHead pdCustomerHead = new PdCustomerHead();
            if (ObjectUtil.isNotEmpty((Object)((Object)oldDb))) {
                pdCustomerHead.setId(oldDb.getId());
                oldMsgId = oldDb.getMsgId();
            } else {
                BeanUtil.copyProperties((Object)((Object)customer), (Object)((Object)pdCustomerHead), (String[])new String[0]);
                pdCustomerHead.setId(IdWorker.getIdStr());
                pdCustomerHead.setElsAccount(elsAccount);
                pdCustomerHead.setCompany(this.subaccountOrgRpcService.getSubaccountOrgCode());
            }
            this.saveOrUpdate((Object)pdCustomerHead);
            if (CollUtil.isNotEmpty(customer.getBehaviors())) {
                customer.getBehaviors().forEach(c -> {
                    PdCustomerItem item = (PdCustomerItem)((Object)((Object)this.pdCustomerItemService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PdCustomerItem::getCustomerId, (Object)customer.getCustomerId())).eq(PdCustomerItem::getAttentionType, (Object)c.getAttentionType())).eq(PdCustomerItem::getContentLinks, (Object)c.getContentLinks())).eq(PdCustomerItem::getAttentionMode, (Object)c.getAttentionMode())).eq(BaseEntity::getElsAccount, (Object)elsAccount), false)));
                    if (ObjectUtil.isEmpty((Object)((Object)item))) {
                        c.setElsAccount(elsAccount);
                        c.setHeadId(pdCustomerHead.getId());
                        this.pdCustomerItemService.save(c);
                    }
                });
            }
            PdAppRp.MsgRp var = new PdAppRp.MsgRp();
            if (StrUtil.isNotBlank((CharSequence)oldMsgId)) {
                PdMsgConfig m1 = msgConfigMap.get(oldMsgId);
                if (ObjectUtil.isEmpty((Object)((Object)m1))) {
                    log.error("{}\u65e7\u6d88\u606f\u914d\u7f6e\u5df2\u4e0d\u5b58\u5728", (Object)customer.getCustomerName());
                    continue;
                }
                PdMsgConfig m2 = sortMsgConfigMap.get(m1.getSortNum() + 1);
                if (ObjectUtil.isEmpty((Object)((Object)m2))) {
                    if (!ObjectUtil.isNotEmpty((Object)pdCustomerHead.getLastContactTime()) || !ObjectUtil.isNotEmpty((Object)m1.getResetNum())) continue;
                    long betweenDay = DateUtil.between((Date)new Date(), (Date)pdCustomerHead.getLastContactTime(), (DateUnit)DateUnit.DAY);
                    if (betweenDay >= (long)m1.getResetNum().intValue()) {
                        PdMsgConfig m3 = sortMsgConfigMap.get(1);
                        var.setMsgId(m3.getId());
                        var.setContent(m3.getMsgContent());
                    }
                } else {
                    var.setMsgId(m2.getId());
                    var.setContent(m2.getMsgContent());
                }
            } else {
                PdMsgConfig m = sortMsgConfigMap.get(1);
                var.setMsgId(m.getId());
                var.setContent(m.getMsgContent());
            }
            var.setId(pdCustomerHead.getId());
            var.setCustomerId(pdCustomerHead.getCustomerId());
            result.add(var);
        }
        this.pdCustomerItemService.updateNum(elsAccount, customerIds);
        return result;
    }

    @Override
    public void msgStatus(PdAppRq.MsgStatus rq) {
        PdMsgConfig msgConfig;
        PdCustomerHead head = (PdCustomerHead)((Object)this.getById((Serializable)((Object)rq.getId())));
        if (ObjectUtil.isNotEmpty((Object)((Object)head)) && ObjectUtil.isNotEmpty((Object)((Object)(msgConfig = (PdMsgConfig)((Object)this.pdMsgConfigService.getById((Serializable)((Object)rq.getMsgId()))))))) {
            head.setLastContent(msgConfig.getMsgContent());
            head.setLastContactTime(rq.getOptTime());
            head.setMsgId(rq.getMsgId());
            head.setClueStage(ClueStageEnum.SEND.getCode());
            this.updateById((Object)head);
        }
    }

    @Override
    public void reply(PdAppRq.MsgReply rq) {
        TouchAppAuth appAuth = this.touchAppAuthService.getByAuthCode(rq.getAuthCode());
        String elsAccount = appAuth.getToElsAccount();
        List heads = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PdCustomerHead::getDeleted, (Object)"0")).eq(PdCustomerHead::getPlatform, (Object)rq.getPlatform())).eq(PdCustomerHead::getCustomerId, (Object)rq.getCustomerId()));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)heads), (String)"customerId\u5f02\u5e38");
        heads.forEach(head -> {
            head.setLastReply(rq.getMsgContent());
            head.setLastContactTime(rq.getOptTime());
            head.setClueStage(ClueStageEnum.GET_REPLY.getCode());
            this.updateById(head);
        });
    }
}

