/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.touch.entity.PdQrcodeConfig;
import com.els.modules.touch.mapper.PdQrcodeConfigMapper;
import com.els.modules.touch.service.PdQrcodeConfigService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PdQrcodeConfigServiceImpl
extends BaseServiceImpl<PdQrcodeConfigMapper, PdQrcodeConfig>
implements PdQrcodeConfigService {
    @Autowired
    private PurchaseAttachmentService purchaseAttachmentService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @Override
    public void add(PdQrcodeConfig pdQrcodeConfig) {
        ((PdQrcodeConfigMapper)this.baseMapper).insert((Object)pdQrcodeConfig);
    }

    @Override
    public void edit(PdQrcodeConfig pdQrcodeConfig) {
        int count = ((PdQrcodeConfigMapper)this.baseMapper).updateById((Object)pdQrcodeConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PdQrcodeConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PdQrcodeConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveConfig(PdQrcodeConfig config) {
        PurchaseAttachment attachment;
        String elsAccount = TenantContext.getTenant();
        PdQrcodeConfig db = this.getByCode(elsAccount, config.getPlatform());
        String oldFileId = null;
        if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
            oldFileId = db.getFileId();
        } else {
            db = new PdQrcodeConfig();
        }
        db.setQrcodePath(config.getQrcodePath());
        db.setFileId(config.getFileId());
        db.setPlatform(config.getPlatform());
        db.setTipsContent(config.getTipsContent());
        this.saveOrUpdate((Object)db);
        if (StrUtil.isNotBlank((CharSequence)oldFileId) && ObjectUtil.isNotEmpty((Object)(attachment = (PurchaseAttachment)this.purchaseAttachmentService.getById((Serializable)((Object)oldFileId))))) {
            this.fileStoreSignServiceImpl.delete(attachment.getFilePath(), attachment.getSaveType());
            this.purchaseAttachmentService.delPurchaseAttachment(oldFileId);
        }
    }

    @Override
    public PdQrcodeConfig getByCode(String elsAccount, String platform) {
        return (PdQrcodeConfig)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PdQrcodeConfig::getPlatform, (Object)platform)).eq(BaseEntity::getDeleted, (Object)"0")));
    }
}

