/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.common.utils;

import java.math.BigDecimal;

public class NumberConverterUtil {
    public static String numToAbbrConverter(String num) {
        if (num.contains("-")) {
            String[] split = num.split("-");
            return NumberConverterUtil.numToAbbrConverterSub(split[0]) + "-" + NumberConverterUtil.numToAbbrConverterSub(split[1]);
        }
        return NumberConverterUtil.numToAbbrConverterSub(num);
    }

    private static String numToAbbrConverterSub(String num) {
        if (num.length() >= 5 && num.length() < 9) {
            BigDecimal divide = new BigDecimal(num).divide(new BigDecimal(10000), 1, 4);
            return divide.stripTrailingZeros().toPlainString() + "w";
        }
        if (num.length() >= 9) {
            BigDecimal divide = new BigDecimal(num).divide(new BigDecimal(100000000), 1, 4);
            return divide.stripTrailingZeros().toPlainString() + "\u4ebf";
        }
        return num;
    }

    public static String abbrToNumConverter(String abbr) {
        if (abbr.contains("-")) {
            String[] split = abbr.split("-");
            return NumberConverterUtil.abbrToNumConverterSub(split[0]) + "-" + NumberConverterUtil.abbrToNumConverterSub(split[1]);
        }
        return NumberConverterUtil.abbrToNumConverterSub(abbr);
    }

    private static String abbrToNumConverterSub(String num) {
        if (num.contains("w")) {
            String w = num.split("w")[0];
            BigDecimal multiply = new BigDecimal(w).multiply(new BigDecimal(10000));
            return multiply.stripTrailingZeros().toPlainString();
        }
        if (num.contains("\u4ebf")) {
            String ww = num.split("\u4ebf")[0];
            BigDecimal multiply = new BigDecimal(ww).multiply(new BigDecimal(100000000));
            return multiply.stripTrailingZeros().toPlainString();
        }
        return num;
    }
}

