/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.common.spider.entity.DouYinTopManDetailBaseInfoEntity;
import com.els.modules.common.spider.entity.TopManDetailDouYinIdEntity;
import com.els.modules.common.spider.entity.TopManDetailDouYinMcnEntity;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DouYinUtil {
    private static final Logger log = LoggerFactory.getLogger(DouYinUtil.class);
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private SpiderApiUtil spiderApiUtil;

    public static String subAvatar(String avatar) {
        if (avatar.contains("avatar/") && avatar.contains(".jpeg")) {
            return avatar.substring(avatar.lastIndexOf("avatar/") + 7, avatar.indexOf(".jpeg"));
        }
        return null;
    }

    public String getDouYinId(String topManName, String avatar, String uid) {
        Serializable entity2;
        if (StrUtil.isBlank((CharSequence)topManName) || StrUtil.isBlank((CharSequence)avatar)) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)(avatar = DouYinUtil.subAvatar(avatar)))) {
            return null;
        }
        String redisKey = "dy_topman_id" + topManName + avatar;
        if (this.redisUtil.hasKey(redisKey)) {
            return (String)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> keyParam = new HashMap<String, Object>(1);
        keyParam.put("avatar", avatar);
        try {
            HashMap<String, Object> requestParam = new HashMap<String, Object>(1);
            requestParam.put("uid", uid);
            DouYinTopManDetailBaseInfoEntity baseInfo = this.spiderApiUtil.getForEntityDouYin(SpiderMethodType.DOU_YIN_BASE_INFO, keyParam, requestParam, DouYinTopManDetailBaseInfoEntity.class);
            if (ObjectUtil.isNotEmpty((Object)baseInfo) && StrUtil.isNotBlank((CharSequence)baseInfo.getAccountDouyin())) {
                this.redisUtil.set(redisKey, (Object)baseInfo.getAccountDouyin());
                return baseInfo.getAccountDouyin();
            }
        }
        catch (Exception requestParam) {
            // empty catch block
        }
        HashMap<String, Object> paramBean = new HashMap<String, Object>(1);
        paramBean.put("topman_name", topManName);
        try {
            entity2 = this.spiderApiUtil.getForEntityDouYin(SpiderMethodType.DOU_YIN_ID, keyParam, paramBean, TopManDetailDouYinIdEntity.class);
            for (TopManDetailDouYinIdEntity.Result result : ((TopManDetailDouYinIdEntity)entity2).getResult()) {
                TopManDetailDouYinIdEntity.DyUserInfo.AvatarThumb avatarThumb;
                String url;
                String str2;
                TopManDetailDouYinIdEntity.DyUserInfo user = result.getUserInfo();
                if (user == null || !(str2 = (url = (avatarThumb = user.getAvatarThumb()).getUrlList().get(0)).substring(url.lastIndexOf("/"))).contains(avatar)) continue;
                this.redisUtil.set(redisKey, (Object)user.getUniqueId());
                return user.getUniqueId();
            }
        }
        catch (Exception entity2) {
            // empty catch block
        }
        try {
            paramBean.put("topman_name", topManName);
            entity2 = this.spiderApiUtil.getForEntityDouYin(SpiderMethodType.DOU_YIN_CMM, keyParam, paramBean, TopManDetailDouYinMcnEntity.class);
            List<TopManDetailDouYinMcnEntity.Result.UserInfo> list = ((TopManDetailDouYinMcnEntity)entity2).getResult().getList();
            for (TopManDetailDouYinMcnEntity.Result.UserInfo result : list) {
                String url = result.getAvatar();
                String str2 = url.substring(url.lastIndexOf("%2F") + 1);
                if (!str2.contains(avatar)) continue;
                return result.getUniqueId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

