/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.touch.dto.TouchAppRp;
import com.els.modules.touch.dto.TouchAppRq;
import com.els.modules.touch.entity.DmAuthConfig;
import com.els.modules.touch.entity.TopManMsgConfig;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.entity.TopManMsgRecordHis;
import com.els.modules.touch.entity.TouchAppAuth;
import com.els.modules.touch.enumerate.MsgTouchTypeEnum;
import com.els.modules.touch.enumerate.TouchAppAuthTypeEnum;
import com.els.modules.touch.mapper.TouchAppAuthMapper;
import com.els.modules.touch.service.DmAuthConfigService;
import com.els.modules.touch.service.TopManMsgConfigService;
import com.els.modules.touch.service.TopManMsgRecordHisService;
import com.els.modules.touch.service.TopManMsgRecordService;
import com.els.modules.touch.service.TouchAppAuthService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TouchAppAuthServiceImpl
extends BaseServiceImpl<TouchAppAuthMapper, TouchAppAuth>
implements TouchAppAuthService {
    private static final Logger log = LoggerFactory.getLogger(TouchAppAuthServiceImpl.class);
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private TopManMsgConfigService msgConfigService;
    @Autowired
    private TopManMsgRecordHisService topManMsgRecordHisService;
    @Autowired
    @Lazy
    private DmAuthConfigService dmAuthConfigService;

    @Override
    public void add(TouchAppAuth touchAppAuth) {
        touchAppAuth.setStartupStatus("0");
        touchAppAuth.setBindingStatus("0");
        ((TouchAppAuthMapper)this.baseMapper).insert((Object)touchAppAuth);
    }

    @Override
    public void edit(TouchAppAuth touchAppAuth) {
        int count = ((TouchAppAuthMapper)this.baseMapper).updateById((Object)touchAppAuth);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TouchAppAuthMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TouchAppAuthMapper)this.baseMapper).deleteBatchIds(idList);
    }

    public static void main(String[] args) {
        String s = "1";
        System.out.println(String.format("%03d", Integer.valueOf(s)));
    }

    @Override
    public String getAuthCode(String toElsAccount) {
        String code = ((TouchAppAuthMapper)this.baseMapper).getAuthCode(toElsAccount);
        if (StrUtil.isBlank((CharSequence)code)) {
            code = toElsAccount + "-001";
            return code;
        }
        String num = code.split("-")[1];
        Integer count = Integer.valueOf(num) + 1;
        return toElsAccount + "-" + String.format("%03d", count);
    }

    @Override
    public void switchAuthStatus(String id) {
        TouchAppAuth auth = (TouchAppAuth)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtil.isNotEmpty((Object)((Object)auth))) {
            auth.setAuthStatus("0".equals(auth.getAuthStatus()) ? "1" : "0");
            this.updateById((Object)auth);
        }
    }

    @Override
    public TouchAppAuth getByAuthCode(String authCode) {
        TouchAppAuth auth = (TouchAppAuth)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(TouchAppAuth::getAuthNo, (Object)authCode)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)auth)), (String)"\u6388\u6743\u7801\u4e0d\u53ef\u7528");
        Assert.isTrue((boolean)ObjectUtil.equals((Object)auth.getDeleted(), (Object)CommonConstant.NO_0), (String)"\u6388\u6743\u7801\u4e0d\u53ef\u7528");
        Assert.isTrue((boolean)ObjectUtil.equals((Object)auth.getAuthStatus(), (Object)"1"), (String)"\u6388\u6743\u7801\u4e0d\u53ef\u7528");
        return auth;
    }

    @Override
    public void binding(TouchAppRq.TouchAppRqBind rq) {
        TouchAppAuth auth = this.getByAuthCode(rq.getAuthCode());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)auth)), (String)"\u6388\u6743\u7801\u4e0d\u53ef\u7528");
        if (!ObjectUtil.equals((Object)rq.getTerminalMachine(), (Object)auth.getTerminalMachine())) {
            Assert.isTrue((boolean)ObjectUtil.equals((Object)auth.getBindingStatus(), (Object)"0"), (String)"\u4e00\u4e2a\u6388\u6743\u7801\u4e0d\u5141\u8bb8\u540c\u65f6\u7ed1\u5b9a\u591a\u53f0\u624b\u673a\uff0c\u6216\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u534f\u52a9\u89e3\u7ed1");
        }
        auth.setTerminalBrand(rq.getTerminalBrand());
        auth.setTerminalMachine(rq.getTerminalMachine());
        auth.setTerminalModel(rq.getTerminalModel());
        auth.setBindingStatus("1");
        this.updateById((Object)auth);
    }

    @Override
    public void unBinding(TouchAppRq.TouchAppRqBind rq) {
        TouchAppAuth auth = this.getByAuthCode(rq.getAuthCode());
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)auth.getTerminalMachine()), (String)"\u6388\u6743\u7801\u548c\u673a\u5668\u7801\u4e0d\u4e00\u81f4");
        Assert.isTrue((boolean)ObjectUtil.equals((Object)rq.getTerminalMachine(), (Object)auth.getTerminalMachine()), (String)"\u6388\u6743\u7801\u548c\u673a\u5668\u7801\u4e0d\u4e00\u81f4");
        Assert.isTrue((boolean)ObjectUtil.equals((Object)auth.getBindingStatus(), (Object)"1"), (String)"\u6388\u6743\u7801\u5df2\u88ab\u89e3\u7ed1");
        auth.setTerminalBrand(null);
        auth.setTerminalMachine(null);
        auth.setTerminalModel(null);
        auth.setBindingStatus("0");
        this.updateById((Object)auth);
    }

    @Override
    public Result startUp(TouchAppRq.TouchAppRqBind rq) {
        TouchAppAuth auth = this.getByAuthCode(rq.getAuthCode());
        ArrayList tips = Lists.newArrayList();
        ArrayList tipCode = Lists.newArrayList();
        boolean flag = false;
        for (String authCode : rq.getAuthTypes()) {
            if (!Arrays.asList(auth.getAuthType().split(",")).contains(authCode)) {
                tips.add(TouchAppAuthTypeEnum.getDescByCode(authCode));
                tipCode.add(authCode);
                continue;
            }
            flag = true;
        }
        if (flag) {
            auth.setStartupStatus("1");
            this.updateById((Object)auth);
        }
        if (CollUtil.isNotEmpty((Collection)tips)) {
            String v = tips.stream().collect(Collectors.joining(","));
            return Result.ok((String)(v + "\u6ca1\u6709\u6388\u6743\uff0c\u6682\u672a\u542f\u52a8"), (Object)tipCode);
        }
        return Result.ok((String)"\u542f\u52a8\u6210\u529f");
    }

    @Override
    public void stop(TouchAppRq.TouchAppRqBind rq) {
        TouchAppAuth auth = this.getByAuthCode(rq.getAuthCode());
        auth.setStartupStatus("0");
        this.updateById((Object)auth);
    }

    @Override
    public List<TouchAppRp> getMsg(TouchAppRq.TouchAppRqBind rq) {
        TouchAppAuth auth = this.getByAuthCode(rq.getAuthCode());
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)auth.getTerminalMachine()), (String)"\u6388\u6743\u7801\u548c\u673a\u5668\u7801\u4e0d\u4e00\u81f4");
        Assert.isTrue((boolean)ObjectUtil.equals((Object)rq.getTerminalMachine(), (Object)auth.getTerminalMachine()), (String)"\u6388\u6743\u7801\u548c\u673a\u5668\u7801\u4e0d\u4e00\u81f4");
        ArrayList appRqs = Lists.newArrayList();
        if ("1".equals(auth.getStartupStatus())) {
            List topManMsgConfig;
            String toElsAccount = auth.getToElsAccount();
            TouchAppAuthTypeEnum touchAppAuthTypeEnum = TouchAppAuthTypeEnum.getByCode(rq.getAuthType());
            Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)((Object)touchAppAuthTypeEnum)), (String)"\u6388\u6743\u9879\u5f02\u5e38");
            DmAuthConfig dmAuthConfig = this.dmAuthConfigService.getByElsAccount(auth.getToElsAccount());
            ArrayList subs = Lists.newArrayList();
            if (ObjectUtil.isNotEmpty((Object)((Object)dmAuthConfig))) {
                String subCompany = dmAuthConfig.getSubCompany();
                String subAccount = dmAuthConfig.getSubAccount();
                if (StrUtil.isNotBlank((CharSequence)subCompany)) {
                    subs.addAll(this.msgConfigService.getSubAccountByCompany(subCompany, toElsAccount));
                }
                if (StrUtil.isNotBlank((CharSequence)subAccount)) {
                    subs.addAll(Arrays.asList(subAccount.split(",")));
                }
                topManMsgConfig = this.msgConfigService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)toElsAccount)).eq(TopManMsgConfig::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).eq(BaseEntity::getDeleted, (Object)"0")).eq(TopManMsgConfig::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform())).in(CollUtil.isNotEmpty((Collection)subs), TopManMsgConfig::getSubAccount, (Collection)subs));
                Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)topManMsgConfig), (String)"\u6388\u6743\u7801\u7ed1\u5b9a\u9650\u5236\u516c\u53f8\u548c\u5b50\u8d26\u53f7\u540e\uff0c\u672a\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6d88\u606f\u53ef\u53d1\u9001");
            } else {
                topManMsgConfig = this.msgConfigService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)toElsAccount)).eq(TopManMsgConfig::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).eq(BaseEntity::getDeleted, (Object)"0")).eq(TopManMsgConfig::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform()));
                Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)topManMsgConfig), (String)"\u8bf7\u5230pc\u7aef\u8bbe\u7f6e\u6d88\u606f\u914d\u7f6e");
                subs.addAll(topManMsgConfig.stream().map(x -> x.getSubAccount()).distinct().collect(Collectors.toList()));
            }
            List<TopManMsgRecord> records = this.topManMsgRecordService.getDmRecords(toElsAccount, touchAppAuthTypeEnum, subs);
            if (CollUtil.isNotEmpty(records)) {
                log.info("\u79c1\u4fe1\u89e6\u8fbe\u83b7\u53d6\u5230\u8bb0\u5f55:{}", (Object)JSON.toJSONString(records));
                Map<String, List<TopManMsgConfig>> msgMap = topManMsgConfig.stream().collect(Collectors.groupingBy(x -> x.getSubAccount()));
                if (ObjectUtil.isNotEmpty(msgMap)) {
                    log.info("msgMap is {}", (Object)JSON.toJSONString(msgMap));
                }
                ArrayList codes = Lists.newArrayList();
                for (TopManMsgRecord record : records) {
                    record.setTouchType(MsgTouchTypeEnum.DM.getCode());
                    if (codes.contains(record.getTopmanCode())) {
                        this.topManMsgRecordService.removeById((Serializable)((Object)record.getId()));
                        continue;
                    }
                    TouchAppRp appRq = new TouchAppRp();
                    switch (touchAppAuthTypeEnum.getPlatform()) {
                        case "1": {
                            appRq.setTopManId(record.getTopmanCode());
                            break;
                        }
                        case "2": {
                            appRq.setTopManId(record.getTopmanId());
                        }
                    }
                    appRq.setTopManName(record.getTopmanName());
                    ArrayList msgs = Lists.newArrayList();
                    List<TopManMsgConfig> msgConfigs = msgMap.get(record.getSubAccount());
                    log.info("record.getSubAccount is {}", (Object)record.getSubAccount());
                    log.info("msgConfigs is {}", (Object)JSON.toJSONString(msgConfigs));
                    if (CollUtil.isNotEmpty(msgConfigs)) {
                        TopManMsgConfig one = msgConfigs.get(0);
                        TouchAppRp.Msg ms = new TouchAppRp.Msg();
                        TopManMsgRecordHis his = new TopManMsgRecordHis();
                        his.setId(IdWorker.getIdStr());
                        his.setTaskId(record.getId());
                        his.setPlatform(record.getPlatform());
                        his.setSubAccount(record.getSubAccount());
                        his.setMsgType(one.getMsgType());
                        his.setSortNum(1);
                        his.setElsAccount(record.getElsAccount());
                        his.setSendMsgContent(one.getMsgContent());
                        his.setSendMsgId(one.getId());
                        ms.setMsgId(his.getId());
                        ms.setContent(his.getSendMsgContent());
                        record.setPush("1");
                        msgs.add(ms);
                        appRq.setMsgs(msgs);
                        try {
                            if (this.topManMsgRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)record.getElsAccount())).eq(TopManMsgRecord::getSubAccount, (Object)record.getSubAccount())).eq(TopManMsgRecord::getTopmanCode, (Object)record.getTopmanCode())).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.DM.getCode())).eq(TopManMsgRecord::getPlatform, (Object)touchAppAuthTypeEnum.getPlatform())).ne(BaseEntity::getId, (Object)record.getId())) > 0) {
                                log.info("\u5b58\u5728\u76f8\u540c\u8fbe\u4ebaid:{}", (Object)JSON.toJSONString((Object)((Object)record)));
                                if (!StrUtil.isNotBlank((CharSequence)record.getId())) continue;
                                this.topManMsgRecordService.removeById((Serializable)((Object)record.getId()));
                                continue;
                            }
                            this.topManMsgRecordService.saveOrUpdate((Object)record);
                            this.topManMsgRecordHisService.save((Object)his);
                            appRqs.add(appRq);
                            codes.add(record.getTopmanCode());
                        }
                        catch (Exception e) {
                            log.error("\u5904\u7406\u79c1\u4fe1\u6d88\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    log.info("{}\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d88\u606f\u914d\u7f6e", (Object)record.getTopmanCode());
                    record.setFailureCode("4");
                    record.setFailureReason("\u672a\u627e\u5230\u6d88\u606f\u914d\u7f6e");
                    record.setFailureTime(new Date());
                    record.setPush("1");
                    this.topManMsgRecordService.saveOrUpdate((Object)record);
                }
            }
        } else {
            log.info("\u79c1\u4fe1\u89e6\u8fbe\u672a\u5f00\u542f");
        }
        return appRqs;
    }

    @Override
    public void notice(TouchAppRq.TouchAppRqNotify rq) {
        List<TouchAppRq.TouchAppRqNotify.Notify> notifies = rq.getNotifys();
        for (TouchAppRq.TouchAppRqNotify.Notify notify : notifies) {
            TopManMsgRecord record;
            TopManMsgRecordHis his = (TopManMsgRecordHis)((Object)this.topManMsgRecordHisService.getById((Serializable)((Object)notify.getMsgId())));
            if (!ObjectUtil.isNotEmpty((Object)((Object)his))) continue;
            if (notify.isSuccess()) {
                his.setSendTime(DateUtil.formatDateTime((Date)notify.getOptTime()));
                this.topManMsgRecordHisService.updateById((Object)his);
            }
            if (!ObjectUtil.isNotEmpty((Object)((Object)(record = (TopManMsgRecord)((Object)this.topManMsgRecordService.getById((Serializable)((Object)his.getTaskId()))))))) continue;
            if (ObjectUtil.isEmpty((Object)record.getSendTime())) {
                record.setSendTime(notify.getOptTime());
            }
            record.setLateSendTime(notify.getOptTime());
            if (notify.isSuccess()) {
                record.setSendStatus("1");
            } else {
                record.setSendStatus("2");
                record.setFailureReason(notify.getMsg());
                record.setFailureTime(new Date());
                record.setFailureCode(notify.getErrorCode());
            }
            this.topManMsgRecordService.updateById((Object)record);
        }
    }

    @Override
    public void handleReply(TouchAppRq.TouchAppRqNotify rq, String authCode) {
        List<TouchAppRq.TouchAppRqNotify.Reply> replies = rq.getReplys();
        Assert.isTrue((boolean)CollUtil.isNotEmpty(replies), (String)"\u53c2\u6570\u5f02\u5e38");
        TouchAppAuth touchAppAuth = this.getByAuthCode(authCode);
        for (TouchAppRq.TouchAppRqNotify.Reply reply : replies) {
            List records = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTopmanCode, (Object)reply.getTopManId())).eq(BaseEntity::getElsAccount, (Object)touchAppAuth.getToElsAccount()));
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)records), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u8fbe\u4eba");
            records.forEach(record -> {
                if ("1".equals(record.getSendStatus())) {
                    List hisList = this.topManMsgRecordHisService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)record.getId())).orderByDesc(BaseEntity::getCreateTime)).last("limit 1"));
                    Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)hisList), (String)(reply.getTopManId() + "\u6296\u97f3\u53f7\u5f02\u5e38,\u672a\u627e\u5230\u6570\u636e"));
                    TopManMsgRecordHis his = (TopManMsgRecordHis)((Object)((Object)hisList.get(0)));
                    if (StrUtil.isNotBlank((CharSequence)reply.getMsgContent())) {
                        his.setReplyStatus("1");
                        his.setReplyContent(reply.getMsgContent());
                        his.setReplyTime(DateUtil.formatTime((Date)reply.getOptTime()));
                        this.topManMsgRecordHisService.updateById((Object)his);
                    }
                    record.setReplyContent(reply.getMsgContent());
                    record.setReplyStatus("1");
                    record.setReplyTime(DateUtil.formatTime((Date)reply.getOptTime()));
                    this.topManMsgRecordService.updateById(record);
                }
            });
        }
    }

    @Override
    public void pageUnBinding(String id) {
        TouchAppAuth auth = (TouchAppAuth)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.equals((Object)auth.getBindingStatus(), (Object)"1"), (String)"\u6388\u6743\u7801\u5df2\u88ab\u89e3\u7ed1");
        auth.setTerminalBrand(null);
        auth.setTerminalMachine(null);
        auth.setTerminalModel(null);
        auth.setBindingStatus("0");
        this.updateById((Object)auth);
    }
}

