/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.adapter.AdapterFactory;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.common.spider.entity.DouYinTopManDetailBaseContacrEntity;
import com.els.modules.common.spider.entity.LoginRp;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.properties.TopManMsgProperties;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.utils.RedissonUtil;
import com.els.modules.common.utils.SmsBean;
import com.els.modules.common.utils.SmsResult;
import com.els.modules.common.utils.SmsUtil;
import com.els.modules.system.service.DictService;
import com.els.modules.topman.entity.TopmanContact;
import com.els.modules.topman.service.McnTopmanContactService;
import com.els.modules.topman.utils.DouYinUtil;
import com.els.modules.touch.dto.TopManMsgCaptchaDto;
import com.els.modules.touch.dto.TopManMsgSmsCaptchaDto;
import com.els.modules.touch.dto.TopmanMsgRqDto;
import com.els.modules.touch.dto.TopmanMsgTaskDto;
import com.els.modules.touch.entity.SmsTemplate;
import com.els.modules.touch.entity.TopManMsgConfig;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.entity.TopManMsgRecordHis;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.enumerate.MsgTemplateTimeSectionEnum;
import com.els.modules.touch.enumerate.MsgTopManSourceEnum;
import com.els.modules.touch.enumerate.MsgTouchTypeEnum;
import com.els.modules.touch.enumerate.MsgTypeEnum;
import com.els.modules.touch.enumerate.TopManMsgSendStatusEnum;
import com.els.modules.touch.mapper.TopManMsgTaskMapper;
import com.els.modules.touch.msg.ITopManMessageAdapter;
import com.els.modules.touch.service.SmsTemplateService;
import com.els.modules.touch.service.TopManMsgConfigService;
import com.els.modules.touch.service.TopManMsgRecordHisService;
import com.els.modules.touch.service.TopManMsgRecordService;
import com.els.modules.touch.service.TopManMsgTaskService;
import com.els.modules.touch.util.EffectiveTimeUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgTaskServiceImpl
extends BaseServiceImpl<TopManMsgTaskMapper, TopManMsgTask>
implements TopManMsgTaskService {
    private static final Logger log = LoggerFactory.getLogger(TopManMsgTaskServiceImpl.class);
    @Autowired
    @Lazy
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Lazy
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private TopManMsgProperties topManMsgProperties;
    @Autowired
    private RedissonUtil redissonUtil;
    @Autowired
    private AdapterFactory adapterFactory;
    @Autowired
    private TopManMsgRecordHisService hisService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DictService dictService;
    public static final ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor(){
        {
            this.setCorePoolSize(3);
            this.setMaxPoolSize(5);
            this.setKeepAliveSeconds(60);
            this.initialize();
        }
    };
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private DouYinUtil douYinUtil;
    @Autowired
    private McnTopmanContactService topmanContactService;
    @Lazy
    @Autowired
    private SmsTemplateService smsTemplateService;

    @Override
    public TopManMsgTask getOneByPlatform(String platform, String touchType) {
        LoginUser loginUser = SysUtil.getLoginUser();
        return (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgTask::getTouchType, (Object)touchType)).eq(TopManMsgTask::getPlatform, (Object)platform)).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO), false));
    }

    @Override
    public void saveBySubAccount(TopManMsgTask topManMsgTask, String type) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TopManMsgTask db = this.getOneByPlatform(topManMsgTask.getPlatform(), topManMsgTask.getTouchType());
        if (ObjectUtil.isEmpty((Object)((Object)db))) {
            topManMsgTask.setSubAccount(loginUser.getSubAccount());
            topManMsgTask.setDeleted(CommonConstant.STATUS_NO);
            ((TopManMsgTaskMapper)this.baseMapper).insert((Object)topManMsgTask);
            db = topManMsgTask;
        } else {
            topManMsgTask.setId(db.getId());
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)topManMsgTask.getId());
        switch (type) {
            case "1": {
                updateWrapper.set((Object)"filter_info_json", (Object)topManMsgTask.getFilterInfoJson());
                db.setFilterInfoJson(topManMsgTask.getFilterInfoJson());
                this.handleRecord(db);
                break;
            }
            case "2": {
                if (MsgTouchTypeEnum.IM.getCode().equals(topManMsgTask.getTouchType())) {
                    this.checkPsd(topManMsgTask);
                }
                if (MsgTouchTypeEnum.SMS.getCode().equals(topManMsgTask.getTouchType())) {
                    updateWrapper.set((Object)"need_captcha", null);
                    this.update((Wrapper)updateWrapper);
                    try {
                        this.checkSmsPsd(topManMsgTask);
                    }
                    catch (Exception e) {
                        updateWrapper.set((Object)"platform_account", (Object)"");
                        updateWrapper.set((Object)"platform_psd", (Object)"");
                        this.update((Wrapper)updateWrapper);
                        throw e;
                    }
                }
                updateWrapper.set((Object)"platform_url", (Object)topManMsgTask.getPlatformUrl());
                updateWrapper.set((Object)"platform_account", (Object)topManMsgTask.getPlatformAccount());
                updateWrapper.set((Object)"platform_psd", (Object)topManMsgTask.getPlatformPsd());
                updateWrapper.set((Object)"is_auto_start", (Object)topManMsgTask.getAutoStart());
                updateWrapper.set((Object)"is_auto_reply", (Object)topManMsgTask.getAutoReply());
            }
        }
        this.update((Wrapper)updateWrapper);
    }

    private void handleRecord(TopManMsgTask topManMsgTask) {
        if (MsgTouchTypeEnum.SMS.getCode().equals(topManMsgTask.getTouchType()) || MsgTouchTypeEnum.WE_CHAT.getCode().equals(topManMsgTask.getTouchType())) {
            return;
        }
        long count = this.topManMsgRecordService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).eq(TopManMsgRecord::getSendStatus, (Object)"1"));
        ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
        int limitSize = this.topManMsgProperties.getLimit();
        if ((limitSize -= (int)count) <= 0) {
            return;
        }
        if (limitSize > 0 && StrUtil.isNotBlank((CharSequence)topManMsgTask.getFilterInfoJson())) {
            List<TopManMsgRecord> searchList = adapter.getSearchData(topManMsgTask.getFilterInfoJson(), topManMsgTask, limitSize);
            ArrayList saveList = Lists.newArrayList();
            if (CollUtil.isNotEmpty(searchList)) {
                if (MsgTouchTypeEnum.DM.getCode().equals(topManMsgTask.getTouchType())) {
                    taskExecutor.execute((Runnable)new Thread(() -> this.handleDmRecord(searchList)));
                    return;
                }
                saveList.addAll(searchList);
                this.topManMsgRecordService.saveBatch(saveList);
            }
        }
    }

    private void handleDmRecord(List<TopManMsgRecord> searchList) {
        searchList.forEach(x -> {
            if ("1".equals(x.getPlatform())) {
                String code = this.douYinUtil.getDouYinId(x.getTopmanName(), x.getAvatar(), x.getTopmanId());
                if (StrUtil.isNotBlank((CharSequence)code)) {
                    x.setTouchType(MsgTouchTypeEnum.DM.getCode());
                    x.setTopmanCode(code);
                    this.topManMsgRecordService.saveOrUpdate(x);
                }
            } else {
                x.setTouchType(MsgTouchTypeEnum.DM.getCode());
                this.topManMsgRecordService.saveOrUpdate(x);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TopManMsgRecord handelContact(MsgTouchTypeEnum msgTouchTypeEnum, List<TopManMsgRecord> searchList, TopManMsgTask task) {
        String contact_mode = "1";
        int i = 0;
        Iterator<TopManMsgRecord> iterator = searchList.iterator();
        block9: while (iterator.hasNext()) {
            TopManMsgRecord search = iterator.next();
            HashMap<String, String> paramBean = new HashMap<String, String>(3);
            paramBean.put("uid", search.getTopmanId());
            paramBean.put("contact_mode", contact_mode);
            paramBean.put("check_mode", "2");
            paramBean.put("username", task.getPlatformAccount());
            paramBean.put("password", task.getPlatformPsd());
            String dyId = this.douYinUtil.getDouYinId(search.getTopmanName(), search.getAvatar(), search.getTopmanId());
            TopmanContact topmanContact = new TopmanContact();
            if (StrUtil.isNotBlank((CharSequence)dyId) && (topmanContact = (TopmanContact)((Object)this.topmanContactService.getOne((Wrapper)Wrappers.lambdaQuery().eq(TopmanContact::getTopmanId, (Object)dyId), false))) == null) {
                topmanContact = new TopmanContact();
            }
            switch (msgTouchTypeEnum) {
                case SMS: {
                    if (ObjectUtil.isNotEmpty((Object)((Object)topmanContact)) && StrUtil.isNotBlank((CharSequence)topmanContact.getMobileNumber())) {
                        search.setContact(topmanContact.getMobileNumber());
                        search.setTouchType(msgTouchTypeEnum.getCode());
                        return search;
                    }
                    if (this.redisUtil.hasKey("topman_sms_touch:" + task.getPlatformAccount())) {
                        return null;
                    }
                    DouYinTopManDetailBaseContacrEntity bodyContacr = null;
                    RLock lock = null;
                    try {
                        long time = 120L;
                        lock = this.redissonUtil.lock("search_topman_contact" + task.getId(), (Long)time);
                        if (ObjectUtil.isNotEmpty((Object)lock)) {
                            if (i > 0) {
                                Thread.sleep(5000L);
                            }
                            bodyContacr = this.spiderApiUtil.postForEntityContact(SpiderMethodType.DOUYIN_SMS_CONTACT, paramBean, DouYinTopManDetailBaseContacrEntity.class);
                            ++i;
                        } else {
                            TopManMsgRecord topManMsgRecord = null;
                            return topManMsgRecord;
                        }
                        lock.unlock();
                    }
                    catch (Exception e) {
                        log.error("\u8fbe\u4eba:[{}]uid:[{}]\u7c7b\u578b:SMS\uff0c\u83b7\u53d6\u8fbe\u4eba\u624b\u673a\u53f7\u5f02\u5e38:", new Object[]{search.getTopmanName(), search.getTopmanId(), e});
                    }
                    finally {
                        lock.unlock();
                    }
                    if (!ObjectUtil.isNotEmpty(bodyContacr)) continue block9;
                    String contact = bodyContacr.getContactValue();
                    Integer max = bodyContacr.getTimesLeft();
                    if (ObjectUtil.isNotEmpty((Object)max) && max == 0) {
                        Calendar curDate = Calendar.getInstance();
                        GregorianCalendar tomorrowDate = new GregorianCalendar(curDate.get(1), curDate.get(2), curDate.get(5) + 1, 0, 0, 0);
                        int second = (int)(tomorrowDate.getTimeInMillis() - curDate.getTimeInMillis()) / 1000;
                        this.redisUtil.set("topman_sms_touch:" + task.getPlatformAccount(), (Object)1, (long)second);
                    }
                    if (!StrUtil.isNotBlank((CharSequence)contact)) continue block9;
                    search.setContact(contact);
                    search.setTouchType(msgTouchTypeEnum.getCode());
                    if (!StrUtil.isNotBlank((CharSequence)dyId)) return search;
                    topmanContact.setTopmanId(dyId);
                    topmanContact.setMobileNumber(contact);
                    topmanContact.setPlatform(Integer.valueOf(search.getPlatform()));
                    topmanContact.setTopmanAvatar(search.getAvatar());
                    topmanContact.setTopmanName(search.getTopmanName());
                    topmanContact.setUnicode(DouYinUtil.subAvatar(search.getAvatar()));
                    topmanContact.setElsAccount("100000");
                    this.topmanContactService.saveOrUpdate((Object)topmanContact);
                    return search;
                }
                case WE_CHAT: {
                    continue block9;
                }
            }
        }
        return null;
    }

    private void checkSmsPsd(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("username", topManMsgTask.getPlatformAccount());
        params.put("password", topManMsgTask.getPlatformPsd());
        params.put("id", topManMsgTask.getId());
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.DOUYIN_SMS_LOGIN, params, LoginRp.class);
    }

    private void checkPsd(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        try {
            LoginRp loginRp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "login_opt"), params, LoginRp.class);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6296\u97f3\u767b\u5f55\u5f02\u5e38", (Throwable)e);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.set((Object)"platform_account", (Object)"");
            updateWrapper.set((Object)"platform_psd", (Object)"");
            updateWrapper.eq((Object)"id", (Object)topManMsgTask.getId());
            this.update((Wrapper)updateWrapper);
            throw new ELSBootException("\u6296\u97f3\u767b\u5f55\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        TopManMsgTask db = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())).eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).eq(TopManMsgTask::getTouchType, (Object)topManMsgTask.getTouchType())).ne(BaseEntity::getId, (Object)topManMsgTask.getId()), false));
        if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
            Assert.isTrue((boolean)false, (String)("\u6b64IM\u8d26\u53f7\u5df2\u88ab" + db.getSubAccount() + "\u6240\u4f7f\u7528"));
        }
    }

    @Override
    public void edit(TopManMsgTask topManMsgTask) {
        int count = ((TopManMsgTaskMapper)this.baseMapper).updateById((Object)topManMsgTask);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgTaskMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private TopManMsgConfig getContent(List<TopManMsgConfig> list, Integer sortNum) {
        if (ObjectUtil.isNotNull((Object)sortNum)) {
            return list.stream().filter(x -> x.getSortNum().equals(sortNum)).findFirst().orElse(new TopManMsgConfig());
        }
        return list.get(0);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public Result<?> startUp(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformAccount()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u8d26\u53f7");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformPsd()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6eIM\u5bc6\u7801");
        List<TopManMsgConfig> msgConfigs = this.topManMsgConfigService.listBySubAccount(topManMsgTask.getElsAccount(), topManMsgTask.getSubAccount(), topManMsgTask.getPlatform(), MsgTouchTypeEnum.IM.getCode());
        Assert.isTrue((boolean)CollUtil.isNotEmpty(msgConfigs), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u6d88\u606f\u8bbe\u7f6e");
        try {
            List search;
            List lev2;
            Map<String, List<TopManMsgConfig>> msgMap = msgConfigs.stream().collect(Collectors.groupingBy(x -> x.getMsgType()));
            Map<String, TopManMsgConfig> msgIdMap = msgConfigs.stream().collect(Collectors.toMap(x -> x.getId(), y -> y));
            List<TopManMsgConfig> callMsgs = msgMap.get(MsgTypeEnum.CALL.getCode());
            Assert.isTrue((boolean)CollUtil.isNotEmpty(msgConfigs), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u62db\u547c\u6d88\u606f\u8bbe\u7f6e");
            int limitSize = this.topManMsgProperties.getLimit();
            List sends = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())).eq(TopManMsgRecord::getPush, (Object)"0")).eq(TopManMsgRecord::getPlatform, (Object)topManMsgTask.getPlatform())).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.IM.getCode())).last("limit " + limitSize));
            if (CollUtil.isEmpty((Collection)sends)) {
                sends = Lists.newArrayList();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String now = simpleDateFormat.format(new Date()) + " 00:00:00";
            if ((limitSize -= sends.size()) > 0 && CollUtil.isNotEmpty((Collection)(lev2 = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSendStatus, (Object)"1")).eq(TopManMsgRecord::getReplyStatus, (Object)"0")).eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).lt(BaseEntity::getUpdateTime, (Object)now)).orderByAsc(TopManMsgRecord::getSubAdd)).last("limit " + limitSize))))) {
                sends.addAll(lev2);
                limitSize -= sends.size();
            }
            List<TopManMsgConfig> chatMsgs = msgMap.get(MsgTypeEnum.CHAT.getCode());
            List calls = Lists.newArrayList();
            if (CollUtil.isNotEmpty(chatMsgs)) {
                calls = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).eq(TopManMsgRecord::getSendStatus, (Object)"1")).eq(TopManMsgRecord::getReplyStatus, (Object)"1")).lt(BaseEntity::getUpdateTime, (Object)now)).orderByAsc(TopManMsgRecord::getSubAdd));
                calls.addAll(this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).in(TopManMsgRecord::getSubAdd, Arrays.asList(MsgTopManSourceEnum.PRO_CONTACTS.getCode(), MsgTopManSourceEnum.INITIATIVE_RETRIEVAL.getCode()))).lt(BaseEntity::getUpdateTime, (Object)now)));
            }
            if (limitSize > 0 && CollUtil.isNotEmpty((Collection)(search = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSendStatus, (Object)"0")).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode())).eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).orderByAsc(TopManMsgRecord::getSubAdd)).last("limit " + limitSize))))) {
                sends.addAll(search);
                limitSize -= sends.size();
            }
            String filterInfoJson = topManMsgTask.getFilterInfoJson();
            ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
            if (limitSize > 0 && StrUtil.isNotBlank((CharSequence)filterInfoJson)) {
                try {
                    List<TopManMsgRecord> searchList = adapter.getSearchData(filterInfoJson, topManMsgTask, limitSize);
                    sends.addAll(searchList);
                }
                catch (Exception e) {
                    log.error("\u89e6\u8fbe\u65f6\u68c0\u7d22\u5f02\u5e38:", (Throwable)e);
                }
            }
            if (CollUtil.isNotEmpty((Collection)sends) || CollUtil.isNotEmpty((Collection)calls)) {
                List<TopManMsgRecord> finallys = this.handleMsgConfig(topManMsgTask, sends, calls, callMsgs, chatMsgs, limitSize);
                this.sensMsgAndSaveRecord(finallys, topManMsgTask, msgIdMap);
            } else {
                Assert.isTrue((boolean)false, (String)"\u672a\u627e\u5230\u53ef\u89e6\u8fbe\u7684\u8fbe\u4eba");
            }
            topManMsgTask.setNeedCaptcha(null);
            topManMsgTask.setStartStatus("0");
            this.updateById((Object)topManMsgTask);
            return Result.ok((Object)((Object)topManMsgTask));
        }
        catch (Exception e) {
            log.error("\u89e6\u8fbe\u5f00\u542f\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private List<TopManMsgRecord> handleMsgConfig(TopManMsgTask task, List<TopManMsgRecord> sends, List<TopManMsgRecord> calls, List<TopManMsgConfig> callMsgs, List<TopManMsgConfig> chatMsgs, int limitSize) {
        TopManMsgConfig config;
        Map<Integer, TopManMsgConfig> call = callMsgs.stream().collect(Collectors.toMap(x -> x.getSortNum(), y -> y));
        Map<Object, Object> chat = Maps.newHashMap();
        if (ObjectUtil.isNotEmpty(chatMsgs)) {
            chat = chatMsgs.stream().collect(Collectors.toMap(x -> x.getSortNum(), y -> y));
        }
        ArrayList finallys = Lists.newArrayList();
        HashSet sendSet = Sets.newHashSet();
        for (TopManMsgRecord send : sends) {
            if (!sendSet.contains(send.getTopmanName())) {
                send.setTaskId(task.getId());
                if (send.getSendCount() == 0) {
                    config = call.get(1);
                    if (ObjectUtil.isEmpty((Object)((Object)config))) continue;
                    send.setMsgId(config.getId());
                    send.setMsgContent(config.getMsgContent());
                    finallys.add(send);
                    continue;
                }
                config = call.get(send.getSendCount() + 1);
                if (ObjectUtil.isEmpty((Object)((Object)config)) || !ObjectUtil.isNotEmpty((Object)((Object)config)) || this.hisService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)send.getId())).eq(TopManMsgRecordHis::getSortNum, (Object)config.getSortNum())) != 0) continue;
                send.setMsgId(config.getId());
                send.setMsgContent(config.getMsgContent());
                finallys.add(send);
                continue;
            }
            sendSet.add(send.getTopmanName());
        }
        for (TopManMsgRecord reply : calls) {
            if (reply.getReplyCount() == 0) {
                config = (TopManMsgConfig)((Object)chat.get(1));
                if (ObjectUtil.isEmpty((Object)((Object)config))) continue;
                reply.setMsgId(config.getId());
                reply.setMsgContent(config.getMsgContent());
                finallys.add(reply);
                continue;
            }
            config = (TopManMsgConfig)((Object)chat.get(reply.getSendCount() + 1));
            if (ObjectUtil.isEmpty((Object)((Object)config)) || !ObjectUtil.isNotEmpty((Object)((Object)config)) || this.hisService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecordHis::getTaskId, (Object)reply.getId())).eq(TopManMsgRecordHis::getSortNum, (Object)config.getSortNum())) != 0) continue;
            reply.setMsgId(config.getId());
            reply.setMsgContent(config.getMsgContent());
            finallys.add(reply);
        }
        return finallys;
    }

    private List<String> getMcnTopManName() {
        ArrayList mcnTopManName = Lists.newArrayList();
        mcnTopManName.add("\u535a\u96c5baby");
        mcnTopManName.add("\u96e8\u51dd\u7684\u5e97\u4e2a\u4f53\u5e97");
        mcnTopManName.add("\u5f20\u5927\u6811");
        return mcnTopManName;
    }

    private void sensMsgAndSaveRecord(List<TopManMsgRecord> finallys, TopManMsgTask topManMsgTask, Map<String, TopManMsgConfig> msgIdMap) {
        Map<String, List<TopManMsgRecord>> finalMap = finallys.stream().collect(Collectors.groupingBy(x -> x.getTopmanName()));
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        params.put("userPwd", topManMsgTask.getPlatformPsd());
        ArrayList rqs = Lists.newArrayList();
        ArrayList records = Lists.newArrayList();
        ArrayList hisList = Lists.newArrayList();
        List dyLimit = this.dictService.queryDictItemsByCode("douYinTouchControl", TenantContext.getTenant(), "1");
        List<String> mcnTopManName = this.getMcnTopManName();
        finalMap.forEach((k, v) -> {
            TopmanMsgRqDto.Msg msg = new TopmanMsgRqDto.Msg();
            msg.setTopmanName((String)k);
            ArrayList contents = Lists.newArrayList();
            TopManMsgRecord record = (TopManMsgRecord)((Object)((Object)v.get(0)));
            msg.setTopmanId(record.getTopmanId());
            record.setPush("1");
            record.setTouchType(MsgTouchTypeEnum.IM.getCode());
            records.add(record);
            v.forEach(row -> {
                TopmanMsgRqDto.Msg.Content content = new TopmanMsgRqDto.Msg.Content();
                TopManMsgRecordHis his = new TopManMsgRecordHis();
                his.setTaskId(record.getId());
                his.setId(IdWorker.getIdStr());
                content.setTaskId(his.getId());
                content.setContent(row.getMsgContent());
                his.setSendMsgId(row.getMsgId());
                his.setSendMsgContent(row.getMsgContent());
                TopManMsgConfig config = (TopManMsgConfig)((Object)((Object)((Object)msgIdMap.get(row.getMsgId()))));
                his.setMsgType(config.getMsgType());
                his.setSortNum(config.getSortNum());
                his.setSubAccount(topManMsgTask.getSubAccount());
                hisList.add(his);
                contents.add(content);
                msg.getMsg().add(content);
            });
            if (CollUtil.isNotEmpty((Collection)dyLimit) && topManMsgTask.getPlatform().equals("1") && dyLimit.stream().filter(x -> x.getValue().equals(topManMsgTask.getPlatformAccount())).count() > 0L) {
                log.info("-----dyLimit is {} \u9650\u5236\u89e6\u8fbe\u8fbe\u4eba----", (Object)JSON.toJSONString((Object)dyLimit));
                if (CollUtil.isEmpty((Collection)mcnTopManName)) {
                    return;
                }
                msg.setTopmanName((String)mcnTopManName.get(0));
                mcnTopManName.remove(0);
            }
            rqs.add(msg);
        });
        params.put("topmanList", rqs);
        LoginRp rp = this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "send_opt"), params, LoginRp.class);
        this.topManMsgRecordService.saveOrUpdateBatch(records);
        this.hisService.saveBatch(hisList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void stop(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform, MsgTouchTypeEnum.IM.getCode());
        this.handleTaskStop(topManMsgTask);
    }

    private void handleTaskStop(TopManMsgTask topManMsgTask) {
        HashMap params = Maps.newHashMap();
        params.put("userName", topManMsgTask.getPlatformAccount());
        this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(topManMsgTask.getPlatform(), "stop_opt"), params, LoginRp.class);
        topManMsgTask.setStatus("0");
        topManMsgTask.setNeedCaptcha(null);
        this.updateById((Object)topManMsgTask);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper.eq((Object)"send_status", (Object)"0");
        queryWrapper.eq((Object)"is_added", (Object)"0");
        queryWrapper.eq((Object)"is_sub_add", (Object)MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode());
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper1.eq((Object)"send_status", (Object)"0");
        queryWrapper1.in((Object)"is_sub_add", MsgTopManSourceEnum.getNotDelSource());
        List records = this.topManMsgRecordService.list((Wrapper)queryWrapper);
        records.addAll(this.topManMsgRecordService.list((Wrapper)queryWrapper1));
        if (CollUtil.isNotEmpty((Collection)records)) {
            this.hisService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecordHis::getSubAccount, (Object)topManMsgTask.getSubAccount())).in(TopManMsgRecordHis::getMsgType, Arrays.asList("1", "2"))).isNull(TopManMsgRecordHis::getSendTime));
            this.topManMsgRecordService.remove((Wrapper)queryWrapper);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        updateWrapper.eq((Object)"send_status", (Object)"0");
        updateWrapper.lambda().and(wrapper -> {
            LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(TopManMsgRecord::getIsAdded, (Object)"1")).or()).in(TopManMsgRecord::getSubAdd, MsgTopManSourceEnum.getNotDelSource());
        });
        updateWrapper.set((Object)"is_push", (Object)"0");
        this.topManMsgRecordService.update((Wrapper)updateWrapper);
    }

    @Override
    public TopManMsgTask getData(String platform, String touchType) {
        TopManMsgTask db = this.getOneByPlatform(platform, touchType);
        return db;
    }

    @Override
    public void processCaptcha(TopManMsgCaptchaDto rq) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)rq.getId()));
        TopManMsgCaptchaDto topManMsgCaptchaDto = (TopManMsgCaptchaDto)this.mongoTemplate.findOne(query, TopManMsgCaptchaDto.class);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgCaptchaDto), (String)"\u672a\u83b7\u53d6\u5230\u6570\u636e!");
        if (ObjectUtil.isEmpty((Object)topManMsgCaptchaDto)) {
            topManMsgCaptchaDto = new TopManMsgCaptchaDto();
        }
        topManMsgCaptchaDto.setType(rq.getType());
        topManMsgCaptchaDto.setUserName(rq.getUserName());
        String key = "TOPMAN_MSG_CAPTCHA:" + rq.getType() + rq.getUserName();
        this.redisUtil.set(key, (Object)topManMsgCaptchaDto);
    }

    @Override
    public TopManMsgCaptchaDto getCaptcha(TopManMsgCaptchaDto rq) {
        String key = "TOPMAN_MSG_CAPTCHA:" + rq.getType() + rq.getUserName();
        if (this.redisUtil.hasKey(key)) {
            TopManMsgCaptchaDto dto = (TopManMsgCaptchaDto)this.redisUtil.get(key);
            this.redisUtil.del(new String[]{key});
            return dto;
        }
        return null;
    }

    @Override
    public void enterCaptcha(TopManMsgCaptchaDto rq) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userName").is((Object)rq.getUserName()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)rq.getType()));
        Update update = new Update();
        update.set("captcha", (Object)rq.getCaptcha());
        update.set("timestamp", (Object)(System.currentTimeMillis() / 1000L));
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, TopManMsgCaptchaDto.COLLECTION_NAME);
    }

    @Override
    public void noTokenStop(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgTask.getPlatformAccount()), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgTask.getPlatform()), (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a");
        TopManMsgTask dbTask = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatformAccount, (Object)topManMsgTask.getPlatformAccount())).eq(TopManMsgTask::getPlatform, (Object)topManMsgTask.getPlatform())).eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.IM.getCode()), false));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)dbTask)), (String)"\u4fe1\u606f\u5f02\u5e38");
        this.handleTaskStop(dbTask);
    }

    @Override
    public String getReply(String platform) {
        TopManMsgTask task = this.getOneByPlatform(platform, MsgTouchTypeEnum.IM.getCode());
        this.handleReply(task);
        return task.getPlatformAccount();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void handleReply(TopManMsgTask task) {
        long time;
        String lockKey = "TOPMAN_MSG_REPLY" + task.getPlatformAccount() + "_" + task.getPlatform();
        RLock lock = this.redissonUtil.lock(lockKey, (Long)(time = 60L));
        if (ObjectUtil.isNotEmpty((Object)lock)) {
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)task)), (String)"\u672a\u5f00\u59cb\u89e6\u8fbe\u4efb\u52a1");
            HashMap params = Maps.newHashMap();
            params.put("userName", task.getPlatformAccount());
            params.put("userPwd", task.getPlatformPsd());
            this.spiderApiUtil.postForEntityMsg(SpiderMethodType.getMsgType(task.getPlatform(), "reply_opt"), params, LoginRp.class);
        }
        task.setNeedCaptcha(null);
        task.setReplyStatus(null);
        this.updateById((Object)task);
    }

    @Override
    public void receiveTaskStatus(TopmanMsgTaskDto topmanMsgTaskDto) {
        TopManMsgTask task = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatformAccount, (Object)topmanMsgTaskDto.getUserName())).eq(TopManMsgTask::getPlatform, (Object)topmanMsgTaskDto.getPlatform())).eq(BaseEntity::getDeleted, (Object)CommonConstant.STATUS_NO)).eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.IM.getCode())));
        if (ObjectUtil.isNotEmpty((Object)((Object)task))) {
            switch (topmanMsgTaskDto.getOptType()) {
                case "1": {
                    task.setNeedCaptcha(topmanMsgTaskDto.getNeedCaptcha());
                    this.updateById((Object)task);
                    break;
                }
                case "2": {
                    if ("1".equals(topmanMsgTaskDto.getType())) {
                        task.setStatus(topmanMsgTaskDto.getSuccess());
                        task.setStartStatus(topmanMsgTaskDto.getSuccess());
                    }
                    if ("2".equals(topmanMsgTaskDto.getType())) {
                        task.setReplyStatus(topmanMsgTaskDto.getSuccess());
                    }
                    this.updateById((Object)task);
                    break;
                }
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void smsStartUp(TopManMsgTask topManMsgTask) {
        block10: {
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
            List<TopManMsgConfig> msgConfigs = this.topManMsgConfigService.listBySubAccount(topManMsgTask.getElsAccount(), topManMsgTask.getSubAccount(), topManMsgTask.getPlatform(), MsgTouchTypeEnum.SMS.getCode());
            if (CollUtil.isEmpty(msgConfigs)) {
                log.error("{}\u672a\u8bbe\u7f6e\u77ed\u4fe1\u6a21\u677f", (Object)topManMsgTask.getId());
                return;
            }
            try {
                Date endTime;
                Date beginTime;
                SimpleDateFormat df;
                Date nowTime;
                MsgTemplateTimeSectionEnum sectionEnum;
                SmsTemplate template;
                TopManMsgConfig msgConfig = msgConfigs.get(0);
                if (ObjectUtil.isNotEmpty((Object)msgConfig.getTemplateId()) && ObjectUtil.isNotEmpty((Object)(template = (SmsTemplate)((Object)this.smsTemplateService.getById((Serializable)((Object)msgConfig.getTemplateId())))).getSmsTimeSection()) && ObjectUtil.isNotEmpty((Object)((Object)(sectionEnum = MsgTemplateTimeSectionEnum.getByCode(template.getSmsTimeSection())))) && !EffectiveTimeUtil.timeCalendar(nowTime = (df = new SimpleDateFormat("HH:mm")).parse(df.format(new Date())), beginTime = df.parse(sectionEnum.getStartTime()), endTime = df.parse(sectionEnum.getEndTime()))) {
                    log.error("{}\u4e0d\u5728\u77ed\u4fe1\u53d1\u9001\u65f6\u95f4\u5185", (Object)topManMsgTask.getId());
                    return;
                }
                List sends = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecord::getSubAccount, (Object)topManMsgTask.getSubAccount())).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())).eq(TopManMsgRecord::getPush, (Object)"0")).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.SMS.getCode())).last("limit 1"));
                if (!CollUtil.isEmpty((Collection)sends)) {
                    this.sendSms((TopManMsgRecord)((Object)sends.get(0)), msgConfig);
                    return;
                }
                sends = Lists.newArrayList();
                List search = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getSendStatus, (Object)"0")).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode())).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.SMS.getCode())).eq(TopManMsgRecord::getTaskId, (Object)topManMsgTask.getId())).orderByAsc(TopManMsgRecord::getSubAdd)).last("limit 1"));
                if (CollUtil.isNotEmpty((Collection)search)) {
                    this.sendSms((TopManMsgRecord)((Object)search.get(0)), msgConfig);
                    return;
                }
                String filterInfoJson = topManMsgTask.getFilterInfoJson();
                ITopManMessageAdapter adapter = (ITopManMessageAdapter)this.adapterFactory.get(topManMsgTask.getPlatform(), ITopManMessageAdapter.class);
                if (!StrUtil.isNotBlank((CharSequence)filterInfoJson)) break block10;
                try {
                    List<TopManMsgRecord> searchList = adapter.getSearchData(filterInfoJson, topManMsgTask, this.topManMsgProperties.getLimit());
                    if (CollUtil.isNotEmpty(searchList)) {
                        TopManMsgRecord record = this.handelContact(MsgTouchTypeEnum.SMS, searchList, topManMsgTask);
                        if (ObjectUtil.isEmpty((Object)((Object)record))) {
                            return;
                        }
                        this.sendSms(record, msgConfig);
                        return;
                    }
                }
                catch (Exception e) {
                    log.error("\u89e6\u8fbe\u65f6\u68c0\u7d22\u5f02\u5e38:", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("\u89e6\u8fbe\u5f00\u542f\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void sendSms(TopManMsgRecord send, TopManMsgConfig msgConfig) {
        DictModel opens;
        List dicts = this.dictService.queryDictItemsByCode("mcnMsgSwitch", "100000", "1");
        boolean open = false;
        List<Object> mcnPhone = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)dicts) && ObjectUtil.isNotEmpty((Object)(opens = dicts.stream().filter(x -> "open".equals(x.getText())).findFirst().get())) && "1".equals(opens.getValue())) {
            open = true;
            DictModel phone = dicts.stream().filter(x -> "phone".equals(x.getText())).findFirst().get();
            if (ObjectUtil.isNotEmpty((Object)phone) && StrUtil.isNotBlank((CharSequence)phone.getValue())) {
                mcnPhone = Arrays.asList(phone.getValue().split(","));
            }
        }
        if (StrUtil.isNotBlank((CharSequence)send.getContact())) {
            boolean flag = false;
            if (open && !mcnPhone.contains(send.getContact())) {
                flag = true;
            }
            SmsBean smsBean = new SmsBean();
            smsBean.setExtcode("385485");
            smsBean.setUserName("110426");
            smsBean.setPassword("ZupkpyNnDaz2");
            smsBean.setUrl("http://47.107.255.220:8001/sms/api/sendMessageOne.do");
            smsBean.setContent(msgConfig.getMsgContent());
            smsBean.setMobile(send.getContact());
            SmsResult smsResult = new SmsResult();
            if (!flag) {
                log.info("\u77ed\u4fe1\u8c03\u7528\u5165\u53c2:[{}]", (Object)JSON.toJSONString((Object)smsBean));
                smsResult = SmsUtil.sendRenRenZhong(smsBean);
                log.info("\u77ed\u4fe1\u8c03\u7528\u54cd\u5e94:[{}]", (Object)JSON.toJSONString((Object)smsResult));
            }
            if (flag || ObjectUtil.isNotEmpty((Object)smsResult) && CollUtil.isNotEmpty(smsResult.getData()) && ObjectUtil.isNotEmpty((Object)smsResult.getData().get(0).getCode()) && smsResult.getData().get(0).getCode().equals(0)) {
                send.setSendStatus("1");
                send.setMsgContent(msgConfig.getMsgContent());
                send.setPush("1");
                send.setMsgId(msgConfig.getId());
                if (ObjectUtil.isEmpty((Object)send.getSendTime())) {
                    send.setSendTime(new Date());
                }
                send.setLateSendTime(new Date());
                TopManMsgRecordHis his = new TopManMsgRecordHis();
                his.setTaskId(send.getId());
                his.setId(IdWorker.getIdStr());
                his.setSendMsgId(send.getMsgId());
                his.setSendMsgContent(send.getMsgContent());
                his.setElsAccount(send.getElsAccount());
                his.setSendTime(DateUtil.formatDateTime((Date)send.getLateSendTime()));
                his.setMsgType(MsgTypeEnum.CALL.getCode());
                his.setSortNum(1);
                his.setSubAccount(send.getSubAccount());
                this.hisService.save((Object)his);
            } else {
                send.setSendStatus(TopManMsgSendStatusEnum.FAILED.getCode());
                if (ObjectUtil.isNotEmpty((Object)smsResult) && CollUtil.isNotEmpty(smsResult.getData()) && ObjectUtil.isNotEmpty((Object)smsResult.getData().get(0).getMessage())) {
                    send.setFailureReason(smsResult.getData().get(0).getMessage());
                } else {
                    send.setFailureReason("\u77ed\u4fe1\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
                }
                log.error("\u8fbe\u4eba{}\u77ed\u4fe1\u89e6\u8fbe\u5f02\u5e38:{}", (Object)send.getTopmanName(), JSON.toJSON((Object)smsBean));
            }
        } else {
            send.setSendStatus(TopManMsgSendStatusEnum.FAILED.getCode());
            send.setFailureReason("\u65e0\u8054\u7cfb\u65b9\u5f0f");
        }
        this.topManMsgRecordService.saveOrUpdate((Object)send);
    }

    @Override
    public void smsStop(String platform) {
        TopManMsgTask topManMsgTask = this.getOneByPlatform(platform, MsgTouchTypeEnum.SMS.getCode());
        topManMsgTask.setStatus("0");
        topManMsgTask.setNeedCaptcha(null);
        this.updateById((Object)topManMsgTask);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper.eq((Object)"send_status", (Object)"0");
        queryWrapper.eq((Object)"is_added", (Object)"0");
        queryWrapper.eq((Object)"is_sub_add", (Object)MsgTopManSourceEnum.AUTO_RETRIEVAL.getCode());
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"task_id", (Object)topManMsgTask.getId());
        queryWrapper1.eq((Object)"send_status", (Object)"0");
        queryWrapper1.in((Object)"is_sub_add", MsgTopManSourceEnum.getNotDelSource());
        List records = this.topManMsgRecordService.list((Wrapper)queryWrapper);
        records.addAll(this.topManMsgRecordService.list((Wrapper)queryWrapper1));
        if (CollUtil.isNotEmpty((Collection)records)) {
            this.hisService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)topManMsgTask.getElsAccount())).eq(TopManMsgRecordHis::getSubAccount, (Object)topManMsgTask.getSubAccount())).in(TopManMsgRecordHis::getMsgType, Arrays.asList("1", "2"))).isNull(TopManMsgRecordHis::getSendTime));
            this.topManMsgRecordService.remove((Wrapper)queryWrapper);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"task_id", (Object)topManMsgTask.getId());
        updateWrapper.eq((Object)"send_status", (Object)"0");
        updateWrapper.lambda().and(wrapper -> {
            LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(TopManMsgRecord::getIsAdded, (Object)"1")).or()).in(TopManMsgRecord::getSubAdd, MsgTopManSourceEnum.getNotDelSource());
        });
        updateWrapper.set((Object)"is_push", (Object)"0");
        this.topManMsgRecordService.update((Wrapper)updateWrapper);
    }

    @Override
    public Result<?> smsStartUpPage(TopManMsgTask topManMsgTask) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)topManMsgTask)), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8fbe\u4eba\u89e6\u8fbe\u6d88\u606f\u4efb\u52a1");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformAccount()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u8d26\u53f7");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)topManMsgTask.getPlatformPsd()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u5bc6\u7801");
        Assert.isTrue((ObjectUtil.isNotEmpty((Object)topManMsgTask.getTest()) && topManMsgTask.getTest() != false ? 1 : 0) != 0, (String)"\u8bf7\u5148\u5230\u89e6\u8fbe\u914d\u7f6e\u4e0b\u7684[\u77ed\u4fe1\u914d\u7f6e]\u914d\u7f6e\u6a21\u677f\uff0c\u5e76\u8f93\u5165\u624b\u673a\u53f7\u7801\u6d4b\u8bd5");
        LoginUser loginUser = SysUtil.getLoginUser();
        int count = this.topManMsgRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgRecord::getSubAccount, (Object)loginUser.getSubAccount())).eq(TopManMsgRecord::getTouchType, (Object)MsgTouchTypeEnum.SMS.getCode())).eq(TopManMsgRecord::getSubAdd, (Object)MsgTopManSourceEnum.MANUALLY_ADDED.getCode())).eq(TopManMsgRecord::getPush, (Object)"0"));
        if (count == 0) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)topManMsgTask.getFilterInfoJson()), (String)"\u8be5\u5b50\u8d26\u53f7\u4e0b\u8fd8\u672a\u8bbe\u7f6e\u68c0\u7d22\u6761\u4ef6");
        }
        topManMsgTask.setStartStatus("0");
        topManMsgTask.setStatus("1");
        this.updateById((Object)topManMsgTask);
        return Result.ok((Object)((Object)topManMsgTask));
    }

    @Override
    public void smsNotice(TopmanMsgTaskDto smsDto) {
        TopManMsgTask task = (TopManMsgTask)((Object)this.getById((Serializable)((Object)smsDto.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)task)), (String)"id\u9519\u8bef");
        if ("1".equals(smsDto.getType())) {
            task.setNeedCaptcha(smsDto.getNeedCaptcha());
        }
        if ("2".equals(smsDto.getType())) {
            task.setStartStatus(smsDto.getSuccess());
        }
        this.updateById((Object)task);
    }

    @Override
    public void smsEnterCaptcha(TopManMsgCaptchaDto rq) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TopManMsgTask task = (TopManMsgTask)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgTask::getPlatform, (Object)rq.getType())).eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.SMS.getCode())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(TopManMsgTask::getSubAccount, (Object)loginUser.getSubAccount())));
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)task.getId()));
        Update update = new Update();
        update.set("captcha", (Object)rq.getCaptcha());
        update.set("timestamp", (Object)(System.currentTimeMillis() / 1000L));
        this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, TopManMsgSmsCaptchaDto.COLLECTION_NAME);
        task.setNeedCaptcha(null);
        this.updateById((Object)task);
    }

    @Override
    public Result<?> test() {
        HashMap<String, String> paramBean = new HashMap<String, String>(3);
        paramBean.put("uid", "v2_0a2bc09adbdc30377eb004a2ab724f95acbb15d9f4c619c460899e735d1c82c4d706e7f5dfc997aa74cf66402d1a490a3c6f9b813507248e80b49dca63740d286e7d2b251349125902337b0be98b3a603bf42788272033e6773af3984f87d352e5ad41b0966baf6d470652d3e810aceda20d18e5ade4c9012201035e0eeb21");
        paramBean.put("contact_mode", "1");
        paramBean.put("check_mode", "2");
        paramBean.put("username", "yangzhihai@51qqt.com");
        paramBean.put("password", "12345@QQT.com");
        DouYinTopManDetailBaseContacrEntity bodyContacr = this.spiderApiUtil.postForEntityContact(SpiderMethodType.DOUYIN_SMS_CONTACT, paramBean, DouYinTopManDetailBaseContacrEntity.class);
        System.out.println(bodyContacr);
        return null;
    }

    @Override
    public void resetRecord(TopManMsgTask task) {
        List records = this.topManMsgRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgRecord::getTaskId, (Object)task.getId())).eq(TopManMsgRecord::getSendStatus, (Object)"0")).eq(TopManMsgRecord::getPush, (Object)"1"));
        if (CollUtil.isNotEmpty((Collection)records)) {
            records.forEach(x -> x.setPush("0"));
            this.topManMsgRecordService.updateBatchById(records);
            List rids = records.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            this.hisService.remove((Wrapper)Wrappers.lambdaQuery().in(TopManMsgRecordHis::getTaskId, rids));
        }
    }
}

