/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.organ.api.dto.PurchaserOrganHeadDTO;
import com.els.modules.organ.dto.PurchaserOrganHeadQueryDto;
import com.els.modules.organ.entity.McnInstitutionalHeadEntity;
import com.els.modules.organ.entity.PurchaserOrganAttractHotPushGoodsItem;
import com.els.modules.organ.entity.PurchaserOrganAttractHotPushShopItem;
import com.els.modules.organ.entity.PurchaserOrganContractTalentItem;
import com.els.modules.organ.entity.PurchaserOrganHead;
import com.els.modules.organ.entity.XhsPurchaserOrganHead;
import com.els.modules.organ.mapper.McnInstitutionalHeadMapper;
import com.els.modules.organ.mapper.PurchaserOrganAttractHotPushGoodsItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganAttractHotPushShopItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganAttractItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganContractTalentItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganFansReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganGradeReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganHeadMapper;
import com.els.modules.organ.mapper.PurchaserOrganIndustryReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganPushCategoryItemMapper;
import com.els.modules.organ.mapper.XhsPurchaserOrganHeadMapper;
import com.els.modules.organ.responsevo.PurchaserOrganAttractBodyData;
import com.els.modules.organ.responsevo.PurchaserOrganDetailAttractData;
import com.els.modules.organ.responsevo.PurchaserOrganDetailMcnData;
import com.els.modules.organ.responsevo.PurchaserOrganDetailTopData;
import com.els.modules.organ.responsevo.PurchaserOrganMcnBodyData;
import com.els.modules.organ.service.PurchaserOrganHeadService;
import com.els.modules.organ.utils.CommonSortUtils;
import com.els.modules.organ.utils.QueryOrganParam;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaserOrganHeadServiceImpl
extends BaseServiceImpl<PurchaserOrganHeadMapper, PurchaserOrganHead>
implements PurchaserOrganHeadService {
    @Autowired
    private PurchaserOrganHeadMapper purchaserOrganHeadMapper;
    @Autowired
    private PurchaserOrganItemMapper purchaserOrganItemMapper;
    @Autowired
    private PurchaserOrganPushCategoryItemMapper purchaserOrganPushCategoryItemMapper;
    @Autowired
    private PurchaserOrganIndustryReleaseItemMapper purchaserOrganIndustryReleaseItemMapper;
    @Autowired
    private PurchaserOrganGradeReleaseItemMapper purchaserOrganGradeReleaseItemMapper;
    @Autowired
    private PurchaserOrganFansReleaseItemMapper purchaserOrganFansReleaseItemMapper;
    @Autowired
    private PurchaserOrganAttractItemMapper purchaserOrganAttractItemMapper;
    @Autowired
    private PurchaserOrganAttractHotPushGoodsItemMapper purchaserOrganAttractHotPushGoodsItemMapper;
    @Autowired
    private PurchaserOrganAttractHotPushShopItemMapper purchaserOrganAttractHotPushShopItemMapper;
    @Autowired
    private PurchaserOrganContractTalentItemMapper purchaserOrganContractTalentItemMapper;
    @Autowired
    private XhsPurchaserOrganHeadMapper xhsPurchaserOrganHeadMapper;
    @Autowired
    private McnInstitutionalHeadMapper mcnInstitutionalHeadMapper;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String MCN_CATGORY_DETAIL_COLLECTION_NAME = "tb_invite_data_category_detail";

    @Override
    public Object pageMcnList(Page<PurchaserOrganMcnBodyData> page, HttpServletRequest req, PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        String platform = purchaserOrganHeadQueryDto.getPlatform();
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)platform), (String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        QueryWrapper<PurchaserOrganHeadQueryDto> queryMcnWrapper = QueryOrganParam.getQueryParam("0", purchaserOrganHeadQueryDto);
        List<String> categoryList = CommonSortUtils.getSearchCategory(purchaserOrganHeadQueryDto);
        CommonSortUtils.getOrder(purchaserOrganHeadQueryDto, queryMcnWrapper);
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        switch (platform) {
            case "1": {
                return this.purchaserOrganHeadMapper.pageMcnList((IPage<PurchaserOrganMcnBodyData>)page, (Wrapper<PurchaserOrganHeadQueryDto>)queryMcnWrapper, categoryList, TenantContext.getTenant(), company);
            }
            case "3": {
                return this.xhsPurchaserOrganHeadMapper.pageMcnList((IPage<PurchaserOrganMcnBodyData>)page, (Wrapper<PurchaserOrganHeadQueryDto>)queryMcnWrapper, categoryList, TenantContext.getTenant(), company);
            }
        }
        return null;
    }

    @Override
    public Object pageAttractList(Page<PurchaserOrganAttractBodyData> page, HttpServletRequest req, PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        String platform = purchaserOrganHeadQueryDto.getPlatform();
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)platform), (String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        QueryWrapper<PurchaserOrganHeadQueryDto> queryAttractParam = QueryOrganParam.getQueryParam("1", purchaserOrganHeadQueryDto);
        List<String> categoryList = CommonSortUtils.getSearchCategory(purchaserOrganHeadQueryDto);
        CommonSortUtils.getOrder(purchaserOrganHeadQueryDto, queryAttractParam);
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        switch (platform) {
            case "1": {
                return this.purchaserOrganHeadMapper.pageAttractList((IPage<PurchaserOrganAttractBodyData>)page, (Wrapper<PurchaserOrganHeadQueryDto>)queryAttractParam, platform, categoryList, TenantContext.getTenant(), company);
            }
            case "2": {
                return this.purchaserOrganHeadMapper.pageKsAttractList((IPage<PurchaserOrganAttractBodyData>)page, (Wrapper<PurchaserOrganHeadQueryDto>)queryAttractParam, platform, categoryList, TenantContext.getTenant(), company);
            }
        }
        return null;
    }

    @Override
    public List<PurchaserOrganContractTalentItem> queryConContractTalentData(String headId) {
        ArrayList<PurchaserOrganContractTalentItem> purchaserOrganContractTalentItems = new ArrayList();
        if (!StringUtils.isNotEmpty((CharSequence)headId)) {
            throw new ELSBootException("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        purchaserOrganContractTalentItems = this.purchaserOrganContractTalentItemMapper.getTopData(headId, 0, 50);
        return purchaserOrganContractTalentItems;
    }

    @Override
    public PurchaserOrganDetailTopData detailTop(String headId) {
        PurchaserOrganDetailTopData purchaserOrganDetailTopData = this.purchaserOrganHeadMapper.detailTop(headId, SysUtil.getLoginUser().getElsAccount());
        if (purchaserOrganDetailTopData != null) {
            List<PurchaserOrganDetailTopData.OrganMainPushData> mainPushCategory = this.purchaserOrganPushCategoryItemMapper.getMainPushCategory(headId);
            purchaserOrganDetailTopData.setOrganMainPushData(mainPushCategory);
        }
        return purchaserOrganDetailTopData;
    }

    @Override
    public PurchaserOrganDetailAttractData detailAttract(String id, String days, String categoryId) {
        PurchaserOrganDetailAttractData purchaserOrganDetailAttractData = this.purchaserOrganHeadMapper.detailAttract(id, days, categoryId);
        if (purchaserOrganDetailAttractData != null) {
            List<PurchaserOrganDetailAttractData.OrganOperateCategoryData> operateCategory = this.purchaserOrganAttractItemMapper.getOperateCategory(id, days);
            purchaserOrganDetailAttractData.setOrganOperateCategoryData(operateCategory);
        }
        return purchaserOrganDetailAttractData;
    }

    @Override
    public PurchaserOrganDetailMcnData detailMcn(String headId) {
        PurchaserOrganDetailMcnData purchaserOrganDetailMcnData = this.purchaserOrganItemMapper.queryByHeadId(headId);
        if (purchaserOrganDetailMcnData != null) {
            List<PurchaserOrganDetailMcnData.PurchaserOrganIndustryReleaseBody> purchaserOrganIndustryReleaseBodies = this.purchaserOrganIndustryReleaseItemMapper.queryByHeadId(headId);
            List<PurchaserOrganDetailMcnData.PurchaserOrganGradeReleaseBody> purchaserOrganGradeReleaseBodies = this.purchaserOrganGradeReleaseItemMapper.queryByHeadId(headId);
            List<PurchaserOrganDetailMcnData.PurchaserOrganFansReleaseBody> purchaserOrganFansReleaseBodies = this.purchaserOrganFansReleaseItemMapper.queryByHeadId(headId);
            purchaserOrganDetailMcnData.setIndustrys(purchaserOrganIndustryReleaseBodies);
            purchaserOrganDetailMcnData.setGrades(purchaserOrganGradeReleaseBodies);
            purchaserOrganDetailMcnData.setFans(purchaserOrganFansReleaseBodies);
        }
        return purchaserOrganDetailMcnData;
    }

    @Override
    public Map getChartData(String id, String days, String categoryId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)I18nUtil.translate((String)"", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        paramMap.put("invite_id", id);
        paramMap.put("days", days);
        if (StringUtils.isNotEmpty((CharSequence)categoryId)) {
            paramMap.put("_id", categoryId);
        } else {
            paramMap.put("cate_name", "\u4e0d\u9650");
        }
        Document document = new Document(paramMap);
        MongoCursor attractCursor = this.mongoTemplate.getCollection("tb_invite_data_category_detail").find((Bson)document).noCursorTimeout(true).cursor();
        Document attract = null;
        while (attractCursor.hasNext()) {
            try {
                attract = (Document)attractCursor.next();
                Map trend_total_sale = (Map)attract.get((Object)"trend_total_sale");
                Map trend_order_topman = (Map)attract.get((Object)"trend_order_topman");
                Map trend_sale_product = (Map)attract.get((Object)"trend_sale_product");
                Map trend_order_shop = (Map)attract.get((Object)"trend_order_shop");
                resultMap.put("totalSale", trend_total_sale);
                resultMap.put("orderTopman", trend_order_topman);
                resultMap.put("saleProduct", trend_sale_product);
                resultMap.put("orderShop", trend_order_shop);
            }
            catch (Exception e) {
                this.log.error("attractCursor error", (Throwable)e);
                if (attract == null) continue;
                this.log.error("error is Data" + attract.toJson());
            }
        }
        return resultMap;
    }

    @Override
    public PurchaserOrganHeadDTO getElsOrganByIdAndPlatform(String platform, String id) {
        PurchaserOrganHeadDTO purchaserOrganHeadDTO = null;
        if (platform == null || "".equals(platform)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(McnInstitutionalHeadEntity::getId, (Object)id);
            McnInstitutionalHeadEntity entity = (McnInstitutionalHeadEntity)this.mcnInstitutionalHeadMapper.selectOne((Wrapper)queryWrapper);
            purchaserOrganHeadDTO = (PurchaserOrganHeadDTO)SysUtil.copyProperties((Object)entity, PurchaserOrganHeadDTO.class);
            purchaserOrganHeadDTO.setLogo(entity.getAvatarUri());
            purchaserOrganHeadDTO.setOrganName(entity.getName());
            return purchaserOrganHeadDTO;
        }
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)platform), (String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        if ("1".equals(platform) || "2".equals(platform)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getId, (Object)id)).eq(PurchaserOrganHead::getPlatform, (Object)platform);
            PurchaserOrganHead purchaserOrganHead = (PurchaserOrganHead)((Object)((PurchaserOrganHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
            purchaserOrganHeadDTO = (PurchaserOrganHeadDTO)SysUtil.copyProperties((Object)((Object)purchaserOrganHead), PurchaserOrganHeadDTO.class);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getId, (Object)id)).eq(XhsPurchaserOrganHead::getPlatform, (Object)platform);
            XhsPurchaserOrganHead xhsPurchaserOrganHead = (XhsPurchaserOrganHead)((Object)this.xhsPurchaserOrganHeadMapper.selectOne((Wrapper)queryWrapper));
            purchaserOrganHeadDTO = (PurchaserOrganHeadDTO)SysUtil.copyProperties((Object)((Object)xhsPurchaserOrganHead), PurchaserOrganHeadDTO.class);
        }
        return purchaserOrganHeadDTO;
    }

    @Override
    public void insertBatch(List<List<PurchaserOrganHead>> organList) {
        organList.forEach(a -> this.deleteBatchByIds((List<PurchaserOrganHead>)a));
        organList.stream().filter(a -> a.size() > 0).forEach(((PurchaserOrganHeadMapper)this.baseMapper)::insertBatch);
    }

    @Override
    public void deleteBatchByIds(List<PurchaserOrganHead> ids) {
        ((PurchaserOrganHeadMapper)this.baseMapper).deleteBatchByIds(ids);
    }

    @Override
    public IPage<PurchaserOrganAttractHotPushGoodsItem> hotSaleGoods(Page<PurchaserOrganAttractHotPushGoodsItem> page, HttpServletRequest req, PurchaserOrganAttractHotPushGoodsItem purchaserOrganAttractHotPushGoodsItem) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserOrganAttractHotPushGoodsItem), (Map)req.getParameterMap());
        Page purchaserOrganAttractHotPushGoodsItemPage = (Page)this.purchaserOrganAttractHotPushGoodsItemMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return purchaserOrganAttractHotPushGoodsItemPage;
    }

    @Override
    public IPage<PurchaserOrganAttractHotPushShopItem> hotSaleShop(Page<PurchaserOrganAttractHotPushShopItem> page, HttpServletRequest req, PurchaserOrganAttractHotPushShopItem purchaserOrganAttractHotPushShopItem) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserOrganAttractHotPushShopItem), (Map)req.getParameterMap());
        Page purchaserOrganAttractHotPushShopItemPage = (Page)this.purchaserOrganAttractHotPushShopItemMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return purchaserOrganAttractHotPushShopItemPage;
    }
}

