/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.common.utils.RedissonUtil;
import com.els.modules.touch.entity.SmsTemplate;
import com.els.modules.touch.entity.TopManMsgConfig;
import com.els.modules.touch.entity.TopManMsgConfigItem;
import com.els.modules.touch.enumerate.MsgTypeEnum;
import com.els.modules.touch.service.SmsTemplateService;
import com.els.modules.touch.service.TopManMsgConfigItemService;
import com.els.modules.touch.service.TopManMsgConfigService;
import com.els.modules.touch.vo.MsgTemplateVO;
import com.els.modules.touch.vo.TopManMsgConfigVO;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/msg/topManMsgConfig"})
public class TopManMsgConfigController
extends BaseController<TopManMsgConfig, TopManMsgConfigService> {
    @Autowired
    private TopManMsgConfigService topManMsgConfigService;
    @Autowired
    private TopManMsgConfigItemService topManMsgConfigItemService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RedissonUtil redissonUtil;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(TopManMsgConfig topManMsgConfig, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topManMsgConfig), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        queryWrapper.eq((Object)"touch_type", (Object)topManMsgConfig.getTouchType());
        queryWrapper.orderByAsc((Object)"sort_num");
        IPage pageList = this.topManMsgConfigService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/noToken/delRedis"})
    public void delRedis(@RequestParam(value="key") String key) {
        this.redisTemplate.delete((Object)key);
    }

    @GetMapping(value={"/noToken/key"})
    public void key(@RequestParam(value="key") String key) {
        RLock lock = this.redissonUtil.lock(key, (Long)1000000000L);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TopManMsgConfig topManMsgConfig) {
        this.topManMsgConfigService.add(topManMsgConfig);
        return Result.ok((Object)((Object)topManMsgConfig));
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TopManMsgConfig topManMsgConfig) {
        this.topManMsgConfigService.edit(topManMsgConfig);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/save/{platform}"})
    public Result<?> save(@RequestBody TopManMsgConfigVO configs, @PathVariable(value="platform") String platform) {
        this.topManMsgConfigService.saveConfigs(configs.getConfigs(), platform, configs.getTouchType());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.topManMsgConfigService.delete(id);
        this.topManMsgConfigItemService.remove((Wrapper)Wrappers.lambdaQuery().eq(TopManMsgConfigItem::getHeadId, (Object)id));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.topManMsgConfigService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TopManMsgConfig topManMsgConfig = (TopManMsgConfig)((Object)this.topManMsgConfigService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)topManMsgConfig));
    }

    @GetMapping(value={"/templateDict"})
    public Result<?> templateDict() {
        List template = this.smsTemplateService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SmsTemplate::getToElsAccount, (Object)TenantContext.getTenant())).eq(SmsTemplate::getTemplateStatus, (Object)"1")).eq(BaseEntity::getDeleted, (Object)"0"));
        List ms = template.stream().map(x -> {
            ConcurrentMap m = Maps.newConcurrentMap();
            m.put("id", x.getId());
            m.put("content", x.getSmsTemplate());
            m.put("items", this.topManMsgConfigItemService.templateList(x.getId()));
            return m;
        }).collect(Collectors.toList());
        return Result.ok(ms);
    }

    @GetMapping(value={"/templateList"})
    public Result<?> templateList() {
        LoginUser user = SysUtil.getLoginUser();
        List template = this.topManMsgConfigService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(TopManMsgConfig::getMsgType, (Object)MsgTypeEnum.SMS.getCode())).eq(TopManMsgConfig::getSubAccount, (Object)user.getSubAccount())).orderByAsc(TopManMsgConfig::getSortNum));
        ArrayList list = Lists.newArrayList();
        for (TopManMsgConfig msgConfig : template) {
            MsgTemplateVO vo = new MsgTemplateVO();
            BeanUtil.copyProperties((Object)((Object)msgConfig), (Object)((Object)vo), (String[])new String[0]);
            if (StrUtil.isNotBlank((CharSequence)vo.getTemplateId())) {
                SmsTemplate template1 = (SmsTemplate)((Object)this.smsTemplateService.getById((Serializable)((Object)vo.getTemplateId())));
                vo.setTemplateContent(template1.getSmsTemplate());
            }
            vo.setItems(this.topManMsgConfigItemService.list((Wrapper)Wrappers.lambdaQuery().eq(TopManMsgConfigItem::getHeadId, (Object)msgConfig.getId())));
            list.add(vo);
        }
        return Result.ok((Object)list);
    }

    @PostMapping(value={"/saveTemplate/{platform}"})
    public Result<?> saveTemplate(@RequestBody List<MsgTemplateVO> rq, @PathVariable(value="platform") String platform) {
        this.topManMsgConfigService.saveTemplate(rq, platform);
        return Result.ok();
    }

    @PostMapping(value={"/smsTest"})
    public Result<?> smsTest(@RequestBody MsgTemplateVO rq) {
        this.topManMsgConfigService.smsTest(rq);
        return Result.ok();
    }
}

