/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.goods.dto.GoodsItemQueryDTO;
import com.els.modules.goods.entity.GoodsHead;
import com.els.modules.goods.entity.GoodsVideoRecord;
import com.els.modules.goods.mapper.GoodsVideoRecordMapper;
import com.els.modules.goods.service.GoodsHeadService;
import com.els.modules.goods.service.GoodsVideoRecordService;
import com.els.modules.goods.vo.GoodsVideoRecordVO;
import com.els.modules.topman.entity.TopManVideoItemList;
import com.els.modules.topman.mapper.TopManVideoItemListMapper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GoodsVideoRecordServiceImpl
extends BaseServiceImpl<GoodsVideoRecordMapper, GoodsVideoRecord>
implements GoodsVideoRecordService {
    @Autowired
    private GoodsVideoRecordMapper goodsVideoRecordMapper;
    @Autowired
    private GoodsHeadService goodsHeadService;
    @Autowired
    private TopManVideoItemListMapper topManVideoItemListMapper;

    @Override
    public List<GoodsVideoRecord> selectByMainId(String mainId) {
        return this.goodsVideoRecordMapper.selectByMainId(mainId);
    }

    @Override
    public IPage<GoodsVideoRecordVO> queryVideoPage(Page<TopManVideoItemList> page, QueryWrapper<TopManVideoItemList> queryWrapper, GoodsItemQueryDTO queryDTO) {
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        IPage<GoodsVideoRecordVO> videoPage = this.topManVideoItemListMapper.topManVideoItemListPage(page, queryWrapper, queryDTO);
        if (CollectionUtils.isNotEmpty((Collection)videoPage.getRecords())) {
            GoodsHead goodsHead = this.goodsHeadService.selectByGoodsId(queryDTO.getGoodsId());
            for (GoodsVideoRecordVO vo : videoPage.getRecords()) {
                if (goodsHead != null) {
                    vo.setPrice(goodsHead.getPrice());
                }
                if (vo.getSalesAmountMax() == null || vo.getPrice() == null || vo.getPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal salesNum = vo.getSalesAmountMax().divide(vo.getPrice(), 0, 4);
                vo.setSalesNum(salesNum);
            }
        }
        return videoPage;
    }
}

