/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ranklist.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.common.weboption.OptionFactory;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.ranklist.dto.WorksRanklistDTO;
import com.els.modules.ranklist.entity.WorksRanklist;
import com.els.modules.ranklist.enumerate.WorksRanklistOptionsType;
import com.els.modules.ranklist.enumerate.WorksRanklistOptionsTypeGroup;
import com.els.modules.ranklist.mapper.WorksRanklistMapper;
import com.els.modules.ranklist.service.WorksRanklistService;
import com.els.modules.ranklist.vo.WorksRanklistVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class WorksRanklistServiceImpl
extends BaseServiceImpl<WorksRanklistMapper, WorksRanklist>
implements WorksRanklistService {
    @Override
    public List<TopManOptionsEntity> getOptions(String type, String listType, String clearCache) {
        OptionFactory.OptionHandler<WorksRanklistOptionsTypeGroup, WorksRanklistOptionsType> init = OptionFactory.init(WorksRanklistOptionsTypeGroup.class, WorksRanklistOptionsType.class);
        init.setCollection("tb_works_ranklist_category");
        switch (type) {
            case "douYin": {
                init.when(WorksRanklistOptionsType.douYinIndustry, (doc, param) -> this.topmanCategoryConverter(doc));
                init.when(WorksRanklistOptionsType.douYinCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                init.when(WorksRanklistOptionsType.douYinOrder, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "zhiHu": {
                init.when(WorksRanklistOptionsType.zhiHuCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            default: {
                throw new ELSBootException("\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b");
            }
        }
        return init.getResult(type + "_" + listType, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> topmanCategoryConverter(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType(h.get((Object)"componentType").toString());
            tag.setChildren(this.getParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("label").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    @Override
    public IPage<WorksRanklistVO> queryPageList(SimplePostRequestParam<WorksRanklistDTO> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        QueryWrapper<WorksRanklist> queryWrapper = this.getQueryWrapper(param);
        IPage<WorksRanklist> pageList = ((WorksRanklistMapper)this.baseMapper).queryPageList((IPage<WorksRanklist>)page, queryWrapper);
        Page newPage = new Page();
        BeanUtils.copyProperties(pageList, (Object)newPage);
        return newPage;
    }

    private QueryWrapper<WorksRanklist> getQueryWrapper(SimplePostRequestParam<WorksRanklistDTO> param) {
        String[] columns;
        WorksRanklistDTO dto = (WorksRanklistDTO)param.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(WorksRanklist::getPlatform, (Object)dto.getPlatform());
        query.lambda().eq(WorksRanklist::getRankType, (Object)dto.getRankType());
        if (dto.getDateType() != null) {
            this.dateTypeConverter(dto, (QueryWrapper<WorksRanklist>)query);
        }
        this.categoryConverter(dto, (QueryWrapper<WorksRanklist>)query);
        String keyWord = param.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)q.lambda().like(WorksRanklist::getWorkTitle, (Object)keyWord);
            });
        }
        this.dateTypeOrder(param);
        String column = param.getColumn();
        if (column != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = param.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new WorksRanklist()));
        }
        return query;
    }

    private void dateTypeConverter(WorksRanklistDTO dto, QueryWrapper<WorksRanklist> query) {
        if (dto.getPlatform() == 1) {
            if (StringUtils.isBlank((CharSequence)dto.getDateType())) {
                query.lambda().eq(WorksRanklist::getDateType, (Object)"7d");
            } else {
                query.lambda().eq(WorksRanklist::getDateType, (Object)dto.getDateType());
            }
        } else if (dto.getPlatform() == 6) {
            if (StringUtils.isBlank((CharSequence)dto.getDateType())) {
                if (dto.getRankType() == 1) {
                    query.lambda().eq(WorksRanklist::getDateType, (Object)"7d");
                } else if (dto.getRankType() == 2) {
                    query.lambda().eq(WorksRanklist::getDateType, (Object)"24h");
                }
            } else {
                query.lambda().eq(WorksRanklist::getDateType, (Object)dto.getDateType());
            }
        }
    }

    private void categoryConverter(WorksRanklistDTO dto, QueryWrapper<WorksRanklist> query) {
        WorksRanklistDTO.ScreenItem screenItem = dto.getScreenItem();
        if (screenItem == null) {
            query.lambda().eq(WorksRanklist::getFbk1, (Object)"0");
            return;
        }
        if (dto.getPlatform() == 1) {
            List<WorksRanklistDTO.ScreenItemField> industrys = screenItem.getDouYinIndustry();
            if (CollectionUtil.isEmpty(industrys)) {
                query.lambda().eq(WorksRanklist::getFbk1, (Object)"0");
            } else {
                WorksRanklistDTO.ScreenItemField screenItemField = industrys.get(0);
                query.lambda().eq(WorksRanklist::getFbk1, (Object)screenItemField.getStarTagId());
            }
            List<WorksRanklistDTO.ScreenItemField> categorys = screenItem.getDouYinCategory();
            if (CollectionUtil.isEmpty(categorys)) {
                query.lambda().eq(WorksRanklist::getFbk2, (Object)"0");
            } else {
                WorksRanklistDTO.ScreenItemField screenItemField = categorys.get(0);
                query.lambda().eq(WorksRanklist::getFbk2, (Object)screenItemField.getStarTagId());
            }
        } else if (dto.getPlatform() == 6) {
            List<WorksRanklistDTO.ScreenItemField> categorys = screenItem.getZhiHuCategory();
            if (CollectionUtil.isEmpty(categorys)) {
                query.lambda().eq(WorksRanklist::getFbk1, (Object)"0");
            } else {
                WorksRanklistDTO.ScreenItemField screenItemField = categorys.get(0);
                query.lambda().eq(WorksRanklist::getFbk1, (Object)screenItemField.getStarTagId());
            }
        }
    }

    private void dateTypeOrder(SimplePostRequestParam<WorksRanklistDTO> param) {
        WorksRanklistDTO dto = (WorksRanklistDTO)param.getFilterInfo();
        WorksRanklistDTO.ScreenItem screenItem = dto.getScreenItem();
        switch (dto.getPlatform()) {
            case 1: {
                if (screenItem == null) {
                    param.setColumn("play_num");
                } else {
                    List<WorksRanklistDTO.ScreenItemField> orders = screenItem.getDouYinOrder();
                    if (CollectionUtil.isEmpty(orders)) {
                        param.setColumn("play_num");
                    } else {
                        WorksRanklistDTO.ScreenItemField screenItemField = orders.get(0);
                        param.setColumn(screenItemField.getStarTagId());
                    }
                }
                param.setOrder("desc");
                break;
            }
            case 2: {
                param.setColumn("rank");
                param.setOrder("asc");
                break;
            }
            case 6: {
                if (dto.getRankType() == 1) {
                    param.setColumn("browses_increment");
                } else if (dto.getRankType() == 2) {
                    param.setColumn("search_index");
                }
                param.setOrder("desc");
                break;
            }
        }
    }
}

