/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ranklist.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.RedisUtil;
import com.els.modules.common.spider.entity.TopManStarsListTabEntity;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.weboption.OptionFactory;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.ranklist.dto.ExistDateDTO;
import com.els.modules.ranklist.dto.TopManRanklistDTO;
import com.els.modules.ranklist.entity.TopManRanklist;
import com.els.modules.ranklist.enumerate.TopManRanklistOptionsType;
import com.els.modules.ranklist.enumerate.TopManRanklistOptionsTypeGroup;
import com.els.modules.ranklist.mapper.TopManRanklistMapper;
import com.els.modules.ranklist.service.TopManRanklistService;
import com.els.modules.ranklist.vo.TopManRanklistVO;
import com.mongodb.client.MongoCursor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class TopManRanklistServiceImpl
extends BaseServiceImpl<TopManRanklistMapper, TopManRanklist>
implements TopManRanklistService {
    @Resource
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TopManRanklistMapper topmanRankListMapper;

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String listType, String clearCache, String rankDate) {
        OptionFactory.OptionHandler<TopManRanklistOptionsTypeGroup, TopManRanklistOptionsType> init = OptionFactory.init(TopManRanklistOptionsTypeGroup.class, TopManRanklistOptionsType.class);
        init.setCollection("tb_topman_ranklist_category");
        switch (type) {
            case "douYin": {
                if ("4".equals(listType) || "5".equals(listType)) {
                    init.when(TopManRanklistOptionsType.douYinCategory2, (doc, param) -> this.topmanCategoryConverter(doc));
                    break;
                }
                init.when(TopManRanklistOptionsType.douYinCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "kuaiShou": {
                init.when(TopManRanklistOptionsType.kuaiShouCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "redBook": {
                init.when(TopManRanklistOptionsType.redBookCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "biliBili": {
                init.when(TopManRanklistOptionsType.biliBiliCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "weiBo": {
                init.when(TopManRanklistOptionsType.weiBoCategory, (doc, param) -> this.topmanCategoryConverter(doc));
                break;
            }
            case "zhiHu": {
                ArrayList<TopManOptionsEntity> result = new ArrayList<TopManOptionsEntity>();
                result.add(this.getZhiHuCategory("tb_zhihu_ranklist_category", rankDate));
                return result;
            }
            default: {
                throw new ELSBootException("\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b");
            }
        }
        return init.getResult(type + "_" + listType, "1".equals(clearCache));
    }

    private List<TopManOptionsEntity.Tag> topmanCategoryConverter(Document doc) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType(h.get((Object)"componentType").toString());
            tag.setChildren(this.getParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private String getDate(int mon) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        calendar.add(2, mon);
        return sdf.format(calendar.getTime());
    }

    private TopManOptionsEntity getZhiHuCategory(String collection, String rankDate) {
        if (rankDate == null || "".equals(rankDate)) {
            rankDate = this.getDate(-2);
        }
        rankDate = rankDate + "-01";
        TopManOptionsEntity result = new TopManOptionsEntity();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"rank_date").is((Object)rankDate));
        result.setTitle("\u9886\u57df\u5206\u7c7b");
        result.setFieldName("zhiHuCategory");
        result.setSort(1);
        ArrayList<TopManOptionsEntity.TagCopy> children = new ArrayList<TopManOptionsEntity.TagCopy>();
        result.setChildren(children);
        List directoryJson = null;
        try (MongoCursor document = this.mongoTemplate.getCollection(collection).find((Bson)query.getQueryObject()).noCursorTimeout(true).cursor();){
            while (document.hasNext()) {
                Document next = (Document)document.next();
                directoryJson = (List)next.get((Object)"directory_json");
            }
        }
        for (Document doc : directoryJson) {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            String tagValue = doc.getString((Object)"starTagName");
            tag.setComponentType("RButton");
            tag.setId(tagValue);
            tag.setValue(tagValue);
            tag.setLabel(tagValue);
            children.add(tag);
        }
        return result;
    }

    private List<Object> getParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (CollectionUtil.isNotEmpty((Collection)children)) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (CollectionUtil.isEmpty((Collection)children)) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("label").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    @Override
    public IPage<TopManRanklistVO> queryPageList(SimplePostRequestParam<TopManRanklistDTO> param) {
        Page page = new Page((long)param.getPageNo().intValue(), (long)param.getPageSize().intValue());
        QueryWrapper<TopManRanklist> queryWrapper = this.getQueryWrapper(param);
        IPage<TopManRanklist> pageList = ((TopManRanklistMapper)this.baseMapper).queryPageList((IPage<TopManRanklist>)page, queryWrapper);
        Page newPage = new Page();
        BeanUtils.copyProperties(pageList, (Object)newPage);
        newPage.setRecords(this.ranklistResultConverter(pageList.getRecords(), (TopManRanklistDTO)param.getFilterInfo()));
        return newPage;
    }

    private List<TopManRanklistVO> ranklistResultConverter(List<TopManRanklist> list, TopManRanklistDTO dto) {
        return list.stream().map(h -> {
            TopManRanklistVO vo = new TopManRanklistVO();
            BeanUtils.copyProperties((Object)h, (Object)vo);
            vo.setAvatar(h.getTopmanAvatar());
            if (dto.getPlatform() == 1 && (dto.getRankType() == 4 || dto.getRankType() == 5)) {
                vo.setRankDiff((vo.getOldRank() != null ? vo.getOldRank() : 0) - vo.getNewRank());
            }
            if (dto.getPlatform() == 2) {
                vo.setRankDiff((vo.getOldRank() != null ? vo.getOldRank() : 0) - vo.getNewRank());
            }
            if (dto.getPlatform() == 2) {
                if (dto.getRankType() == 1 || dto.getRankType() == 2) {
                    vo.setStarType("4");
                } else if (dto.getRankType() == 5 || dto.getRankType() == 7 || dto.getRankType() == 9) {
                    vo.setStarType("1");
                }
                vo.setUserId(h.getTopmanId());
                vo.setStarId(h.getStarId());
            }
            if (dto.getPlatform() == 6) {
                vo.setUid(h.getTopmanId());
            }
            return vo;
        }).collect(Collectors.toList());
    }

    private QueryWrapper<TopManRanklist> getQueryWrapper(SimplePostRequestParam<TopManRanklistDTO> param) {
        String rankDate;
        TopManRanklistDTO dto = (TopManRanklistDTO)param.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(TopManRanklist::getPlatform, (Object)dto.getPlatform());
        query.lambda().eq(TopManRanklist::getRankType, (Object)dto.getRankType());
        query.lambda().eq(BaseEntity::getDeleted, (Object)0);
        if (dto.getPlatform() == 1 && dto.getDateType() != null) {
            query.lambda().eq(TopManRanklist::getDateType, (Object)dto.getDateType());
            rankDate = this.getRankDate(dto.getRankType(), dto.getDateType(), dto.getRankDate());
            query.lambda().like(TopManRanklist::getRankDate, (Object)rankDate);
        } else if (dto.getPlatform() == 2) {
            rankDate = this.getAllRankDate(dto.getRankType(), dto.getDateType(), dto.getRankDate());
            query.lambda().like(TopManRanklist::getRankDate, (Object)rankDate);
        } else if (dto.getDateType() != null && dto.getRankDate() != null) {
            rankDate = this.getRankDate(dto.getRankType(), dto.getDateType(), dto.getRankDate());
            query.lambda().like(TopManRanklist::getRankDate, (Object)rankDate);
        }
        if (dto.getPlatform() == 1 && (dto.getRankType() == 4 || dto.getRankType() == 5)) {
            this.categoryStarsConverter(dto, (QueryWrapper<TopManRanklist>)query);
        } else {
            this.categoryConverter(dto, (QueryWrapper<TopManRanklist>)query);
        }
        String keyWord = param.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)q.lambda().like(TopManRanklist::getTopmanName, (Object)keyWord);
            });
        }
        QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
            {
                this.put("order", new String[]{"asc"});
                this.put("column", new String[]{"new_rank"});
            }
        }, (Object)((Object)new TopManRanklist()));
        return query;
    }

    private String getRankDate(Integer rankType, Integer dateType, Date rankDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (rankDate != null) {
            if (dateType == 1) {
                return new SimpleDateFormat("yyyy-MM-dd").format(rankDate);
            }
            if (dateType == 2) {
                calendar.setTime(rankDate);
                ((Calendar)calendar).add(5, -6);
                return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
            }
            return new SimpleDateFormat("yyyy-MM").format(rankDate);
        }
        calendar.setTime(new Date());
        if (dateType == 1) {
            if (rankType != 4 && rankType != 5) {
                ((Calendar)calendar).add(5, -2);
                return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
            }
            return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        }
        if (dateType == 2) {
            ((Calendar)calendar).add(3, -1);
            calendar.set(7, 2);
            return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        }
        if (rankType != 4 && rankType != 5) {
            ((Calendar)calendar).add(2, -1);
            return new SimpleDateFormat("yyyy-MM").format(calendar.getTime());
        }
        return new SimpleDateFormat("yyyy-MM").format(new Date());
    }

    private String getAllRankDate(Integer rankType, Integer dateType, Date rankDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (rankDate != null) {
            if (this.nowDateIsBeform16()) {
                return new SimpleDateFormat("yyyy-MM-dd").format(rankDate);
            }
            calendar.setTime(rankDate);
            ((Calendar)calendar).add(5, -1);
            return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        }
        calendar.setTime(new Date());
        if (this.nowDateIsBeform16()) {
            ((Calendar)calendar).add(5, -2);
        } else {
            ((Calendar)calendar).add(5, -3);
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
    }

    private boolean nowDateIsBeform16() {
        Calendar calendar = Calendar.getInstance();
        int date = calendar.get(11);
        return date >= 16;
    }

    private void categoryStarsConverter(TopManRanklistDTO dto, QueryWrapper<TopManRanklist> query) {
        String category = "";
        TopManStarsListTabEntity tabEntity = this.listTab();
        if (tabEntity == null) {
            query.lambda().eq(TopManRanklist::getFbk1, (Object)category);
            return;
        }
        List<TopManStarsListTabEntity.HotLists> hotLists = tabEntity.getHotLists();
        if (CollectionUtil.isEmpty(hotLists)) {
            query.lambda().eq(TopManRanklist::getFbk1, (Object)category);
            return;
        }
        for (TopManStarsListTabEntity.HotLists h : hotLists) {
            if (dto.getRankType() == 4 && "\u6da8\u7c89\u9ed1\u9a6c\u699c".equals(h.getTitle())) {
                category = this.categoryStarsDateType(dto.getDateType(), h.getConfs(), dto.getScreenItem());
                continue;
            }
            if (dto.getRankType() != 5 || !"\u8d85\u503c\u661f\u9009\u699c".equals(h.getTitle())) continue;
            category = this.categoryStarsDateType(dto.getDateType(), h.getConfs(), dto.getScreenItem());
        }
        query.lambda().eq(TopManRanklist::getFbk1, (Object)category);
    }

    private String categoryStarsDateType(Integer dateType, List<TopManStarsListTabEntity.Confs> list, TopManRanklistDTO.ScreenItem screenItem) {
        if (CollectionUtil.isEmpty(list)) {
            return "";
        }
        for (TopManStarsListTabEntity.Confs confs : list) {
            if (dateType == 1 && "1".equals(confs.getPeriod())) {
                return this.categoryStarsConverterSub(confs, screenItem);
            }
            if (dateType == 2 && "7".equals(confs.getPeriod())) {
                return this.categoryStarsConverterSub(confs, screenItem);
            }
            if (dateType != 3 || !"30".equals(confs.getPeriod())) continue;
            return this.categoryStarsConverterSub(confs, screenItem);
        }
        return "";
    }

    private String categoryStarsConverterSub(TopManStarsListTabEntity.Confs confs, TopManRanklistDTO.ScreenItem screenItem) {
        List<TopManStarsListTabEntity.Tags> tags = confs.getTags();
        if (CollectionUtil.isEmpty(tags)) {
            return "";
        }
        Map<String, String> tagsMap = tags.stream().collect(Collectors.toMap(TopManStarsListTabEntity.Tags::getLabel, TopManStarsListTabEntity.Tags::getValue));
        if (screenItem == null) {
            return tagsMap.get("\u5168\u90e8");
        }
        List<TopManRanklistDTO.ScreenItemField> categorys = screenItem.getDouYinCategory();
        if (CollectionUtil.isEmpty(categorys)) {
            return tagsMap.get("\u5168\u90e8");
        }
        TopManRanklistDTO.ScreenItemField field = categorys.get(0);
        System.out.println(field.getTitle());
        System.out.println(tagsMap.get(field.getTitle()));
        return tagsMap.get(field.getTitle());
    }

    private void categoryConverter(TopManRanklistDTO dto, QueryWrapper<TopManRanklist> query) {
        TopManRanklistDTO.ScreenItem screenItem = dto.getScreenItem();
        if (screenItem == null) {
            if (dto.getPlatform() != 3 && dto.getPlatform() != 6) {
                query.lambda().eq(TopManRanklist::getFbk1, (Object)"0");
            } else {
                query.lambda().eq(TopManRanklist::getFbk1, (Object)"1");
            }
        } else {
            List<TopManRanklistDTO.ScreenItemField> categorys = this.categoryConverterSub(dto.getPlatform(), screenItem);
            if (CollectionUtil.isEmpty(categorys)) {
                if (dto.getPlatform() != 3 && dto.getPlatform() != 6) {
                    query.lambda().eq(TopManRanklist::getFbk1, (Object)"0");
                } else {
                    query.lambda().eq(TopManRanklist::getFbk1, (Object)"1");
                }
            } else {
                TopManRanklistDTO.ScreenItemField screenItemField = categorys.get(0);
                String categoryId = this.handleCategory(screenItemField, query, dto.getPlatform());
                query.lambda().eq(TopManRanklist::getFbk1, (Object)categoryId);
            }
        }
    }

    private List<TopManRanklistDTO.ScreenItemField> categoryConverterSub(Integer platform, TopManRanklistDTO.ScreenItem screenItem) {
        switch (platform) {
            case 1: {
                return screenItem.getDouYinCategory();
            }
            case 2: {
                return screenItem.getKuaiShouCategory();
            }
            case 3: {
                return screenItem.getRedBookCategory();
            }
            case 4: {
                return screenItem.getBiliBiliCategory();
            }
            case 5: {
                return screenItem.getWeiBoCategory();
            }
            case 6: {
                return screenItem.getZhiHuCategory();
            }
        }
        return new ArrayList<TopManRanklistDTO.ScreenItemField>(0);
    }

    private String handleCategory(TopManRanklistDTO.ScreenItemField screenItemField, QueryWrapper<TopManRanklist> query, Integer platform) {
        String starTagId = screenItemField.getStarTagId();
        if (platform != 1) {
            return starTagId;
        }
        String[] starTagNames = new String[]{"\u793c\u54c1\u6587\u521b", "\u4e8c\u624b\u95f2\u7f6e", "\u672c\u5730\u751f\u6d3b", "\u519c\u8d44\u79cd\u690d"};
        if (Arrays.asList(starTagNames).contains(screenItemField.getTitle())) {
            return starTagId;
        }
        JSONArray jsonArray = JSONUtil.parseArray((Object)screenItemField.getValue());
        if (CollectionUtil.isEmpty((Collection)jsonArray)) {
            return starTagId;
        }
        if (jsonArray.size() > 1) {
            return starTagId;
        }
        JSONObject jsonObject = JSONUtil.parseObj((Object)jsonArray.get(0));
        return jsonObject.get((Object)"starTagId").toString();
    }

    @Override
    public TopManStarsListTabEntity listTab() {
        return this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_JLXT_LIST_TAB, new HashMap<String, Object>(0), TopManStarsListTabEntity.class);
    }

    @Override
    public void cleanCache(String cacheKey) {
        this.redisUtil.dels(cacheKey);
    }

    @Override
    public void addCategory() {
    }

    @Override
    public List<ExistDateDTO> queryExistDate(String platform) {
        return this.topmanRankListMapper.queryExistDate(platform);
    }
}

